/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.provider.plugins;

import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wss.provider.ProviderConfig;
import com.sun.identity.wss.provider.ProviderException;
import com.sun.identity.wss.provider.ProviderUtils;
import com.sun.identity.wss.provider.TrustAuthorityConfig;
import com.sun.identity.wss.security.PasswordCredential;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class AgentProvider
extends ProviderConfig {
    private static Set attrNames = new HashSet();
    private static final String AGENT_PASSWORD_ATTR = "userpassword";
    private static final String AGENT_DEVICE_STATUS_ATTR = "sunIdentityServerDeviceStatus";
    private static final String AGENT_TYPE_ATTR = "AgentType";
    private static final String SEC_MECH = "SecurityMech";
    private static final String WSP_ENDPOINT = "WSPEndpoint";
    private static final String WSS_PROXY_ENDPOINT = "WSPProxyEndpoint";
    private static final String KS_FILE = "KeyStoreFile";
    private static final String KS_PASSWD = "KeyStorePassword";
    private static final String KEY_PASSWD = "KeyPassword";
    private static final String RESPONSE_SIGN = "isResponseSign";
    private static final String RESPONSE_ENCRYPT = "isResponseEncrypt";
    private static final String REQUEST_SIGN = "isRequestSign";
    private static final String REQUEST_ENCRYPT = "isRequestEncrypt";
    private static final String REQUEST_HEADER_ENCRYPT = "isRequestHeaderEncrypt";
    private static final String KEY_ALIAS = "privateKeyAlias";
    private static final String KEY_TYPE = "privateKeyType";
    private static final String PUBLIC_KEY_ALIAS = "publicKeyAlias";
    private static final String STS_TRUST_AUTHORITY = "STS";
    private static final String DISCOVERY_TRUST_AUTHORITY = "Discovery";
    private static final String PROPERTY = "Property:";
    private static final String USER_NAME = "UserName";
    private static final String USER_PASSWORD = "UserPassword";
    private static final String USER_CREDENTIAL = "UserCredential";
    private static final String SERVICE_TYPE = "serviceType";
    private static final String USE_DEFAULT_KEYSTORE = "useDefaultStore";
    private static final String FORCE_AUTHENTICATION = "forceUserAuthn";
    private static final String KEEP_SECURITY_HEADERS = "keepSecurityHeaders";
    private static final String AUTHENTICATION_CHAIN = "authenticationChain";
    private static final String SAML_ATTRIBUTE_MAPPING = "SAMLAttributeMapping";
    private static final String INCLUDE_MEMBERSHIPS = "includeMemberships";
    private static final String SAML_ATTRIBUTE_NS = "AttributeNamespace";
    private static final String NAMEID_MAPPER = "NameIDMapper";
    private AMIdentityRepository idRepo;
    private static Set agentConfigAttribute;
    private static Debug debug;
    private SSOToken token;
    private boolean profilePresent;

    public void init(String providerName, String providerType, SSOToken token, boolean isEndPoint) throws ProviderException {
        this.providerName = providerName;
        this.providerType = providerType;
        this.token = token;
        if (providerType.equals("WSPAgent") && isEndPoint) {
            try {
                if (this.idRepo == null) {
                    this.idRepo = new AMIdentityRepository(token, "/");
                }
                IdSearchControl control = new IdSearchControl();
                control.setAllReturnAttributes(true);
                control.setTimeOut(0);
                HashMap kvPairMap = new HashMap();
                HashSet<String> set = new HashSet<String>();
                set.add(providerType);
                kvPairMap.put(AGENT_TYPE_ATTR, set);
                set = new HashSet();
                set.add(providerName);
                kvPairMap.put(WSP_ENDPOINT, set);
                control.setSearchModifiers(IdSearchOpModifier.OR, kvPairMap);
                IdSearchResults results = this.idRepo.searchIdentities(IdType.AGENTONLY, "*", control);
                Set agents = results.getSearchResults();
                if (!agents.isEmpty()) {
                    AMIdentity provider = (AMIdentity)agents.iterator().next();
                    Map attributes = null;
                    attributes = attrNames != null ? provider.getAttributes(attrNames) : provider.getAttributes();
                    if (debug.messageEnabled()) {
                        debug.message("Attributes from WSP end point : " + attributes);
                    }
                    this.parseAgentKeyValues(attributes);
                }
            }
            catch (Exception ex) {
                debug.error("AgentProvider.init: Unable to get idRepo", ex);
                throw new ProviderException("idRepo exception: " + ex.getMessage());
            }
            return;
        }
        try {
            if (this.idRepo == null) {
                this.idRepo = new AMIdentityRepository(token, "/");
            }
            IdSearchControl control = new IdSearchControl();
            control.setAllReturnAttributes(true);
            IdSearchResults results = this.idRepo.searchIdentities(IdType.AGENTONLY, providerName, control);
            Set agents = results.getSearchResults();
            if (!agents.isEmpty()) {
                AMIdentity provider = (AMIdentity)agents.iterator().next();
                this.profilePresent = true;
                Map attributes = provider.getAttributes(attrNames);
                if (debug.messageEnabled()) {
                    debug.message("Attributes from provider name : " + attributes);
                }
                this.parseAgentKeyValues(attributes);
            }
        }
        catch (Exception e) {
            debug.error("AgentProvider.init: Unable to get idRepo", e);
            throw new ProviderException("idRepo exception: " + e.getMessage());
        }
    }

    private void parseAgentKeyValues(Map attributes) throws ProviderException {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        for (String key : attributes.keySet()) {
            Set valSet = (Set)attributes.get(key);
            String value = null;
            if (valSet != null && valSet.size() > 0) {
                Iterator iter = valSet.iterator();
                StringBuffer sb = new StringBuffer(100);
                while (iter.hasNext()) {
                    sb.append((String)iter.next()).append(",");
                }
                sb = sb.deleteCharAt(sb.length() - 1);
                value = sb.toString();
            }
            this.setConfig(key, value);
        }
    }

    private void setConfig(String attr, String value) {
        if (debug.messageEnabled()) {
            debug.message("Attribute name: " + attr + " Value: " + value);
        }
        if (attr.equals(SEC_MECH)) {
            if (this.secMech == null) {
                this.secMech = new ArrayList();
            }
            StringTokenizer st = new StringTokenizer(value, ",");
            while (st.hasMoreTokens()) {
                this.secMech.add(st.nextToken());
            }
        } else if (attr.equals(WSP_ENDPOINT)) {
            this.wspEndpoint = value;
        } else if (attr.equals(WSS_PROXY_ENDPOINT)) {
            this.wssProxyEndpoint = value;
        } else if (attr.equals(KS_FILE)) {
            this.ksFile = value;
        } else if (attr.equals(KS_PASSWD)) {
            this.ksPasswd = value;
        } else if (attr.equals(KEY_PASSWD)) {
            this.keyPasswd = value;
        } else if (attr.equals(RESPONSE_SIGN)) {
            this.isResponseSigned = Boolean.valueOf(value);
        } else if (attr.equals(RESPONSE_ENCRYPT)) {
            this.isResponseEncrypted = Boolean.valueOf(value);
        } else if (attr.equals(REQUEST_SIGN)) {
            this.isRequestSigned = Boolean.valueOf(value);
        } else if (attr.equals(REQUEST_ENCRYPT)) {
            this.isRequestEncrypted = Boolean.valueOf(value);
        } else if (attr.equals(REQUEST_HEADER_ENCRYPT)) {
            this.isRequestHeaderEncrypted = Boolean.valueOf(value);
        } else if (attr.equals(KEY_ALIAS)) {
            this.privateKeyAlias = value;
        } else if (attr.equals(PUBLIC_KEY_ALIAS)) {
            this.publicKeyAlias = value;
        } else if (attr.equals(KEY_TYPE)) {
            this.privateKeyType = value;
        } else if (attr.equals(SERVICE_TYPE)) {
            this.serviceType = value;
        } else if (attr.equals(USE_DEFAULT_KEYSTORE)) {
            this.isDefaultKeyStore = Boolean.valueOf(value);
        } else if (attr.equals(DISCOVERY_TRUST_AUTHORITY)) {
            if (value != null && value.length() != 0 && !value.equals("[Empty]")) {
                try {
                    this.taconfig = TrustAuthorityConfig.getConfig(value, "DiscoveryAgent");
                }
                catch (ProviderException pe) {
                    ProviderUtils.debug.error("AgentProvider.setAttribute: error", pe);
                }
            }
        } else if (attr.equals(STS_TRUST_AUTHORITY)) {
            if (value != null && value.length() != 0 && !value.equals("[Empty]")) {
                try {
                    this.taconfig = TrustAuthorityConfig.getConfig(value, "STSAgent");
                }
                catch (ProviderException pe) {
                    ProviderUtils.debug.error("AgentProvider.setAttribute: error", pe);
                }
            }
        } else if (attr.startsWith(PROPERTY)) {
            this.properties.put(attr.substring(PROPERTY.length()), value);
        } else if (attr.equals(USER_CREDENTIAL)) {
            if (value != null && value.length() != 0) {
                if (this.usercredentials == null) {
                    this.usercredentials = new ArrayList();
                }
                StringTokenizer stVal = new StringTokenizer(value, ",");
                while (stVal.hasMoreTokens()) {
                    StringTokenizer st1;
                    String tmpVal = stVal.nextToken();
                    int index = tmpVal.indexOf("|");
                    if (index == -1) {
                        return;
                    }
                    String usertmp = tmpVal.substring(0, index);
                    String passwordtmp = tmpVal.substring(index + 1, tmpVal.length());
                    String user = null;
                    String password = null;
                    StringTokenizer st = new StringTokenizer(usertmp, ":");
                    if (USER_NAME.equals(st.nextToken()) && st.hasMoreTokens()) {
                        user = st.nextToken();
                    }
                    if (USER_PASSWORD.equals((st1 = new StringTokenizer(passwordtmp, ":")).nextToken()) && st1.hasMoreTokens()) {
                        password = st1.nextToken();
                    }
                    if (user == null || password == null) continue;
                    PasswordCredential credential = new PasswordCredential(user, password);
                    this.usercredentials.add(credential);
                }
            }
        } else if (attr.equals(FORCE_AUTHENTICATION)) {
            if (value != null && value.length() != 0) {
                this.forceAuthn = Boolean.valueOf(value);
            }
        } else if (attr.equals(KEEP_SECURITY_HEADERS)) {
            this.preserveSecHeaders = Boolean.valueOf(value);
        } else if (attr.equals(AUTHENTICATION_CHAIN)) {
            if (value != null && value.length() != 0 && !value.equals("[Empty]")) {
                this.authenticationChain = value;
            }
        } else if (attr.equals(SAML_ATTRIBUTE_MAPPING)) {
            if (this.samlAttributes == null) {
                this.samlAttributes = new HashSet();
            }
            if (value != null && !value.equals("")) {
                this.samlAttributes.add(value);
            }
        } else if (attr.equals(INCLUDE_MEMBERSHIPS)) {
            if (value != null && value.length() != 0) {
                this.includeMemberships = Boolean.valueOf(value);
            }
        } else if (attr.equals(SAML_ATTRIBUTE_NS)) {
            this.attributeNS = value;
        } else if (attr.equals(NAMEID_MAPPER)) {
            this.nameIDMapper = value;
        } else if (ProviderUtils.debug.messageEnabled()) {
            ProviderUtils.debug.message("AgentProvider.setConfig: Invalid Attribute configured." + attr);
        }
    }

    public void store() throws ProviderException {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(AGENT_TYPE_ATTR, this.providerType);
        config.put(AGENT_PASSWORD_ATTR, this.providerName);
        config.put(AGENT_DEVICE_STATUS_ATTR, "Active");
        if (this.wspEndpoint != null) {
            config.put(WSP_ENDPOINT, this.wspEndpoint);
        }
        if (this.wssProxyEndpoint != null) {
            config.put(WSS_PROXY_ENDPOINT, this.wssProxyEndpoint);
        }
        if (this.ksFile != null) {
            config.put(KS_FILE, this.ksFile);
        }
        if (this.ksPasswd != null) {
            config.put(KS_PASSWD, this.ksPasswd);
        }
        if (this.keyPasswd != null) {
            config.put(KEY_PASSWD, this.keyPasswd);
        }
        if (this.serviceType != null) {
            config.put(SERVICE_TYPE, this.serviceType);
        }
        HashSet<String> secMechSet = new HashSet<String>();
        if (this.secMech != null) {
            Iterator iter = this.secMech.iterator();
            while (iter.hasNext()) {
                secMechSet.add((String)iter.next());
            }
        }
        config.put(RESPONSE_SIGN, Boolean.toString(this.isResponseSigned));
        config.put(RESPONSE_ENCRYPT, Boolean.toString(this.isResponseEncrypted));
        config.put(REQUEST_SIGN, Boolean.toString(this.isRequestSigned));
        config.put(REQUEST_ENCRYPT, Boolean.toString(this.isRequestEncrypted));
        config.put(REQUEST_HEADER_ENCRYPT, Boolean.toString(this.isRequestHeaderEncrypted));
        config.put(USE_DEFAULT_KEYSTORE, Boolean.toString(this.isDefaultKeyStore));
        if (this.providerType != null && this.providerType.equals("WSCAgent")) {
            config.put(FORCE_AUTHENTICATION, Boolean.toString(this.forceAuthn));
        }
        config.put(KEEP_SECURITY_HEADERS, Boolean.toString(this.preserveSecHeaders));
        if (this.authenticationChain != null) {
            config.put(AUTHENTICATION_CHAIN, this.authenticationChain);
        }
        if (this.privateKeyAlias != null) {
            config.put(KEY_ALIAS, this.privateKeyAlias);
        }
        if (this.privateKeyType != null) {
            config.put(KEY_TYPE, this.privateKeyType);
        }
        if (this.publicKeyAlias != null) {
            config.put(PUBLIC_KEY_ALIAS, this.publicKeyAlias);
        }
        Enumeration<?> props = this.properties.propertyNames();
        while (props.hasMoreElements()) {
            String propertyName = (String)props.nextElement();
            String propertyValue = this.properties.getProperty(propertyName);
            config.put(PROPERTY + propertyName, propertyValue);
        }
        if (this.usercredentials != null) {
            Iterator iter = this.usercredentials.iterator();
            StringBuffer sb = new StringBuffer(100);
            while (iter.hasNext()) {
                PasswordCredential cred = (PasswordCredential)iter.next();
                String user = cred.getUserName();
                String password = cred.getPassword();
                if (user == null || password == null) continue;
                sb.append(USER_NAME).append(":").append(user).append("|").append(USER_PASSWORD).append(":").append(password).append(",");
            }
            sb = sb.deleteCharAt(sb.length() - 1);
            config.put(USER_CREDENTIAL, sb.toString());
        }
        String stsTA = null;
        String discoTA = null;
        if (this.taconfig != null) {
            if (this.taconfig.getType().equals(STS_TRUST_AUTHORITY)) {
                stsTA = this.taconfig.getName();
            }
            if (this.taconfig.getType().equals(DISCOVERY_TRUST_AUTHORITY)) {
                discoTA = this.taconfig.getName();
            }
        }
        if (stsTA != null) {
            config.put(STS_TRUST_AUTHORITY, stsTA);
        }
        if (discoTA != null) {
            config.put(DISCOVERY_TRUST_AUTHORITY, discoTA);
        }
        if (this.attributeNS != null) {
            config.put(SAML_ATTRIBUTE_NS, this.attributeNS);
        }
        if (this.nameIDMapper != null) {
            config.put(NAMEID_MAPPER, this.nameIDMapper);
        }
        if (this.includeMemberships) {
            config.put(INCLUDE_MEMBERSHIPS, Boolean.toString(this.includeMemberships));
        }
        try {
            HashMap<String, Set> attributes = new HashMap<String, Set>();
            HashSet<String> values = null;
            for (String key : config.keySet()) {
                String value = (String)config.get(key);
                values = new HashSet<String>();
                values.add(value);
                attributes.put(key, values);
            }
            if (secMechSet != null) {
                attributes.put(SEC_MECH, secMechSet);
            }
            if (this.samlAttributes != null && !this.samlAttributes.isEmpty()) {
                attributes.put(SAML_ATTRIBUTE_MAPPING, this.samlAttributes);
            }
            if (this.profilePresent) {
                attributes.remove(AGENT_TYPE_ATTR);
                AMIdentity id = new AMIdentity(this.token, this.providerName, IdType.AGENTONLY, "/", null);
                if (debug.messageEnabled()) {
                    debug.message("Attributes to be stored: " + attributes);
                }
                id.setAttributes(attributes);
                id.store();
            } else {
                if (this.idRepo == null) {
                    this.idRepo = new AMIdentityRepository(this.token, "/");
                }
                if (debug.messageEnabled()) {
                    debug.message("New provider - Attributes to be stored: " + attributes);
                }
                this.idRepo.createIdentity(IdType.AGENTONLY, this.providerName, attributes);
            }
        }
        catch (Exception e) {
            debug.error("AgentProvider.store: Unable to get idRepo", e);
            throw new ProviderException("idRepo exception: " + e.getMessage());
        }
    }

    public void delete() throws ProviderException {
        if (!this.profilePresent) {
            return;
        }
        try {
            if (this.idRepo == null) {
                this.idRepo = new AMIdentityRepository(this.token, "/");
            }
            AMIdentity id = new AMIdentity(this.token, this.providerName, IdType.AGENTONLY, "/", null);
            HashSet<AMIdentity> identities = new HashSet<AMIdentity>();
            identities.add(id);
            this.idRepo.deleteIdentities(identities);
        }
        catch (Exception e) {
            debug.error("AgentProvider.delete: Unable to get idRepo", e);
            throw new ProviderException("idRepo exception: " + e.getMessage());
        }
    }

    private String getKeyValue(String key, String value) {
        return key + "=" + value;
    }

    public boolean isExists() {
        return this.profilePresent;
    }

    static {
        debug = ProviderUtils.debug;
        attrNames.add(SEC_MECH);
        attrNames.add(WSP_ENDPOINT);
        attrNames.add(WSS_PROXY_ENDPOINT);
        attrNames.add(KS_FILE);
        attrNames.add(KS_PASSWD);
        attrNames.add(KEY_PASSWD);
        attrNames.add(RESPONSE_SIGN);
        attrNames.add(RESPONSE_ENCRYPT);
        attrNames.add(REQUEST_HEADER_ENCRYPT);
        attrNames.add(REQUEST_SIGN);
        attrNames.add(REQUEST_ENCRYPT);
        attrNames.add(KEY_ALIAS);
        attrNames.add(KEY_TYPE);
        attrNames.add(PUBLIC_KEY_ALIAS);
        attrNames.add(STS_TRUST_AUTHORITY);
        attrNames.add(DISCOVERY_TRUST_AUTHORITY);
        attrNames.add(USER_CREDENTIAL);
        attrNames.add(SERVICE_TYPE);
        attrNames.add(USE_DEFAULT_KEYSTORE);
        attrNames.add(FORCE_AUTHENTICATION);
        attrNames.add(KEEP_SECURITY_HEADERS);
        attrNames.add(AUTHENTICATION_CHAIN);
        attrNames.add(INCLUDE_MEMBERSHIPS);
        attrNames.add(SAML_ATTRIBUTE_MAPPING);
        attrNames.add(SAML_ATTRIBUTE_NS);
        attrNames.add(NAMEID_MAPPER);
    }
}

