/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOToken;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.OrganizationConfigManagerImpl;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceConfigManagerImpl;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.LDAPDN;
import netscape.ldap.util.DN;

class SMSEventListenerManager
implements SMSObjectListener {
    protected static Map notificationObjects = Collections.synchronizedMap(new HashMap());
    protected static HashMap allChanges = new HashMap();
    protected static Map nodeChanges = Collections.synchronizedMap(new HashMap());
    protected static Map subNodeChanges = Collections.synchronizedMap(new HashMap());
    private static Debug debug = SMSEntry.eventDebug;
    protected static boolean initialized;

    static void initialize(SSOToken token) {
        if (!initialized) {
            try {
                initialized = true;
                SMSEntry.registerCallbackHandler(token, new SMSEventListenerManager());
                debug.message("Initialized SMS Event listner");
            }
            catch (Exception e) {
                debug.error("SMSEventListenerManager::initialize Unable to intialize SMS listener: " + e);
                initialized = false;
            }
        }
    }

    SMSEventListenerManager() {
    }

    public void objectChanged(String odn, int event) {
        this.objectChanged(odn, event, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void objectChanged(String odn, int event, boolean isLocal) {
        if (debug.messageEnabled()) {
            debug.message("SMSEventListener::entry changed for: " + odn + " type: " + event);
        }
        DN sdn = new DN(odn);
        String dn = sdn.toRFCString().toLowerCase();
        if (!isLocal && !SMSEntry.enableDataStoreNotification && event == 1) {
            HashSet<String> childDNs = new HashSet<String>();
            HashSet itemSet = new HashSet(2);
            Map map = nodeChanges;
            synchronized (map) {
                itemSet.addAll(nodeChanges.keySet());
            }
            Iterator keyitems = itemSet.iterator();
            while (keyitems.hasNext()) {
                String cdn = (String)keyitems.next();
                if (!new DN(cdn).isDescendantOf(sdn)) continue;
                childDNs.add(cdn);
            }
            if (debug.messageEnabled()) {
                debug.message("SMSEventListener::objectChanged: Sending delete event of: " + dn + " to child nodes: " + childDNs);
            }
            Iterator items = childDNs.iterator();
            while (items.hasNext()) {
                this.objectChanged((String)items.next(), event, true);
            }
        }
        SMSEventListenerManager.sendNotifications((Set)nodeChanges.get(dn), null, event);
        if (event == 0 || event == 1) {
            if (debug.messageEnabled()) {
                debug.message("SMSEventListener::entry changed for: " + dn + " sending notifications to its parents");
            }
            SMSEventListenerManager.sendNotifications((Set)subNodeChanges.get(new DN(dn).getParent().toRFCString().toLowerCase()), odn, event);
        }
        SMSEventListenerManager.sendAllChangesNotification(dn, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allObjectsChanged() {
        if (debug.messageEnabled()) {
            debug.message("SMSEventListenerManager::allObjectsChanged called");
        }
        HashSet dns = new HashSet();
        Map map = nodeChanges;
        synchronized (map) {
            Iterator items = nodeChanges.keySet().iterator();
            while (items.hasNext()) {
                dns.add(items.next());
            }
        }
        Iterator items = dns.iterator();
        while (items.hasNext()) {
            this.objectChanged((String)items.next(), 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String notifyAllNodeChanges(SSOToken token, Object object) {
        SMSEventListenerManager.initialize(token);
        String id = SMSUtils.getUniqueID();
        HashMap hashMap = allChanges;
        synchronized (hashMap) {
            allChanges.put(id, object);
        }
        return id;
    }

    protected static String notifyChangesToNode(SSOToken token, String dn, Method method, Object object, Object[] args) {
        SMSEventListenerManager.initialize(token);
        String ndn = new DN(dn).toRFCString().toLowerCase();
        return SMSEventListenerManager.addNotificationObject(nodeChanges, ndn, method, object, args);
    }

    protected static String notifyChangesToSubNodes(SSOToken token, String dn, Method method, Object object, Object[] args) {
        SMSEventListenerManager.initialize(token);
        String ndn = new DN(dn).toRFCString().toLowerCase();
        return SMSEventListenerManager.addNotificationObject(subNodeChanges, ndn, method, object, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeNotification(String notificationID) {
        NotificationObject no = (NotificationObject)notificationObjects.get(notificationID);
        if (no != null) {
            no.set.remove(no);
        }
        HashMap hashMap = allChanges;
        synchronized (hashMap) {
            allChanges.remove(notificationID);
        }
    }

    private static String addNotificationObject(Map nChangesMap, String dn, Method method, Object object, Object[] args) {
        HashSet<NotificationObject> nObjects = (HashSet<NotificationObject>)nChangesMap.get(dn);
        if (nObjects == null) {
            nObjects = new HashSet<NotificationObject>();
            nChangesMap.put(dn, nObjects);
        }
        NotificationObject no = new NotificationObject(method, object, args, nObjects);
        nObjects.add(no);
        notificationObjects.put(no.getID(), no);
        return no.getID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendAllChangesNotification(String dn, int type) {
        HashMap ac;
        HashMap hashMap = allChanges;
        synchronized (hashMap) {
            ac = (HashMap)allChanges.clone();
        }
        Iterator items = ac.values().iterator();
        while (items.hasNext()) {
            Object obj = items.next();
            if (obj instanceof ServiceConfigManagerImpl) {
                ServiceConfigManagerImpl scimpl = (ServiceConfigManagerImpl)obj;
                scimpl.entryChanged(dn, type);
            }
            if (!(obj instanceof OrganizationConfigManagerImpl)) continue;
            OrganizationConfigManagerImpl ocimpl = (OrganizationConfigManagerImpl)obj;
            ocimpl.entryChanged(dn, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendNotifications(Set nObjects, String dn, int event) {
        if (nObjects == null || nObjects.isEmpty()) {
            return;
        }
        HashSet nobjs = new HashSet(2);
        Set set = nObjects;
        synchronized (set) {
            nobjs.addAll(nObjects);
        }
        Iterator items = nobjs.iterator();
        while (items.hasNext()) {
            try {
                NotificationObject no = (NotificationObject)items.next();
                if (dn != null && no.object instanceof CachedSubEntries) {
                    CachedSubEntries cse = (CachedSubEntries)no.object;
                    if (dn.startsWith("o=")) continue;
                    if (event == 0) {
                        cse.add(LDAPDN.explodeDN(dn, true)[0]);
                        continue;
                    }
                    cse.remove(LDAPDN.explodeDN(dn, true)[0]);
                    continue;
                }
                no.method.invoke(no.object, no.args);
            }
            catch (Exception e) {
                debug.error("SMSEvent notification: Unable to send notification: ", e);
            }
        }
    }

    private static class NotificationObject {
        String id;
        Method method;
        Object object;
        Object[] args;
        Set set;

        NotificationObject(Method m, Object o, Object[] a, Set s) {
            this.method = m;
            this.object = o;
            this.args = a;
            this.set = s;
        }

        String getID() {
            if (this.id == null) {
                this.id = SMSUtils.getUniqueID();
            }
            return this.id;
        }

        public boolean equals(Object o) {
            if (o instanceof NotificationObject) {
                NotificationObject no = (NotificationObject)o;
                if (this.id == no.id) {
                    return true;
                }
            }
            return false;
        }
    }
}

