/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared.test.tools;

import com.sun.identity.shared.test.tools.TestCase;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Test {
    private String name;
    private int numberOfTests;
    private int numberOfFailures;
    private int numberOfErrors;
    private float timeTaken;
    private List<TestCase> testcases = new ArrayList<TestCase>();

    public Test(File f) throws ParserConfigurationException, SAXException, IOException {
        this.parseXML(f);
    }

    public boolean passed() {
        return this.getSkippedTestCases().isEmpty() && this.getFailedTestCases().isEmpty();
    }

    public List<TestCase> getPassedTestCases() {
        ArrayList<TestCase> passed = new ArrayList<TestCase>();
        for (TestCase tc : this.testcases) {
            if (!tc.passed()) continue;
            passed.add(tc);
        }
        return passed;
    }

    public List<TestCase> getSkippedTestCases() {
        ArrayList<TestCase> skipped = new ArrayList<TestCase>();
        for (TestCase tc : this.testcases) {
            if (!tc.skipped()) continue;
            skipped.add(tc);
        }
        return skipped;
    }

    public List<TestCase> getFailedTestCases() {
        ArrayList<TestCase> failed = new ArrayList<TestCase>();
        for (TestCase tc : this.testcases) {
            if (!tc.failed()) continue;
            failed.add(tc);
        }
        return failed;
    }

    public String toHTML() {
        List<TestCase> failed = this.getFailedTestCases();
        List<TestCase> passed = this.getPassedTestCases();
        List<TestCase> skipped = this.getSkippedTestCases();
        StringBuffer buff = new StringBuffer();
        for (TestCase tc : failed) {
            buff.append(tc.toHTML());
        }
        for (TestCase tc : passed) {
            buff.append(tc.toHTML());
        }
        for (TestCase tc : skipped) {
            buff.append(tc.toHTML());
        }
        Object[] params = new Object[]{this.name, buff.toString()};
        return MessageFormat.format("<tr>\n<th colspan=\"4\" id=\"tblTest\">{0}</th>\n</tr>\n<tr>\n<th id=\"tblTestTitle\">Method Name</th>\n<th id=\"tblTestTitle\">Status</th>\n<th id=\"tblTestTitle\">Time (secs)</th>\n<th id=\"tblTestTitle\">Exception</th>\n</tr>\n<tr>\n{1}</tr>\n", params);
    }

    private void parseXML(File f) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(f);
        Element topElement = doc.getDocumentElement();
        this.name = topElement.getAttribute("name");
        this.numberOfTests = Integer.parseInt(topElement.getAttribute("tests"));
        this.numberOfFailures = Integer.parseInt(topElement.getAttribute("failures"));
        this.numberOfErrors = Integer.parseInt(topElement.getAttribute("errors"));
        this.timeTaken = Float.parseFloat(topElement.getAttribute("time"));
        NodeList childElements = topElement.getChildNodes();
        int numChildElements = childElements.getLength();
        for (int i = 0; i < numChildElements; ++i) {
            String elementName;
            Node node = childElements.item(i);
            if (node == null || node.getNodeType() != 1 || !(elementName = node.getNodeName()).equals("testcase")) continue;
            this.testcases.add(new TestCase(node));
        }
    }
}

