/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.protocol.impl;

import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.protocol.IDPList;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.RequesterID;
import com.sun.identity.saml2.protocol.Scoping;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScopingImpl
implements Scoping {
    private static final String PROXYCOUNT = "ProxyCount";
    private IDPList idpList;
    private List requesterIDList = null;
    private boolean isMutable = false;
    private Integer proxyCount;

    public ScopingImpl() {
        this.isMutable = true;
    }

    public ScopingImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
    }

    public ScopingImpl(String xmlString) throws SAML2Exception {
        Document xmlDocument = XMLUtils.toDOMDocument(xmlString, SAML2SDKUtils.debug);
        if (xmlDocument == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        this.parseElement(xmlDocument.getDocumentElement());
    }

    public IDPList getIDPList() {
        return this.idpList;
    }

    public void setIDPList(IDPList idpList) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.idpList = idpList;
    }

    public List getRequesterIDs() {
        return this.requesterIDList;
    }

    public void setRequesterIDs(List value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.requesterIDList = value;
    }

    public Integer getProxyCount() {
        return this.proxyCount;
    }

    public void setProxyCount(Integer proxyCount) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.proxyCount = proxyCount;
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        String xmlElementString = null;
        if (this.idpList != null || !this.requesterIDList.isEmpty() || this.proxyCount != null) {
            this.validateProxyCount(this.proxyCount);
            StringBuffer xmlString = new StringBuffer(300);
            xmlString.append("<");
            if (includeNSPrefix) {
                xmlString.append("samlp:");
            }
            xmlString.append("Scoping");
            if (declareNS) {
                xmlString.append(" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\"");
            }
            if (this.proxyCount != null) {
                xmlString.append(" ").append(PROXYCOUNT).append("=").append("\"").append(this.proxyCount).append("\"");
            }
            xmlString.append(">").append("\n");
            if (this.idpList != null) {
                xmlString.append(this.idpList.toXMLString(includeNSPrefix, declareNS)).append("\n");
            }
            if (this.requesterIDList != null && !this.requesterIDList.isEmpty()) {
                Iterator it = this.requesterIDList.iterator();
                while (it.hasNext()) {
                    RequesterID reqID = (RequesterID)it.next();
                    String reqIDStr = reqID.toXMLString(includeNSPrefix, declareNS);
                    xmlString.append(reqIDStr).append("\n");
                }
            }
            xmlString.append("</samlp:").append("Scoping").append(">");
            xmlElementString = xmlString.toString();
        }
        return xmlElementString;
    }

    public void makeImmutable() {
        if (this.isMutable) {
            this.idpList.makeImmutable();
            Iterator i = this.requesterIDList.iterator();
            while (i.hasNext()) {
                RequesterID reqID = (RequesterID)i.next();
                reqID.makeImmutable();
            }
            this.isMutable = false;
        }
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    private void parseElement(Element element) throws SAML2Exception {
        NodeList nList;
        String proxyCountStr = element.getAttribute(PROXYCOUNT);
        if (proxyCountStr != null && proxyCountStr.length() > 0) {
            this.proxyCount = new Integer(proxyCountStr);
            this.validateProxyCount(this.proxyCount);
        }
        if ((nList = element.getChildNodes()) != null || nList.getLength() > 0) {
            if (this.requesterIDList == null || this.requesterIDList.isEmpty()) {
                this.requesterIDList = new ArrayList();
            }
            for (int i = 0; i < nList.getLength(); ++i) {
                Node childNode = nList.item(i);
                String cName = childNode.getLocalName();
                if (cName == null) continue;
                if (cName.equals("IDPList")) {
                    this.validateIDPList();
                    this.idpList = ProtocolFactory.getInstance().createIDPList((Element)childNode);
                    continue;
                }
                if (!cName.equals("RequesterID")) continue;
                RequesterID reqID = ProtocolFactory.getInstance().createRequesterID((Element)childNode);
                this.requesterIDList.add(reqID);
            }
            if (this.requesterIDList != null && !this.requesterIDList.isEmpty()) {
                this.requesterIDList = Collections.unmodifiableList(this.requesterIDList);
            }
        }
    }

    private void validateIDPList() throws SAML2Exception {
        if (this.idpList != null) {
            SAML2SDKUtils.debug.message("Too many IDPList Elements");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("schemaViolation"));
        }
        if (this.requesterIDList != null && !this.requesterIDList.isEmpty()) {
            SAML2SDKUtils.debug.message("IDPList should be the first element");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("schemaViolation"));
        }
    }

    private void validateProxyCount(Integer proxyCount) throws SAML2Exception {
        if (proxyCount != null && (proxyCount < 0 || proxyCount > 65535)) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ProxyCount value should be a nonnegative Integer");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalidProxyCount"));
        }
    }
}

