/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.common;

import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.common.NameIDInfoKey;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import java.util.StringTokenizer;

public class NameIDInfo {
    private static final String DELIM = "|";
    private static final String NULL = "null";
    private String _hostEntityID = null;
    private String _remoteEntityID = null;
    private String _nameIDValue = null;
    private String _nameQualifier = null;
    private String _format = null;
    private String _spNameIDValue = null;
    private String _spNameQualifier = null;
    private String _role = null;
    private boolean _isAffiliation = false;
    private NameID _nameID = null;

    private NameIDInfo() {
    }

    public NameIDInfo(String hostEntityID, String remoteEntityID, NameID nameID, String hostEntityRole, boolean isAffiliation) throws SAML2Exception {
        if (nameID == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullNameID"));
        }
        if (hostEntityID == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullHostEntityID"));
        }
        if (remoteEntityID == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullRemoteEntityID"));
        }
        if (hostEntityRole == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullEntityRole"));
        }
        this._hostEntityID = hostEntityID;
        this._remoteEntityID = remoteEntityID;
        this._nameIDValue = nameID.getValue();
        this._nameQualifier = nameID.getNameQualifier();
        this._format = nameID.getFormat();
        this._spNameIDValue = nameID.getSPProvidedID();
        this._spNameQualifier = nameID.getSPNameQualifier();
        this._role = hostEntityRole;
        this._isAffiliation = isAffiliation;
        this._nameID = nameID;
    }

    public NameID getNameID() {
        return this._nameID;
    }

    public NameIDInfoKey getNameIDInfoKey() throws SAML2Exception {
        return new NameIDInfoKey(this._nameIDValue, this._hostEntityID, this._remoteEntityID);
    }

    public String getNameIDValue() {
        return this._nameIDValue;
    }

    public String getNameQualifier() {
        return this._nameQualifier;
    }

    public String getFormat() {
        return this._format;
    }

    public String getSPNameIDValue() {
        return this._spNameIDValue;
    }

    public String getSPNameQualifier() {
        return this._spNameQualifier;
    }

    public String getHostEntityID() {
        return this._hostEntityID;
    }

    public String getRemoteEntityID() {
        return this._remoteEntityID;
    }

    public String getHostEntityRole() {
        return this._role;
    }

    public boolean isAffiliation() {
        return this._isAffiliation;
    }

    public String toValueString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._hostEntityID).append(DELIM).append(this._remoteEntityID).append(DELIM).append(this._nameIDValue).append(DELIM);
        if (this._nameQualifier != null && this._nameQualifier.length() != 0) {
            sb.append(this._nameQualifier);
        } else {
            sb.append(NULL);
        }
        sb.append(DELIM);
        if (this._format != null && this._format.length() != 0) {
            sb.append(this._format);
        } else {
            sb.append(NULL);
        }
        sb.append(DELIM);
        if (this._spNameIDValue != null && this._spNameIDValue.length() != 0) {
            sb.append(this._spNameIDValue);
        } else {
            sb.append(NULL);
        }
        sb.append(DELIM);
        if (this._spNameQualifier != null && this._spNameQualifier.length() != 0) {
            sb.append(this._spNameQualifier);
        } else {
            sb.append(NULL);
        }
        sb.append(DELIM);
        if (this._role != null && this._role.length() != 0) {
            sb.append(this._role);
        } else {
            sb.append(NULL);
        }
        sb.append(DELIM).append(Boolean.toString(this._isAffiliation));
        return sb.toString();
    }

    public static NameIDInfo parse(String info) throws SAML2Exception {
        if (info == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullNameIDInfo"));
        }
        StringTokenizer st = new StringTokenizer(info, DELIM);
        if (st.countTokens() != 9) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("inValidNameIDInfo"));
        }
        String hostEntityID = st.nextToken();
        String remoteEntityID = st.nextToken();
        String nameIDValue = st.nextToken();
        String nameQualifier = st.nextToken();
        String format = st.nextToken();
        String spNameIDValue = st.nextToken();
        String spNameQualifier = st.nextToken();
        String role = st.nextToken();
        boolean isAffiliation = Boolean.valueOf(st.nextToken());
        NameID nameID = AssertionFactory.getInstance().createNameID();
        nameID.setValue(nameIDValue);
        if (nameQualifier != null && !NULL.equals(nameQualifier)) {
            nameID.setNameQualifier(nameQualifier);
        }
        if (spNameIDValue != null && !NULL.equals(spNameIDValue)) {
            nameID.setSPProvidedID(spNameIDValue);
        }
        if (spNameQualifier != null && !NULL.equals(spNameQualifier)) {
            nameID.setSPNameQualifier(spNameQualifier);
        }
        if (format != null && !NULL.equals(format)) {
            nameID.setFormat(format);
        }
        return new NameIDInfo(hostEntityID, remoteEntityID, nameID, role, isAffiliation);
    }
}

