/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.assertion.impl;

import com.sun.identity.saml2.assertion.Advice;
import com.sun.identity.saml2.assertion.Assertion;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.AssertionIDRef;
import com.sun.identity.saml2.assertion.EncryptedAssertion;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AdviceImpl
implements Advice {
    private List assertions = new ArrayList();
    private List encryptedAssertions = new ArrayList();
    private List assertionIDRefs = new ArrayList();
    private List assertionURIRefs = new ArrayList();
    private List additionalInfo = new ArrayList();
    private boolean isMutable = true;
    public static String ADVICE_ELEMENT = "Advice";
    public static String ASSERTION_URI_REF_ELEMENT = "AssertionURIRef";
    public static String ASSERTION_ID_REF_ELEMENT = "AssertionIDRef";
    public static String ASSERTION_ELEMENT = "Assertion";
    public static String ENCRYPTED_ASSERTION_ELEMENT = "EncryptedAssertion";

    public AdviceImpl() {
    }

    public AdviceImpl(String xml) throws SAML2Exception {
        Document document = XMLUtils.toDOMDocument(xml, SAML2SDKUtils.debug);
        if (document == null) {
            SAML2SDKUtils.debug.error("AdviceImpl.processElement(): invalid XML input");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        Element rootElement = document.getDocumentElement();
        this.processElement(rootElement);
        this.makeImmutable();
    }

    public AdviceImpl(Element element) throws SAML2Exception {
        this.processElement(element);
        this.makeImmutable();
    }

    private void processElement(Element element) throws SAML2Exception {
        if (element == null) {
            SAML2SDKUtils.debug.error("AdviceImpl.processElement(): invalid root element");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalid_element"));
        }
        String elemName = element.getLocalName();
        if (elemName == null) {
            SAML2SDKUtils.debug.error("AdviceImpl.processElement(): local name missing");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missing_local_name"));
        }
        if (!elemName.equals(ADVICE_ELEMENT)) {
            SAML2SDKUtils.debug.error("AdviceImpl.processElement(): invalid local name " + elemName);
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalid_local_name"));
        }
        NodeList nodes = element.getChildNodes();
        int numOfNodes = nodes.getLength();
        for (int nextElem = 0; nextElem < numOfNodes; ++nextElem) {
            String childName;
            Node child = nodes.item(nextElem);
            if (child.getNodeType() != 1 || (childName = child.getLocalName()) == null) continue;
            String ns = child.getNamespaceURI();
            if ("urn:oasis:names:tc:SAML:2.0:assertion".equals(ns)) {
                if (childName.equals(ASSERTION_ID_REF_ELEMENT)) {
                    this.assertionIDRefs.add(AssertionFactory.getInstance().createAssertionIDRef((Element)child));
                    continue;
                }
                if (childName.equals(ASSERTION_URI_REF_ELEMENT)) {
                    this.assertionURIRefs.add(XMLUtils.getElementValue((Element)child));
                    continue;
                }
                if (childName.equals(ASSERTION_ELEMENT)) {
                    this.assertions.add(AssertionFactory.getInstance().createAssertion((Element)child));
                    continue;
                }
                if (childName.equals(ENCRYPTED_ASSERTION_ELEMENT)) {
                    this.encryptedAssertions.add(AssertionFactory.getInstance().createEncryptedAssertion((Element)child));
                    continue;
                }
                if (childName.equals(ASSERTION_URI_REF_ELEMENT)) {
                    this.assertionURIRefs.add(XMLUtils.getElementValue((Element)child));
                    continue;
                }
                this.additionalInfo.add(XMLUtils.print((Element)child));
                continue;
            }
            this.additionalInfo.add(XMLUtils.print((Element)child));
        }
    }

    public List getAssertions() {
        return this.assertions;
    }

    public void setAssertions(List assertions) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.assertions = assertions;
    }

    public List getAssertionIDRefs() {
        return this.assertionIDRefs;
    }

    public void setAssertionIDRefs(List idRefs) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.assertionIDRefs = idRefs;
    }

    public List getAssertionURIRefs() {
        return this.assertionURIRefs;
    }

    public void setAssertionURIRefs(List uriRefs) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.assertionURIRefs = uriRefs;
    }

    public List getEncryptedAssertions() {
        return this.encryptedAssertions;
    }

    public void setEncryptedAssertions(List encryptedAssertions) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.encryptedAssertions = encryptedAssertions;
    }

    public List getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(List info) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.additionalInfo = info;
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        String str;
        int i;
        StringBuffer sb = new StringBuffer(2000);
        String NS = "";
        String appendNS = "";
        if (declareNS) {
            NS = " xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\"";
        }
        if (includeNSPrefix) {
            appendNS = "saml:";
        }
        sb.append("<").append(appendNS).append(ADVICE_ELEMENT).append(NS).append(">\n");
        int length = 0;
        if (this.assertionIDRefs != null) {
            length = this.assertionIDRefs.size();
            for (i = 0; i < length; ++i) {
                AssertionIDRef assertionIDRef = (AssertionIDRef)this.assertionIDRefs.get(i);
                sb.append(assertionIDRef.toXMLString(includeNSPrefix, false));
            }
        }
        if (this.assertionURIRefs != null) {
            length = this.assertionURIRefs.size();
            for (i = 0; i < length; ++i) {
                str = (String)this.assertionURIRefs.get(i);
                sb.append("<").append(appendNS).append(ASSERTION_URI_REF_ELEMENT).append(">").append(str).append("</").append(appendNS).append(ASSERTION_URI_REF_ELEMENT).append(">\n");
            }
        }
        if (this.assertions != null) {
            length = this.assertions.size();
            for (i = 0; i < length; ++i) {
                Assertion assertion = (Assertion)this.assertions.get(i);
                sb.append(assertion.toXMLString(includeNSPrefix, false));
            }
        }
        if (this.encryptedAssertions != null) {
            length = this.encryptedAssertions.size();
            for (i = 0; i < length; ++i) {
                EncryptedAssertion ea = (EncryptedAssertion)this.encryptedAssertions.get(i);
                sb.append(ea.toXMLString(includeNSPrefix, false));
            }
        }
        if (this.additionalInfo != null) {
            length = this.additionalInfo.size();
            for (i = 0; i < length; ++i) {
                str = (String)this.additionalInfo.get(i);
                sb.append(str).append("\n");
            }
        }
        sb.append("</").append(appendNS).append(ADVICE_ELEMENT).append(">");
        return sb.toString();
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public void makeImmutable() {
        if (this.isMutable) {
            int i;
            int length;
            if (this.assertions != null) {
                length = this.assertions.size();
                for (i = 0; i < length; ++i) {
                    Assertion assertion = (Assertion)this.assertions.get(i);
                    assertion.makeImmutable();
                }
                this.assertions = Collections.unmodifiableList(this.assertions);
            }
            if (this.encryptedAssertions != null) {
                this.encryptedAssertions = Collections.unmodifiableList(this.encryptedAssertions);
            }
            if (this.assertionIDRefs != null) {
                length = this.assertionIDRefs.size();
                for (i = 0; i < length; ++i) {
                    AssertionIDRef assertionIDRef = (AssertionIDRef)this.assertionIDRefs.get(i);
                    assertionIDRef.makeImmutable();
                }
                this.assertionIDRefs = Collections.unmodifiableList(this.assertionIDRefs);
            }
            if (this.assertionURIRefs != null) {
                this.assertionURIRefs = Collections.unmodifiableList(this.assertionURIRefs);
            }
            if (this.additionalInfo != null) {
                this.additionalInfo = Collections.unmodifiableList(this.additionalInfo);
            }
            this.isMutable = false;
        }
    }

    public boolean isMutable() {
        return this.isMutable;
    }
}

