/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.plugins;

import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.plugins.DefaultPartnerAccountMapper;
import com.sun.identity.sm.SMSEntry;
import java.util.Map;
import netscape.ldap.util.DN;

public class NameIDPartnerAccountMapper
extends DefaultPartnerAccountMapper {
    protected void getUser(Subject subject, String sourceID, Map map) {
        NameIdentifier nameIdentifier = subject.getNameIdentifier();
        if (nameIdentifier != null) {
            String name = nameIdentifier.getName();
            if (name != null && !name.equals("")) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("NameIDPartnerAccountMapper: name=" + name);
                }
                map.put("name", this.getUserName(name));
            } else {
                SAMLUtils.debug.warning("NameIDPAccountMapper: Name is null");
                map.put("name", ANONYMOUS_USER);
            }
            String rootSuffix = SMSEntry.getRootSuffix();
            map.put("org", rootSuffix);
        }
    }

    private String getUserName(String name) {
        if (DN.isDN(name)) {
            DN dn1 = new DN(name);
            String[] eDN = dn1.explodeDN(true);
            return this.removeAt(eDN[0]);
        }
        return this.removeAt(name);
    }

    private String removeAt(String name) {
        int loc = name.indexOf("@");
        if (loc != -1) {
            return name.substring(0, loc);
        }
        return name;
    }
}

