/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.Cache;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.InvalidFormatException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.NoPermissionException;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.Referrals;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.Rule;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.interfaces.Referral;
import com.sun.identity.policy.plugins.OrgReferral;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.SchemaException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceManager;
import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import netscape.ldap.util.DN;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResourceManager {
    private String org = "/";
    private SSOToken token = null;
    private ServiceConfigManager scm = null;
    private boolean canCreateNewRes = false;
    ServiceTypeManager stm = null;
    private ServiceConfig rConfig = null;
    private Hashtable serviceTypeHash = new Hashtable();
    private static final String RESOURCES_XML = "xmlresources";
    private static final String RESOURCE_PREFIXES = "resourceprefixes";
    static final String EMPTY_RESOURCE_NAME = "---EMPTY---";
    static final String LTS = "<";
    static final String LTSS = "</";
    static final String GTS = ">";
    static final String SGTS = "/>";
    static final String SPACE = " ";
    static final String QUOTE = "\"";
    static final String EQUALS = "=";
    static final String NEW_LINE = "\n";
    static final String RESOURCE_PREFIXES_XML = "resourcePrefixesXml";
    static final String ATTRIBUTE_VALUE_PAIR = "AttributValuePair";
    static final String PREFIX = "Prefix";
    static final String NAME = "name";
    static final String COUNT = "count";
    Cache policyNames = new Cache(1000);

    ResourceManager(SSOToken token, String orgName, ServiceConfigManager scm) throws SSOException {
        this.token = token;
        this.org = orgName;
        this.scm = scm;
        DN orgDN = new DN(this.org);
        DN baseDN = new DN(ServiceManager.getBaseDN());
        this.stm = ServiceTypeManager.getServiceTypeManager();
        String serviceName = scm.getName();
        this.canCreateNewRes = orgDN.equals(baseDN);
    }

    public Set getManagedResourceNames() throws PolicyException {
        HashSet managedResources = null;
        ServiceConfig resources = this.getResourcesServiceConfig(false);
        if (resources == null) {
            managedResources = Collections.EMPTY_SET;
        } else {
            Set resourceTypes = null;
            try {
                resourceTypes = resources.getSubConfigNames();
            }
            catch (SMSException e1) {
                throw new PolicyException(e1);
            }
            if (resourceTypes == null || resourceTypes.isEmpty()) {
                managedResources = Collections.EMPTY_SET;
            } else {
                managedResources = new HashSet();
                Iterator rtIter = resourceTypes.iterator();
                while (rtIter.hasNext()) {
                    String resourceType = (String)rtIter.next();
                    managedResources.addAll(this.getManagedResourceNames(resourceType));
                }
            }
        }
        return managedResources;
    }

    public Set getManagedResourceNames(String serviceType) throws PolicyException {
        Set existingRes;
        ServiceConfig resources = this.getResourcesServiceConfig(false);
        if (resources == null) {
            return Collections.EMPTY_SET;
        }
        ServiceConfig leafConfig = null;
        try {
            leafConfig = resources.getSubConfig(serviceType);
        }
        catch (SMSException e1) {
            throw new PolicyException(e1);
        }
        catch (SSOException e1) {
            throw new PolicyException("amPolicy", "invalid_sso_token", null, null);
        }
        if (leafConfig == null) {
            return Collections.EMPTY_SET;
        }
        Map existingAttrs = null;
        existingAttrs = leafConfig.getAttributes();
        if (existingAttrs == null || !existingAttrs.containsKey(RESOURCE_PREFIXES)) {
            return Collections.EMPTY_SET;
        }
        Set resourcePrefixes = existingRes = (Set)existingAttrs.get(RESOURCE_PREFIXES);
        if (existingRes != null && !existingRes.isEmpty()) {
            String xmlPrefix = (String)existingRes.iterator().next();
            resourcePrefixes = this.xmlToResourcePrefixes(xmlPrefix).keySet();
        }
        return resourcePrefixes;
    }

    public boolean canCreateNewResource(String ServiceType2) throws PolicyException {
        return this.canCreateNewRes;
    }

    public Set getValidServiceNames() throws SSOException, PolicyException {
        HashSet<String> answer = null;
        Iterator serviceNames = this.stm.getServiceTypeNames().iterator();
        while (serviceNames.hasNext()) {
            String serviceName = (String)serviceNames.next();
            if (!this.canCreateNewResource(serviceName) && this.getManagedResourceNames(serviceName).isEmpty()) continue;
            if (answer == null) {
                answer = new HashSet<String>();
            }
            answer.add(serviceName);
        }
        return answer == null ? Collections.EMPTY_SET : answer;
    }

    public Set getPolicyNames(String serviceType, String resource, boolean includePoliciesForSuperResources) throws InvalidFormatException, NoPermissionException, PolicyException, SSOException {
        StringBuffer cacheNameBuffer = new StringBuffer();
        String cacheName = cacheNameBuffer.append(serviceType).append(resource).append(includePoliciesForSuperResources).toString();
        Set answer = null;
        answer = (Set)this.policyNames.get(cacheName);
        if (answer != null) {
            return answer;
        }
        Node rootNode = this.getXMLRootNode(serviceType);
        if (rootNode == null) {
            return Collections.EMPTY_SET;
        }
        ServiceType st = this.getServiceType(serviceType);
        answer = this.getPolicyNames(rootNode, null, st, resource, includePoliciesForSuperResources);
        this.policyNames.put(cacheName, answer);
        return answer;
    }

    private ServiceType getServiceType(String serviceType) throws SSOException, NameNotFoundException {
        ServiceType st = (ServiceType)this.serviceTypeHash.get(serviceType);
        if (st == null) {
            st = this.stm.getServiceType(serviceType);
            this.serviceTypeHash.put(serviceType, st);
        }
        return st;
    }

    void addPolicyToResourceTree(Policy policy) throws PolicyException, SSOException {
        Set referralNames;
        Set ruleNames = policy.getRuleNames();
        Iterator i = ruleNames.iterator();
        String ruleName = null;
        Rule rule = null;
        while (i.hasNext()) {
            ruleName = (String)i.next();
            rule = policy.getRule(ruleName);
            this.addRuleToResourceTree(policy.getName(), rule);
        }
        Referrals referrals = policy.getReferrals();
        if (referrals != null && (referralNames = referrals.getReferralNames()) != null && !referralNames.isEmpty()) {
            Iterator referralIter = referralNames.iterator();
            while (referralIter.hasNext()) {
                Set values;
                String referralName = (String)referralIter.next();
                Referral referral = referrals.getReferral(referralName);
                if (!(referral instanceof OrgReferral) || (values = referral.getValues()) == null || values.isEmpty()) continue;
                Iterator valueIter = values.iterator();
                while (valueIter.hasNext()) {
                    String value = (String)valueIter.next();
                    PolicyManager pm = new PolicyManager(this.token, value);
                    ResourceManager rm = pm.getResourceManager();
                    Set ruleNames1 = policy.getRuleNames();
                    Iterator ruleIter = ruleNames1.iterator();
                    while (ruleIter.hasNext()) {
                        String ruleName1 = (String)ruleIter.next();
                        Rule rule1 = policy.getRule(ruleName1);
                        String resourceName = rule1.getResourceName();
                        if (resourceName == null) continue;
                        String serviceTypeName = rule1.getServiceTypeName();
                        HashSet<String> resourceNames = new HashSet<String>();
                        resourceNames.add(resourceName);
                        rm.addResourcePrefixes(serviceTypeName, resourceNames);
                    }
                }
            }
        }
    }

    void removePolicyFromResourceTree(Policy policy) throws PolicyException, SSOException {
        Set referralNames;
        Set ruleNames = policy.getRuleNames();
        Iterator i = ruleNames.iterator();
        String ruleName = null;
        Rule rule = null;
        while (i.hasNext()) {
            ruleName = (String)i.next();
            rule = policy.getRule(ruleName);
            this.removeRuleFromResourceTree(policy.getName(), rule.getResourceName(), rule.getServiceTypeName(), rule.getServiceType());
        }
        Referrals referrals = policy.getReferrals();
        if (referrals != null && (referralNames = referrals.getReferralNames()) != null && !referralNames.isEmpty()) {
            Iterator referralIter = referralNames.iterator();
            while (referralIter.hasNext()) {
                Set values;
                String referralName = (String)referralIter.next();
                Referral referral = referrals.getReferral(referralName);
                if (!(referral instanceof OrgReferral) || (values = referral.getValues()) == null || values.isEmpty()) continue;
                Iterator valueIter = values.iterator();
                while (valueIter.hasNext()) {
                    String value = (String)valueIter.next();
                    PolicyManager pm = new PolicyManager(this.token, value);
                    ResourceManager rm = pm.getResourceManager();
                    Iterator ruleIter = policy.getRuleNames().iterator();
                    while (ruleIter.hasNext()) {
                        String ruleName1 = (String)ruleIter.next();
                        Rule rule1 = policy.getRule(ruleName);
                        String resourceName = rule1.getResourceName();
                        if (resourceName == null) continue;
                        String serviceTypeName = rule1.getServiceTypeName();
                        HashSet<String> resourceNames = new HashSet<String>();
                        resourceNames.add(resourceName);
                        rm.removeResourcePrefixes(serviceTypeName, resourceNames);
                    }
                }
            }
        }
    }

    void replacePolicyInResourceTree(Policy oldPolicy, Policy newPolicy) throws PolicyException, SSOException {
        this.removePolicyFromResourceTree(oldPolicy);
        this.addPolicyToResourceTree(newPolicy);
    }

    private ServiceConfig getResourcesServiceConfig(boolean create) throws PolicyException {
        if (this.rConfig == null) {
            try {
                ServiceConfig oConfig;
                this.rConfig = create ? PolicyManager.createOrGetPolicyConfig("Resources", "Resources", this.scm, this.org) : ((oConfig = this.scm.getOrganizationConfig(this.org, null)) == null ? null : oConfig.getSubConfig("Resources"));
            }
            catch (SMSException e) {
                throw new PolicyException(e);
            }
            catch (SSOException e) {
                throw new PolicyException("amPolicy", "invalid_sso_token", null, null);
            }
        }
        return this.rConfig;
    }

    private void addRuleToResourceTree(String policyName, Rule rule) throws PolicyException, SSOException {
        Node rootNode;
        ServiceConfig resources;
        String resourceName = rule.getResourceName();
        String serviceTypeName = rule.getServiceTypeName();
        ServiceType st = rule.getServiceType();
        if (resourceName == null || resourceName.length() == 0) {
            resourceName = EMPTY_RESOURCE_NAME;
        }
        if ((resources = this.getResourcesServiceConfig(true)) == null) {
            return;
        }
        ServiceConfig leafConfig = null;
        try {
            leafConfig = resources.getSubConfig(serviceTypeName);
        }
        catch (SMSException e1) {
            throw new PolicyException(e1);
        }
        if (leafConfig == null) {
            try {
                String newResourcesXml = rule.toResourcesXml(policyName);
                HashMap newAttrs = new HashMap();
                HashSet<String> newSet = new HashSet<String>();
                newSet.add(newResourcesXml);
                newAttrs.put(RESOURCES_XML, newSet);
                resources.addSubConfig(serviceTypeName, "ServiceType", 0, newAttrs);
            }
            catch (SMSException e2) {
                throw new PolicyException(e2);
            }
            return;
        }
        Map existingAttrs = null;
        existingAttrs = leafConfig.getAttributes();
        if (existingAttrs == null || !existingAttrs.containsKey(RESOURCES_XML)) {
            try {
                String newResourcesXml = rule.toResourcesXml(policyName);
                HashSet<String> newSet = new HashSet<String>();
                newSet.add(newResourcesXml);
                leafConfig.addAttribute(RESOURCES_XML, newSet);
            }
            catch (SMSException e4) {
                throw new PolicyException(e4);
            }
            return;
        }
        Set existingRes = (Set)existingAttrs.get(RESOURCES_XML);
        if (existingRes.isEmpty()) {
            try {
                String newResourcesXml = rule.toResourcesXml(policyName);
                HashMap newAttrs = new HashMap();
                HashSet<String> newSet = new HashSet<String>();
                newSet.add(newResourcesXml);
                newAttrs.put(RESOURCES_XML, newSet);
                leafConfig.setAttributes(newAttrs);
            }
            catch (SMSException e5) {
                throw new PolicyException(e5);
            }
            return;
        }
        Object[] retVal = this.getXMLRootNode(existingRes);
        Document doc = (Document)retVal[1];
        boolean modified = this.matchAndAddReferenceNode(doc, rootNode = (Node)retVal[0], resourceName, policyName, st);
        if (!modified) {
            return;
        }
        String modifiedResourcesXml = SMSSchema.nodeToString(rootNode);
        HashMap modifiedAttrs = new HashMap();
        HashSet<String> modifiedSet = new HashSet<String>();
        modifiedSet.add(modifiedResourcesXml);
        modifiedAttrs.put(RESOURCES_XML, modifiedSet);
        try {
            leafConfig.setAttributes(modifiedAttrs);
        }
        catch (SMSException e6) {
            throw new PolicyException(e6);
        }
    }

    private void removeRuleFromResourceTree(String policyName, String resourceName, String serviceTypeName, ServiceType st) throws PolicyException, SSOException {
        ServiceConfig resources;
        if (resourceName == null || resourceName.length() == 0) {
            resourceName = EMPTY_RESOURCE_NAME;
        }
        if ((resources = this.getResourcesServiceConfig(false)) == null) {
            return;
        }
        ServiceConfig leafConfig = null;
        try {
            leafConfig = resources.getSubConfig(serviceTypeName);
        }
        catch (SMSException e1) {
            throw new PolicyException(e1);
        }
        if (leafConfig == null) {
            return;
        }
        Map existingAttrs = null;
        existingAttrs = leafConfig.getAttributes();
        if (existingAttrs == null || !existingAttrs.containsKey(RESOURCES_XML)) {
            return;
        }
        int n = existingAttrs.size();
        Set existingRes = (Set)existingAttrs.get(RESOURCES_XML);
        if (existingRes.isEmpty()) {
            return;
        }
        Object[] retVal = this.getXMLRootNode(existingRes);
        Node rootNode = (Node)retVal[0];
        boolean modified = this.matchAndRemoveReferenceNode(rootNode, resourceName, policyName, st, new Stack());
        if (!modified) {
            return;
        }
        if (!rootNode.hasChildNodes()) {
            try {
                leafConfig.removeAttribute(RESOURCES_XML);
                if (n == 1) {
                    resources.removeSubConfig(serviceTypeName);
                }
                return;
            }
            catch (SMSException e3) {
                throw new PolicyException(e3);
            }
        }
        String modifiedResourcesXml = SMSSchema.nodeToString(rootNode);
        HashMap modifiedAttrs = new HashMap();
        HashSet<String> modifiedSet = new HashSet<String>();
        modifiedSet.add(modifiedResourcesXml);
        modifiedAttrs.put(RESOURCES_XML, modifiedSet);
        try {
            leafConfig.setAttributes(modifiedAttrs);
        }
        catch (SMSException e4) {
            throw new PolicyException(e4);
        }
    }

    private boolean matchAndAddReferenceNode(Document doc, Node node, String resource, String policyName, ServiceType st) throws PolicyException {
        boolean modified = true;
        Set referenceNodes = XMLUtils.getChildNodes(node, "Reference");
        if (referenceNodes == null || referenceNodes.isEmpty()) {
            this.addReferenceNodes(doc, node, resource, policyName, st);
            return modified;
        }
        Iterator items = referenceNodes.iterator();
        Node referenceNode = null;
        String referenceName = null;
        ResourceMatch matchResult = null;
        boolean hasMatch = false;
        while (items.hasNext()) {
            referenceNode = (Node)items.next();
            referenceName = XMLUtils.getNodeAttributeValue(referenceNode, NAME);
            matchResult = st.compare(resource, referenceName);
            if (matchResult.equals(ResourceMatch.EXACT_MATCH)) {
                hasMatch = true;
                Set policyNames = this.getPolicyNames(referenceNode);
                if (policyNames.contains(policyName)) {
                    modified = false;
                    break;
                }
                this.addPolicyNameNode(doc, referenceNode, policyName);
                break;
            }
            if (!matchResult.equals(ResourceMatch.SUPER_RESOURCE_MATCH)) continue;
            hasMatch = true;
            String subResource = st.getSubResource(resource, referenceName);
            modified = this.matchAndAddReferenceNode(doc, referenceNode, subResource, policyName, st);
            break;
        }
        if (!hasMatch) {
            this.addReferenceNodes(doc, node, resource, policyName, st);
        }
        return modified;
    }

    private boolean matchAndRemoveReferenceNode(Node node, String resource, String policyName, ServiceType st, Stack stack) throws PolicyException {
        Set referenceNodes = XMLUtils.getChildNodes(node, "Reference");
        if (referenceNodes == null || referenceNodes.isEmpty()) {
            return false;
        }
        Iterator items = referenceNodes.iterator();
        Node referenceNode = null;
        String referenceName = null;
        ResourceMatch matchResult = null;
        while (items.hasNext()) {
            referenceNode = (Node)items.next();
            referenceName = XMLUtils.getNodeAttributeValue(referenceNode, NAME);
            matchResult = st.compare(resource, referenceName);
            if (matchResult.equals(ResourceMatch.EXACT_MATCH)) {
                stack.push(node);
                return this.removePolicyNameNode(referenceNode, policyName, stack);
            }
            if (!matchResult.equals(ResourceMatch.SUPER_RESOURCE_MATCH)) continue;
            String subResource = st.getSubResource(resource, referenceName);
            stack.push(node);
            return this.matchAndRemoveReferenceNode(referenceNode, subResource, policyName, st, stack);
        }
        return false;
    }

    private void addPolicyNameNode(Document doc, Node referenceNode, String policyName) throws PolicyException {
        Element element = doc.createElement("PolicyName");
        element.setAttribute(NAME, policyName);
        referenceNode.appendChild(element);
    }

    private boolean removePolicyNameNode(Node referenceNode, String policyName, Stack stack) throws PolicyException {
        Set policyNameNodes = XMLUtils.getChildNodes(referenceNode, "PolicyName");
        Iterator items = policyNameNodes.iterator();
        Node policyNameNode = null;
        String policyNameAttr = null;
        while (items.hasNext()) {
            policyNameNode = (Node)items.next();
            policyNameAttr = XMLUtils.getNodeAttributeValue(policyNameNode, NAME);
            if (!policyNameAttr.equals(policyName)) continue;
            referenceNode.removeChild(policyNameNode);
            this.removeReferenceNodes(referenceNode, stack);
            return true;
        }
        return false;
    }

    private void addReferenceNodes(Document doc, Node parentNode, String resourceName, String policyName, ServiceType st) throws PolicyException {
        String[] resources = st.split(resourceName);
        int n = resources.length;
        if (n < 1) {
            return;
        }
        Element[] nodes = new Element[n];
        Element policyNameNode = doc.createElement("PolicyName");
        policyNameNode.setAttribute(NAME, policyName);
        nodes[n - 1] = doc.createElement("Reference");
        nodes[n - 1].setAttribute(NAME, resources[n - 1]);
        nodes[n - 1].appendChild(policyNameNode);
        for (int i = n - 2; i >= 0; --i) {
            nodes[i] = doc.createElement("Reference");
            nodes[i].setAttribute(NAME, resources[i]);
            nodes[i].appendChild(nodes[i + 1]);
        }
        parentNode.appendChild(nodes[0]);
    }

    private void removeReferenceNodes(Node referenceNode, Stack stack) {
        if (!referenceNode.hasChildNodes() && !stack.empty()) {
            Node parentRefNode = (Node)stack.pop();
            parentRefNode.removeChild(referenceNode);
            this.removeReferenceNodes(parentRefNode, stack);
        }
    }

    Node getXMLRootNode(String serviceType) throws InvalidFormatException, NoPermissionException, PolicyException {
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message("searching for resources of the service type: " + serviceType + " in organization: " + this.org);
        }
        try {
            ServiceConfig policyResources = this.getResourcesServiceConfig(false);
            if (policyResources == null) {
                if (PolicyManager.debug.messageEnabled()) {
                    PolicyManager.debug.message("Resources branch is non-existent in organization: " + this.org);
                }
                return null;
            }
            ServiceConfig serviceResources = policyResources.getSubConfig(serviceType);
            if (serviceResources == null) {
                if (PolicyManager.debug.warningEnabled()) {
                    PolicyManager.debug.warning(serviceType + " branch under Resources is null" + " in organization: " + this.org);
                }
                return null;
            }
            Map attrs = serviceResources.getAttributes();
            Set res = null;
            if (attrs != null) {
                res = (Set)attrs.get(RESOURCES_XML);
            }
            if (res == null) {
                if (PolicyManager.debug.warningEnabled()) {
                    PolicyManager.debug.warning("Unable to find resources attribute for the service: " + serviceType + " under Resources in organization: " + this.org);
                }
                return null;
            }
            if (res.isEmpty()) {
                if (PolicyManager.debug.warningEnabled()) {
                    PolicyManager.debug.warning("Unable to find resources attribute value for the service: " + serviceType + " in organization: " + this.org);
                }
                return null;
            }
            Object[] retVal = this.getXMLRootNode(res);
            return (Node)retVal[0];
        }
        catch (SMSException se) {
            PolicyManager.debug.error("Unable to get resources of the service type: " + serviceType + " in organization" + this.org);
            Object[] objs = new String[]{serviceType, this.org};
            if (se.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                throw new NoPermissionException("amPolicy", "unable_to_get_resources_for_service", objs);
            }
            throw new PolicyException(se);
        }
        catch (SSOException ssoe) {
            throw new PolicyException("amPolicy", "invalid_sso_token", null, null);
        }
    }

    private Object[] getXMLRootNode(Set xmlBlob) throws PolicyException {
        Iterator it = xmlBlob.iterator();
        String resourcesXml = (String)it.next();
        Document doc = null;
        try {
            doc = SMSSchema.getXMLDocument(resourcesXml, false);
        }
        catch (SchemaException se) {
            PolicyManager.debug.error("XML parsing error: " + resourcesXml);
            throw new PolicyException(se);
        }
        catch (SMSException smse) {
            throw new PolicyException(smse);
        }
        Node rootNode = XMLUtils.getRootNode(doc, "PolicyCrossReferences");
        if (rootNode == null) {
            PolicyManager.debug.error("invalid (no root node) xml resources blob: " + resourcesXml);
            throw new InvalidFormatException("amPolicy", "invalid_resources_blob_no_root", null, "", 3);
        }
        String referenceType = XMLUtils.getNodeAttributeValue(rootNode, "type");
        if (!referenceType.equals("Resources")) {
            PolicyManager.debug.error("invalid (no type attr for PolicyCrossReference element) xml resources blob: " + resourcesXml);
            throw new InvalidFormatException("amPolicy", "invalid_resources_blob_no_type", null, "", 3);
        }
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message("returning XML root node");
        }
        Object[] retVal = new Object[]{rootNode, doc};
        return retVal;
    }

    private Set getPolicyNames(Node node, String superRes, ServiceType st, String resource, boolean includePoliciesForSuperResources) {
        Set referenceNodes = XMLUtils.getChildNodes(node, "Reference");
        Iterator items = referenceNodes.iterator();
        Node referenceNode = null;
        String referenceName = null;
        String combinedName = null;
        ResourceMatch matchResult = null;
        while (items.hasNext()) {
            referenceNode = (Node)items.next();
            referenceName = XMLUtils.getNodeAttributeValue(referenceNode, NAME);
            combinedName = superRes == null ? referenceName : st.append(superRes, referenceName);
            matchResult = st.compare(resource, combinedName);
            if (matchResult.equals(ResourceMatch.EXACT_MATCH)) {
                return this.getPolicyNames(referenceNode);
            }
            if (!matchResult.equals(ResourceMatch.SUPER_RESOURCE_MATCH)) continue;
            if (!includePoliciesForSuperResources) {
                return this.getPolicyNames(referenceNode, combinedName, st, resource, false);
            }
            Set policyNamesForTheReferenceNode = this.getPolicyNames(referenceNode);
            Set policyNamesForChildrenNodes = this.getPolicyNames(referenceNode, combinedName, st, resource, true);
            if (policyNamesForChildrenNodes.isEmpty()) {
                return policyNamesForTheReferenceNode;
            }
            if (policyNamesForTheReferenceNode.isEmpty()) {
                return policyNamesForChildrenNodes;
            }
            policyNamesForTheReferenceNode.addAll(policyNamesForChildrenNodes);
            return policyNamesForTheReferenceNode;
        }
        if (!includePoliciesForSuperResources && superRes != null) {
            return this.getPolicyNames(referenceNode);
        }
        return Collections.EMPTY_SET;
    }

    private Set getPolicyNames(Node referenceNode) {
        if (referenceNode == null) {
            return Collections.EMPTY_SET;
        }
        Set policyNameNodes = XMLUtils.getChildNodes(referenceNode, "PolicyName");
        Iterator items = policyNameNodes.iterator();
        Node policyNameNode = null;
        String policyName = null;
        HashSet<String> retVal = new HashSet<String>();
        while (items.hasNext()) {
            policyNameNode = (Node)items.next();
            policyName = XMLUtils.getNodeAttributeValue(policyNameNode, NAME);
            retVal.add(policyName);
        }
        return retVal;
    }

    void addResourcePrefixes(String serviceTypeName, Set resourcePrefixes) throws PolicyException {
        ServiceConfig resources = this.getResourcesServiceConfig(true);
        if (resources == null) {
            return;
        }
        ServiceConfig leafConfig = null;
        try {
            leafConfig = resources.getSubConfig(serviceTypeName);
        }
        catch (SMSException e1) {
            throw new PolicyException(e1);
        }
        catch (SSOException e1) {
            throw new PolicyException("amPolicy", "invalid_sso_token", null, null);
        }
        if (leafConfig == null) {
            try {
                HashMap newAttrs = new HashMap();
                HashSet<String> newSet = new HashSet<String>();
                Map prefixMap = this.addResourcePrefixes(resourcePrefixes, new HashMap());
                newSet.clear();
                newSet.add(ResourceManager.resourcePrefixesToXml(prefixMap));
                newAttrs.put(RESOURCE_PREFIXES, newSet);
                resources.addSubConfig(serviceTypeName, "ServiceType", 0, newAttrs);
            }
            catch (SMSException e2) {
                throw new PolicyException(e2);
            }
            catch (SSOException e) {
                throw new PolicyException("amPolicy", "invalid_sso_token", null, null);
            }
            return;
        }
        Map existingAttrs = null;
        existingAttrs = leafConfig.getAttributes();
        if (existingAttrs == null || !existingAttrs.containsKey(RESOURCE_PREFIXES)) {
            try {
                HashSet<String> newSet = new HashSet<String>();
                Map prefixMap = this.addResourcePrefixes(resourcePrefixes, new HashMap());
                newSet.clear();
                newSet.add(ResourceManager.resourcePrefixesToXml(prefixMap));
                leafConfig.addAttribute(RESOURCE_PREFIXES, newSet);
            }
            catch (SMSException e4) {
                throw new PolicyException(e4);
            }
            catch (SSOException e) {
                throw new PolicyException("amPolicy", "invalid_sso_token", null, null);
            }
            return;
        }
        Set existingRes = (Set)existingAttrs.get(RESOURCE_PREFIXES);
        try {
            HashMap newAttrs = new HashMap();
            Map prefixMap = null;
            if (existingRes != null && !existingRes.isEmpty()) {
                String prefixXml = (String)existingRes.iterator().next();
                prefixMap = this.xmlToResourcePrefixes(prefixXml);
            } else {
                prefixMap = new HashMap();
            }
            prefixMap = this.addResourcePrefixes(resourcePrefixes, prefixMap);
            HashSet<String> newSet = new HashSet<String>(1);
            newSet.add(ResourceManager.resourcePrefixesToXml(prefixMap));
            newAttrs.put(RESOURCE_PREFIXES, newSet);
            leafConfig.setAttributes(newAttrs);
        }
        catch (SMSException e5) {
            throw new PolicyException(e5);
        }
        catch (SSOException e) {
            throw new PolicyException("amPolicy", "invalid_sso_token", null, null);
        }
    }

    void removeResourcePrefixes(String serviceTypeName, Set resourcePrefixes) throws PolicyException {
        ServiceConfig resources = this.getResourcesServiceConfig(false);
        if (resources == null) {
            return;
        }
        ServiceConfig leafConfig = null;
        try {
            leafConfig = resources.getSubConfig(serviceTypeName);
        }
        catch (SMSException e1) {
            throw new PolicyException(e1);
        }
        catch (SSOException e) {
            throw new PolicyException("amPolicy", "invalid_sso_token", null, null);
        }
        if (leafConfig == null) {
            return;
        }
        Map existingAttrs = null;
        existingAttrs = leafConfig.getAttributes();
        if (existingAttrs == null || !existingAttrs.containsKey(RESOURCE_PREFIXES)) {
            return;
        }
        int n = existingAttrs.size();
        Set existingSet = (Set)existingAttrs.get(RESOURCE_PREFIXES);
        Map prefixMap = null;
        if (existingSet != null && !existingSet.isEmpty()) {
            String prefixXml = (String)existingSet.iterator().next();
            prefixMap = this.xmlToResourcePrefixes(prefixXml);
        } else {
            prefixMap = new HashMap();
        }
        HashMap newAttrs = new HashMap();
        prefixMap = this.removeResourcePrefixes(resourcePrefixes, prefixMap);
        HashSet<String> newSet = new HashSet<String>(1);
        newSet.add(ResourceManager.resourcePrefixesToXml(prefixMap));
        newAttrs.put(RESOURCE_PREFIXES, newSet);
        try {
            leafConfig.setAttributes(newAttrs);
        }
        catch (SMSException e5) {
            throw new PolicyException(e5);
        }
        catch (SSOException e) {
            throw new PolicyException("amPolicy", "invalid_sso_token", null, null);
        }
    }

    public String[] splitResourceName(String serviceTypeName, String resourceName) throws NameNotFoundException, SSOException, PolicyException {
        ServiceType st = this.getServiceType(serviceTypeName);
        Set prefixes = this.getManagedResourceNames(serviceTypeName);
        String[] retVal = new String[2];
        if (prefixes.isEmpty()) {
            retVal[0] = "";
            retVal[1] = resourceName;
            return retVal;
        }
        Iterator iter = prefixes.iterator();
        String tmp = null;
        ResourceMatch matchResult = null;
        boolean foundSuperMatch = false;
        boolean foundExactMatch = false;
        while (iter.hasNext()) {
            tmp = (String)iter.next();
            matchResult = st.compare(resourceName, tmp);
            if (matchResult.equals(ResourceMatch.SUPER_RESOURCE_MATCH)) {
                foundSuperMatch = true;
                break;
            }
            if (!matchResult.equals(ResourceMatch.EXACT_MATCH)) continue;
            foundExactMatch = true;
            break;
        }
        if (foundSuperMatch) {
            retVal[0] = tmp;
            retVal[1] = st.getSubResource(resourceName, tmp);
            return retVal;
        }
        if (foundExactMatch) {
            retVal[0] = tmp;
            retVal[1] = "";
            return retVal;
        }
        retVal[0] = "";
        retVal[1] = resourceName;
        return retVal;
    }

    void saveResourceIndex(String resourceType, String indexXML) throws PolicyException, SSOException {
        HashMap newAttrs = new HashMap();
        HashSet<String> newSet = new HashSet<String>();
        newSet.add(indexXML);
        newAttrs.put(RESOURCES_XML, newSet);
        ServiceConfig resources = this.getResourcesServiceConfig(true);
        if (resources != null) {
            ServiceConfig leafConfig = null;
            try {
                leafConfig = resources.getSubConfig(resourceType);
                if (leafConfig == null) {
                    resources.addSubConfig(resourceType, "ServiceType", 0, newAttrs);
                } else {
                    leafConfig.setAttributes(newAttrs);
                }
            }
            catch (SMSException e1) {
                throw new PolicyException(e1);
            }
        }
    }

    private Map xmlToResourcePrefixes(String xmlResourcePrefixes) {
        HashMap<String, String> resourcePrefixes = new HashMap<String, String>();
        try {
            Set nodeSet;
            Node rootNode;
            Document document = XMLUtils.getXMLDocument(new ByteArrayInputStream(xmlResourcePrefixes.getBytes("UTF8")));
            if (document != null && (rootNode = XMLUtils.getRootNode(document, RESOURCE_PREFIXES)) != null && (nodeSet = XMLUtils.getChildNodes(rootNode, PREFIX)) != null) {
                Iterator nodes = nodeSet.iterator();
                while (nodes.hasNext()) {
                    Node node = (Node)nodes.next();
                    String prefix = XMLUtils.getNodeAttributeValue(node, NAME);
                    String count = XMLUtils.getNodeAttributeValue(node, COUNT);
                    if (prefix == null || count == null) continue;
                    resourcePrefixes.put(prefix, count);
                }
            }
        }
        catch (Exception xmle) {
            PolicyManager.debug.error("XML parsing error for resource prefixes  in organization: " + this.org);
        }
        return resourcePrefixes;
    }

    private static String resourcePrefixesToXml(Map resourcePrefixes) {
        StringBuffer sb = new StringBuffer(128);
        sb.append(LTS).append(RESOURCE_PREFIXES).append(GTS).append(NEW_LINE);
        Iterator prefixes = resourcePrefixes.keySet().iterator();
        while (prefixes.hasNext()) {
            String prefix = (String)prefixes.next();
            String value = (String)resourcePrefixes.get(prefix);
            sb.append(LTS).append(PREFIX).append(SPACE).append(NAME).append(EQUALS).append(QUOTE).append(XMLUtils.escapeSpecialCharacters(prefix)).append(QUOTE).append(SPACE).append(COUNT).append(EQUALS).append(QUOTE).append(value).append(QUOTE).append(SGTS).append(NEW_LINE);
        }
        sb.append(LTSS).append(RESOURCE_PREFIXES).append(GTS).append(NEW_LINE);
        return sb.toString();
    }

    private Map addResourcePrefixes(Set prefixes, Map prefixMap) {
        Iterator iter = prefixes.iterator();
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            int intValue = 0;
            String count = (String)prefixMap.get(prefix);
            if (count != null) {
                try {
                    intValue = Integer.parseInt(count);
                }
                catch (Exception e) {
                    PolicyManager.debug.error("ResourceManager.addResourcePrefixes:", e);
                }
            }
            prefixMap.put(prefix, Integer.toString(++intValue));
        }
        return prefixMap;
    }

    private Map removeResourcePrefixes(Set prefixes, Map prefixMap) {
        Iterator iter = prefixes.iterator();
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            int intValue = 0;
            String count = (String)prefixMap.get(prefix);
            if (count != null) {
                try {
                    intValue = Integer.parseInt(count);
                }
                catch (Exception e) {
                    PolicyManager.debug.error("ResourceManager.removeResourcePrefixes:", e);
                }
            }
            if (--intValue > 0) {
                prefixMap.put(prefix, Integer.toString(intValue));
                continue;
            }
            prefixMap.remove(prefix);
        }
        return prefixMap;
    }
}

