/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.Referrals;
import com.sun.identity.policy.ResourceManager;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.Rule;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.interfaces.Referral;
import com.sun.identity.policy.plugins.OrgReferral;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

class ResourceIndexManager {
    static final Debug DEBUG = PolicyManager.debug;
    static final String LTS = "<";
    static final String LTSS = "</";
    static final String GTS = ">";
    static final String SGTS = "/>";
    static final String SPACE = " ";
    static final String QUOTE = "\"";
    static final String EQUALS = "=";
    static final String NEW_LINE = "\n";
    static final String POLICY_CROSS_REFERENCES = "PolicyCrossReferences";
    static final String NAME = "name";
    static final String TYPE = "type";
    static final String RESOURCES = "Resources";
    static final String REFERENCE = "Reference";
    static final String POLICY_NAME = "PolicyName";
    private Map resourceIndices = Collections.synchronizedMap(new HashMap());
    private ResourceManager resourceManager;

    ResourceIndexManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    Set getPolicyNames(ServiceType resourceType, String resourceName, boolean includeSrPolicies) throws PolicyException {
        Set policyNames = null;
        ResourceIndex resourceIndex = (ResourceIndex)this.resourceIndices.get(resourceType.getName());
        if (resourceIndex == null) {
            resourceIndex = this.refreshResourceIndexFromDataStore(resourceType);
        }
        policyNames = resourceIndex.getPolicyNames(resourceName, includeSrPolicies);
        if (DEBUG.messageEnabled()) {
            DEBUG.message("ResourceIndexManager.getPolicyNames - resourceName, policyNames=" + resourceName + ":" + policyNames);
        }
        return policyNames;
    }

    Set getSuperResourcePolicyNames(ServiceType resourceType, String resourceName) throws PolicyException {
        Set policyNames = null;
        ResourceIndex resourceIndex = (ResourceIndex)this.resourceIndices.get(resourceType.getName());
        if (resourceIndex == null) {
            resourceIndex = this.refreshResourceIndexFromDataStore(resourceType);
        }
        policyNames = resourceIndex.getSuperResourcePolicyNames(resourceName);
        if (DEBUG.messageEnabled()) {
            DEBUG.message("ResourceIndexManager.getPolicyNames - resourceName, policyNames=" + resourceName + ":" + policyNames);
        }
        return policyNames;
    }

    Set getTopLevelResourceNames(ServiceType resourceType) throws PolicyException {
        ResourceIndex resourceIndex = (ResourceIndex)this.resourceIndices.get(resourceType.getName());
        if (resourceIndex == null) {
            resourceIndex = this.refreshResourceIndexFromDataStore(resourceType);
        }
        return resourceIndex.getTopLevelResourceNames();
    }

    Set getSubResourcePolicyNames(ServiceType resourceType, String resourceName) throws PolicyException {
        ResourceIndex resourceIndex = (ResourceIndex)this.resourceIndices.get(resourceType.getName());
        if (resourceIndex == null) {
            resourceIndex = this.refreshResourceIndexFromDataStore(resourceType);
        }
        return resourceIndex.getSubResourcePolicyNames(resourceName);
    }

    Set getWildSubResourcePolicyNames(ServiceType resourceType, String resourceName) throws PolicyException {
        ResourceIndex resourceIndex = (ResourceIndex)this.resourceIndices.get(resourceType.getName());
        if (resourceIndex == null) {
            resourceIndex = this.refreshResourceIndexFromDataStore(resourceType);
        }
        return resourceIndex.getWildSubResourcePolicyNames(resourceType, resourceName);
    }

    void clearResourceIndex(String resourceTypeName) {
        HashSet resourceTypes = new HashSet();
        resourceTypes.addAll(this.resourceIndices.keySet());
        Iterator iter = resourceTypes.iterator();
        while (iter.hasNext()) {
            String resourceType = (String)iter.next();
            if (!resourceType.equalsIgnoreCase(resourceTypeName)) continue;
            this.resourceIndices.remove(resourceType);
            break;
        }
    }

    ResourceIndex getResourceIndex(ServiceType resourceType) throws PolicyException {
        ResourceIndex resourceIndex = (ResourceIndex)this.resourceIndices.get(resourceType.getName());
        if (resourceIndex == null) {
            resourceIndex = this.refreshResourceIndexFromDataStore(resourceType);
        }
        return resourceIndex;
    }

    ResourceIndex getResourceIndexFromDataStore(ServiceType resourceType) throws PolicyException {
        ResourceIndex resourceIndex = new ResourceIndex(resourceType, this.resourceManager);
        resourceIndex.refreshFromDataStore();
        return resourceIndex;
    }

    private ResourceIndex refreshResourceIndexFromDataStore(ServiceType resourceType) throws PolicyException {
        ResourceIndex resourceIndex = this.getResourceIndexFromDataStore(resourceType);
        this.resourceIndices.put(resourceType.getName(), resourceIndex);
        return resourceIndex;
    }

    private boolean addIndexEntry(ServiceType resourceType, String resourceName, String policyName) throws PolicyException {
        ResourceIndex resourceIndex = (ResourceIndex)this.resourceIndices.get(resourceType.getName());
        if (resourceIndex == null) {
            resourceIndex = this.refreshResourceIndexFromDataStore(resourceType);
        }
        return resourceIndex.addIndexEntry(resourceName, policyName);
    }

    private boolean removeIndexEntry(ServiceType resourceType, String resourceName, String policyName) throws PolicyException {
        ResourceIndex resourceIndex = (ResourceIndex)this.resourceIndices.get(resourceType.getName());
        if (resourceIndex == null) {
            resourceIndex = this.refreshResourceIndexFromDataStore(resourceType);
        }
        return resourceIndex.removeIndexEntry(resourceName, policyName);
    }

    Set getChildResourceNames(ServiceType resourceType, String resourceName, boolean followChild) throws PolicyException {
        Set resourceNames = null;
        ResourceIndex resourceIndex = (ResourceIndex)this.resourceIndices.get(resourceType.getName());
        if (resourceIndex == null) {
            resourceIndex = this.refreshResourceIndexFromDataStore(resourceType);
        }
        resourceNames = resourceIndex.getChildResourceNames(resourceName, followChild);
        return resourceNames;
    }

    void saveResourceIndex(String resourceType) throws PolicyException, SSOException {
        ResourceIndex resourceIndex = (ResourceIndex)this.resourceIndices.get(resourceType);
        if (resourceIndex != null) {
            String resourceIndexXML = resourceIndex.toXML();
            this.resourceManager.saveResourceIndex(resourceType, resourceIndexXML);
        }
    }

    void addPolicyToResourceTree(ServiceTypeManager svtm, SSOToken token, Policy policy) throws PolicyException, SSOException {
        Set referralNames;
        Set ruleNames = policy.getRuleNames();
        Iterator iter = ruleNames.iterator();
        HashSet<String> serviceNames = new HashSet<String>();
        while (iter.hasNext()) {
            String ruleName = (String)iter.next();
            Rule rule = policy.getRule(ruleName);
            String serviceName = rule.getServiceTypeName();
            serviceNames.add(serviceName);
            ServiceType resourceType = svtm.getServiceType(serviceName);
            this.addIndexEntry(resourceType, rule.getResourceName(), policy.getName());
        }
        iter = serviceNames.iterator();
        while (iter.hasNext()) {
            String serviceName = (String)iter.next();
            this.saveResourceIndex(serviceName);
        }
        Referrals referrals = policy.getReferrals();
        if (referrals != null && (referralNames = referrals.getReferralNames()) != null && !referralNames.isEmpty()) {
            Iterator referralIter = referralNames.iterator();
            while (referralIter.hasNext()) {
                Set values;
                String referralName = (String)referralIter.next();
                Referral referral = referrals.getReferral(referralName);
                if (!(referral instanceof OrgReferral) || (values = referral.getValues()) == null || values.isEmpty()) continue;
                Iterator valueIter = values.iterator();
                while (valueIter.hasNext()) {
                    HashMap<String, HashSet<String>> servicePrefixMap = new HashMap<String, HashSet<String>>();
                    String value = (String)valueIter.next();
                    PolicyManager pm = new PolicyManager(token, value);
                    ResourceManager rm = pm.getResourceManager();
                    Set ruleNames1 = policy.getRuleNames();
                    Iterator ruleIter = ruleNames1.iterator();
                    while (ruleIter.hasNext()) {
                        String ruleName1 = (String)ruleIter.next();
                        Rule rule1 = policy.getRule(ruleName1);
                        String resourceName = rule1.getResourceName();
                        if (resourceName == null) continue;
                        String service = rule1.getServiceTypeName();
                        HashSet<String> resourceNames = (HashSet<String>)servicePrefixMap.get(service);
                        if (resourceNames == null) {
                            resourceNames = new HashSet<String>();
                            servicePrefixMap.put(service, resourceNames);
                        }
                        resourceNames.add(resourceName);
                    }
                    Iterator serviceIter = servicePrefixMap.keySet().iterator();
                    while (serviceIter.hasNext()) {
                        String service = (String)serviceIter.next();
                        Set resourceNames = (Set)servicePrefixMap.get(service);
                        rm.addResourcePrefixes(service, resourceNames);
                    }
                }
            }
        }
    }

    void removePolicyFromResourceTree(ServiceTypeManager svtm, SSOToken token, Policy policy) throws PolicyException, SSOException {
        Set referralNames;
        String serviceName;
        Set ruleNames = policy.getRuleNames();
        Iterator iter = ruleNames.iterator();
        String ruleName = null;
        Rule rule = null;
        HashSet<String> serviceNames = new HashSet<String>();
        while (iter.hasNext()) {
            ruleName = (String)iter.next();
            rule = policy.getRule(ruleName);
            serviceName = rule.getServiceTypeName();
            serviceNames.add(serviceName);
            ServiceType resourceType = svtm.getServiceType(serviceName);
            this.removeIndexEntry(resourceType, rule.getResourceName(), policy.getName());
        }
        iter = serviceNames.iterator();
        while (iter.hasNext()) {
            serviceName = (String)iter.next();
            this.saveResourceIndex(serviceName);
        }
        Referrals referrals = policy.getReferrals();
        if (referrals != null && (referralNames = referrals.getReferralNames()) != null && !referralNames.isEmpty()) {
            Iterator referralIter = referralNames.iterator();
            while (referralIter.hasNext()) {
                Set values;
                String referralName = (String)referralIter.next();
                Referral referral = referrals.getReferral(referralName);
                if (!(referral instanceof OrgReferral) || (values = referral.getValues()) == null || values.isEmpty()) continue;
                Iterator valueIter = values.iterator();
                while (valueIter.hasNext()) {
                    HashMap<String, HashSet<String>> servicePrefixMap = new HashMap<String, HashSet<String>>();
                    String value = (String)valueIter.next();
                    try {
                        PolicyManager pm = new PolicyManager(token, value);
                        ResourceManager rm = pm.getResourceManager();
                        Iterator ruleIter = policy.getRuleNames().iterator();
                        while (ruleIter.hasNext()) {
                            String ruleName1 = (String)ruleIter.next();
                            Rule rule1 = policy.getRule(ruleName1);
                            String resourceName = rule1.getResourceName();
                            if (resourceName == null) continue;
                            String service = rule1.getServiceTypeName();
                            HashSet<String> resourceNames = (HashSet<String>)servicePrefixMap.get(service);
                            if (resourceNames == null) {
                                resourceNames = new HashSet<String>();
                                servicePrefixMap.put(service, resourceNames);
                            }
                            resourceNames.add(resourceName);
                        }
                        Iterator serviceIter = servicePrefixMap.keySet().iterator();
                        while (serviceIter.hasNext()) {
                            String service = (String)serviceIter.next();
                            Set resourceNames = (Set)servicePrefixMap.get(service);
                            rm.removeResourcePrefixes(service, resourceNames);
                        }
                    }
                    catch (PolicyException e) {
                        if (!DEBUG.warningEnabled()) continue;
                        DEBUG.warning("Could not clean up resource  prefixes in referrred to org :" + value + "-" + e.getMessage());
                    }
                }
            }
        }
    }

    void replacePolicyInResourceTree(ServiceTypeManager svtm, SSOToken token, Policy oldPolicy, Policy newPolicy) throws PolicyException, SSOException {
        this.removePolicyFromResourceTree(svtm, token, oldPolicy);
        this.addPolicyToResourceTree(svtm, token, newPolicy);
    }

    private static class ResourceIndexEntry {
        private String resourceName;
        private Set policyNames = new HashSet();
        private Set childEntries = new HashSet();
        private ResourceIndexEntry parent;

        private ResourceIndexEntry(String resourceName, String policyName) {
            this.resourceName = resourceName;
            this.policyNames.add(policyName);
        }

        ResourceIndexEntry(String resourceName, Set policyNames) {
            this.resourceName = resourceName;
            if (policyNames != null) {
                this.policyNames = policyNames;
            }
        }

        String getResourceName() {
            return this.resourceName;
        }

        void setParent(ResourceIndexEntry parent) {
            if (this.parent != null) {
                this.parent.childEntries.remove(this);
            }
            this.parent = parent;
            parent.childEntries.add(this);
        }

        ResourceIndexEntry getParent() {
            return this.parent;
        }

        boolean addIndexEntry(ServiceType resourceType, String resourceName, String policyName) {
            boolean processed = false;
            ResourceMatch resourceMatch = resourceType.compare(this.resourceName, resourceName, false);
            if (resourceMatch.equals(ResourceMatch.EXACT_MATCH)) {
                this.policyNames.add(policyName);
                processed = true;
            } else if (resourceMatch.equals(ResourceMatch.SUB_RESOURCE_MATCH)) {
                ResourceIndexEntry resourceIndexEntry;
                Iterator iter = this.childEntries.iterator();
                while (!processed && iter.hasNext()) {
                    resourceIndexEntry = (ResourceIndexEntry)iter.next();
                    if (!resourceIndexEntry.addIndexEntry(resourceType, resourceName, policyName)) continue;
                    processed = true;
                }
                if (!processed) {
                    resourceIndexEntry = new ResourceIndexEntry(resourceName, policyName);
                    HashSet children = new HashSet();
                    children.addAll(this.childEntries);
                    Iterator iter1 = children.iterator();
                    while (iter1.hasNext()) {
                        ResourceIndexEntry rie = (ResourceIndexEntry)iter1.next();
                        ResourceMatch rm = resourceType.compare(resourceName, rie.resourceName, false);
                        if (!rm.equals(ResourceMatch.SUB_RESOURCE_MATCH)) continue;
                        rie.setParent(resourceIndexEntry);
                    }
                    this.childEntries.add(resourceIndexEntry);
                    processed = true;
                }
            }
            return processed;
        }

        boolean removeIndexEntry(ServiceType resourceType, String resourceName, String policyName) {
            boolean processed = false;
            ResourceMatch resourceMatch = resourceType.compare(this.resourceName, resourceName, false);
            if (resourceMatch.equals(ResourceMatch.EXACT_MATCH)) {
                this.policyNames.remove(policyName);
                processed = true;
                if (this.childEntries.isEmpty() && this.policyNames.isEmpty() && this.parent != null) {
                    this.parent.childEntries.remove(this);
                }
            } else if (resourceMatch.equals(ResourceMatch.SUB_RESOURCE_MATCH)) {
                Iterator iter = this.childEntries.iterator();
                while (!processed && iter.hasNext()) {
                    ResourceIndexEntry resourceIndexEntry = (ResourceIndexEntry)iter.next();
                    if (!resourceIndexEntry.removeIndexEntry(resourceType, resourceName, policyName)) continue;
                    processed = true;
                }
                processed = true;
            }
            return processed;
        }

        ResourceIndexEntry findClosestMatch(ServiceType resourceType, String resourceName) {
            ResourceIndexEntry resourceIndexEntry = null;
            ResourceMatch rm = resourceType.compare(resourceName, this.resourceName, false);
            if (rm.equals(ResourceMatch.EXACT_MATCH) || rm.equals(ResourceMatch.SUB_RESOURCE_MATCH)) {
                resourceIndexEntry = this;
            } else if (rm.equals(ResourceMatch.SUPER_RESOURCE_MATCH)) {
                Iterator iter = this.childEntries.iterator();
                boolean processed = false;
                while (!processed && iter.hasNext()) {
                    ResourceIndexEntry rie = (ResourceIndexEntry)iter.next();
                    resourceIndexEntry = rie.findClosestMatch(resourceType, resourceName);
                    if (resourceIndexEntry == null) continue;
                    processed = true;
                }
                if (resourceIndexEntry == null) {
                    resourceIndexEntry = this;
                }
            }
            return resourceIndexEntry;
        }

        Set getPolicyNames(boolean includeSrPolicies) {
            HashSet pNames = new HashSet();
            if (includeSrPolicies) {
                for (ResourceIndexEntry current = this; current != null; current = current.getParent()) {
                    pNames.addAll(current.policyNames);
                }
            } else {
                pNames.addAll(this.policyNames);
            }
            return pNames;
        }

        Set getSubResourcePolicyNames() {
            HashSet pNames = new HashSet();
            pNames.addAll(this.policyNames);
            Iterator children = this.childEntries.iterator();
            while (children.hasNext()) {
                ResourceIndexEntry child = (ResourceIndexEntry)children.next();
                pNames.addAll(child.getSubResourcePolicyNames());
            }
            return pNames;
        }

        Set getWildSubResourcePolicyNames(ServiceType resourceType, String resourceName) {
            HashSet pNames = new HashSet();
            ResourceMatch rm = resourceType.compare(resourceName, this.resourceName, true);
            if (rm != ResourceMatch.NO_MATCH) {
                pNames.addAll(this.getSubResourcePolicyNames());
            }
            HashSet<String> mismatches = new HashSet<String>();
            Iterator iter = pNames.iterator();
            while (iter.hasNext()) {
                String candidateResource = (String)iter.next();
                rm = resourceType.compare(resourceName, this.resourceName, true);
                if (rm != ResourceMatch.NO_MATCH) continue;
                mismatches.add(candidateResource);
            }
            pNames.removeAll(mismatches);
            return pNames;
        }

        Set getPolicyNames(String resourceName, boolean includeSrPolicies, ServiceType resourceType) {
            HashSet pNames = new HashSet();
            ResourceMatch rm = resourceType.compare(resourceName, this.resourceName);
            if (rm.equals(ResourceMatch.EXACT_MATCH) || rm.equals(ResourceMatch.WILDCARD_MATCH)) {
                pNames.addAll(this.policyNames);
                Iterator iter = this.childEntries.iterator();
                while (iter.hasNext()) {
                    ResourceIndexEntry rie = (ResourceIndexEntry)iter.next();
                    pNames.addAll(rie.getPolicyNames(resourceName, includeSrPolicies, resourceType));
                }
            } else if (rm.equals(ResourceMatch.SUPER_RESOURCE_MATCH)) {
                if (includeSrPolicies) {
                    pNames.addAll(this.policyNames);
                }
                Iterator iter = this.childEntries.iterator();
                while (iter.hasNext()) {
                    ResourceIndexEntry rie = (ResourceIndexEntry)iter.next();
                    pNames.addAll(rie.getPolicyNames(resourceName, includeSrPolicies, resourceType));
                }
            }
            if (DEBUG.messageEnabled()) {
                DEBUG.message("ResourceIndexEntry.getPolicyNames - resourceName, this.resourceName, resourceMach,  policyNames=" + resourceName + ":" + this.resourceName + ":" + rm + ":" + this.policyNames);
            }
            return pNames;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(120);
            sb.append("ResourceName:").append(this.resourceName).append(";");
            sb.append("PolicyNames:").append(this.policyNames.toString());
            return sb.toString();
        }

        Set getChildResourceNames(boolean followChild) {
            HashSet<String> resourceNames = new HashSet<String>();
            resourceNames.add(this.getResourceName());
            if (followChild) {
                Iterator children = this.childEntries.iterator();
                while (children.hasNext()) {
                    ResourceIndexEntry indexEntry = (ResourceIndexEntry)children.next();
                    resourceNames.addAll(indexEntry.getChildResourceNames(followChild));
                }
            }
            return resourceNames;
        }

        String toXML() {
            String xmlString = null;
            if (this.policyNames.isEmpty() && this.childEntries.isEmpty()) {
                xmlString = "";
            } else {
                StringBuffer sb = new StringBuffer(256);
                sb.append(ResourceIndexManager.LTS).append(ResourceIndexManager.REFERENCE).append(ResourceIndexManager.SPACE).append(ResourceIndexManager.NAME).append(ResourceIndexManager.EQUALS).append(ResourceIndexManager.QUOTE).append(XMLUtils.escapeSpecialCharacters(this.getResourceName())).append(ResourceIndexManager.QUOTE).append(ResourceIndexManager.GTS).append(ResourceIndexManager.NEW_LINE);
                Iterator iter = this.policyNames.iterator();
                while (iter.hasNext()) {
                    String policyName = (String)iter.next();
                    sb.append(ResourceIndexManager.LTS).append(ResourceIndexManager.POLICY_NAME).append(ResourceIndexManager.SPACE).append(ResourceIndexManager.NAME).append(ResourceIndexManager.EQUALS).append(ResourceIndexManager.QUOTE).append(XMLUtils.escapeSpecialCharacters(policyName)).append(ResourceIndexManager.QUOTE).append(ResourceIndexManager.SGTS).append(ResourceIndexManager.NEW_LINE);
                }
                iter = this.childEntries.iterator();
                while (iter.hasNext()) {
                    ResourceIndexEntry rie = (ResourceIndexEntry)iter.next();
                    sb.append(rie.toXML());
                }
                sb.append(ResourceIndexManager.LTSS).append(ResourceIndexManager.REFERENCE).append(ResourceIndexManager.GTS).append(ResourceIndexManager.NEW_LINE);
                xmlString = sb.toString();
            }
            return xmlString;
        }
    }

    static class ResourceIndex {
        private ServiceType resourceType;
        private ResourceManager resourceManager;
        private Set topLevelEntries = new HashSet();
        private Map policyNamesCache = Collections.synchronizedMap(new HashMap());
        private Map policyNamesCacheFp = Collections.synchronizedMap(new HashMap());

        ResourceIndex(ServiceType resourceType, ResourceManager resourceManager) {
            this.resourceType = resourceType;
            this.resourceManager = resourceManager;
        }

        Set getPolicyNames(String resourceName, boolean includeSrPolicies) {
            Set policyNames = null;
            if (includeSrPolicies) {
                policyNames = (HashSet)this.policyNamesCacheFp.get(resourceName);
                if (policyNames == null) {
                    policyNames = new HashSet();
                    Iterator iter = this.topLevelEntries.iterator();
                    while (iter.hasNext()) {
                        ResourceIndexEntry resourceIndexEntry = (ResourceIndexEntry)iter.next();
                        policyNames.addAll(resourceIndexEntry.getPolicyNames(resourceName, includeSrPolicies, this.resourceType));
                    }
                    this.policyNamesCacheFp.put(resourceName, policyNames);
                }
            } else {
                policyNames = (Set)this.policyNamesCache.get(resourceName);
                if (policyNames == null) {
                    policyNames = new HashSet();
                    Iterator iter = this.topLevelEntries.iterator();
                    while (iter.hasNext()) {
                        ResourceIndexEntry resourceIndexEntry = (ResourceIndexEntry)iter.next();
                        policyNames.addAll(resourceIndexEntry.getPolicyNames(resourceName, includeSrPolicies, this.resourceType));
                    }
                }
                this.policyNamesCache.put(resourceName, policyNames);
            }
            if (DEBUG.messageEnabled()) {
                DEBUG.message("ResourceIndex.getPolicyNames - resourceName, policyNames=" + resourceName + ":" + policyNames);
            }
            return policyNames;
        }

        Set getSuperResourcePolicyNames(String resourceName) {
            Set policyNames = Collections.EMPTY_SET;
            ResourceIndexEntry resourceIndexEntry = this.findClosestMatch(resourceName);
            if (resourceIndexEntry != null) {
                policyNames = resourceIndexEntry.getPolicyNames(true);
            }
            return policyNames;
        }

        void refreshFromDataStore() throws PolicyException {
            Node xmlRootNode = null;
            try {
                xmlRootNode = this.resourceManager.getXMLRootNode(this.resourceType.getName());
            }
            catch (Exception e) {
                DEBUG.error("Error reading resource index from data store ", e);
                throw new PolicyException("amPolicy", "error_reading_resource_index_from_data_store", null, e);
            }
            if (xmlRootNode != null) {
                Set topIndexEntryNodeSet = XMLUtils.getChildNodes(xmlRootNode, ResourceIndexManager.REFERENCE);
                Iterator topIndexEntryNodes = topIndexEntryNodeSet.iterator();
                while (topIndexEntryNodes.hasNext()) {
                    Node topIndexEntryNode = (Node)topIndexEntryNodes.next();
                    String resourceName = XMLUtils.getNodeAttributeValue(topIndexEntryNode, ResourceIndexManager.NAME);
                    Set policyNames = this.getPolicyNames(topIndexEntryNode);
                    ResourceIndexEntry rie = new ResourceIndexEntry(resourceName, policyNames);
                    this.topLevelEntries.add(rie);
                    Set indexEntryNodeSet = XMLUtils.getChildNodes(topIndexEntryNode, ResourceIndexManager.REFERENCE);
                    Iterator indexEntryNodes = indexEntryNodeSet.iterator();
                    while (indexEntryNodes.hasNext()) {
                        Node indexEntryNode = (Node)indexEntryNodes.next();
                        this.processIndexEntryNode(rie, indexEntryNode);
                    }
                }
            }
        }

        boolean addIndexEntry(String resourceName, String policyName) {
            ResourceIndexEntry resourceIndexEntry;
            Iterator iter = this.topLevelEntries.iterator();
            boolean processed = false;
            while (!processed && iter.hasNext()) {
                resourceIndexEntry = (ResourceIndexEntry)iter.next();
                if (!resourceIndexEntry.addIndexEntry(this.resourceType, resourceName, policyName)) continue;
                processed = true;
            }
            if (!processed) {
                resourceIndexEntry = new ResourceIndexEntry(resourceName, policyName);
                HashSet currentEntries = new HashSet();
                currentEntries.addAll(this.topLevelEntries);
                Iterator iter1 = currentEntries.iterator();
                while (iter1.hasNext()) {
                    ResourceIndexEntry rie = (ResourceIndexEntry)iter1.next();
                    ResourceMatch rm = this.resourceType.compare(resourceName, rie.getResourceName(), false);
                    if (!rm.equals(ResourceMatch.SUB_RESOURCE_MATCH)) continue;
                    rie.setParent(resourceIndexEntry);
                    this.topLevelEntries.remove(rie);
                }
                this.topLevelEntries.add(resourceIndexEntry);
                processed = true;
            }
            return processed;
        }

        boolean removeIndexEntry(String resourceName, String policyName) {
            Iterator iter = this.topLevelEntries.iterator();
            boolean processed = false;
            while (!processed && iter.hasNext()) {
                ResourceIndexEntry resourceIndexEntry = (ResourceIndexEntry)iter.next();
                if (!resourceIndexEntry.removeIndexEntry(this.resourceType, resourceName, policyName)) continue;
                processed = true;
            }
            return processed;
        }

        private ResourceIndexEntry findClosestMatch(String resourceName) {
            ResourceIndexEntry resourceIndexEntry = null;
            Iterator iter = this.topLevelEntries.iterator();
            boolean processed = false;
            while (!processed && iter.hasNext()) {
                ResourceIndexEntry tle = (ResourceIndexEntry)iter.next();
                resourceIndexEntry = tle.findClosestMatch(this.resourceType, resourceName);
                if (resourceIndexEntry == null) continue;
                processed = true;
            }
            return resourceIndexEntry;
        }

        private Set getSubResourcePolicyNames(String resourceName) {
            HashSet policyNames = new HashSet();
            Iterator iter = this.topLevelEntries.iterator();
            while (iter.hasNext()) {
                ResourceIndexEntry tle = (ResourceIndexEntry)iter.next();
                ResourceIndexEntry resourceIndexEntry = tle.findClosestMatch(this.resourceType, resourceName);
                if (resourceIndexEntry == null) continue;
                policyNames.addAll(resourceIndexEntry.getSubResourcePolicyNames());
            }
            return policyNames;
        }

        private Set getWildSubResourcePolicyNames(ServiceType resourceType, String resourceName) {
            HashSet policyNames = new HashSet();
            Iterator iter = this.topLevelEntries.iterator();
            while (iter.hasNext()) {
                ResourceIndexEntry tle = (ResourceIndexEntry)iter.next();
                policyNames.addAll(tle.getWildSubResourcePolicyNames(resourceType, resourceName));
            }
            return policyNames;
        }

        private void processIndexEntryNode(ResourceIndexEntry rie, Node indexNode) {
            String resourceName = XMLUtils.getNodeAttributeValue(indexNode, ResourceIndexManager.NAME);
            Set policyNames = this.getPolicyNames(indexNode);
            ResourceIndexEntry ie = new ResourceIndexEntry(resourceName, policyNames);
            rie.childEntries.add(ie);
            ie.parent = rie;
            Set indexEntryNodeSet = XMLUtils.getChildNodes(indexNode, ResourceIndexManager.REFERENCE);
            Iterator indexEntryNodes = indexEntryNodeSet.iterator();
            while (indexEntryNodes.hasNext()) {
                Node indexEntryNode = (Node)indexEntryNodes.next();
                this.processIndexEntryNode(ie, indexEntryNode);
            }
        }

        private Set getPolicyNames(Node referenceNode) {
            Set policyNameNodes = XMLUtils.getChildNodes(referenceNode, ResourceIndexManager.POLICY_NAME);
            Iterator items = policyNameNodes.iterator();
            Node policyNameNode = null;
            String policyName = null;
            HashSet<String> retVal = new HashSet<String>();
            while (items.hasNext()) {
                policyNameNode = (Node)items.next();
                policyName = XMLUtils.getNodeAttributeValue(policyNameNode, ResourceIndexManager.NAME);
                retVal.add(policyName);
            }
            return retVal;
        }

        Set getChildResourceNames(String resourceName, boolean followChild) {
            Set resourceNames = null;
            ResourceIndexEntry rie = this.findClosestMatch(resourceName);
            resourceNames = rie != null ? rie.getChildResourceNames(followChild) : Collections.EMPTY_SET;
            return resourceNames;
        }

        Set getTopLevelResourceNames() {
            HashSet<String> tlr = new HashSet<String>();
            Iterator iter = this.topLevelEntries.iterator();
            while (iter.hasNext()) {
                ResourceIndexEntry resourceIndexEntry = (ResourceIndexEntry)iter.next();
                tlr.add(resourceIndexEntry.getResourceName());
            }
            return tlr;
        }

        String toXML() {
            StringBuffer sb = new StringBuffer(256);
            sb.append(ResourceIndexManager.LTS).append(ResourceIndexManager.POLICY_CROSS_REFERENCES).append(ResourceIndexManager.SPACE).append(ResourceIndexManager.NAME).append(ResourceIndexManager.EQUALS).append(ResourceIndexManager.QUOTE).append(XMLUtils.escapeSpecialCharacters(this.resourceType.getName())).append(ResourceIndexManager.QUOTE).append(ResourceIndexManager.SPACE).append(ResourceIndexManager.TYPE).append(ResourceIndexManager.EQUALS).append(ResourceIndexManager.QUOTE).append(ResourceIndexManager.RESOURCES).append(ResourceIndexManager.QUOTE).append(ResourceIndexManager.GTS).append(ResourceIndexManager.NEW_LINE);
            Iterator iter = this.topLevelEntries.iterator();
            while (iter.hasNext()) {
                ResourceIndexEntry rie = (ResourceIndexEntry)iter.next();
                sb.append(rie.toXML());
            }
            sb.append(ResourceIndexManager.LTSS).append(ResourceIndexManager.POLICY_CROSS_REFERENCES).append(ResourceIndexManager.GTS).append(ResourceIndexManager.NEW_LINE);
            return sb.toString();
        }
    }
}

