/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.sun.identity.policy.PolicyConfig;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyEvent;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.interfaces.PolicyListener;
import com.sun.identity.policy.interfaces.ResourceName;
import com.sun.identity.shared.debug.Debug;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PolicyDecisionCacheListener
implements PolicyListener {
    private static Map resultsCache = PolicyEvaluator.policyResultsCache;
    private static Debug debug = PolicyManager.debug;
    private static final String resourceWildcard = "*";
    private static final String resourceDelimiter = "/";
    private static final String resourceCase = "false";
    private ResourceName resourceNameUtil = null;
    private String serviceName = null;

    public PolicyDecisionCacheListener(String serviceName) {
        this.serviceName = serviceName;
        HashMap<String, String> resourceMap = null;
        String className = null;
        try {
            resourceMap = PolicyConfig.getResourceCompareConfig(serviceName);
            if (resourceMap != null) {
                className = (String)resourceMap.get("class");
            } else {
                resourceMap = new HashMap<String, String>();
                resourceMap.put("delimiter", resourceDelimiter);
                resourceMap.put("wildcard", resourceWildcard);
                resourceMap.put("caseSensitive", resourceCase);
            }
            if (className != null) {
                Class<?> resourceClass = Class.forName(className);
                this.resourceNameUtil = (ResourceName)resourceClass.newInstance();
                this.resourceNameUtil.initialize(resourceMap);
            }
        }
        catch (Exception e) {
            debug.error("PolicyDecisionCacheListener: failed to get a resource comparator", e);
        }
    }

    public void setServiceTypeName(String name) {
        this.serviceName = name;
    }

    public String getServiceTypeName() {
        return this.serviceName;
    }

    public synchronized void policyChanged(PolicyEvent evt) {
        HashMap svcValue;
        if (debug.messageEnabled()) {
            debug.message("PolicyDecisionCacheListener.policyChanged()");
        }
        if (evt == null) {
            debug.error("PolicyDecisionCacheListener.policyChanged(): invalid policy event");
            return;
        }
        Set resourceNames = evt.getResourceNames();
        if (debug.messageEnabled()) {
            debug.message("PolicyDecisionCacheListener.policyChanged(): resource names from the policy event :" + resourceNames.toString());
        }
        if (!resultsCache.isEmpty() && !resourceNames.isEmpty() && (svcValue = (HashMap)resultsCache.get(this.serviceName)) != null) {
            Set rscInCache = svcValue.keySet();
            Iterator rscInCacheIter = rscInCache.iterator();
            block0: while (rscInCacheIter.hasNext()) {
                String rscValueInCache = (String)rscInCacheIter.next();
                Iterator resourceNamesIter = resourceNames.iterator();
                while (resourceNamesIter.hasNext()) {
                    String resourceNameValue = (String)resourceNamesIter.next();
                    ResourceMatch match = this.resourceNameUtil.compare(rscValueInCache, resourceNameValue, true);
                    if (match.equals(ResourceMatch.NO_MATCH)) continue;
                    rscInCacheIter.remove();
                    if (!debug.messageEnabled()) continue block0;
                    debug.message("PolicyDecisionCacheListener.policyChanged(): cache wiped out for " + rscValueInCache);
                    continue block0;
                }
            }
        }
    }
}

