/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.monitoring;

import com.sun.cmm.cim.OperationalStatus;
import com.sun.identity.monitoring.Monitoring;
import com.sun.identity.monitoring.MonitoringUtils;
import com.sun.mfwk.instrum.me.CIM_ManagedElementInstrum;
import com.sun.mfwk.instrum.me.CMM_ApplicationSystemInstrum;
import com.sun.mfwk.instrum.me.CMM_ConnectionPoolInstrum;
import com.sun.mfwk.instrum.me.CMM_RemoteServiceAccessPointInstrum;
import com.sun.mfwk.instrum.me.CMM_SWRCacheInstrum;
import com.sun.mfwk.instrum.me.CMM_ServiceAccessURIInstrum;
import com.sun.mfwk.instrum.me.CMM_ServiceInstrum;
import com.sun.mfwk.instrum.me.MfManagedElementInstrumException;
import com.sun.mfwk.instrum.me.settings.CMM_ConnectionPoolSettingInstrum;
import com.sun.mfwk.instrum.me.settings.CMM_SWRCacheSettingInstrum;
import com.sun.mfwk.instrum.me.statistics.CMM_ConnectionPoolStatsInstrum;
import com.sun.mfwk.instrum.me.statistics.CMM_RemoteServiceAccessPointStatsInstrum;
import com.sun.mfwk.instrum.me.statistics.CMM_SWRCacheStatsInstrum;
import com.sun.mfwk.instrum.me.statistics.CMM_ServiceAccessURIStatsInstrum;
import com.sun.mfwk.instrum.me.statistics.CMM_ServiceStatsInstrum;
import com.sun.mfwk.instrum.relations.MfRelationInstrum;
import com.sun.mfwk.instrum.relations.MfRelationInstrumException;
import com.sun.mfwk.instrum.server.MfManagedElementInfo;
import com.sun.mfwk.instrum.server.MfManagedElementServer;
import com.sun.mfwk.instrum.server.MfManagedElementServerException;
import com.sun.mfwk.instrum.server.MfManagedElementType;
import com.sun.mfwk.instrum.server.MfRelationInfo;
import com.sun.mfwk.instrum.server.MfRelationType;
import java.util.HashSet;

public class MonitoringPolicy {
    private static CMM_ServiceInstrum amSvcPolicy;
    private static CMM_ServiceInstrum amSVCPolicyPlugin;
    private static CMM_ServiceInstrum amPolicyPluginSubject;
    private static CMM_RemoteServiceAccessPointInstrum amPolicyRsapSubjectLdapDest;
    private static CMM_ServiceStatsInstrum amPolicySvcStats;
    private static CMM_ConnectionPoolInstrum amPolicyConnPoolElement;
    private static CMM_ConnectionPoolStatsInstrum amPolicyConnPoolStats;
    private static CMM_ConnectionPoolSettingInstrum amPolicyConnPoolSetting;
    private static CMM_SWRCacheInstrum amPolicyCacheElement;
    private static CMM_SWRCacheStatsInstrum amPolicyCacheStats;
    private static CMM_SWRCacheSettingInstrum amPolicyCacheSetting;
    private static CMM_ServiceAccessURIStatsInstrum amPolicySvcUriStats;
    private static CMM_RemoteServiceAccessPointStatsInstrum amPolicyRsapSubjectLdapStats;
    private static CMM_ServiceAccessURIInstrum amPolicySvcUri;
    private static CMM_ServiceAccessURIInstrum amPolicyJaxrpcUri;

    protected static int createPolicy(MfManagedElementServer mfMEServer, CMM_ApplicationSystemInstrum amAppli) {
        Monitoring.debug.message("MonitoringPolicy:createPolicy");
        try {
            MfRelationInstrum mRI = null;
            MfManagedElementInfo meInfo = mfMEServer.makeManagedElementInfo();
            MfRelationInfo relInfo = mfMEServer.makeRelationInfo();
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("policy");
            relInfo.setType(MfRelationType.CMM_HOSTED_SERVICE);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amSvcPolicy = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("policy plugins");
            relInfo.setType(MfRelationType.CMM_SERVICE_COMPONENT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcPolicy, relInfo, meInfo);
            amSVCPolicyPlugin = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("subject");
            relInfo.setType(MfRelationType.CMM_SERVICE_COMPONENT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSVCPolicyPlugin, relInfo, meInfo);
            amPolicyPluginSubject = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT);
            meInfo.setName("subject's LDAP");
            relInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amPolicyRsapSubjectLdapDest = (CMM_RemoteServiceAccessPointInstrum)mRI.getDestination();
            relInfo.setType(MfRelationType.CMM_SERVICE_SAP_DEPENDENCY);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amPolicyRsapSubjectLdapDest, relInfo, (CIM_ManagedElementInstrum)amPolicyPluginSubject);
            meInfo.setType(MfManagedElementType.CMM_SERVICE_ACCESS_URI);
            meInfo.setName("policy service URI");
            relInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amPolicySvcUri = (CMM_ServiceAccessURIInstrum)mRI.getDestination();
            amPolicySvcUri.setLabeledURI("%protocol://%host:%port/amserver/policyservice");
            relInfo.setType(MfRelationType.CMM_SERVICE_ACCESS_BY_SAP);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amSvcPolicy, relInfo, (CIM_ManagedElementInstrum)amPolicySvcUri);
            relInfo.setType(MfRelationType.CMM_SERVICE_ACCESS_BY_SAP);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amSvcPolicy, relInfo, (CIM_ManagedElementInstrum)Monitoring.getAMJAXRPCURI());
            meInfo.setType(MfManagedElementType.CMM_SERVICE_STATS);
            meInfo.setName("policy rqt");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcPolicy, relInfo, meInfo);
            amPolicySvcStats = (CMM_ServiceStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_CONNECTION_POOL);
            meInfo.setName("policy connection pool");
            relInfo.setType(MfRelationType.CMM_RESOURCE_OF_SYSTEM);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amPolicyConnPoolElement = (CMM_ConnectionPoolInstrum)mRI.getDestination();
            relInfo.setType(MfRelationType.CMM_SERVICE_RESOURCE);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amSvcPolicy, relInfo, (CIM_ManagedElementInstrum)amPolicyConnPoolElement);
            meInfo.setType(MfManagedElementType.CMM_CONNECTION_POOL_STATS);
            meInfo.setName("policy connection pool stats");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amPolicyConnPoolElement, relInfo, meInfo);
            amPolicyConnPoolStats = (CMM_ConnectionPoolStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_CONNECTION_POOL_SETTING);
            meInfo.setName("policy connection pool setting");
            relInfo.setType(MfRelationType.CMM_SCOPED_SETTING);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amPolicyConnPoolElement, relInfo, meInfo);
            amPolicyConnPoolSetting = (CMM_ConnectionPoolSettingInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SWR_CACHE);
            meInfo.setName("policy cache");
            relInfo.setType(MfRelationType.CMM_RESOURCE_OF_SYSTEM);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amPolicyCacheElement = (CMM_SWRCacheInstrum)mRI.getDestination();
            relInfo.setType(MfRelationType.CMM_SERVICE_RESOURCE);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amSvcPolicy, relInfo, (CIM_ManagedElementInstrum)amPolicyCacheElement);
            meInfo.setType(MfManagedElementType.CMM_SWR_CACHE_STATS);
            meInfo.setName("policy cache stats");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amPolicyCacheElement, relInfo, meInfo);
            amPolicyCacheStats = (CMM_SWRCacheStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SWR_CACHE_SETTING);
            meInfo.setName("policy cache setting");
            relInfo.setType(MfRelationType.CMM_SCOPED_SETTING);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amPolicyCacheElement, relInfo, meInfo);
            amPolicyCacheSetting = (CMM_SWRCacheSettingInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SERVICE_ACCESS_URI_STATS);
            meInfo.setName("policy URI stats");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amPolicySvcUri, relInfo, meInfo);
            amPolicySvcUriStats = (CMM_ServiceAccessURIStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT_STATS);
            meInfo.setName("policy subject's LDAP stats");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amPolicyRsapSubjectLdapDest, relInfo, meInfo);
            amPolicyRsapSubjectLdapStats = (CMM_RemoteServiceAccessPointStatsInstrum)mRI.getDestination();
            MonitoringPolicy.initStats();
        }
        catch (MfManagedElementServerException mmese) {
            Monitoring.debug.error("MonitoringPolicy:createPolicy: " + mmese.getMessage());
        }
        catch (MfRelationInstrumException mrie) {
            Monitoring.debug.error("MonitoringPolicy:createPolicy: " + mrie.getMessage());
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("MonitoringPolicy:createPolicy:from initStats(): " + mmeie.getMessage());
        }
        return 0;
    }

    public static void initAttributes() {
    }

    public static CMM_ConnectionPoolStatsInstrum getConnectionPoolStatsInstrum() {
        return amPolicyConnPoolStats;
    }

    private static void initStats() throws MfManagedElementInstrumException {
        MonitoringUtils.initSvcStats(amPolicySvcStats, "policy");
        MonitoringUtils.initConnPoolStats(amPolicyConnPoolStats, "policy");
        MonitoringUtils.initConnPoolSetting(amPolicyConnPoolSetting, "policy");
        MonitoringUtils.initSWRCacheStats(amPolicyCacheStats, "policy");
        MonitoringUtils.initSWRCacheSetting(amPolicyCacheSetting, "policy");
        if (amPolicyCacheSetting == null) {
            Monitoring.debug.message("MonitoringPolicy:initStats - no cache setting yet.");
        }
        MonitoringUtils.initRsapStats(amPolicyRsapSubjectLdapStats, "policy subject LDAP");
        MonitoringUtils.initSvcUriStats(amPolicySvcUriStats, "policy");
    }

    public static void setStatus(OperationalStatus status) {
        if (!Monitoring.isLocal) {
            return;
        }
        HashSet<OperationalStatus> polStatus = new HashSet<OperationalStatus>();
        polStatus.add(status);
        if (amSvcPolicy == null || amSVCPolicyPlugin == null) {
            return;
        }
        try {
            amSvcPolicy.setOperationalStatus(polStatus);
            amSVCPolicyPlugin.setOperationalStatus(polStatus);
            if (amPolicyPluginSubject != null) {
                amPolicyPluginSubject.setOperationalStatus(polStatus);
            }
            if (amPolicySvcUri != null) {
                amPolicySvcUri.setOperationalStatus(polStatus);
            }
            if (amPolicyConnPoolElement != null) {
                amPolicyConnPoolElement.setOperationalStatus(polStatus);
            }
            if (amPolicyCacheElement != null) {
                amPolicyCacheElement.setOperationalStatus(polStatus);
            }
            if (amPolicyRsapSubjectLdapDest != null) {
                amPolicyRsapSubjectLdapDest.setOperationalStatus(polStatus);
            }
            if (Monitoring.debug.messageEnabled()) {
                Monitoring.debug.message("MonitoringPolicy:setStatus = " + status);
            }
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("MonitoringPolicy:setStatus:error = " + mmeie.getMessage());
        }
    }

    public static CMM_ServiceStatsInstrum getPolicySvcStats() {
        return amPolicySvcStats;
    }

    public static void incrementPolicyEvalsIn() {
        if (amPolicySvcStats == null) {
            return;
        }
        try {
            amPolicySvcStats.addInRequests(1L);
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("MonitoringPolicy:incrementPolicyEvalsIn:error = " + mmeie.getMessage());
        }
    }

    public static void incrementPolicyEvalsOut() {
        if (amPolicySvcStats == null) {
            return;
        }
        try {
            amPolicySvcStats.addOutRequests(1L);
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("MonitoringPolicy:incrementPolicyEvalsOut:error = " + mmeie.getMessage());
        }
    }

    public static void incrementCacheHits() {
        if (amPolicyCacheStats == null) {
            return;
        }
        try {
            amPolicyCacheStats.incrementCacheHits();
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("MonitoringPolicy:incrementCacheHits:error = " + mmeie.getMessage());
        }
    }

    public static void incrementCacheMisses() {
        if (amPolicyCacheStats == null) {
            return;
        }
        try {
            amPolicyCacheStats.incrementCacheMisses();
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("MonitoringPolicy:incrementCacheMisses:error = " + mmeie.getMessage());
        }
    }

    public static void incrementWrites() {
        if (amPolicyCacheStats == null) {
            return;
        }
        try {
            amPolicyCacheStats.incrementWrites();
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("MonitoringPolicy:incrementWrites:error = " + mmeie.getMessage());
        }
    }

    public static void incrementReads() {
        if (amPolicyCacheStats == null) {
            return;
        }
        try {
            amPolicyCacheStats.incrementReads();
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("MonitoringPolicy:incrementReads:error = " + mmeie.getMessage());
        }
    }

    public static void setCacheHits(long num) {
        if (amPolicyCacheStats == null) {
            return;
        }
        try {
            amPolicyCacheStats.setCacheHits(num);
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("MonitoringPolicy:setCacheHits:error = " + mmeie.getMessage());
        }
    }

    public static void setCacheMisses(long num) {
        if (amPolicyCacheStats == null) {
            return;
        }
        try {
            amPolicyCacheStats.setCacheMisses(num);
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("MonitoringPolicy:setCacheMisses:error = " + mmeie.getMessage());
        }
    }

    public static void setWrites(long num) {
        if (amPolicyCacheStats == null) {
            return;
        }
        try {
            amPolicyCacheStats.setWrites(num);
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("MonitoringPolicy:setWrites:error = " + mmeie.getMessage());
        }
    }

    public static void setReads(long num) {
        if (amPolicyCacheStats == null) {
            return;
        }
        try {
            amPolicyCacheStats.setReads(num);
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("MonitoringPolicy:setReads:error = " + mmeie.getMessage());
        }
    }

    protected static CMM_ServiceInstrum getSvcPolicy() {
        return amSvcPolicy;
    }
}

