/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceInstanceUpdateHeader {
    private List securityMechIDs = new ArrayList();
    private List credentials = new ArrayList();
    private String endpoint = null;
    private String id = null;
    private Boolean mustUnderstand = null;
    private String actor = null;

    public ServiceInstanceUpdateHeader() {
        this.actor = "http://schemas.xmlsoap.org/soap/actor/next";
        this.mustUnderstand = Boolean.TRUE;
    }

    ServiceInstanceUpdateHeader(Element siuElement) throws SOAPBindingException {
        NodeList nl = siuElement.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            String msg;
            Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            Element childElement = (Element)child;
            String localName = childElement.getLocalName();
            String namespaceURI = childElement.getNamespaceURI();
            if (!"urn:liberty:sb:2004-04".equals(namespaceURI)) {
                Object[] args = new Object[]{"{" + namespaceURI + "}:" + localName};
                String msg2 = Utils.getString("invalidElementSIU", args);
                Utils.debug.error("ServiceInstanceUpdateHeader: " + msg2);
                throw new SOAPBindingException(msg2);
            }
            if ("SecurityMechID".equals(localName)) {
                if (!this.credentials.isEmpty() || this.endpoint != null) {
                    msg = Utils.bundle.getString("invalidSeqSIU");
                    Utils.debug.error("ServiceInstanceUpdateHeader: " + msg);
                    throw new SOAPBindingException(msg);
                }
                String securityMechID = XMLUtils.getElementValue(childElement);
                if (securityMechID == null) continue;
                this.securityMechIDs.add(securityMechID);
                continue;
            }
            if ("Credential".equals(localName)) {
                if (this.endpoint != null) {
                    msg = Utils.bundle.getString("invalidSeqSIU");
                    Utils.debug.error("ServiceInstanceUpdateHeader: " + msg);
                    throw new SOAPBindingException(msg);
                }
                this.credentials.add(new Credential(childElement));
                continue;
            }
            if ("Endpoint".equals(localName)) {
                if (this.endpoint != null) {
                    msg = Utils.bundle.getString("tooManyEndpoint");
                    Utils.debug.error("ServiceInstanceUpdateHeader: " + msg);
                    throw new SOAPBindingException(msg);
                }
                this.endpoint = XMLUtils.getElementValue(childElement);
                continue;
            }
            msg = Utils.bundle.getString("invalidChildSIU");
            Utils.debug.error("ServiceInstanceUpdateHeader: " + msg);
            throw new SOAPBindingException(msg);
        }
        this.id = XMLUtils.getNodeAttributeValue(siuElement, "id");
        String str = XMLUtils.getNodeAttributeValueNS(siuElement, "http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand");
        if (str != null && str.length() > 0) {
            try {
                this.mustUnderstand = Utils.StringToBoolean(str);
            }
            catch (Exception pe) {
                String msg = Utils.bundle.getString("invalidMustUnderstand");
                Utils.debug.error("ServiceInstanceUpdateHeader: " + msg, pe);
                throw new SOAPBindingException(msg);
            }
        }
        this.actor = XMLUtils.getNodeAttributeValueNS(siuElement, "http://schemas.xmlsoap.org/soap/envelope/", "actor");
    }

    public List getSecurityMechIDs() {
        return this.securityMechIDs;
    }

    public List getCredentials() {
        return this.credentials;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getId() {
        return this.id;
    }

    public Boolean getMustUnderstand() {
        return this.mustUnderstand;
    }

    public String getActor() {
        return this.actor;
    }

    public void setSecurityMechIDs(List securityMechIDs) {
        if (securityMechIDs != null) {
            this.securityMechIDs.clear();
            this.securityMechIDs.addAll(securityMechIDs);
        }
    }

    public void setCredentials(List credentials) {
        if (credentials != null) {
            this.credentials.clear();
            this.credentials.addAll(credentials);
        }
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setMustUnderstand(Boolean mustUnderstand) {
        this.mustUnderstand = mustUnderstand;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public void setSignFlag(boolean signFlag) {
        this.id = signFlag ? SAMLUtils.generateID() : null;
    }

    void addToParent(Element headerE) {
        Iterator iter;
        Document doc = headerE.getOwnerDocument();
        Element siuHeaderE = doc.createElementNS("urn:liberty:sb:2004-04", "sb-ext:ServiceInstanceUpdate");
        headerE.appendChild(siuHeaderE);
        if (!this.securityMechIDs.isEmpty()) {
            iter = this.securityMechIDs.iterator();
            while (iter.hasNext()) {
                String securityMechID = (String)iter.next();
                Element secMechIDE = doc.createElementNS("urn:liberty:sb:2004-04", "sb-ext:SecurityMechID");
                secMechIDE.appendChild(doc.createTextNode(securityMechID));
                siuHeaderE.appendChild(secMechIDE);
            }
        }
        if (!this.credentials.isEmpty()) {
            iter = this.credentials.iterator();
            while (iter.hasNext()) {
                Credential credential = (Credential)iter.next();
                credential.addToParent(siuHeaderE);
            }
        }
        if (this.endpoint != null) {
            Element endpointE = doc.createElementNS("urn:liberty:sb:2004-04", "sb-ext:Endpoint");
            endpointE.appendChild(doc.createTextNode(this.endpoint));
            siuHeaderE.appendChild(endpointE);
        }
        if (this.id != null) {
            siuHeaderE.setAttributeNS(null, "id", this.id);
        }
        if (this.mustUnderstand != null) {
            siuHeaderE.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "S:mustUnderstand", Utils.BooleanToString(this.mustUnderstand));
        }
        if (this.actor != null) {
            siuHeaderE.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "S:actor", this.actor);
        }
    }

    public static class Credential {
        private Element child;
        private Date notOnOrAfter = null;

        public Credential(Element child, Date notOnOrAfter) {
            this.child = child;
            this.notOnOrAfter = notOnOrAfter;
        }

        Credential(Element credentialE) throws SOAPBindingException {
            NodeList nl = credentialE.getChildNodes();
            int length = nl.getLength();
            for (int i = 0; i < length; ++i) {
                Node node = nl.item(i);
                if (node.getNodeType() != 1) continue;
                if (this.child != null) {
                    String msg = Utils.bundle.getString("tooManyChildrenCr");
                    Utils.debug.error("ServiceInstanceUpdateHeader: " + msg);
                    throw new SOAPBindingException(msg);
                }
                this.child = (Element)node;
            }
            String str = XMLUtils.getNodeAttributeValue(credentialE, "notOnOrAfter");
            if (str != null && str.length() > 0) {
                try {
                    this.notOnOrAfter = DateUtils.stringToDate(str);
                }
                catch (ParseException pe) {
                    Object[] args = new Object[]{str};
                    String msg = Utils.getString("invalidNotOnOrAfter", args);
                    Utils.debug.error("ServiceInstanceUpdateHeader: " + msg);
                    throw new SOAPBindingException(msg);
                }
            }
        }

        public Date getNotOnOrAfter() {
            return this.notOnOrAfter;
        }

        public Element getChild() {
            return this.child;
        }

        public void setNotOnOrAfter(Date notOnOrAfter) {
            this.notOnOrAfter = notOnOrAfter;
        }

        public void setChild(Element child) {
            this.child = child;
        }

        void addToParent(Element siuHeaderE) {
            Document doc = siuHeaderE.getOwnerDocument();
            Element credentialE = doc.createElementNS("urn:liberty:sb:2004-04", "sb-ext:Credential");
            siuHeaderE.appendChild(credentialE);
            if (this.child != null) {
                credentialE.appendChild(doc.importNode(this.child, true));
            }
            if (this.notOnOrAfter != null) {
                credentialE.setAttributeNS(null, "notOnOrAfter", DateUtils.toUTCDateFormat(this.notOnOrAfter));
            }
        }
    }
}

