/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.security;

import com.sun.identity.liberty.ws.security.ProxySubject;
import com.sun.identity.liberty.ws.security.SessionContext;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SessionContextStatement
extends SubjectStatement {
    public static final int SESSIONCONTEXT_STATEMENT = 5;
    protected ProxySubject _proxySubject = null;
    protected SessionContext _sessionContext = null;

    public SessionContextStatement(SessionContext sessionContext, Subject subject) throws SAMLException {
        if (sessionContext == null || subject == null) {
            SAMLUtils.debug.message("SessionContextStatement: SessionContext is null!");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        this._sessionContext = sessionContext;
        this._subject = subject;
    }

    public SessionContextStatement(SessionContext sessionContext, ProxySubject proxySubject, Subject subject) throws SAMLException {
        if (sessionContext == null || subject == null) {
            SAMLUtils.debug.message("SessionContextStatement: SessionContext is null!");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        this._sessionContext = sessionContext;
        this._proxySubject = proxySubject;
        this._subject = subject;
    }

    public SessionContextStatement(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtils.debug.message("AttributeStatement: null input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        boolean valid = SAMLUtils.checkStatement(element, "SessionContextStatement");
        if (!valid) {
            SAMLUtils.debug.message("SessionContextStatement: Wrong input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        NodeList nodes = element.getChildNodes();
        int nodeCount = nodes.getLength();
        if (nodeCount > 0) {
            for (int i = 0; i < nodeCount; ++i) {
                Node currentNode = nodes.item(i);
                if (currentNode.getNodeType() != 1) continue;
                String tagName = currentNode.getLocalName();
                String tagNS = currentNode.getNamespaceURI();
                if (tagName == null || tagName.length() == 0 || tagNS == null || tagNS.length() == 0) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("SessionContextStatement: The tag name or tag namespace of child element is either null or empty.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
                }
                if (tagName.equals("Subject") && tagNS.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                    if (this._subject != null) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("SessionContextStatement should only contain one subject");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
                    }
                    this._subject = new Subject((Element)currentNode);
                    continue;
                }
                if (tagName.equals("ProxySubject") && tagNS.equals("urn:liberty:sec:2003-08")) {
                    if (this._proxySubject != null) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("SessionContextStatement should only contain one ProxySubject");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
                    }
                    this._proxySubject = new ProxySubject((Element)currentNode);
                    continue;
                }
                if (tagName.equals("SessionContext") && tagNS.equals("urn:liberty:sec:2003-08")) {
                    if (this._sessionContext != null) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("SessionContextStatement should only contain one SessionContext");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
                    }
                    this._sessionContext = new SessionContext((Element)currentNode);
                    continue;
                }
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("SessionContextStatement:Wrong element " + tagName + " included.");
                }
                throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
            }
        }
    }

    public ProxySubject getProxySubject() {
        return this._proxySubject;
    }

    public SessionContext getSessionContext() {
        return this._sessionContext;
    }

    public boolean setProxySubject(ProxySubject proxySubject) {
        if (proxySubject == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("ResourceAccessStatement: setResourceID:Input is null.");
            }
            return false;
        }
        this._proxySubject = proxySubject;
        return true;
    }

    public int getStatementType() {
        return 5;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer xml = new StringBuffer(1000);
        String prefix = "";
        String secprefix = "";
        String libprefix = "";
        String uri = "";
        String securi = "";
        if (includeNS) {
            prefix = "saml:";
            libprefix = "lib:";
            secprefix = "sec:";
        }
        if (declareNS) {
            uri = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
            securi = " xmlns:sec=\"urn:liberty:sec:2003-08\"";
        }
        try {
            xml.append("<").append(secprefix).append("SessionContextStatement").append(securi).append(">\n");
            xml.append(this._subject.toString(includeNS, true));
            if (this._proxySubject != null) {
                xml.append(this._proxySubject.toString(includeNS, declareNS));
            }
            xml.append(this._sessionContext.toXMLString(includeNS, declareNS));
            xml.append("</").append(secprefix).append("SessionContextStatement>");
        }
        catch (Exception e) {
            return null;
        }
        return xml.toString();
    }
}

