/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.security;

import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProxySubject
extends Subject {
    public ProxySubject(NameIdentifier nameIdentifier, SubjectConfirmation subjectConfirmation) throws SAMLException {
        super(nameIdentifier, subjectConfirmation);
    }

    public boolean equals(ProxySubject subject) {
        return super.equals(subject);
    }

    public ProxySubject(NameIdentifier nameIdentifier) throws SAMLException {
        super(nameIdentifier);
    }

    public ProxySubject(Element subjectElement) throws SAMLException {
        int elementCount = 0;
        Element elt = subjectElement;
        String eltName = elt.getLocalName();
        if (eltName == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("ProxySubject: local name missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (!eltName.equals("ProxySubject")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("ProxySubject: invalid root element");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("invalidElement"));
        }
        NodeList nl = subjectElement.getChildNodes();
        int length = nl.getLength();
        if (length == 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Subject: No sub elements found");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("emptyElement"));
        }
        for (int n = 0; n < length; ++n) {
            Node child = nl.item(n);
            if (child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName.equals("NameIdentifier")) {
                this.setNameIdentifier(new NameIdentifier((Element)child));
                ++elementCount;
                continue;
            }
            if (childName.equals("SubjectConfirmation")) {
                this.setSubjectConfirmation(new SubjectConfirmation((Element)child));
                ++elementCount;
                continue;
            }
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Subject: Invalid element encountered.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("invalidElement"));
        }
        if (elementCount > 2) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Subject: more than allowed elements passed");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("moreElement"));
        }
    }

    public ProxySubject(SubjectConfirmation subjectConfirmation) throws SAMLException {
        super(subjectConfirmation);
    }

    public String toString() {
        String xml = this.toString(true, false);
        return xml;
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer xml = new StringBuffer(3000);
        String secprefix = "";
        String secNS = "";
        String secNSString = "";
        if (includeNS) {
            secprefix = "sec:";
        }
        if (declareNS) {
            secNS = "urn:liberty:sec:2003-08";
            secNSString = " xmlns:sec=\"" + secNS + "\"";
        }
        xml.append("<").append(secprefix).append("ProxySubject").append(secNSString).append(">");
        if (this.getNameIdentifier() != null) {
            xml.append(this.getNameIdentifier().toString(includeNS, declareNS));
        }
        if (this.getSubjectConfirmation() != null) {
            xml.append(this.getSubjectConfirmation().toString(includeNS, declareNS));
        }
        xml.append("</").append(secprefix).append("ProxySubject").append(">");
        return xml.toString();
    }
}

