/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.dst;

import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.liberty.ws.dst.DSTModification;
import com.sun.identity.liberty.ws.dst.DSTUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DSTModify {
    private String resourceID;
    private EncryptedResourceID encryptedResourceID;
    private List modification = new ArrayList();
    private String itemID;
    private String id;
    private List extension = new ArrayList();
    private String nameSpaceURI = null;
    private String prefix = null;

    public DSTModify() {
    }

    public DSTModify(String resourceID, List modifications, String serviceNS) {
        this.resourceID = resourceID;
        if (modifications != null) {
            this.modification.addAll(modifications);
            DSTModification dm = (DSTModification)modifications.get(0);
            this.nameSpaceURI = serviceNS == null ? dm.getNameSpaceURI() : serviceNS;
            this.prefix = dm.getNameSpacePrefix();
        }
    }

    public DSTModify(EncryptedResourceID encResourceID, List modifications, String serviceNS) {
        this.encryptedResourceID = encResourceID;
        if (modifications != null) {
            this.modification.addAll(modifications);
            DSTModification dm = (DSTModification)modifications.get(0);
            this.nameSpaceURI = serviceNS == null ? dm.getNameSpaceURI() : serviceNS;
            this.prefix = dm.getNameSpacePrefix();
        }
    }

    public DSTModify(Element element) throws DSTException {
        if (element == null) {
            DSTUtils.debug.error("DSTModify(element):null input");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        String elementName = element.getLocalName();
        if (elementName == null || !elementName.equals("Modify")) {
            DSTUtils.debug.error("DSTModify(element):Invalid element name");
            throw new DSTException(DSTUtils.bundle.getString("invalidElement"));
        }
        this.nameSpaceURI = element.getNamespaceURI();
        if (this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTModify(element): NameSpace is not defined");
            throw new DSTException(DSTUtils.bundle.getString("noNameSpace"));
        }
        this.prefix = element.getPrefix();
        this.id = element.getAttribute("id");
        this.itemID = element.getAttribute("itemID");
        NodeList list = element.getElementsByTagNameNS(this.nameSpaceURI, "ResourceID");
        if (list.getLength() == 0 || list.getLength() > 1) {
            DSTUtils.debug.error("DSTModify(element): ResourceIDNode is null or more than one resource id is found.");
            throw new DSTException(DSTUtils.bundle.getString("invalidResourceID"));
        }
        this.resourceID = XMLUtils.getElementValue((Element)list.item(0));
        if (this.resourceID == null) {
            DSTUtils.debug.error("DSTModify(element): ResourceID is null");
            throw new DSTException(DSTUtils.bundle.getString("invalidResourceID"));
        }
        NodeList modificationNodes = element.getElementsByTagNameNS(this.nameSpaceURI, "Modification");
        if (modificationNodes == null || modificationNodes.getLength() == 0) {
            DSTUtils.debug.error("DSTModify(element): Modifications are null");
            throw new DSTException(DSTUtils.bundle.getString("nullModifications"));
        }
        int size = modificationNodes.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = modificationNodes.item(0);
            DSTModification dstModification = new DSTModification((Element)node);
            this.modification.add(dstModification);
        }
    }

    public List getModification() {
        return this.modification;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public EncryptedResourceID getEncryptedResourceID() {
        return this.encryptedResourceID;
    }

    public void setEncryptedResourceID(EncryptedResourceID resourceID) {
        this.encryptedResourceID = resourceID;
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public void setResourceID(String resourceID) {
        this.resourceID = resourceID;
    }

    public String getItemID() {
        return this.itemID;
    }

    public void setItemID(String itemID) {
        this.itemID = itemID;
    }

    public List getExtension() {
        return this.extension;
    }

    public void setExtension(List extensions) {
        if (extensions != null) {
            this.extension.addAll(extensions);
        }
    }

    public String getNameSpaceURI() {
        return this.nameSpaceURI;
    }

    public void setNameSpaceURI(String nameSpace) {
        this.nameSpaceURI = nameSpace;
    }

    public void setNameSpacePrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getNameSpacePrefix() {
        return this.prefix;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        String tempPrefix = "";
        if (includeNS) {
            if (this.prefix == null) {
                this.prefix = "sis";
            }
            tempPrefix = this.prefix + ":";
        }
        if (declareNS && this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTModify.toString: Name Space is not defined");
            return "";
        }
        StringBuffer sb = new StringBuffer(300);
        sb.append("<").append(tempPrefix).append("Modify");
        if (this.id != null && this.id.length() != 0) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        if (this.itemID != null && this.itemID.length() != 0) {
            sb.append(" itemID=\"").append(this.itemID).append("\"");
        }
        if (declareNS) {
            sb.append(" xmlns:").append(this.prefix).append("=\"").append(this.nameSpaceURI).append("\"").append(" xmlns=\"").append(this.nameSpaceURI).append("\"");
        }
        sb.append(">");
        if (this.encryptedResourceID == null) {
            sb.append("<").append(tempPrefix).append("ResourceID").append(">").append(this.resourceID).append("</").append(tempPrefix).append("ResourceID").append(">");
        } else {
            sb.append(this.encryptedResourceID.toString(this.nameSpaceURI));
        }
        Iterator iter = this.modification.iterator();
        while (iter.hasNext()) {
            DSTModification modification = (DSTModification)iter.next();
            sb.append(modification.toString());
        }
        sb.append("</").append(tempPrefix).append("Modify").append(">");
        if (DSTUtils.debug.messageEnabled()) {
            DSTUtils.debug.message("DSTModify.toString: " + sb.toString());
        }
        return sb.toString();
    }
}

