/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco;

import com.sun.identity.liberty.ws.common.Status;
import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModifyResponse {
    private String id = null;
    private List newEntryIDs = null;
    private Status status = null;
    private Element extension = null;

    public ModifyResponse(Status status) {
        this.status = status;
    }

    public ModifyResponse(Element root) throws DiscoveryException {
        StringTokenizer st;
        String nameSpaceURI;
        if (root == null) {
            DiscoUtils.debug.message("ModifyResponse(Element): null input.");
            throw new DiscoveryException(DiscoUtils.bundle.getString("nullInput"));
        }
        String nodeName = root.getLocalName();
        if (nodeName == null || !nodeName.equals("ModifyResponse") || (nameSpaceURI = root.getNamespaceURI()) == null || !nameSpaceURI.equals("urn:liberty:disco:2003-08")) {
            DiscoUtils.debug.message("ModifyResponse(Element): wrong input");
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        this.id = root.getAttribute("id");
        String ids = root.getAttribute("newEntryIDs");
        if (ids != null && ids.length() != 0 && (st = new StringTokenizer(ids)).countTokens() > 0) {
            if (this.newEntryIDs == null) {
                this.newEntryIDs = new ArrayList();
            }
            while (st.hasMoreTokens()) {
                this.newEntryIDs.add(st.nextToken());
            }
        }
        NodeList contentnl = root.getChildNodes();
        int length = contentnl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = contentnl.item(i);
            nodeName = child.getLocalName();
            if (nodeName == null) continue;
            nameSpaceURI = ((Element)child).getNamespaceURI();
            if (nodeName.equals("Status") && nameSpaceURI != null && nameSpaceURI.equals("urn:liberty:disco:2003-08")) {
                if (this.status != null) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("ModifyResponse(Element): included more than one Status.");
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("moreElement"));
                }
                this.status = DiscoUtils.parseStatus((Element)child);
                continue;
            }
            if (nodeName.equals("Extension") && nameSpaceURI != null && nameSpaceURI.equals("urn:liberty:disco:2003-08")) {
                if (this.extension != null) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("ModifyResponse(Element): included more than one Extension.");
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("moreElement"));
                }
                this.extension = (Element)child;
                continue;
            }
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("ModifyResponse(Element): invalid node" + nodeName);
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        if (this.status == null) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("ModifyResponse(Element): missing Status.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("missingStatus"));
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status value) {
        this.status = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List getNewEntryIDs() {
        return this.newEntryIDs;
    }

    public void setNewEntryIDs(List ids) {
        this.newEntryIDs = ids;
    }

    public Element getExtension() {
        return this.extension;
    }

    public void setExtension(Element extension) {
        this.extension = extension;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(400);
        sb.append("<ModifyResponse xmlns=\"").append("urn:liberty:disco:2003-08").append("\"");
        if (this.id != null && this.id.length() != 0) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        if (this.newEntryIDs != null) {
            sb.append(" newEntryIDs=\"");
            Iterator iter = this.newEntryIDs.iterator();
            if (iter.hasNext()) {
                sb.append((String)iter.next());
            }
            while (iter.hasNext()) {
                sb.append(" ").append((String)iter.next());
            }
            sb.append("\"");
        }
        sb.append(">");
        if (this.status != null) {
            sb.append(this.status.toString());
        }
        if (this.extension != null) {
            sb.append(XMLUtils.print(this.extension));
        }
        sb.append("</ModifyResponse>");
        return sb.toString();
    }
}

