/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco;

import com.sun.identity.liberty.ws.disco.Directive;
import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.ResourceOffering;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InsertEntry {
    private ResourceOffering offering = null;
    private List any = null;

    public InsertEntry(ResourceOffering resourceOffering, List any) {
        this.offering = resourceOffering;
        this.any = any;
    }

    public InsertEntry(Element elem) throws DiscoveryException {
        String nameSpaceURI;
        if (elem == null) {
            DiscoUtils.debug.message("InsertEntry(Element): null input.");
            throw new DiscoveryException(DiscoUtils.bundle.getString("nullInput"));
        }
        String nodeName = elem.getLocalName();
        if (nodeName == null || !nodeName.equals("InsertEntry") || (nameSpaceURI = elem.getNamespaceURI()) == null || !nameSpaceURI.equals("urn:liberty:disco:2003-08")) {
            DiscoUtils.debug.message("InsertEntry(Element): wrong input");
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        NodeList contentnl = elem.getChildNodes();
        int length = contentnl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = contentnl.item(i);
            nodeName = child.getLocalName();
            if (nodeName == null) continue;
            nameSpaceURI = ((Element)child).getNamespaceURI();
            if (nodeName.equals("ResourceOffering") && nameSpaceURI != null && nameSpaceURI.equals("urn:liberty:disco:2003-08")) {
                if (this.offering != null) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("InsertEntry(Element): included more than one ResourceOffering.");
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("moreElement"));
                }
                this.offering = new ResourceOffering((Element)child);
                continue;
            }
            Directive directive = new Directive((Element)child);
            if (this.any == null) {
                this.any = new ArrayList();
            }
            this.any.add(directive);
        }
        if (this.offering == null) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("InsertEntry(Element): missing ResourceOffering.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("missingResourceOffering"));
        }
    }

    public ResourceOffering getResourceOffering() {
        return this.offering;
    }

    public void setResourceOffering(ResourceOffering value) {
        this.offering = value;
    }

    public List getAny() {
        return this.any;
    }

    public void setAny(List any) {
        this.any = any;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("<InsertEntry xmlns=\"").append("urn:liberty:disco:2003-08").append("\">");
        if (this.offering != null) {
            sb.append(this.offering);
        }
        if (this.any != null) {
            Iterator iter = this.any.iterator();
            while (iter.hasNext()) {
                sb.append(iter.next().toString());
            }
        }
        sb.append("</InsertEntry>");
        return sb.toString();
    }
}

