/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.authnsvc.protocol;

import com.sun.identity.liberty.ws.authnsvc.AuthnSvcUtils;
import com.sun.identity.liberty.ws.authnsvc.protocol.Parameter;
import com.sun.identity.liberty.ws.authnsvc.protocol.Transform;
import java.util.ArrayList;
import java.util.Iterator;

public class TruncationTransform
extends Transform {
    public TruncationTransform() {
        this.name = "urn:liberty:sa:pw:truncate";
    }

    public TruncationTransform(int length) {
        this.name = "urn:liberty:sa:pw:truncate";
        Parameter parameter = new Parameter("length", "" + length);
        this.parameters = new ArrayList();
        this.parameters.add(parameter);
    }

    public String transform(String password) {
        if (AuthnSvcUtils.debug.messageEnabled()) {
            AuthnSvcUtils.debug.message("TruncationTransform.transform");
        }
        if (password == null) {
            return null;
        }
        if (this.parameters == null || this.parameters.isEmpty()) {
            if (AuthnSvcUtils.debug.warningEnabled()) {
                AuthnSvcUtils.debug.warning("TruncationTransform.transform: no parameter found");
            }
            return password;
        }
        Iterator iter = this.parameters.iterator();
        while (iter.hasNext()) {
            block10: {
                Parameter parameter = (Parameter)iter.next();
                if (!parameter.getName().equals("length")) continue;
                try {
                    int length = Integer.parseInt(parameter.getValue());
                    if (length < password.length() && length >= 0) {
                        return password.substring(0, length);
                    }
                    if (AuthnSvcUtils.debug.messageEnabled()) {
                        AuthnSvcUtils.debug.message("TruncationTransform.transform: parameter length value isn't less than password length");
                    }
                }
                catch (Exception ex) {
                    if (!AuthnSvcUtils.debug.warningEnabled()) break block10;
                    AuthnSvcUtils.debug.warning("TruncationTransform.transform: parameter value is not integer", ex);
                }
            }
            return password;
        }
        if (AuthnSvcUtils.debug.warningEnabled()) {
            AuthnSvcUtils.debug.warning("TruncationTransform.transform: parameter 'name' not found");
        }
        return password;
    }
}

