/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.authnsvc;

import com.sun.identity.liberty.ws.authnsvc.AuthnSvcUtils;
import com.sun.identity.liberty.ws.authnsvc.mechanism.MechanismHandler;
import com.sun.identity.plugin.configuration.ConfigurationActionEvent;
import com.sun.identity.plugin.configuration.ConfigurationException;
import com.sun.identity.plugin.configuration.ConfigurationInstance;
import com.sun.identity.plugin.configuration.ConfigurationListener;
import com.sun.identity.plugin.configuration.ConfigurationManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class AuthnSvcService
implements ConfigurationListener {
    static final String SERVICE_NAME = "sunIdentityServerAuthnService";
    static final String MECHANISM_HANDLER_LIST_ATTR = "MechanismHandlerList";
    static HashMap handlers = new HashMap();
    static ConfigurationInstance ci = null;

    private AuthnSvcService() {
    }

    public static MechanismHandler getMechanismHandler(String mechanism) {
        return (MechanismHandler)handlers.get(mechanism);
    }

    public void configChanged(ConfigurationActionEvent e) {
        if (AuthnSvcUtils.debug.messageEnabled()) {
            AuthnSvcUtils.debug.message("AuthnSvcService.configChanged");
        }
        AuthnSvcService.setValues();
    }

    private static void setValues() {
        Map attrMap = null;
        try {
            attrMap = ci.getConfiguration(null, null);
        }
        catch (ConfigurationException ce) {
            AuthnSvcUtils.debug.error("AuthnSvcService.setValues:", ce);
            return;
        }
        handlers.clear();
        Set values = (Set)attrMap.get(MECHANISM_HANDLER_LIST_ATTR);
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            String value = (String)iter.next();
            StringTokenizer stz = new StringTokenizer(value, "|");
            String key = null;
            String class_ = null;
            while (stz.hasMoreTokens()) {
                String token = stz.nextToken();
                if (token.startsWith("key=")) {
                    key = token.substring(4);
                    continue;
                }
                if (!token.startsWith("class=")) continue;
                class_ = token.substring(6);
            }
            if (key != null && class_ != null) {
                try {
                    handlers.put(key, (MechanismHandler)Class.forName(class_).newInstance());
                }
                catch (Throwable t) {
                    AuthnSvcUtils.debug.error("AuthnSvcService.setValues class = " + class_, t);
                }
                continue;
            }
            if (!AuthnSvcUtils.debug.warningEnabled()) continue;
            AuthnSvcUtils.debug.warning("AuthnSvcService.setValues: Invalid syntax for Mechanism Handler List: " + value);
        }
    }

    static {
        try {
            ci = ConfigurationManager.getConfigurationInstance("AUTHN_SVC");
            ci.addListener(new AuthnSvcService());
            AuthnSvcService.setValues();
        }
        catch (ConfigurationException ce) {
            AuthnSvcUtils.debug.error("AuthnSvcService.static:", ce);
        }
    }
}

