/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm;

import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import com.sun.identity.shared.locale.L10NMessage;
import com.sun.identity.shared.locale.Locale;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import netscape.ldap.LDAPException;

public class IdRepoException
extends Exception
implements L10NMessage {
    private transient AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    private transient Debug debug = AMIdentityRepository.debug;
    private String message;
    private String bundleName;
    private String errorCode;
    private Object[] args;
    private LDAPException rootCause = null;
    private String ldapErrCode = null;

    public IdRepoException() {
    }

    public IdRepoException(String msg) {
        this.message = msg;
    }

    public IdRepoException(String msg, String errorCode) {
        this.message = msg;
        this.errorCode = errorCode;
    }

    public IdRepoException(String rbName, String errorCode, Object[] args) {
        this.bundleName = rbName;
        this.errorCode = errorCode;
        this.args = args;
        this.message = this.getL10NMessage(java.util.Locale.ENGLISH);
    }

    public String getL10NMessage(java.util.Locale locale) {
        String result = this.errorCode;
        if (this.bundleName != null && locale != null) {
            ResourceBundle bundle = this.amCache.getResBundle(this.bundleName, locale);
            String mid = Locale.getString(bundle, this.errorCode, this.debug);
            result = this.args == null || this.args.length == 0 ? mid : MessageFormat.format(mid, this.args);
        }
        return result;
    }

    public String getResourceBundleName() {
        return this.bundleName;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getLDAPErrorCode() {
        return this.ldapErrCode;
    }

    public void setLDAPErrorCode(String errorCode) {
        this.ldapErrCode = errorCode;
    }

    public Object[] getMessageArgs() {
        return this.args;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String msg = this.message;
        if (msg != null && msg.length() > 0) {
            buf.append("Message:");
            buf.append(msg);
            buf.append("\n");
        }
        return buf.toString();
    }

    public String getMessage() {
        return this.message;
    }
}

