/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message.common;

import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.key.EncInfo;
import com.sun.identity.federation.key.KeyUtil;
import com.sun.identity.federation.message.common.EncryptableNameIdentifier;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.liberty.ws.meta.jaxb.ProviderDescriptorType;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.xmlenc.EncryptionException;
import com.sun.identity.xmlenc.XMLEncryptionManager;
import java.security.Key;
import java.security.PrivateKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EncryptedNameIdentifier {
    private static Document getEncryptableDocument(EncryptableNameIdentifier eni) {
        StringBuffer xml = new StringBuffer(300);
        String NS = " xmlns:lib=\"urn:liberty:iff:2003-08\"";
        String appendNS = "lib:";
        xml.append("<").append(appendNS).append("EncryptedNameIdentifier").append(" ").append(NS).append(">").append(eni.toString()).append("</").append(appendNS).append("EncryptedNameIdentifier").append(">");
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("EncryptedNameIdentifier.getEncryptableNameIdentifier: doc =" + xml.toString());
        }
        return XMLUtils.toDOMDocument(xml.toString(), FSUtils.debug);
    }

    public static NameIdentifier getEncryptedNameIdentifier(NameIdentifier ni, String realm, String providerID) throws FSException {
        if (ni == null || providerID == null) {
            FSUtils.debug.error("EncryptedNameIdentifier.construct: nullInputParameter");
            throw new FSException("nullInputParameter", null);
        }
        ProviderDescriptorType providerDesc = null;
        try {
            IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
            if (metaManager != null && (providerDesc = metaManager.getSPDescriptor(realm, providerID)) == null) {
                providerDesc = metaManager.getIDPDescriptor(realm, providerID);
            }
            if (providerDesc == null) {
                throw new IDFFMetaException((String)null);
            }
        }
        catch (IDFFMetaException ae) {
            FSUtils.debug.error("EncryptedNameIdentifier.construct: Couldnot retrieve the meta for provider" + providerID);
            throw new FSException(ae);
        }
        EncInfo encInfo = KeyUtil.getEncInfo((ProviderDescriptorType)providerDesc, (String)providerID, (boolean)false);
        return EncryptedNameIdentifier.getEncryptedNameIdentifier(ni, providerID, encInfo.getWrappingKey(), encInfo.getDataEncAlgorithm(), encInfo.getDataEncStrength());
    }

    public static NameIdentifier getEncryptedNameIdentifier(NameIdentifier ni, String providerID, Key enckey, String dataEncAlgorithm, int dataEncStrength) throws FSException {
        if (ni == null || providerID == null) {
            FSUtils.debug.error("EncryptedNameIdentifier.construct: nullInputParameter");
            throw new FSException("nullInputParameter", null);
        }
        EncryptableNameIdentifier eni = new EncryptableNameIdentifier(ni);
        Document encryptableDoc = EncryptedNameIdentifier.getEncryptableDocument(eni);
        Document encryptedDoc = null;
        try {
            Element encryptElement = (Element)encryptableDoc.getElementsByTagNameNS("urn:liberty:iff:2003-08", "EncryptableNameIdentifier").item(0);
            XMLEncryptionManager manager = XMLEncryptionManager.getInstance();
            encryptedDoc = manager.encryptAndReplace(encryptableDoc, encryptElement, dataEncAlgorithm, dataEncStrength, enckey, 0, providerID);
        }
        catch (EncryptionException ee) {
            FSUtils.debug.error("EncryptedNameIdentifier.construct: Unableto encrypt the xml doc", ee);
            throw new FSException(ee);
        }
        if (encryptedDoc == null) {
            throw new FSException("EncryptionFailed", null);
        }
        String encodedStr = Base64.encode(SAMLUtils.stringToByteArray(XMLUtils.print(encryptedDoc)));
        try {
            return new NameIdentifier(encodedStr, ni.getNameQualifier(), "urn:liberty:iff:nameid:encrypted");
        }
        catch (SAMLException se) {
            throw new FSException(se);
        }
    }

    public static NameIdentifier getDecryptedNameIdentifier(NameIdentifier encNI, String realm, String providerID) throws FSException {
        if (encNI == null || providerID == null) {
            FSUtils.debug.error("EncryptedNameIdentifier.getDecryptedNameIdentifier: null values");
            throw new FSException("nullInputParameter", null);
        }
        BaseConfigType providerConfig = null;
        try {
            providerConfig = FSUtils.getIDFFMetaManager().getSPDescriptorConfig(realm, providerID);
            if (providerConfig == null) {
                providerConfig = FSUtils.getIDFFMetaManager().getIDPDescriptorConfig(realm, providerID);
            }
        }
        catch (Exception ae) {
            FSUtils.debug.error("EncryptedNameIdentifier.getDecryptedNameIdentifier: Unable to find provider", ae);
            throw new FSException(ae);
        }
        if (providerConfig == null) {
            FSUtils.debug.error("EncryptedNameIdentifier.getDecryptedNameIdentifier: Unable to find provider " + providerID);
            throw new FSException("noProviderFound", null);
        }
        return EncryptedNameIdentifier.getDecryptedNameIdentifier(encNI, KeyUtil.getDecryptionKey((BaseConfigType)providerConfig));
    }

    public static NameIdentifier getDecryptedNameIdentifier(NameIdentifier encNI, PrivateKey decKey) throws FSException {
        if (encNI.getFormat() == null || !encNI.getFormat().equals("urn:liberty:iff:nameid:encrypted")) {
            throw new FSException("notValidFormat", null);
        }
        String name = encNI.getName();
        name = FSUtils.removeNewLineChars(name);
        String decodeStr = SAMLUtils.byteArrayToString(Base64.decode(name));
        Document encryptedDoc = XMLUtils.toDOMDocument(decodeStr, FSUtils.debug);
        try {
            XMLEncryptionManager manager = XMLEncryptionManager.getInstance();
            Document doc = manager.decryptAndReplace(encryptedDoc, decKey);
            Element element = (Element)doc.getElementsByTagNameNS("urn:liberty:iff:2003-08", "EncryptableNameIdentifier").item(0);
            EncryptableNameIdentifier eni = new EncryptableNameIdentifier(element);
            return new NameIdentifier(eni.getName(), eni.getNameQualifier(), eni.getFormat());
        }
        catch (EncryptionException ee) {
            FSUtils.debug.error("EncryptedNameIdentifier.getDecryptedNameIdentifier: Decryption exception", ee);
            throw new FSException(ee);
        }
        catch (SAMLException se) {
            throw new FSException(se);
        }
    }
}

