/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.message.common.IDPProvidedNameIdentifier;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.common.SAMLException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSSubject
extends Subject {
    protected IDPProvidedNameIdentifier _idpNameIdentifier;

    protected FSSubject() {
    }

    public FSSubject(NameIdentifier nameIdentifier, SubjectConfirmation subjectConfirmation, IDPProvidedNameIdentifier idpNameIdentifier) throws FSMsgException, SAMLException {
        super(nameIdentifier, subjectConfirmation);
        this._idpNameIdentifier = idpNameIdentifier;
    }

    public FSSubject(NameIdentifier nameIdentifier, IDPProvidedNameIdentifier idpNameIdentifier) throws FSMsgException, SAMLException {
        super(nameIdentifier);
        this._idpNameIdentifier = idpNameIdentifier;
    }

    public FSSubject(Element subjectElement) throws FSMsgException, SAMLException {
        FSUtils.debug.message("FSSubject(Element): Called");
        int elementCount = 0;
        Element elt = subjectElement;
        String rootTagName = elt.getLocalName();
        if (rootTagName == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSubject: local name missing");
            }
            throw new FSMsgException("nullInput", null);
        }
        if (!rootTagName.equals("Subject")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSubject: invalid root element");
            }
            throw new FSMsgException("invalidElement", null);
        }
        NodeList nl = subjectElement.getChildNodes();
        int length = nl.getLength();
        if (length == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSubject: No sub elements found");
            }
            throw new FSMsgException("emptyElement", null);
        }
        for (int n = 0; n < length; ++n) {
            Node child = nl.item(n);
            if (child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName.equals("NameIdentifier")) {
                this.setNameIdentifier(new NameIdentifier((Element)child));
                ++elementCount;
                continue;
            }
            if (childName.equals("SubjectConfirmation")) {
                this.setSubjectConfirmation(new SubjectConfirmation((Element)child));
                ++elementCount;
                continue;
            }
            if (childName.equals("IDPProvidedNameIdentifier")) {
                this._idpNameIdentifier = new IDPProvidedNameIdentifier((Element)child);
                ++elementCount;
                continue;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSubject: Invalid element encountered.");
            }
            throw new FSMsgException("invalidElement", null);
        }
        if (elementCount > 3) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSubject: more than allowed elements passed");
            }
            throw new FSMsgException("moreElement", null);
        }
        FSUtils.debug.message("FSSubject(Element): leaving");
    }

    public FSSubject(SubjectConfirmation subjectConfirmation) throws SAMLException {
        super(subjectConfirmation);
    }

    public boolean setIDPProvidedNameIdentifier(IDPProvidedNameIdentifier idpNameIdentifier) {
        if (idpNameIdentifier == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSubject:null IDPProvidedNameIdentifierspecified");
            }
            return false;
        }
        this._idpNameIdentifier = idpNameIdentifier;
        return true;
    }

    public IDPProvidedNameIdentifier getIDPProvidedNameIdentifier() {
        return this._idpNameIdentifier;
    }

    public String toXMLString() throws FSMsgException {
        String xml = this.toXMLString(true, false);
        return xml;
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws FSMsgException {
        StringBuffer xml = new StringBuffer(3000);
        String prefix = "";
        String libprefix = "";
        String uri = "";
        String liburi = "";
        if (includeNS) {
            prefix = "saml:";
            libprefix = "lib:";
        }
        if (declareNS) {
            uri = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
            liburi = " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
        }
        xml.append("<").append(prefix).append("Subject").append(" ").append(uri).append(" ").append(liburi).append(" ").append("xsi:type").append("=\"").append(libprefix).append("SubjectType").append("\"").append(">");
        if (this.getNameIdentifier() != null) {
            xml.append(this.getNameIdentifier().toString(includeNS, false));
        }
        if (this.getSubjectConfirmation() != null) {
            xml.append(this.getSubjectConfirmation().toString(includeNS, false));
        }
        if (this._idpNameIdentifier != null) {
            xml.append(this._idpNameIdentifier.toXMLString(includeNS, false));
        }
        xml.append("</").append(prefix).append("Subject").append(">");
        return xml.toString();
    }
}

