/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAuthnResponse;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSAuthnResponseEnvelope {
    private List otherElements;
    private FSAuthnResponse authnResponse;
    private String assertionConsumerServiceURL = null;
    private int minorVersion = 0;

    public FSAuthnResponseEnvelope() {
    }

    public FSAuthnResponseEnvelope(FSAuthnResponse authnResponse) {
        this.authnResponse = authnResponse;
        this.otherElements = null;
    }

    public FSAuthnResponseEnvelope(Element root) throws FSMsgException, SAMLException {
        if (root == null) {
            FSUtils.debug.message("FSAuthnResponseEnvelope.parseXML: null input.");
            throw new FSMsgException("nullInput", null);
        }
        String tag = null;
        tag = root.getLocalName();
        if (tag == null || !tag.equals("AuthnResponseEnvelope")) {
            FSUtils.debug.message("FSAuthnResponseEnvelope.parseXML: wrong input.");
            throw new FSMsgException("wrongInput", null);
        }
        String ns = root.getNamespaceURI();
        if (ns == null) {
            FSUtils.debug.error("FSAuthnResponseEnvelope(Element):No namespace");
            throw new FSMsgException("wrongInput", null);
        }
        if (ns.equals("urn:liberty:iff:2003-08")) {
            this.minorVersion = 2;
        }
        NodeList nl = root.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            String childName = child.getLocalName();
            if (childName == null) continue;
            if (childName.equals("AuthnResponse")) {
                if (this.authnResponse != null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAuthnResponseEnvelope: included more than one <AuthnResponse>");
                    }
                    throw new FSMsgException("moreElement", null);
                }
                this.authnResponse = new FSAuthnResponse((Element)child);
                continue;
            }
            if (!childName.equals("AssertionConsumerServiceURL")) continue;
            this.assertionConsumerServiceURL = XMLUtils.getElementValue((Element)child);
        }
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public List getOtherElements() {
        return this.otherElements;
    }

    public void setOtherElements(List otherElement) {
        this.otherElements = otherElement;
    }

    public FSAuthnResponse getAuthnResponse() {
        return this.authnResponse;
    }

    public void setAuthnResponse(FSAuthnResponse authnResponse) {
        this.authnResponse = authnResponse;
    }

    public String getAssertionConsumerServiceURL() {
        return this.assertionConsumerServiceURL;
    }

    public void setAssertionConsumerServiceURL(String assertionConsumerUrl) {
        this.assertionConsumerServiceURL = assertionConsumerUrl;
    }

    public static FSAuthnResponseEnvelope parseXML(String xml) throws FSMsgException {
        try {
            Document doc = XMLUtils.toDOMDocument(xml, FSUtils.debug);
            Element root = doc.getDocumentElement();
            return new FSAuthnResponseEnvelope(root);
        }
        catch (SAMLException ex) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnResponseEnvelope.parseXML: Error while parsing input xml string");
            }
            throw new FSMsgException("parseError", null);
        }
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws FSMsgException {
        return this.toXMLString(includeNS, declareNS, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS, boolean includeHeader) throws FSMsgException {
        StringBuffer xml = new StringBuffer(300);
        if (includeHeader) {
            xml.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\"").append(" ").append('?').append(">");
        }
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "lib:";
        }
        if (declareNS) {
            uri = this.minorVersion == 2 ? " xmlns:lib=\"urn:liberty:iff:2003-08\"" : " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
        }
        xml.append("<").append(prefix).append("AuthnResponseEnvelope").append(uri).append(">");
        if (this.authnResponse != null) {
            xml.append(this.authnResponse.toXMLString());
        }
        if (this.assertionConsumerServiceURL == null || this.assertionConsumerServiceURL.length() == 0) {
            throw new FSMsgException("nullInput", null);
        }
        xml.append("<").append(prefix).append("AssertionConsumerServiceURL").append(uri).append(">").append(this.assertionConsumerServiceURL).append("</").append(prefix).append("AssertionConsumerServiceURL").append(">");
        xml.append("</").append(prefix).append("AuthnResponseEnvelope");
        return xml.toString();
    }

    public String toBASE64EncodedString() throws FSMsgException {
        return Base64.encode(this.toXMLString().getBytes());
    }

    public static FSAuthnResponseEnvelope parseBASE64EncodedString(String encodedReq) throws FSMsgException {
        if (encodedReq != null) {
            String decodedAuthnReq = new String(Base64.decode(encodedReq));
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnResponseEnvelope.parseBASE64EncodedString: decoded input string: \n" + decodedAuthnReq);
            }
            return FSAuthnResponseEnvelope.parseXML(decodedAuthnReq);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAuthnResponseEnvelope.parseBASE64EncodedString: null String passedin as argument.");
        }
        throw new FSMsgException("nullInput", null);
    }
}

