/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.sun.identity.common.ShutdownListener;
import com.sun.identity.common.ShutdownPriority;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ShutdownManager {
    protected static ShutdownManager instance;
    protected Set[] listeners;
    protected boolean shutdownCalled = false;

    protected ShutdownManager() {
        int size = ShutdownPriority.HIGHEST.getIntValue();
        this.listeners = new HashSet[size];
        for (int i = 0; i < size; ++i) {
            this.listeners[i] = new HashSet();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                ShutdownManager.this.shutdown();
            }
        }, "ShutdownThread"));
    }

    public static synchronized ShutdownManager getInstance() {
        if (instance == null) {
            instance = new ShutdownManager();
        }
        return instance;
    }

    public void addShutdownListener(ShutdownListener listener) {
        this.addShutdownListener(listener, ShutdownPriority.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addShutdownListener(ShutdownListener listener, ShutdownPriority priority) throws IllegalStateException {
        if (!this.shutdownCalled) {
            Set[] setArray = this.listeners;
            synchronized (this.listeners) {
                this.removeShutdownListener(listener);
                this.listeners[priority.getIntValue() - 1].add(listener);
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            throw new IllegalStateException("It is shutdown already!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeShutdownListener(ShutdownListener listener) throws IllegalStateException {
        if (!this.shutdownCalled) {
            Set[] setArray = this.listeners;
            synchronized (this.listeners) {
                int index;
                List priorities = ShutdownPriority.getPriorities();
                Iterator i = priorities.iterator();
                while (i.hasNext() && !this.listeners[(index = ((ShutdownPriority)i.next()).getIntValue()) - 1].remove(listener)) {
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else {
            throw new IllegalStateException("It is shutdown already!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Set[] setArray = this;
        synchronized (this) {
            this.shutdownCalled = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            setArray = this.listeners;
            synchronized (this.listeners) {
                List priorities = ShutdownPriority.getPriorities();
                Iterator i = priorities.iterator();
                while (i.hasNext()) {
                    int index = ((ShutdownPriority)i.next()).getIntValue();
                    Iterator j = this.listeners[index - 1].iterator();
                    while (j.hasNext()) {
                        ShutdownListener element = (ShutdownListener)j.next();
                        element.shutdown();
                        j.remove();
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

