/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.sso.providers.dpro;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOProvider;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.providers.dpro.SSOProviderBundle;
import com.iplanet.sso.providers.dpro.SSOTokenImpl;
import com.sun.identity.common.SearchResults;
import com.sun.identity.shared.debug.Debug;
import java.net.InetAddress;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public final class SSOProviderImpl
implements SSOProvider {
    public static Debug debug = null;
    private static boolean checkIP = Boolean.valueOf(SystemProperties.get("com.iplanet.am.clientIPCheckEnabled"));

    public SSOToken createSSOToken(HttpServletRequest request) throws SSOException {
        try {
            SessionID sid = new SessionID(request);
            Session session = Session.getSession(sid);
            if (sid != null) {
                Boolean cookieMode = sid.getCookieMode();
                if (debug.messageEnabled()) {
                    debug.message("cookieMode is :" + cookieMode);
                }
                if (cookieMode != null) {
                    session.setCookieMode(cookieMode);
                }
            }
            if (checkIP && !this.isIPValid(session, request.getRemoteAddr())) {
                throw new Exception(SSOProviderBundle.getString("invalidIP"));
            }
            SSOTokenImpl ssoToken = new SSOTokenImpl(session);
            return ssoToken;
        }
        catch (Exception e) {
            if (debug.messageEnabled()) {
                debug.message("could not create SSOToken from HttpRequest", e);
            }
            throw new SSOException(e);
        }
    }

    public SSOToken createSSOToken(Principal user, String password) throws SSOException, UnsupportedOperationException {
        try {
            SSOTokenImpl ssoToken = new SSOTokenImpl(user, password);
            if (debug.messageEnabled()) {
                debug.message("SSO token ldap auth successful for " + ((Object)user).toString());
            }
            return ssoToken;
        }
        catch (Exception e) {
            if (debug.messageEnabled()) {
                debug.message("could not create SSOTOken for user " + user.getName(), e);
            }
            throw new SSOException(e);
        }
    }

    public SSOToken createSSOToken(String tokenId) throws SSOException, UnsupportedOperationException {
        try {
            SessionID sessionId = new SessionID(tokenId);
            Session session = Session.getSession(sessionId);
            SSOTokenImpl ssoToken = new SSOTokenImpl(session);
            return ssoToken;
        }
        catch (Exception e) {
            if (debug.messageEnabled()) {
                debug.message("could not create SSOTOken for token ID " + tokenId, e);
            }
            throw new SSOException(e);
        }
    }

    public SSOToken createSSOToken(String tokenId, String clientIP) throws SSOException, UnsupportedOperationException {
        try {
            SessionID sessionId = new SessionID(tokenId);
            Session session = Session.getSession(sessionId);
            if (checkIP && !this.isIPValid(session, clientIP)) {
                throw new Exception(SSOProviderBundle.getString("invalidIP"));
            }
            SSOTokenImpl ssoToken = new SSOTokenImpl(session);
            return ssoToken;
        }
        catch (Exception e) {
            if (debug.messageEnabled()) {
                debug.message("could not create SSOTOken for token ID " + tokenId, e);
            }
            throw new SSOException(e);
        }
    }

    public boolean isValidToken(SSOToken token) {
        SSOTokenImpl tokenImpl = (SSOTokenImpl)token;
        return tokenImpl.isValid();
    }

    public void validateToken(SSOToken token) throws SSOException {
        try {
            SSOTokenImpl tokenImpl = (SSOTokenImpl)token;
            tokenImpl.validate();
        }
        catch (Exception e) {
            if (debug.messageEnabled()) {
                debug.message("validateToken: ", e);
            }
            throw new SSOException(SSOProviderBundle.rbName, "invalidtoken", null);
        }
    }

    public void destroyToken(SSOToken token) throws SSOException {
        try {
            SSOTokenImpl tokenImpl = (SSOTokenImpl)token;
            if (tokenImpl.isLdapConnection()) {
                tokenImpl.setStatus(false);
                return;
            }
            SSOTokenID tokenid = token.getTokenID();
            String id = ((Object)tokenid).toString();
            SessionID sessid = new SessionID(id);
            Session session = Session.getSession(sessid);
            session.destroySession(session);
        }
        catch (Exception e) {
            if (debug.messageEnabled()) {
                debug.message("DestroyToken: ", e);
            }
            throw new SSOException(e);
        }
    }

    public boolean isIPValid(Session sess, String clientIP) throws SSOException {
        boolean check;
        block3: {
            check = false;
            try {
                InetAddress sessIPAddress = InetAddress.getByName(sess.getProperty("Host"));
                InetAddress clientIPAddress = InetAddress.getByName(clientIP);
                if (sessIPAddress.equals(clientIPAddress)) {
                    check = true;
                }
            }
            catch (Exception e) {
                if (!debug.messageEnabled()) break block3;
                debug.message("IP address check of Token Failed", e);
            }
        }
        return check;
    }

    public void refreshSession(SSOToken token) throws SSOException {
        try {
            SSOTokenID tokenId = token.getTokenID();
            SessionID sid = new SessionID(((Object)tokenId).toString());
            Session session = Session.getSession(sid);
            session.refresh(true);
        }
        catch (Exception e) {
            debug.error("Error in refreshing the session from sessions erver");
            throw new SSOException(e);
        }
    }

    public void destroyToken(SSOToken destroyer, SSOToken destroyed) throws SSOException {
        try {
            Session requester = ((SSOTokenImpl)destroyer).getSession();
            Session target = ((SSOTokenImpl)destroyed).getSession();
            requester.destroySession(target);
        }
        catch (SessionException e) {
            throw new SSOException(e);
        }
    }

    public Set getValidSessions(SSOToken requester, String server) throws SSOException {
        HashSet<SSOTokenImpl> results = new HashSet<SSOTokenImpl>();
        try {
            SearchResults result = ((SSOTokenImpl)requester).getSession().getValidSessions(server, null);
            Iterator iter = result.getResultAttributes().values().iterator();
            while (iter.hasNext()) {
                Session s = (Session)iter.next();
                if (s == null) continue;
                results.add(new SSOTokenImpl(s));
            }
        }
        catch (SessionException e) {
            throw new SSOException(e);
        }
        return results;
    }

    static {
        debug = Debug.getInstance("amSSOProvider");
    }
}

