/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.util;

import com.iplanet.services.util.AMEncryption;
import com.iplanet.services.util.ConfigurableKey;
import com.sun.identity.shared.debug.Debug;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class JCEEncryption
implements AMEncryption,
ConfigurableKey {
    private static final byte VERSION = 1;
    private static final String CRYPTO_DESCRIPTOR = System.getProperty("amCryptoDescriptor", "PBEWithMD5AndDES");
    private static final String CRYPTO_DESCRIPTOR_PROPERTY_NAME = "amCryptoDescriptor";
    private static final String CRYPTO_DESCRIPTOR_DEFAULT_VALUE = "PBEWithMD5AndDES";
    private static final String CRYPTO_DESCRIPTOR_PROVIDER;
    private static final String CRYPTO_DESCRIPTOR_PROVIDER_PROPERTY_NAME = "amCryptoDescriptor.provider";
    private static final String CRYPTO_DESCRIPTOR_PROVIDER_DEFAULT_VALUE = "SunJCE";
    private static final String KEYGEN_ALGORITHM;
    private static final String KEYGEN_ALGORITHM_PROPERTY_NAME = "amKeyGenDescriptor";
    private static final String KEYGEN_ALGORITHM_DEFAULT_VALUE = "PBEWithMD5AndDES";
    private static final String KEYGEN_ALGORITHM_PROVIDER;
    private static final String KEYGEN_ALGORITHM_PROVIDER_PROPERTY_NAME = "amKeyGenDescriptor.provider";
    private static final String KEYGEN_ALGORITHM_PROVIDER_DEFAULT_VALUE = "SunJCE";
    private static final int DEFAULT_KEYGEN_ALG_INDEX = 2;
    private static final int DEFAULT_ENC_ALG_INDEX = 2;
    private static final int ITERATION_COUNT = 5;
    private static final byte[] ___y;
    private SecretKey pbeKey;
    private boolean _initialized = false;
    private static PBEParameterSpec pbeParameterSpec;

    public byte[] encrypt(byte[] clearText) {
        return this.pbeEncrypt(clearText);
    }

    public byte[] decrypt(byte[] encText) {
        return this.pbeDecrypt(encText);
    }

    private static void registerSunJCEProvider() {
        block9: {
            String sunJCEProviderClassName = "com.sun.crypto.provider.SunJCE";
            Provider[] providers = Security.getProviders();
            boolean providerRegistered = false;
            if (providers != null && providers.length > 0) {
                for (int i = 0; i < providers.length; ++i) {
                    if (!providers[i].getClass().getName().equals(sunJCEProviderClassName)) continue;
                    providerRegistered = true;
                    break;
                }
            }
            if (!providerRegistered) {
                Debug debug = Debug.getInstance("amSDK");
                if (debug != null && debug.warningEnabled()) {
                    debug.warning("JCEEncryption: SunJCE provider not registered. Attempting to register...");
                }
                Provider sunJCEProvider = null;
                try {
                    Class<?> sunJCEProviderClass = Class.forName(sunJCEProviderClassName);
                    sunJCEProvider = (Provider)sunJCEProviderClass.newInstance();
                    Security.addProvider(sunJCEProvider);
                    if (debug != null && debug.messageEnabled()) {
                        debug.message("JCEEncryption: registered SunJCE provider");
                    }
                    break block9;
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.error("JCEEncryption: exception while registering provider", ex);
                    }
                    break block9;
                }
            }
            Debug debug = Debug.getInstance("amSDK");
            if (debug != null && debug.messageEnabled()) {
                debug.message("JCEEncryption: SunJCE provider is already registered.");
            }
        }
    }

    private byte[] pbeEncrypt(byte[] clearText) {
        byte[] result;
        block13: {
            result = null;
            if (clearText == null || clearText.length == 0) {
                return null;
            }
            if (this._initialized) {
                try {
                    byte[] type = new byte[2];
                    type[1] = 2;
                    type[0] = 2;
                    Cipher pbeCipher = null;
                    try {
                        pbeCipher = Cipher.getInstance(CRYPTO_DESCRIPTOR, CRYPTO_DESCRIPTOR_PROVIDER);
                    }
                    catch (Exception ex) {
                        if (ex instanceof NoSuchAlgorithmException || ex instanceof NoSuchPaddingException) {
                            Debug debug = Debug.getInstance("amSDK");
                            if (debug != null) {
                                debug.error("JCEEncryption:pbeEncrypt", ex);
                            }
                            JCEEncryption.registerSunJCEProvider();
                            pbeCipher = Cipher.getInstance(CRYPTO_DESCRIPTOR);
                        }
                        throw ex;
                    }
                    if (pbeCipher != null) {
                        pbeCipher.init(1, (Key)this.pbeKey, pbeParameterSpec);
                        result = pbeCipher.doFinal(clearText);
                        byte[] iv = pbeCipher.getIV();
                        result = JCEEncryption.addPrefix(type, iv, result);
                    } else {
                        Debug debug = Debug.getInstance("amSDK");
                        if (debug != null) {
                            debug.error("JCEEncryption: Failed to obtain Cipher");
                        }
                    }
                    break block13;
                }
                catch (Exception ex) {
                    Debug debug = Debug.getInstance("amSDK");
                    if (debug != null) {
                        debug.error("JCEEncryption:: failed to encrypt data", ex);
                    }
                    break block13;
                }
            }
            Debug debug = Debug.getInstance("amSDK");
            if (debug != null) {
                debug.error("JCEEncryption:: not yet initialized");
            }
        }
        return result;
    }

    private static byte[] addPrefix(byte[] type, byte[] iv, byte[] share) {
        int i;
        byte[] data = new byte[share.length + 11];
        data[0] = 1;
        data[1] = type[0];
        data[2] = type[1];
        for (i = 0; i < 8; ++i) {
            data[3 + i] = iv[i];
        }
        for (i = 0; i < share.length; ++i) {
            data[11 + i] = share[i];
        }
        return data;
    }

    private byte[] pbeDecrypt(byte[] cipherText) {
        byte[] result;
        block14: {
            result = null;
            if (this._initialized) {
                try {
                    byte[] share = cipherText;
                    if (share[0] != 1) {
                        Debug debug = Debug.getInstance("amSDK");
                        if (debug != null) {
                            debug.error("JCEEncryption:: Unsported version: " + share[0]);
                        }
                        return null;
                    }
                    byte[] raw = JCEEncryption.getRaw(share);
                    Cipher pbeCipher = null;
                    try {
                        pbeCipher = Cipher.getInstance(CRYPTO_DESCRIPTOR, CRYPTO_DESCRIPTOR_PROVIDER);
                    }
                    catch (Exception ex) {
                        if (ex instanceof NoSuchAlgorithmException || ex instanceof NoSuchPaddingException) {
                            Debug debug = Debug.getInstance("amSDK");
                            if (debug != null) {
                                debug.error("JCEEncryption:pbeDecrypt", ex);
                            }
                            JCEEncryption.registerSunJCEProvider();
                            pbeCipher = Cipher.getInstance(CRYPTO_DESCRIPTOR);
                        }
                        throw ex;
                    }
                    if (pbeCipher != null) {
                        pbeCipher.init(2, (Key)this.pbeKey, pbeParameterSpec);
                        result = pbeCipher.doFinal(raw);
                    } else {
                        Debug debug = Debug.getInstance("amSDK");
                        if (debug != null) {
                            debug.error("JCEEncryption: Failed to obtain Cipher");
                        }
                    }
                    break block14;
                }
                catch (Exception ex) {
                    Debug debug = Debug.getInstance("amSDK");
                    if (debug != null) {
                        debug.error("JCEEncryption:: failed to decrypt data", ex);
                    }
                    break block14;
                }
            }
            Debug debug = Debug.getInstance("amSDK");
            if (debug != null) {
                debug.error("JCEEncryption:: not yet initialized");
            }
        }
        return result;
    }

    private static byte[] getRaw(byte[] share) {
        byte[] data = new byte[share.length - 11];
        for (int i = 11; i < share.length; ++i) {
            data[i - 11] = share[i];
        }
        return data;
    }

    public void setPassword(String password) throws Exception {
        this.pbeKey = SecretKeyFactory.getInstance(KEYGEN_ALGORITHM, KEYGEN_ALGORITHM_PROVIDER).generateSecret(new PBEKeySpec(password.toCharArray()));
        this._initialized = true;
    }

    static {
        KEYGEN_ALGORITHM = System.getProperty(KEYGEN_ALGORITHM_PROPERTY_NAME, "PBEWithMD5AndDES");
        CRYPTO_DESCRIPTOR_PROVIDER = System.getProperty(CRYPTO_DESCRIPTOR_PROVIDER_PROPERTY_NAME, "SunJCE");
        KEYGEN_ALGORITHM_PROVIDER = System.getProperty(KEYGEN_ALGORITHM_PROVIDER_PROPERTY_NAME, "SunJCE");
        ___y = new byte[]{1, 1, 1, 1, 1, 1, 1, 1};
        pbeParameterSpec = new PBEParameterSpec(___y, 5);
    }
}

