/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap.event;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.services.ldap.event.DSEvent;
import com.iplanet.services.ldap.event.EventException;
import com.iplanet.services.ldap.event.EventService;
import com.iplanet.services.ldap.event.EventServicePolling;
import com.iplanet.services.ldap.event.IDSEventListener;
import com.iplanet.services.ldap.event.Request;
import com.iplanet.services.util.I18n;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.providers.dpro.SSOProviderBundle;
import com.sun.identity.authentication.internal.AuthContext;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.common.ShutdownListener;
import com.sun.identity.common.ShutdownManager;
import com.sun.identity.common.SystemTimer;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.security.ServerInstanceAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPInterruptedException;
import netscape.ldap.LDAPMessage;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSearchResult;
import netscape.ldap.LDAPSearchResultReference;
import netscape.ldap.controls.LDAPEntryChangeControl;
import netscape.ldap.controls.LDAPPersistSearchControl;

public class EventService
implements Runnable {
    protected static DSConfigMgr cm = null;
    protected Map _requestList = null;
    static Thread _monitorThread = null;
    static LDAPSearchListener _msgQueue;
    protected static EventService _instance;
    private static final boolean CHANGES_ONLY = true;
    private static final boolean RETURN_CONTROLS = true;
    private static final boolean IS_CRITICAL = true;
    private static I18n i18n;
    protected static Debug debugger;
    protected static final String EVENT_CONNECTION_NUM_RETRIES = "com.iplanet.am.event.connection.num.retries";
    protected static final String EVENT_CONNECTION_RETRY_INTERVAL = "com.iplanet.am.event.connection.delay.between.retries";
    protected static final String EVENT_CONNECTION_ERROR_CODES = "com.iplanet.am.event.connection.ldap.error.codes.retries";
    protected static final String EVENT_IDLE_TIMEOUT_INTERVAL = "com.sun.am.event.connection.idle.timeout";
    protected static final String EVENT_LISTENER_DISABLE_LIST = "com.sun.am.event.connection.disable.list";
    private static boolean _allDisabled;
    private static int _numRetries;
    private static int _retryInterval;
    protected static HashSet _retryErrorCodes;
    protected static int _idleTimeOut;
    protected static long _idleTimeOutMills;
    protected static final String[] listeners;
    protected static Hashtable _ideListenersMap;
    protected static volatile boolean _isThreadStarted;
    protected static volatile boolean _shutdownCalled;

    private static HashSet getPropertyRetryErrorCodes(String key) {
        HashSet<String> codes = new HashSet<String>();
        String retryErrorStr = SystemProperties.get(key);
        if (retryErrorStr != null && retryErrorStr.trim().length() > 0) {
            StringTokenizer stz = new StringTokenizer(retryErrorStr, ",");
            while (stz.hasMoreTokens()) {
                codes.add(stz.nextToken().trim());
            }
        }
        return codes;
    }

    private static int getPropertyIntValue(String key, int defaultValue) {
        int value;
        block4: {
            value = defaultValue;
            String valueStr = SystemProperties.get(key);
            if (valueStr != null && valueStr.trim().length() > 0) {
                try {
                    value = Integer.parseInt(valueStr);
                }
                catch (NumberFormatException e) {
                    value = defaultValue;
                    if (!debugger.warningEnabled()) break block4;
                    debugger.warning("EventService.getPropertyIntValue(): Invalid value for property: com.iplanet.am.event.connection.num.retries Defaulting to value: " + defaultValue);
                }
            }
        }
        if (debugger.messageEnabled()) {
            debugger.message("EventService.getPropertyIntValue(): " + key + " = " + value);
        }
        return value;
    }

    private static void getListenerList() {
        String list = SystemProperties.get(EVENT_LISTENER_DISABLE_LIST, "");
        if (debugger.messageEnabled()) {
            debugger.message("EventService.getListenerList(): com.sun.am.event.connection.disable.list = " + list);
        }
        if (list.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(list, ",");
        boolean disableACI = false;
        boolean disableUM = false;
        boolean disableSM = false;
        String listener = "";
        while (st.hasMoreTokens()) {
            listener = st.nextToken().trim();
            if (listener.equalsIgnoreCase("aci")) {
                EventService.listeners[0] = null;
                disableACI = true;
                continue;
            }
            if (listener.equalsIgnoreCase("um")) {
                EventService.listeners[1] = null;
                disableUM = true;
                continue;
            }
            if (listener.equalsIgnoreCase("sm")) {
                EventService.listeners[2] = null;
                disableSM = true;
                continue;
            }
            debugger.error("EventService.getListenerList() - Invalid listener name: " + listener);
        }
        if (disableACI && disableUM && disableSM) {
            if (debugger.messageEnabled()) {
                debugger.message("EventService.getListenerList() - all listeners are disabled, EventService won't start");
            }
            _allDisabled = true;
        }
    }

    protected EventService() throws EventException {
        EventService.getConfigManager();
        this._requestList = Collections.synchronizedMap(new HashMap());
    }

    public static synchronized EventService getEventService() throws EventException, LDAPException {
        if (_allDisabled || _shutdownCalled) {
            return null;
        }
        if (_instance == null) {
            _instance = _idleTimeOut == 0 ? new EventService() : new EventServicePolling();
            ShutdownManager.getInstance().addShutdownListener((ShutdownListener)new /* Unavailable Anonymous Inner Class!! */);
            EventService.initListeners();
        }
        return _instance;
    }

    protected static String getName() {
        return "EventService";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        Object object = this;
        synchronized (object) {
            _shutdownCalled = true;
            if (_monitorThread != null && _monitorThread.isAlive()) {
                _monitorThread.interrupt();
                _isThreadStarted = false;
            }
        }
        object = this._requestList;
        synchronized (object) {
            Collection requestObjs = this._requestList.values();
            Iterator iter = requestObjs.iterator();
            while (iter.hasNext()) {
                Request request = (Request)iter.next();
                this.removeListener(request);
            }
            this._requestList.clear();
        }
    }

    public synchronized String addListener(SSOToken token, IDSEventListener listener, String base, int scope, String filter, int operations) throws LDAPException, EventException {
        LDAPConnection lc;
        block19: {
            if (_shutdownCalled) {
                throw new EventException(i18n.getString("dscfg-connectFail"));
            }
            lc = null;
            try {
                ServiceSchemaManager scm = new ServiceSchemaManager(token, "sunIdentityRepositoryService", "1.0");
                ServiceSchema idRepoSubSchema = scm.getOrganizationSchema();
                Set idRepoPlugins = idRepoSubSchema.getSubSchemaNames();
                if (listener.getClass().getName().equals("com.sun.identity.sm.ldap.LDAPEventManager") && cm.getServerGroup("sms") != null) {
                    lc = cm.getNewConnection("sms", LDAPUser.Type.AUTH_ADMIN);
                    break block19;
                }
                if (idRepoPlugins.contains("amSDK")) {
                    lc = cm.getNewAdminConnection();
                    break block19;
                }
                return "0";
            }
            catch (SSOException ssoe) {
                throw new EventException(i18n.getString("dscfg-connectFail"), ssoe);
            }
            catch (SMSException smse) {
                throw new EventException(i18n.getString("dscfg-connectFail"), smse);
            }
            catch (LDAPServiceException le) {
                throw new EventException(i18n.getString("dscfg-connectFail"), le);
            }
        }
        LDAPSearchConstraints cons = lc.getSearchConstraints();
        LDAPPersistSearchControl psearchCtrl = new LDAPPersistSearchControl(operations, true, true, true);
        cons.setServerControls((LDAPControl)psearchCtrl);
        cons.setBatchSize(1);
        String[] attrs = new String[]{"objectclass"};
        LDAPSearchListener searchListener = null;
        try {
            if (debugger.messageEnabled()) {
                debugger.message("EventService.addListener() - Submiting Persistent Search on: " + base + " for listener: " + listener);
            }
            searchListener = lc.search(base, scope, filter, attrs, false, null, cons);
        }
        catch (LDAPException le) {
            if (lc != null && lc.isConnected()) {
                try {
                    lc.disconnect();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            debugger.error("EventService.addListener() - Failed to set Persistent Search" + le.getMessage());
            throw le;
        }
        int[] outstandingRequests = searchListener.getMessageIDs();
        int id = outstandingRequests[outstandingRequests.length - 1];
        String reqID = Integer.toString(id);
        long startTime = System.currentTimeMillis();
        Request request = new Request(id, reqID, token, base, scope, filter, attrs, operations, listener, lc, startTime);
        this._requestList.put(reqID, request);
        if (_msgQueue == null) {
            _msgQueue = searchListener;
        } else {
            _msgQueue.merge(searchListener);
        }
        if (!_isThreadStarted) {
            EventService.startMonitorThread();
        } else if (this._requestList.size() == 1) {
            this.notify();
        }
        if (debugger.messageEnabled()) {
            outstandingRequests = _msgQueue.getMessageIDs();
            debugger.message("EventService.addListener(): merged Listener:  requestID: " + reqID + " & Request: " + request + " on to message Queue. No. of current outstanding " + "requests = " + outstandingRequests.length);
        }
        return reqID;
    }

    public IDSEventListener getIDSListeners(String className) {
        return (IDSEventListener)_ideListenersMap.get(className);
    }

    public static boolean isThreadStarted() {
        return _isThreadStarted;
    }

    protected static void initListeners() {
        int size = listeners.length;
        for (int i = 0; i < size; ++i) {
            String l1 = listeners[i];
            if (l1 == null) continue;
            try {
                if (l1.equals("com.sun.identity.sm.ldap.LDAPEventManager")) {
                    String enableDataStoreNotification = SystemProperties.get("com.sun.identity.sm.enableDataStoreNotification", "true");
                    if (!SMSEntry.getRootSuffix().equalsIgnoreCase(SMSEntry.getAMSdkBaseDN())) {
                        enableDataStoreNotification = "false";
                    }
                    if (debugger.messageEnabled()) {
                        debugger.message("EventService.initListeners()-com.sun.identity.sm.enableDataStoreNotification:" + enableDataStoreNotification);
                    }
                    if (enableDataStoreNotification.equals("false") && ServiceManager.isRealmEnabled()) {
                        debugger.message("EventService.initListeners() - Skipping com.sun.identity.sm.ldap.LDAPEventManager");
                        continue;
                    }
                }
                Class<?> thisClass = Class.forName(l1);
                IDSEventListener listener = (IDSEventListener)thisClass.newInstance();
                _ideListenersMap.put(l1, listener);
                _instance.addListener(EventService.getSSOToken(), listener, listener.getBase(), listener.getScope(), listener.getFilter(), listener.getOperations());
                if (!debugger.messageEnabled()) continue;
                debugger.message("EventService.initListeners() - successfully initialized listener: " + l1);
                continue;
            }
            catch (Exception e) {
                debugger.error("EventService.initListeners() Unable to start listener " + l1, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (debugger.messageEnabled()) {
                debugger.message("EventService.run(): Event Thread is running! No Idle timeout Set: " + _idleTimeOut + " minutes.");
            }
            boolean successState = true;
            LDAPMessage message = null;
            while (successState) {
                try {
                    if (debugger.messageEnabled()) {
                        debugger.message("EventService.run(): Waiting for response");
                    }
                    message = _msgQueue.getResponse();
                    EventService eventService = this;
                    synchronized (eventService) {
                        if (_shutdownCalled) {
                            break;
                        }
                        if (message == null && this._requestList.isEmpty()) {
                            this.wait();
                            continue;
                        }
                        successState = this.processResponse(message);
                    }
                }
                catch (LDAPInterruptedException ex) {
                    if (_shutdownCalled) {
                        break;
                    }
                    if (!debugger.warningEnabled()) continue;
                    debugger.warning("EventService.run() LDAPInterruptedException received:", ex);
                }
                catch (LDAPException ex) {
                    if (_shutdownCalled) {
                        break;
                    }
                    int resultCode = ex.getLDAPResultCode();
                    if (debugger.warningEnabled()) {
                        debugger.warning("EventService.run() LDAPException received:", ex);
                    }
                    if (_retryErrorCodes.contains("" + resultCode)) {
                        this.resetErrorSearches(true);
                        continue;
                    }
                    this.processNetworkError(ex);
                }
            }
        }
        catch (InterruptedException ex) {
            if (!_shutdownCalled && debugger.warningEnabled()) {
                debugger.warning("EventService.run(): Interrupted exception caught.", ex);
            }
        }
        catch (RuntimeException ex) {
            if (debugger.warningEnabled()) {
                debugger.warning("EventService.run(): Runtime exception caught.", ex);
            }
            throw ex;
        }
        catch (Exception ex) {
            if (debugger.warningEnabled()) {
                debugger.warning("EventService.run(): Unknown exception caught.", ex);
            }
        }
        catch (Throwable t) {
            if (debugger.warningEnabled()) {
                debugger.warning("EventService.run(): Unknown exception caught. Sleeping for a while.. ", t);
            }
            throw new Error(t);
        }
        finally {
            EventService ex = this;
            synchronized (ex) {
                if (!_shutdownCalled) {
                    _monitorThread = null;
                    EventService.startMonitorThread();
                }
            }
        }
    }

    private static synchronized void startMonitorThread() {
        if (_monitorThread == null || !_monitorThread.isAlive() && !_shutdownCalled) {
            _monitorThread = new Thread((Runnable)_instance, EventService.getName());
            _monitorThread.start();
            _isThreadStarted = true;
        }
    }

    protected boolean processResponse(LDAPMessage message) {
        if (message == null && !this._requestList.isEmpty()) {
            debugger.warning("EventService.processResponse() - Received a NULL Response. Attempting to re-start persistent searches");
            this.resetErrorSearches(false);
            return true;
        }
        if (debugger.messageEnabled()) {
            debugger.message("EventService.processResponse() - received DS message  => " + message.toString());
        }
        boolean successState = true;
        Request request = this.getRequestEntry(message.getMessageID());
        if (request == null) {
            if (debugger.messageEnabled()) {
                debugger.message("EventService.processResponse() - Received ldap message with unknown id = " + message.getMessageID());
            }
        } else if (message instanceof LDAPSearchResult) {
            this.processSearchResultMessage((LDAPSearchResult)message, request);
            request.setLastUpdatedTime(System.currentTimeMillis());
        } else if (message instanceof LDAPResponse) {
            LDAPResponse rsp = (LDAPResponse)message;
            successState = this.processResponseMessage(rsp, request);
        } else if (message instanceof LDAPSearchResultReference) {
            this.processSearchResultRef((LDAPSearchResultReference)message, request);
        }
        return successState;
    }

    protected void removeListener(Request request) {
        block5: {
            LDAPConnection connection = request.getLDAPConnection();
            if (connection != null) {
                if (debugger.messageEnabled()) {
                    debugger.message("EventService.removeListener(): Removing listener requestID: " + request.getRequestID() + " Listener: " + request.getListener());
                }
                try {
                    if (connection != null && connection.isConnected()) {
                        connection.abandon(request.getId());
                        connection.disconnect();
                    }
                }
                catch (LDAPException le) {
                    if (!debugger.warningEnabled()) break block5;
                    debugger.warning("EventService.removeListener(): LDAPException, when trying to remove listener", le);
                }
            }
        }
    }

    protected void resetErrorSearches(boolean clearCaches) {
        Hashtable tmpReqList = new Hashtable(this._requestList);
        int[] ids = _msgQueue.getMessageIDs();
        for (int i = 0; i < ids.length; ++i) {
            String reqID = Integer.toString(ids[i]);
            tmpReqList.remove(reqID);
        }
        Collection reqList = tmpReqList.values();
        Iterator iter = reqList.iterator();
        while (iter.hasNext()) {
            Request req = (Request)iter.next();
            this._requestList.remove(req.getRequestID());
            if (!clearCaches) continue;
            req.getListener().allEntriesChanged();
        }
        RetryTask task = new RetryTask(this, tmpReqList, _numRetries);
        SystemTimer.getTimer().schedule((TaskRunnable)task, new Date((System.currentTimeMillis() + (long)_retryInterval) / 1000L * 1000L));
    }

    public synchronized boolean resetAllSearches(boolean clearCaches) {
        Iterator iter;
        boolean doItAgain;
        if (_shutdownCalled) {
            return false;
        }
        Hashtable tmpReqList = new Hashtable(this._requestList);
        this._requestList.clear();
        Collection reqList = tmpReqList.values();
        int retry = 1;
        boolean bl = doItAgain = _numRetries == -1 || _numRetries != 0 && retry <= _numRetries;
        if (clearCaches) {
            iter = reqList.iterator();
            while (iter.hasNext()) {
                Request req = (Request)iter.next();
                IDSEventListener el = req.getListener();
                el.allEntriesChanged();
            }
        }
        while (doItAgain) {
            this.sleepRetryInterval();
            if (debugger.messageEnabled()) {
                String str = _numRetries == -1 ? "indefinitely" : Integer.toString(retry);
                debugger.message("EventService.resetAllSearches(): retrying = " + str);
            }
            iter = reqList.iterator();
            while (iter.hasNext()) {
                try {
                    Request request = (Request)iter.next();
                    this.addListener(request.getRequester(), request.getListener(), request.getBaseDn(), request.getScope(), request.getFilter(), request.getOperations());
                    this.removeListener(request);
                    iter.remove();
                }
                catch (LDAPServiceException e) {
                    if (retry != _numRetries) continue;
                    this.processNetworkError(e);
                }
                catch (LDAPException le) {
                    if (retry != _numRetries) continue;
                    this.processNetworkError(le);
                }
            }
            if (reqList.isEmpty()) {
                return true;
            }
            if (_numRetries == -1 || (doItAgain = ++retry <= _numRetries)) continue;
            iter = reqList.iterator();
            while (iter.hasNext()) {
                this.removeListener((Request)iter.next());
            }
        }
        return false;
    }

    protected void sleepRetryInterval() {
        try {
            Thread.sleep(_retryInterval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected static void getConfigManager() throws EventException {
        try {
            cm = DSConfigMgr.getDSConfigMgr();
        }
        catch (LDAPServiceException lse) {
            debugger.error("EventService.getConfigManager() - Failed to get handle to Configuration Manager", lse);
            throw new EventException(i18n.getString("dscfg-nocfgmgr"), lse);
        }
    }

    private void dispatchException(Exception e, Request request) {
        IDSEventListener el = request.getListener();
        debugger.error("EventService.dispatchException() - dispatching exception to the listener: " + request.getRequestID() + " Listener: " + request.getListener(), e);
        el.eventError(e.toString());
    }

    private void dispatchEvent(DSEvent dirEvent, Request request) {
        IDSEventListener el = request.getListener();
        el.entryChanged(dirEvent);
    }

    protected void processNetworkError(Exception ex) {
        Hashtable tmpRequestList = new Hashtable(this._requestList);
        int[] ids = _msgQueue.getMessageIDs();
        for (int i = 0; i < ids.length; ++i) {
            tmpRequestList.remove(Integer.toString(ids[i]));
        }
        Collection reqList = tmpRequestList.values();
        Iterator iter = reqList.iterator();
        while (iter.hasNext()) {
            Request request = (Request)iter.next();
            this.dispatchException(ex, request);
        }
    }

    protected boolean processResponseMessage(LDAPResponse rsp, Request request) {
        if (_retryErrorCodes.contains("" + rsp.getResultCode())) {
            if (debugger.messageEnabled()) {
                debugger.message("EventService.processResponseMessage() - received LDAP Response for requestID: " + request.getRequestID() + " Listener: " + request.getListener() + "Need restarting");
            }
            this.resetErrorSearches(false);
        } else if (rsp.getResultCode() != 0 || rsp.getResultCode() != 10) {
            LDAPException ex = new LDAPException("Error result", rsp.getResultCode(), rsp.getErrorMessage(), rsp.getMatchedDN());
            this.dispatchException(ex, request);
        }
        return true;
    }

    protected void processSearchResultMessage(LDAPSearchResult res, Request req) {
        LDAPControl[] ctrls;
        LDAPEntry modEntry = res.getEntry();
        if (debugger.messageEnabled()) {
            debugger.message("EventService.processSearchResultMessage() - Changed " + modEntry.getDN());
        }
        if ((ctrls = res.getControls()) == null) {
            Exception ex = new Exception("EventService - Cannot create NamingEvent, no change control info");
            this.dispatchException(ex, req);
        } else {
            for (int i = 0; i < ctrls.length; ++i) {
                LDAPEntryChangeControl changeCtrl = null;
                if (!(ctrls[i] instanceof LDAPEntryChangeControl)) continue;
                changeCtrl = (LDAPEntryChangeControl)ctrls[i];
                if (debugger.messageEnabled()) {
                    debugger.message("EventService.processSearchResultMessage() changeCtrl = " + changeCtrl.toString());
                }
                if (changeCtrl.getChangeType() == -1) {
                    Exception ex = new Exception("EventService - Cannot create NamingEvent, no change control info");
                    this.dispatchException(ex, req);
                }
                try {
                    DSEvent event = this.createDSEvent(modEntry, changeCtrl, req);
                    this.dispatchEvent(event, req);
                    continue;
                }
                catch (Exception ex) {
                    this.dispatchException(ex, req);
                }
            }
        }
    }

    protected void processSearchResultRef(LDAPSearchResultReference ref, Request req) {
        if (debugger.messageEnabled()) {
            debugger.message("EventService.processSearchResultRef() - Ignoring..");
        }
    }

    protected static SSOToken getSSOToken() throws SSOException {
        try {
            DSConfigMgr cfgMgr = DSConfigMgr.getDSConfigMgr();
            ServerInstance serInstance = cfgMgr.getServerInstance(LDAPUser.Type.AUTH_ADMIN);
            AuthPrincipal user = new AuthPrincipal(serInstance.getAuthID());
            String adminPW = (String)AccessController.doPrivileged(new ServerInstanceAction(serInstance));
            AuthContext authCtx = new AuthContext((Principal)user, adminPW.toCharArray());
            return authCtx.getSSOToken();
        }
        catch (Exception e) {
            throw new SSOException(SSOProviderBundle.rbName, "invalidadmin", null);
        }
    }

    protected Request getRequestEntry(int id) {
        return (Request)this._requestList.get(Integer.toString(id));
    }

    private DSEvent createDSEvent(LDAPEntry entry, LDAPEntryChangeControl changeCtrl, Request req) throws Exception {
        DSEvent dsEvent = new DSEvent();
        if (debugger.messageEnabled()) {
            debugger.message("EventService.createDSEvent() - Notifying event to: " + req.getListener());
        }
        String dn = entry.getDN();
        dsEvent.setID(dn);
        int changeType = changeCtrl.getChangeType();
        dsEvent.setEventType(changeType);
        dsEvent.setSearchID(req.getRequestID());
        String className = entry.getAttribute("objectclass").toString();
        dsEvent.setClassName(className);
        return dsEvent;
    }

    static /* synthetic */ int access$000() {
        return _retryInterval;
    }

    static /* synthetic */ void access$100(EventService x0, Exception x1, Request x2) {
        x0.dispatchException(x1, x2);
    }

    static {
        _instance = null;
        i18n = I18n.getInstance("amSDK");
        debugger = Debug.getInstance("amEventService");
        _allDisabled = false;
        _numRetries = 3;
        _retryInterval = 3000;
        _idleTimeOut = 0;
        listeners = new String[]{"com.iplanet.am.sdk.ldap.ACIEventListener", "com.iplanet.am.sdk.ldap.EntryEventListener", "com.sun.identity.sm.ldap.LDAPEventManager"};
        _ideListenersMap = new Hashtable();
        _isThreadStarted = false;
        _shutdownCalled = false;
        _numRetries = EventService.getPropertyIntValue(EVENT_CONNECTION_NUM_RETRIES, _numRetries);
        _retryInterval = EventService.getPropertyIntValue(EVENT_CONNECTION_RETRY_INTERVAL, _retryInterval);
        _retryErrorCodes = EventService.getPropertyRetryErrorCodes(EVENT_CONNECTION_ERROR_CODES);
        _idleTimeOut = EventService.getPropertyIntValue(EVENT_IDLE_TIMEOUT_INTERVAL, _idleTimeOut);
        _idleTimeOutMills = _idleTimeOut * 60000;
        EventService.getListenerList();
    }
}

