/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.share;

import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.share.SessionInfo;
import com.iplanet.dpro.session.share.SessionRequestParser;
import com.iplanet.dpro.session.share.SessionResponse;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class SessionResponseParser {
    private SessionResponse sessionResponse = null;
    Document document;

    public SessionResponseParser(Document xmlDoc) {
        this.document = xmlDoc;
    }

    public SessionResponseParser(String xmlString) {
        this.document = XMLUtils.toDOMDocument(xmlString, SessionRequestParser.debug);
    }

    public SessionResponse parseXML() throws SessionException {
        if (this.document == null) {
            return null;
        }
        Element elem = this.document.getDocumentElement();
        this.sessionResponse = new SessionResponse();
        String temp = elem.getAttribute("vers");
        this.sessionResponse.setResponseVersion(temp);
        temp = elem.getAttribute("reqid");
        this.sessionResponse.setRequestID(temp);
        NodeList nodelist = elem.getElementsByTagName("GetSession");
        if (nodelist != null && nodelist.getLength() != 0) {
            this.sessionResponse.setMethodID(0);
        }
        if ((nodelist = elem.getElementsByTagName("GetActiveSessions")) != null && nodelist.getLength() != 0) {
            this.sessionResponse.setMethodID(1);
        }
        if ((nodelist = elem.getElementsByTagName("DestroySession")) != null && nodelist.getLength() != 0) {
            this.sessionResponse.setMethodID(2);
        }
        if ((nodelist = elem.getElementsByTagName("Logout")) != null && nodelist.getLength() != 0) {
            this.sessionResponse.setMethodID(3);
        }
        if ((nodelist = elem.getElementsByTagName("AddSessionListener")) != null && nodelist.getLength() != 0) {
            this.sessionResponse.setMethodID(4);
        }
        if ((nodelist = elem.getElementsByTagName("AddSessionListenerOnAllSessions")) != null && nodelist.getLength() != 0) {
            this.sessionResponse.setMethodID(5);
        }
        if ((nodelist = elem.getElementsByTagName("SetProperty")) != null && nodelist.getLength() != 0) {
            this.sessionResponse.setMethodID(6);
        }
        if ((nodelist = elem.getElementsByTagName("GetSessionCount")) != null && nodelist.getLength() != 0) {
            this.sessionResponse.setMethodID(7);
        }
        if ((nodelist = elem.getElementsByTagName("SessionExpirationTimeInfo")) != null && nodelist.getLength() != 0) {
            this.parseAllSessionsGivenUUIDElements(nodelist);
        }
        if ((nodelist = elem.getElementsByTagName("Session")) != null && nodelist.getLength() != 0) {
            this.parseSessionElements(nodelist);
        }
        if ((nodelist = elem.getElementsByTagName("OK")) != null && nodelist.getLength() != 0) {
            this.sessionResponse.setBooleanFlag(true);
        }
        if ((nodelist = elem.getElementsByTagName("Exception")) != null && nodelist.getLength() != 0) {
            Element exception = (Element)nodelist.item(0);
            this.sessionResponse.setException(SessionRequestParser.parseCDATA(exception));
        }
        if ((nodelist = elem.getElementsByTagName("Status")) != null && nodelist.getLength() != 0) {
            String status = SessionRequestParser.parseCDATA((Element)nodelist.item(0));
            try {
                this.sessionResponse.setStatus(Integer.parseInt(status));
            }
            catch (NumberFormatException e) {
                SessionRequestParser.debug.error("SessionResponseParse : ", e);
                throw new SessionException(e.getMessage());
            }
        }
        return this.sessionResponse;
    }

    private void parseAllSessionsGivenUUIDElements(NodeList nodelist) {
        int len = nodelist.getLength();
        for (int i = 0; i < len; ++i) {
            Element sess = (Element)nodelist.item(i);
            this.parseSessionExpirationTimeInfo(sess);
        }
    }

    private void parseSessionExpirationTimeInfo(Element sess) {
        String sid = null;
        Long expTime = null;
        String temp = sess.getAttribute("sid");
        if (temp != null) {
            sid = temp;
        }
        if ((temp = sess.getAttribute("expTime")) != null) {
            expTime = new Long(temp);
        }
        this.sessionResponse.addSessionForGivenUUID(sid, expTime);
    }

    private void parseSessionElements(NodeList nodelist) {
        int len = nodelist.getLength();
        for (int i = 0; i < len; ++i) {
            Element sess = (Element)nodelist.item(i);
            SessionInfo sessionInfo = SessionResponseParser.parseSessionElement(sess);
            this.sessionResponse.addSessionInfo(sessionInfo);
            SessionRequestParser.debug.message("In parse session " + sessionInfo.toString());
        }
    }

    static SessionInfo parseSessionElement(Element sess) {
        NodeList properties;
        SessionInfo sessionInfo = new SessionInfo();
        String temp = sess.getAttribute("sid");
        if (temp != null) {
            sessionInfo.sid = temp;
        }
        if ((temp = sess.getAttribute("stype")) != null) {
            sessionInfo.stype = temp;
        }
        if ((temp = sess.getAttribute("cid")) != null) {
            sessionInfo.cid = temp;
        }
        if ((temp = sess.getAttribute("cdomain")) != null) {
            sessionInfo.cdomain = temp;
        }
        if ((temp = sess.getAttribute("maxtime")) != null) {
            sessionInfo.maxtime = temp;
        }
        if ((temp = sess.getAttribute("maxidle")) != null) {
            sessionInfo.maxidle = temp;
        }
        if ((temp = sess.getAttribute("maxcaching")) != null) {
            sessionInfo.maxcaching = temp;
        }
        if ((temp = sess.getAttribute("timeleft")) != null) {
            sessionInfo.timeleft = temp;
        }
        if ((temp = sess.getAttribute("timeidle")) != null) {
            sessionInfo.timeidle = temp;
        }
        if ((temp = sess.getAttribute("state")) != null) {
            sessionInfo.state = temp;
        }
        if ((properties = sess.getElementsByTagName("Property")) != null) {
            int p = properties.getLength();
            for (int j = 0; j < p; ++j) {
                Element property = (Element)properties.item(j);
                String name = property.getAttribute("name");
                if (name == null) continue;
                sessionInfo.properties.put(name, property.getAttribute("value"));
            }
        }
        return sessionInfo;
    }
}

