/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.CaseInsensitiveHashSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AMHashMap
extends CaseInsensitiveHashMap {
    private static final long serialVersionUID = 6468554078141700418L;
    private boolean byteValues = false;
    private Set byteNegativeAttrs = Collections.EMPTY_SET;

    public AMHashMap() {
    }

    public AMHashMap(boolean forByteValues) {
        this.byteValues = forByteValues;
    }

    public AMHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public AMHashMap(int initialCapacity, boolean forByteValues) {
        super(initialCapacity);
        this.byteValues = forByteValues;
    }

    public AMHashMap(HashMap map) {
        if (map != null) {
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                String n = (String)it.next();
                this.put(n, map.get(n));
            }
        }
    }

    public boolean isEmpty() {
        if (!this.byteValues) {
            return super.isEmpty();
        }
        return super.isEmpty() && this.byteNegativeAttrs.isEmpty();
    }

    public void clear() {
        super.clear();
        if (this.byteValues) {
            this.clearNegativeByteAttrs();
        }
    }

    private void addNegativeByteAttr(String name) {
        if (this.byteNegativeAttrs == Collections.EMPTY_SET) {
            this.byteNegativeAttrs = new CaseInsensitiveHashSet();
        }
        this.byteNegativeAttrs.add(name);
    }

    private void removeNegativeByteAttr(String name) {
        if (this.byteNegativeAttrs != Collections.EMPTY_SET) {
            this.byteNegativeAttrs.remove(name);
        }
    }

    protected void clearNegativeByteAttrs() {
        if (this.byteNegativeAttrs != Collections.EMPTY_SET) {
            this.byteNegativeAttrs.clear();
        }
    }

    private boolean isNegativeByteAttr(String name) {
        return this.byteNegativeAttrs.contains(name);
    }

    protected void setNegativeByteAttr(Set n) {
        this.byteNegativeAttrs = n;
    }

    public Set getNegativeByteAttrClone() {
        if (this.byteNegativeAttrs == Collections.EMPTY_SET) {
            return Collections.EMPTY_SET;
        }
        HashSet res = new HashSet();
        Iterator it = this.byteNegativeAttrs.iterator();
        while (it.hasNext()) {
            res.add(it.next());
        }
        return res;
    }

    public Set getMissingKeys(Set keys) {
        HashSet<String> missAttrNames = new HashSet<String>();
        Iterator itr = keys.iterator();
        while (itr.hasNext()) {
            String name = (String)itr.next();
            if (this.get(name) != null) continue;
            if (this.byteValues) {
                if (this.isNegativeByteAttr(name)) continue;
                missAttrNames.add(name);
                this.addNegativeByteAttr(name);
                continue;
            }
            missAttrNames.add(name);
            this.put(name, new HashSet());
        }
        return missAttrNames;
    }

    public Set getMissingAndEmptyKeys(Set keys) {
        HashSet<String> missAttrNames = new HashSet<String>();
        Iterator itr = keys.iterator();
        if (!this.byteValues) {
            while (itr.hasNext()) {
                String name = (String)itr.next();
                Set values = (Set)this.get(name);
                if (values == null) {
                    missAttrNames.add(name);
                    this.put(name, new HashSet());
                    continue;
                }
                if (!values.isEmpty()) continue;
                missAttrNames.add(name);
            }
        } else {
            while (itr.hasNext()) {
                String name = (String)itr.next();
                byte[][] values = (byte[][])this.get(name);
                if (values == null) {
                    missAttrNames.add(name);
                    this.addNegativeByteAttr(name);
                    continue;
                }
                if (!this.isNegativeByteAttr(name)) continue;
                missAttrNames.add(name);
            }
        }
        return missAttrNames;
    }

    public void removeKeys(Set keys) {
        if (keys != null && !keys.isEmpty()) {
            Iterator itr = keys.iterator();
            while (itr.hasNext()) {
                String t = (String)itr.next();
                this.remove(t);
                this.removeNegativeByteAttr(t);
            }
        }
    }

    public void copy(Map map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        Iterator itr = map.keySet().iterator();
        if (!this.byteValues) {
            while (itr.hasNext()) {
                String name = (String)itr.next();
                Set values = (Set)map.get(name);
                this.put(name, this.getSetCopy(values));
            }
        } else {
            while (itr.hasNext()) {
                String name = (String)itr.next();
                byte[][] values = (byte[][])map.get(name);
                this.put(name, values);
                this.removeNegativeByteAttr(name);
            }
            if (map instanceof AMHashMap) {
                this.setNegativeByteAttr(((AMHashMap)map).getNegativeByteAttrClone());
            }
        }
    }

    public Set copyValuesOnly(Map map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        HashSet<String> attrsWithValues = new HashSet<String>();
        Iterator itr = map.keySet().iterator();
        if (!this.byteValues) {
            while (itr.hasNext()) {
                String name = (String)itr.next();
                Set values = (Set)map.get(name);
                if (!values.isEmpty()) {
                    this.put(name, this.getSetCopy(values));
                    attrsWithValues.add(name);
                    continue;
                }
                this.put(name, Collections.EMPTY_SET);
                attrsWithValues.add(name);
            }
        } else {
            while (itr.hasNext()) {
                String name = (String)itr.next();
                byte[][] values = (byte[][])map.get(name);
                this.put(name, values);
                attrsWithValues.add(name);
            }
        }
        return attrsWithValues;
    }

    public void merge(Map map) {
        if (map == null) {
            throw new NullPointerException();
        }
        if (!this.byteValues) {
            Iterator itr = map.keySet().iterator();
            while (itr.hasNext()) {
                String name = (String)itr.next();
                Set values = (Set)this.get(name);
                if (values != null) {
                    values.addAll((Set)map.get(name));
                    continue;
                }
                this.put(name, (Set)map.get(name));
            }
        } else {
            this.putAll(map);
        }
    }

    public void addEmptyValues(Set names) {
        Iterator itr = names.iterator();
        while (itr.hasNext()) {
            String name = (String)itr.next();
            if (!this.byteValues) {
                this.put(name, new HashSet());
                continue;
            }
            this.addNegativeByteAttr(name);
        }
    }

    public void removeEmptyValues() {
        HashSet<String> emptyKeys = new HashSet<String>();
        if (!this.byteValues) {
            Iterator itr = this.keySet().iterator();
            while (itr.hasNext()) {
                String name = (String)itr.next();
                Set values = (Set)this.get(name);
                if (!values.isEmpty()) continue;
                emptyKeys.add(name);
            }
            this.removeKeys(emptyKeys);
        }
        this.clearNegativeByteAttrs();
    }

    public Map getCopy() {
        if (!this.byteValues) {
            AMHashMap map = new AMHashMap(this.size(), false);
            if (!this.isEmpty()) {
                Iterator itr = this.keySet().iterator();
                while (itr.hasNext()) {
                    String name = (String)itr.next();
                    Set values = (Set)this.get(name);
                    map.put(name, this.getSetCopy(values));
                }
            }
            return map;
        }
        AMHashMap map = new AMHashMap(this.size(), true);
        if (!this.isEmpty()) {
            Iterator itr = this.keySet().iterator();
            while (itr.hasNext()) {
                String name = (String)itr.next();
                byte[][] values = (byte[][])this.get(name);
                map.put(name, this.getByteArrayCopy(values));
            }
        }
        map.setNegativeByteAttr(this.getNegativeByteAttrClone());
        return map;
    }

    public Map getCopy(Set names) {
        if (!this.byteValues) {
            AMHashMap map = new AMHashMap(false);
            if (!this.isEmpty() && !names.isEmpty()) {
                Iterator itr = names.iterator();
                while (itr.hasNext()) {
                    String name = (String)itr.next();
                    Set values = (Set)this.get(name);
                    if (values == null) continue;
                    map.put(name, this.getSetCopy(values));
                }
            }
            return map;
        }
        AMHashMap map = new AMHashMap(true);
        if (!this.isEmpty() && !names.isEmpty()) {
            Iterator itr = names.iterator();
            while (itr.hasNext()) {
                String name = (String)itr.next();
                byte[][] values = (byte[][])this.get(name);
                if (values == null) continue;
                map.put(name, this.getByteArrayCopy(values));
            }
        }
        map.setNegativeByteAttr(this.getNegativeByteAttrClone());
        return map;
    }

    private Set getSetCopy(Set values) {
        HashSet<String> copyValues = new HashSet<String>(values.size());
        if (!values.isEmpty()) {
            Iterator itr = values.iterator();
            while (itr.hasNext()) {
                String value = (String)itr.next();
                copyValues.add(value);
            }
        }
        return copyValues;
    }

    private byte[][] getByteArrayCopy(byte[][] values) {
        int count1 = values.length;
        byte[][] copyValues = new byte[count1][];
        for (int i = 0; i < count1; ++i) {
            int count2 = values[i].length;
            copyValues[i] = new byte[count2];
            for (int j = 0; j < count2; ++j) {
                copyValues[i][j] = values[i][j];
            }
        }
        return copyValues;
    }
}

