/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.identity.hibernate;

import java.sql.Connection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.jbpm.identity.Group;
import org.jbpm.identity.Membership;
import org.jbpm.identity.User;
import org.jbpm.identity.hibernate.IdentitySession;

public class IdentitySessionFactory {
    protected Configuration configuration = null;
    protected SessionFactory sessionFactory = null;
    private static final Log log = LogFactory.getLog((Class)IdentitySessionFactory.class);

    public IdentitySessionFactory() {
        this(IdentitySessionFactory.createConfiguration());
    }

    public IdentitySessionFactory(Configuration configuration) {
        this(configuration, configuration.buildSessionFactory());
    }

    public IdentitySessionFactory(Configuration configuration, SessionFactory sessionFactory) {
        this.configuration = configuration;
        this.sessionFactory = sessionFactory;
    }

    public static Configuration createConfiguration() {
        return IdentitySessionFactory.createConfiguration(null);
    }

    public static Configuration createConfiguration(String resource) {
        Configuration configuration = null;
        configuration = new Configuration();
        if (resource != null) {
            log.debug((Object)("using '" + resource + "' as hibernate configuration for jbpm"));
            configuration.configure(resource);
        } else {
            log.debug((Object)"using the default hibernate configuration file: hibernate.cfg.xml");
            configuration.configure();
        }
        return configuration;
    }

    public IdentitySession openIdentitySession() {
        return new IdentitySession((Session)this.sessionFactory.openSession());
    }

    public IdentitySession openIdentitySession(Connection connection) {
        return new IdentitySession((Session)this.sessionFactory.openSession(connection));
    }

    public void evictCachedIdentities() {
        this.sessionFactory.evict(User.class);
        this.sessionFactory.evict(Membership.class);
        this.sessionFactory.evict(Group.class);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }
}

