/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.juddi.v3.client.config.TokenResolver;
import org.apache.juddi.v3.client.config.UDDIClerk;
import org.apache.juddi.v3.client.config.UDDINode;
import org.apache.juddi.v3.client.config.XRegistration;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientConfig {
    private static final String UDDI_CONFIG_FILENAME_PROPERTY = "uddi.client.xml";
    public static final String UDDI_CONFIG = "META-INF/uddi.xml";
    private Logger log = Logger.getLogger(ClientConfig.class);
    private Configuration config = null;
    private Map<String, UDDINode> uddiNodes = null;
    private Map<String, UDDIClerk> uddiClerks = null;
    private Set<XRegistration> xBusinessRegistrations = null;
    private Set<XRegistration> xServiceBindingRegistrations = null;
    private String managerName = null;

    public ClientConfig(String configurationFile) throws ConfigurationException {
        this.loadConfiguration(configurationFile);
    }

    protected void loadManager() throws ConfigurationException {
        this.uddiNodes = this.readNodeConfig(this.config);
        this.uddiClerks = this.readClerkConfig(this.config, this.uddiNodes);
        this.xServiceBindingRegistrations = this.readXServiceBindingRegConfig(this.config, this.uddiClerks);
        this.xBusinessRegistrations = this.readXBusinessRegConfig(this.config, this.uddiClerks);
    }

    private void loadConfiguration(String configurationFile) throws ConfigurationException {
        String filename;
        CompositeConfiguration compositeConfig = new CompositeConfiguration();
        compositeConfig.addConfiguration((Configuration)new SystemConfiguration());
        XMLConfiguration xmlConfig = null;
        xmlConfig = configurationFile != null ? new XMLConfiguration(configurationFile) : ((filename = System.getProperty(UDDI_CONFIG_FILENAME_PROPERTY)) != null ? new XMLConfiguration(filename) : new XMLConfiguration(UDDI_CONFIG));
        this.log.info((Object)("Reading UDDI Client properties file " + xmlConfig.getBasePath()));
        long refreshDelay = xmlConfig.getLong("reloadDelay", 1000L);
        this.log.debug((Object)("Setting refreshDelay to " + refreshDelay));
        FileChangedReloadingStrategy fileChangedReloadingStrategy = new FileChangedReloadingStrategy();
        fileChangedReloadingStrategy.setRefreshDelay(refreshDelay);
        xmlConfig.setReloadingStrategy((ReloadingStrategy)fileChangedReloadingStrategy);
        compositeConfig.addConfiguration((Configuration)xmlConfig);
        this.config = compositeConfig;
        this.loadManager();
    }

    private Map<String, UDDIClerk> readClerkConfig(Configuration config, Map<String, UDDINode> uddiNodes) throws ConfigurationException {
        this.managerName = config.getString("manager[@name]");
        HashMap<String, UDDIClerk> clerks = new HashMap<String, UDDIClerk>();
        if (config.containsKey("manager.clerks.clerk[@name]")) {
            String[] names = config.getStringArray("manager.clerks.clerk[@name]");
            this.log.debug((Object)("clerk names=" + names));
            for (int i = 0; i < names.length; ++i) {
                UDDIClerk uddiClerk = new UDDIClerk();
                uddiClerk.setManagerName(this.managerName);
                uddiClerk.setName(config.getString("manager.clerks.clerk(" + i + ")[@name]"));
                String nodeRef = config.getString("manager.clerks.clerk(" + i + ")[@node]");
                if (!uddiNodes.containsKey(nodeRef)) {
                    throw new ConfigurationException("Could not find Node with name=" + nodeRef);
                }
                UDDINode uddiNode = uddiNodes.get(nodeRef);
                uddiClerk.setUDDINode(uddiNode);
                uddiClerk.setPublisher(config.getString("manager.clerks.clerk(" + i + ")[@publisher]"));
                uddiClerk.setPassword(config.getString("manager.clerks.clerk(" + i + ")[@password]"));
                String[] classes = config.getStringArray("manager.clerks.clerk(" + i + ").class");
                uddiClerk.setClassWithAnnotations(classes);
                clerks.put(names[i], uddiClerk);
            }
        }
        return clerks;
    }

    public boolean isRegisterOnStartup() {
        boolean isRegisterOnStartup = false;
        if (this.config.containsKey("manager.clerks[@registerOnStartup]")) {
            isRegisterOnStartup = this.config.getBoolean("manager.clerks[@registerOnStartup]");
        }
        return isRegisterOnStartup;
    }

    private Map<String, UDDINode> readNodeConfig(Configuration config) throws ConfigurationException {
        String[] names = config.getStringArray("manager.nodes.node.name");
        HashMap<String, UDDINode> nodes = new HashMap<String, UDDINode>();
        this.log.debug((Object)("node names=" + names));
        for (int i = 0; i < names.length; ++i) {
            UDDINode uddiNode = new UDDINode();
            String nodeName = config.getString("manager.nodes.node(" + i + ").name");
            String[] propertyKeys = config.getStringArray("manager.nodes.node(" + i + ").properties.property[@name]");
            Properties properties = null;
            if (propertyKeys != null && propertyKeys.length > 0) {
                properties = new Properties();
                for (int p = 0; p < propertyKeys.length; ++p) {
                    String name = config.getString("manager.nodes.node(" + i + ").properties.property(" + p + ")[@name]");
                    String value = config.getString("manager.nodes.node(" + i + ").properties.property(" + p + ")[@value]");
                    this.log.debug((Object)("Property: name=" + name + " value=" + value));
                    properties.put(name, value);
                }
                uddiNode.setProperties(properties);
            }
            uddiNode.setHomeJUDDI(config.getBoolean("manager.nodes.node(" + i + ")[@isHomeJUDDI]", false));
            uddiNode.setName(config.getString("manager.nodes.node(" + i + ").name"));
            uddiNode.setManagerName(config.getString("manager[@name]"));
            uddiNode.setDescription(config.getString("manager.nodes.node(" + i + ").description"));
            uddiNode.setProxyTransport(config.getString("manager.nodes.node(" + i + ").proxyTransport"));
            uddiNode.setInquiryUrl(TokenResolver.replaceTokens(config.getString("manager.nodes.node(" + i + ").inquiryUrl"), properties));
            uddiNode.setPublishUrl(TokenResolver.replaceTokens(config.getString("manager.nodes.node(" + i + ").publishUrl"), properties));
            uddiNode.setCustodyTransferUrl(TokenResolver.replaceTokens(config.getString("manager.nodes.node(" + i + ").custodyTransferUrl"), properties));
            uddiNode.setSecurityUrl(TokenResolver.replaceTokens(config.getString("manager.nodes.node(" + i + ").securityUrl"), properties));
            uddiNode.setSubscriptionUrl(TokenResolver.replaceTokens(config.getString("manager.nodes.node(" + i + ").subscriptionUrl"), properties));
            uddiNode.setSubscriptionListenerUrl(TokenResolver.replaceTokens(config.getString("manager.nodes.node(" + i + ").subscriptionListenerUrl"), properties));
            uddiNode.setJuddiApiUrl(TokenResolver.replaceTokens(config.getString("manager.nodes.node(" + i + ").juddiApiUrl"), properties));
            uddiNode.setFactoryInitial(config.getString("manager.nodes.node(" + i + ").javaNamingFactoryInitial"));
            uddiNode.setFactoryURLPkgs(config.getString("manager.nodes.node(" + i + ").javaNamingFactoryUrlPkgs"));
            uddiNode.setFactoryNamingProvider(TokenResolver.replaceTokens(config.getString("manager.nodes.node(" + i + ").javaNamingProviderUrl"), properties));
            nodes.put(nodeName, uddiNode);
        }
        return nodes;
    }

    private Set<XRegistration> readXBusinessRegConfig(Configuration config, Map<String, UDDIClerk> clerks) throws ConfigurationException {
        return this.readXRegConfig(config, clerks, "business");
    }

    private Set<XRegistration> readXServiceBindingRegConfig(Configuration config, Map<String, UDDIClerk> clerks) throws ConfigurationException {
        return this.readXRegConfig(config, clerks, "servicebinding");
    }

    private Set<XRegistration> readXRegConfig(Configuration config, Map<String, UDDIClerk> clerks, String entityType) throws ConfigurationException {
        String[] entityKeys = config.getStringArray("manager.clerks.xregister." + entityType + "[@entityKey]");
        HashSet<XRegistration> xRegistrations = new HashSet<XRegistration>();
        this.log.info((Object)("XRegistration " + entityKeys.length + " " + entityType + "Keys"));
        for (int i = 0; i < entityKeys.length; ++i) {
            XRegistration xRegistration = new XRegistration();
            xRegistration.setEntityKey(config.getString("manager.clerks.xregister." + entityType + "(" + i + ")[@entityKey]"));
            String fromClerkRef = config.getString("manager.clerks.xregister." + entityType + "(" + i + ")[@fromClerk]");
            if (!clerks.containsKey(fromClerkRef)) {
                throw new ConfigurationException("Could not find fromClerk with name=" + fromClerkRef);
            }
            UDDIClerk fromClerk = clerks.get(fromClerkRef);
            xRegistration.setFromClerk(fromClerk);
            String toClerkRef = config.getString("manager.clerks.xregister." + entityType + "(" + i + ")[@toClerk]");
            if (!clerks.containsKey(toClerkRef)) {
                throw new ConfigurationException("Could not find toClerk with name=" + toClerkRef);
            }
            UDDIClerk toClerk = clerks.get(toClerkRef);
            xRegistration.setToClerk(toClerk);
            this.log.info((Object)xRegistration);
            xRegistrations.add(xRegistration);
        }
        return xRegistrations;
    }

    protected Map<String, UDDINode> getUDDINodes() {
        return this.uddiNodes;
    }

    public UDDINode getUDDINode(String nodeName) throws ConfigurationException {
        if (!this.uddiNodes.containsKey(nodeName)) {
            throw new ConfigurationException("Node '" + nodeName + "' cannot be found in the config '" + this.getManagerName() + "'");
        }
        return this.uddiNodes.get(nodeName);
    }

    public Map<String, UDDIClerk> getUDDIClerks() {
        return this.uddiClerks;
    }

    public Set<XRegistration> getXServiceBindingRegistrations() {
        return this.xServiceBindingRegistrations;
    }

    public Set<XRegistration> getXBusinessRegistrations() {
        return this.xBusinessRegistrations;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public String getManagerName() {
        return this.managerName;
    }
}

