/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Sprintf;

@JRubyClass(name={"NameError"}, parent="StandardError")
public class RubyNameError
extends RubyException {
    private IRubyObject name;
    private static ObjectAllocator NAMEERROR_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyNameError(runtime, klass);
        }
    };

    public static RubyClass createNameErrorClass(Ruby runtime, RubyClass standardErrorClass) {
        RubyClass nameErrorClass = runtime.defineClass("NameError", standardErrorClass, NAMEERROR_ALLOCATOR);
        nameErrorClass.defineAnnotatedMethods(RubyNameError.class);
        return nameErrorClass;
    }

    public static RubyClass createNameErrorMessageClass(Ruby runtime, RubyClass nameErrorClass) {
        RubyClass messageClass = nameErrorClass.defineClassUnder("Message", runtime.getObject(), RubyNameErrorMessage.NAMEERRORMESSAGE_ALLOCATOR);
        messageClass.defineAnnotatedMethods(RubyNameErrorMessage.class);
        return messageClass;
    }

    protected RubyNameError(Ruby runtime, RubyClass exceptionClass) {
        this(runtime, exceptionClass, exceptionClass.getName());
    }

    public RubyNameError(Ruby runtime, RubyClass exceptionClass, String message) {
        this(runtime, exceptionClass, message, null);
    }

    public RubyNameError(Ruby runtime, RubyClass exceptionClass, String message, String name) {
        super(runtime, exceptionClass, message);
        this.name = name == null ? runtime.getNil() : runtime.newString(name);
    }

    @JRubyMethod(name={"exception"}, rest=true, meta=true)
    public static RubyException newRubyNameError(IRubyObject recv, IRubyObject[] args) {
        RubyClass klass = (RubyClass)recv;
        RubyException newError = (RubyException)klass.allocate();
        newError.callInit(args, Block.NULL_BLOCK);
        return newError;
    }

    @JRubyMethod(name={"initialize"}, optional=2, frame=true)
    public IRubyObject initialize(IRubyObject[] args, Block block) {
        if (args.length > 1) {
            this.name = args[args.length - 1];
            int newLength = args.length > 2 ? args.length - 2 : args.length - 1;
            IRubyObject[] tmpArgs = new IRubyObject[newLength];
            System.arraycopy(args, 0, tmpArgs, 0, newLength);
            args = tmpArgs;
        } else {
            this.name = this.getRuntime().getNil();
        }
        super.initialize(args, block);
        return this;
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        if (this.message.isNil()) {
            return this.getRuntime().newString(this.message.getMetaClass().getName());
        }
        RubyString str = this.message.convertToString();
        if (str != this.message) {
            this.message = str;
        }
        if (this.isTaint()) {
            this.message.setTaint(true);
        }
        return this.message;
    }

    @JRubyMethod(name={"name"})
    public IRubyObject name() {
        return this.name;
    }

    @JRubyClass(name={"NameError::Message"}, parent="Object")
    public static final class RubyNameErrorMessage
    extends RubyObject {
        static ObjectAllocator NAMEERRORMESSAGE_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                RubyObject dummy = new RubyObject(runtime, runtime.getObject());
                return new RubyNameErrorMessage(runtime, dummy, dummy, Visibility.PRIVATE, CallType.VARIABLE);
            }
        };
        private final IRubyObject object;
        private final IRubyObject method;
        private final Visibility visibility;
        private final CallType callType;

        RubyNameErrorMessage(Ruby runtime, IRubyObject object, IRubyObject method, Visibility visibility, CallType callType) {
            super(runtime, runtime.getNameErrorMessage(), false);
            this.object = object;
            this.method = method;
            this.visibility = visibility;
            this.callType = callType;
        }

        @JRubyMethod(name={"_load"}, meta=true)
        public static IRubyObject load(IRubyObject recv, IRubyObject arg) {
            return arg;
        }

        @JRubyMethod(name={"_dump"})
        public IRubyObject dump(ThreadContext context, IRubyObject arg) {
            return this.to_str(context);
        }

        @JRubyMethod(name={"to_str"})
        public IRubyObject to_str(ThreadContext context) {
            String format = null;
            if (this.visibility == Visibility.PRIVATE) {
                format = "private method `%s' called for %s";
            } else if (this.visibility == Visibility.PROTECTED) {
                format = "protected method `%s' called for %s";
            } else if (this.callType == CallType.VARIABLE) {
                format = "undefined local variable or method `%s' for %s";
            } else if (this.callType == CallType.SUPER) {
                format = "super: no superclass method `%s'";
            }
            if (format == null) {
                format = "undefined method `%s' for %s";
            }
            String description = null;
            if (this.object.isNil()) {
                description = "nil";
            } else if (this.object instanceof RubyBoolean && this.object.isTrue()) {
                description = "true";
            } else if (this.object instanceof RubyBoolean && !this.object.isTrue()) {
                description = "false";
            } else {
                try {
                    description = RubyObject.inspect(context, this.object).toString();
                }
                catch (JumpException e) {
                    // empty catch block
                }
                if (description == null || description.length() > 65) {
                    description = this.object.anyToString().toString();
                }
            }
            if (description.length() == 0 || description.length() > 0 && description.charAt(0) != '#') {
                description = description + ":" + this.object.getMetaClass().getRealClass().getName();
            }
            Ruby runtime = this.getRuntime();
            RubyArray arr = runtime.newArray(this.method, runtime.newString(description));
            RubyString msg = runtime.newString(((Object)Sprintf.sprintf(runtime.newString(format), (IRubyObject)arr)).toString());
            if (this.object.isTaint()) {
                msg.setTaint(true);
            }
            return msg;
        }
    }
}

