/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Jar2Jax {
    public static final int ZIP_BUFFER_SIZE = 0x100000;
    private static boolean ttyMode;
    private static String errorMessage;

    public static void makeJax(String jarFileName, String jaxFileName, String mainClassName, String[] imports) {
        try {
            File jarFile = new File(jarFileName);
            if (!jarFile.exists()) {
                throw new FileNotFoundException(jarFileName);
            }
            File jaxFile = new File(jaxFileName);
            if (ttyMode || jaxFile.exists()) {
                // empty if block
            }
            ZipEntry ze = null;
            byte[] zipBuffer = new byte[0x100000];
            int bytesRead = 0;
            ZipInputStream jarStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(jarFile), 0x200000));
            ZipOutputStream jaxStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(jaxFile), 0x200000));
            while ((ze = jarStream.getNextEntry()) != null) {
                if (ze.getName().equals("META-INF/MANIFEST.MF")) {
                    int thisTime;
                    bytesRead = 0;
                    while ((thisTime = jarStream.read(zipBuffer, bytesRead, 0x100000 - bytesRead)) != -1) {
                        bytesRead += thisTime;
                    }
                    ByteArrayInputStream bais = new ByteArrayInputStream(zipBuffer, 0, bytesRead);
                    BufferedReader jarReader = new BufferedReader(new InputStreamReader(bais));
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    PrintWriter jaxWriter = new PrintWriter(new OutputStreamWriter(baos));
                    String line = null;
                    while ((line = jarReader.readLine()) != null) {
                        line = line.trim();
                        System.out.println("'" + line + "'");
                        if (line.length() == 0) {
                            jaxWriter.println("Main-Class: " + mainClassName);
                            if (imports != null && imports.length > 0) {
                                jaxWriter.print("Class-Path:");
                                int i = 0;
                                while (i < imports.length) {
                                    jaxWriter.print(" " + imports[i]);
                                    ++i;
                                }
                                jaxWriter.println("");
                            }
                            jaxWriter.println("");
                            break;
                        }
                        jaxWriter.println(line);
                    }
                    while ((line = jarReader.readLine()) != null) {
                        jaxWriter.println(line);
                    }
                    jarReader.close();
                    jaxWriter.close();
                    byte[] jaxBuffer = baos.toByteArray();
                    baos.reset();
                    ZipEntry newZE = new ZipEntry(ze.getName());
                    newZE.setComment(ze.getComment());
                    newZE.setMethod(ze.getMethod());
                    CRC32 theCRC = new CRC32();
                    theCRC.update(jaxBuffer);
                    newZE.setCrc(theCRC.getValue());
                    newZE.setExtra(ze.getExtra());
                    newZE.setSize(jaxBuffer.length);
                    jaxStream.putNextEntry(newZE);
                    jaxStream.write(jaxBuffer, 0, jaxBuffer.length);
                    continue;
                }
                jaxStream.putNextEntry(ze);
                while ((bytesRead = jarStream.read(zipBuffer, 0, 0x100000)) != -1) {
                    jaxStream.write(zipBuffer, 0, bytesRead);
                }
            }
            zipBuffer = null;
            jarStream.close();
            jaxStream.close();
        }
        catch (FileNotFoundException e) {
            errorMessage = "JAR file not found: " + jarFileName;
        }
        catch (Exception e) {
            e.printStackTrace();
            errorMessage = e.toString();
        }
    }

    public static String jarToJaxName(String jarName) {
        return Jar2Jax.jarToClassName(jarName) + ".jax";
    }

    public static String jarToClassName(String jarName) {
        String retval = jarName;
        int ind = retval.lastIndexOf(File.separator);
        if (ind > -1) {
            retval = retval.substring(ind + 1, retval.length());
        }
        if ((ind = retval.lastIndexOf(".")) > -1) {
            retval = retval.substring(0, ind);
        }
        return retval;
    }

    public static String jarToPathName(String jarName) {
        String retval = jarName;
        int ind = retval.lastIndexOf(File.separator);
        retval = ind > -1 ? retval.substring(0, ind + 1) : "";
        return retval;
    }

    public static void main(String[] args) {
        String jarFileName = null;
        String jaxFileName = null;
        String mainClassName = null;
        String[] includes = null;
        Frame aFrame = null;
        if (args.length == 0) {
            aFrame = new Frame("Jar2Jax");
            ((Component)aFrame).setSize(500, 100);
            aFrame.show();
            FileDialog fd = new FileDialog(aFrame, "Select JAR file to convert:");
            fd.show();
            if (fd.getDirectory() == null || fd.getFile() == null) {
                System.exit(1);
            }
            String dir = fd.getDirectory();
            jarFileName = fd.getDirectory() + fd.getFile();
            fd.dispose();
            fd = new FileDialog(aFrame, "Save JAX file as:", 1);
            fd.setDirectory(dir);
            fd.setFile(Jar2Jax.jarToJaxName(jarFileName));
            fd.show();
            if (fd.getDirectory() == null || fd.getFile() == null) {
                System.exit(1);
            }
            jaxFileName = fd.getDirectory() + fd.getFile();
            fd.dispose();
            Dialog d = new Dialog(aFrame, "Settings", true);
            ((Component)d).setSize(400, 200);
            d.setLayout(new FlowLayout());
            d.add(new Label("Main-Class:"));
            TextField tf = new TextField(Jar2Jax.jarToClassName(jarFileName), 40);
            d.add(tf);
            d.add(new Label("Class-Path:"));
            Checkbox swingallCheckbox = new Checkbox("swingall.jar");
            d.add(swingallCheckbox);
            Button convertButton = new Button("Convert");
            d.add(convertButton);
            convertButton.addActionListener(new ActionListener(d){
                private final /* synthetic */ Dialog val$d;

                public void actionPerformed(ActionEvent evt) {
                    ((Component)this.val$d).setVisible(false);
                }
                {
                    this.val$d = val$d;
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
            Button cancelButton = new Button("Cancel");
            d.add(cancelButton);
            cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    System.exit(1);
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
            d.show();
            mainClassName = tf.getText();
            if (swingallCheckbox.getState()) {
                includes = new String[]{"swingall.jar"};
            }
            d.dispose();
        } else {
            if (args[0].equalsIgnoreCase("-version")) {
                System.exit(0);
            }
            jarFileName = args[0];
            jaxFileName = args.length >= 2 ? args[1] : Jar2Jax.jarToPathName(jarFileName) + Jar2Jax.jarToJaxName(jarFileName);
            mainClassName = args.length >= 3 ? args[2] : Jar2Jax.jarToClassName(jarFileName);
            if (args.length >= 4) {
                includes = new String[args.length - 3];
                int i = 0;
                while (i < args.length - 3) {
                    includes[i] = args[i + 3];
                    ++i;
                }
            }
        }
        Jar2Jax.makeJax(jarFileName, jaxFileName, mainClassName, includes);
        if (errorMessage != null) {
            System.out.println(errorMessage);
        }
        if (aFrame != null) {
            aFrame.dispose();
        }
        System.exit(0);
    }
}

