/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb.interceptor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mockejb.interceptor.Interceptor;
import org.mockejb.interceptor.InvocationContext;
import org.mockejb.interceptor.RegexpWrapper;

public class InvocationRecorder
implements Interceptor {
    private List invocationContextList = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intercept(InvocationContext invocationContext) throws Exception {
        Object thrownException = null;
        Object returnObj = null;
        try {
            invocationContext.proceed();
        }
        finally {
            this.invocationContextList.add(invocationContext);
        }
    }

    public List getMethodInvocationList() {
        return this.invocationContextList;
    }

    public boolean hasRecords() {
        return !this.invocationContextList.isEmpty();
    }

    public void clear() {
        this.invocationContextList.clear();
    }

    public InvocationContext findByTargetMethod(String methodPattern) {
        RegexpWrapper regexp = new RegexpWrapper(methodPattern);
        Iterator i = this.invocationContextList.iterator();
        while (i.hasNext()) {
            InvocationContext invocation = (InvocationContext)i.next();
            if (!regexp.containedInString(invocation.getTargetMethod().toString())) continue;
            return invocation;
        }
        return null;
    }

    public InvocationContext findByInterceptedMethod(String methodPattern) {
        return this.findByProxyMethod(methodPattern);
    }

    public InvocationContext findByProxyMethod(String methodPattern) {
        RegexpWrapper regexp = new RegexpWrapper(methodPattern);
        Iterator i = this.invocationContextList.iterator();
        while (i.hasNext()) {
            InvocationContext invocation = (InvocationContext)i.next();
            if (!regexp.containedInString(invocation.getProxyMethod().toString())) continue;
            return invocation;
        }
        return null;
    }

    public String toString() {
        return this.invocationContextList.toString();
    }
}

