/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.storage;

import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolverException;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.implementations.KeyStoreResolver;
import com.sun.org.apache.xml.internal.security.keys.storage.implementations.SingleCertificateResolver;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StorageResolver {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$internal$security$keys$storage$StorageResolver == null ? (class$com$sun$org$apache$xml$internal$security$keys$storage$StorageResolver = StorageResolver.class$("com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver")) : class$com$sun$org$apache$xml$internal$security$keys$storage$StorageResolver).getName());
    List _storageResolvers = new ArrayList();
    Iterator _iterator = null;
    static /* synthetic */ Class class$com$sun$org$apache$xml$internal$security$keys$storage$StorageResolver;

    public StorageResolver() {
    }

    public StorageResolver(StorageResolverSpi storageResolverSpi) {
        this.add(storageResolverSpi);
    }

    public void add(StorageResolverSpi storageResolverSpi) {
        this._storageResolvers.add(storageResolverSpi);
        this._iterator = null;
    }

    public StorageResolver(KeyStore keyStore) {
        this.add(keyStore);
    }

    public void add(KeyStore keyStore) {
        try {
            this.add(new KeyStoreResolver(keyStore));
        }
        catch (StorageResolverException storageResolverException) {
            log.log(Level.SEVERE, "Could not add KeyStore because of: ", storageResolverException);
        }
    }

    public StorageResolver(X509Certificate x509Certificate) {
        this.add(x509Certificate);
    }

    public void add(X509Certificate x509Certificate) {
        this.add(new SingleCertificateResolver(x509Certificate));
    }

    public Iterator getIterator() {
        if (this._iterator == null) {
            this._iterator = new StorageResolverIterator(this._storageResolvers.iterator());
        }
        return this._iterator;
    }

    public boolean hasNext() {
        if (this._iterator == null) {
            this._iterator = new StorageResolverIterator(this._storageResolvers.iterator());
        }
        return this._iterator.hasNext();
    }

    public X509Certificate next() {
        return (X509Certificate)this._iterator.next();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class StorageResolverIterator
    implements Iterator {
        Iterator _resolvers = null;
        int _currentResolver = 0;

        public StorageResolverIterator(Iterator iterator) {
            this._resolvers = iterator;
        }

        public boolean hasNext() {
            return this._resolvers.hasNext();
        }

        public Object next() {
            return this._resolvers.next();
        }

        public void remove() {
            throw new UnsupportedOperationException("Can't remove keys from KeyStore");
        }
    }
}

