/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import netscape.ldap.LDAPBind;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPRebind;

public class LDAPSearchConstraints
extends LDAPConstraints
implements Cloneable {
    public static final int REFERRAL_ERROR_CONTINUE = 0;
    public static final int REFERRAL_ERROR_EXCEPTION = 1;
    private int deref;
    private int maxRes;
    private int batch;
    private int serverTimeLimit;
    private int maxBacklog = 100;
    private int referralErrors = 0;

    public LDAPSearchConstraints() {
        this.deref = 0;
        this.maxRes = 1000;
        this.batch = 1;
        this.serverTimeLimit = 0;
    }

    public LDAPSearchConstraints(int n, int n2, int n3, boolean bl, int n4, LDAPRebind lDAPRebind, int n5) {
        super(n, bl, lDAPRebind, n5);
        this.deref = n2;
        this.maxRes = n3;
        this.batch = n4;
    }

    public LDAPSearchConstraints(int n, int n2, int n3, int n4, boolean bl, int n5, LDAPRebind lDAPRebind, int n6) {
        super(n, bl, lDAPRebind, n6);
        this.serverTimeLimit = n2;
        this.deref = n3;
        this.maxRes = n4;
        this.batch = n5;
    }

    public LDAPSearchConstraints(int n, int n2, int n3, int n4, boolean bl, int n5, LDAPBind lDAPBind, int n6) {
        super(n, bl, lDAPBind, n6);
        this.serverTimeLimit = n2;
        this.deref = n3;
        this.maxRes = n4;
        this.batch = n5;
    }

    public int getServerTimeLimit() {
        return this.serverTimeLimit;
    }

    public int getDereference() {
        return this.deref;
    }

    public int getMaxResults() {
        return this.maxRes;
    }

    public int getBatchSize() {
        return this.batch;
    }

    public void setServerTimeLimit(int n) {
        this.serverTimeLimit = n;
    }

    public void setDereference(int n) {
        this.deref = n;
    }

    public void setMaxResults(int n) {
        this.maxRes = n;
    }

    public void setBatchSize(int n) {
        this.batch = n;
    }

    public void setMaxBacklog(int n) {
        this.maxBacklog = n;
    }

    public int getMaxBacklog() {
        return this.maxBacklog;
    }

    public int getReferralErrors() {
        return this.referralErrors;
    }

    public void setReferralErrors(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid error behavior: " + n);
        }
        this.referralErrors = n;
    }

    public Object clone() {
        LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)super.clone();
        return lDAPSearchConstraints;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("LDAPSearchConstraints {");
        stringBuffer.append(super.toString() + ' ');
        stringBuffer.append("size limit " + this.maxRes + ", ");
        stringBuffer.append("server time limit " + this.serverTimeLimit + ", ");
        stringBuffer.append("aliases " + this.deref + ", ");
        stringBuffer.append("batch size " + this.batch + ", ");
        stringBuffer.append("max backlog " + this.maxBacklog + ", ");
        stringBuffer.append("referralErrors " + this.referralErrors);
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

