/*
 * Decompiled with CFR 0.152.
 */
package com.sun.liberty;

import com.sun.identity.cot.COTException;
import com.sun.identity.cot.CircleOfTrustDescriptor;
import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.jaxb.entityconfig.SPDescriptorConfigElement;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSNameIdentifierMappingRequest;
import com.sun.identity.federation.message.FSNameIdentifierMappingResponse;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.FSLoginHelper;
import com.sun.identity.federation.services.FSLoginHelperException;
import com.sun.identity.federation.services.FSSOAPService;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.FSSessionPartner;
import com.sun.identity.federation.services.namemapping.FSNameMappingHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.liberty.ws.meta.jaxb.IDPDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.ProviderDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.SPDescriptorType;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.URLEncDec;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LibertyManager {
    static Debug debug = null;
    private static IDFFMetaManager metaManager = null;

    public static Iterator getIDPList() {
        return LibertyManager.getAllIDPList("/");
    }

    public static Iterator getAllIDPList(String realm) {
        HashSet idpList = new HashSet();
        try {
            if (metaManager != null) {
                idpList.addAll(metaManager.getAllHostedIdentityProviderIDs(realm));
                idpList.addAll(metaManager.getAllRemoteIdentityProviderIDs(realm));
            }
        }
        catch (IDFFMetaException ame) {
            debug.error("LibertyManager: getAllIDPList: Error while getting  Active ProviderIds  ", ame);
        }
        return idpList.iterator();
    }

    public static Iterator getIDPList(String hostedEntityID) {
        return LibertyManager.getList("/", hostedEntityID, "SP", "IDP");
    }

    public static Iterator getIDPList(String realm, String hostedEntityID) {
        return LibertyManager.getList(realm, hostedEntityID, "SP", "IDP");
    }

    public static Iterator getSPList() {
        return LibertyManager.getSPList("/");
    }

    public static Iterator getAllSPList(String realm) {
        HashSet spList = new HashSet();
        try {
            if (metaManager != null) {
                spList.addAll(metaManager.getAllHostedServiceProviderEntities(realm));
                spList.addAll(metaManager.getAllRemoteServiceProviderEntities(realm));
            }
        }
        catch (IDFFMetaException ame) {
            debug.error("LibertyManager: getAllSPList: Error while getting  Active ProviderIds  ", ame);
        }
        return spList.iterator();
    }

    public static Iterator getSPList(String hostedEntityID) {
        return LibertyManager.getList("/", hostedEntityID, "IDP", "SP");
    }

    public static Iterator getSPList(String realm, String hostedEntityID) {
        return LibertyManager.getList(realm, hostedEntityID, "IDP", "SP");
    }

    public static boolean getIDPFederationStatus(String user, String remoteEntityId, String hostedEntityId, String hostedProviderRole) {
        return LibertyManager.getIDPFederationStatus(user, "/", remoteEntityId, hostedEntityId, hostedProviderRole);
    }

    public static boolean getIDPFederationStatus(String user, String realm, String remoteEntityId, String hostedEntityId, String hostedProviderRole) {
        boolean result = false;
        if (user == null || remoteEntityId == null || hostedEntityId == null || hostedProviderRole == null) {
            debug.error("LibertyManager.getIDPFederationStatus:: null input  parameters.");
            return result;
        }
        try {
            result = FSAccountManager.getInstance((String)LibertyManager.getMetaAlias(realm, hostedEntityId, hostedProviderRole)).isFederationActive(user, remoteEntityId);
        }
        catch (FSAccountMgmtException ame) {
            debug.error("LibertyManager: getIDPFederationStatus: Couldnot get Federation Status ", ame);
        }
        return result;
    }

    public static boolean getSPFederationStatus(String user, String remoteProviderId, String hostedProviderId, String hostedProviderRole) {
        return LibertyManager.getSPFederationStatus(user, "/", remoteProviderId, hostedProviderId, hostedProviderRole);
    }

    public static boolean getSPFederationStatus(String user, String realm, String remoteProviderId, String hostedProviderId, String hostedProviderRole) {
        boolean result = false;
        if (user == null || remoteProviderId == null || hostedProviderId == null || hostedProviderRole == null) {
            FSUtils.debug.error("LibertyManager.getSPFederationStatus::  null input parameters.");
            return result;
        }
        try {
            result = FSAccountManager.getInstance((String)LibertyManager.getMetaAlias(realm, hostedProviderId, hostedProviderRole)).isFederationActive(user, remoteProviderId);
        }
        catch (FSAccountMgmtException ame) {
            debug.error("LibertyManager: getIDPFederationStatus: Couldnot get Federation Status ", ame);
        }
        return result;
    }

    public static String getNonce(String user) {
        Random random = new Random();
        long l = random.nextLong();
        String nonce = String.valueOf(l);
        return nonce;
    }

    public static boolean checkNonce(String nonce, String user) {
        return true;
    }

    public static String getIntroducedProvider(HttpServletRequest request) {
        String provider = request.getParameter("_liberty_idp");
        return provider;
    }

    private static Iterator getList(String realm, String entityID, String providerRole, String remoteProviderRole) {
        HashSet trustedProviders = null;
        BaseConfigType providerConfig = IDFFMetaUtils.getExtendedConfig(realm, entityID, providerRole, metaManager);
        if (providerConfig != null) {
            trustedProviders = metaManager.getAllTrustedProviders(providerConfig.getMetaAlias());
        }
        if (trustedProviders == null) {
            trustedProviders = new HashSet();
        }
        return trustedProviders.iterator();
    }

    public static String getMetaAliasKey() {
        return "metaAlias";
    }

    public static String getTerminationProviderIDKey() {
        return "_liberty_id";
    }

    public static String getRequestIDKey() {
        return "RequestID";
    }

    public static String getProviderIDKey() {
        return "_liberty_idp";
    }

    public static String getLRURLKey() {
        return "RelayState";
    }

    public static String getCOTKey() {
        return "cotkey";
    }

    public static String getSelectedProviderKey() {
        return "selectedprovider";
    }

    public static String getFedErrorKey() {
        return "federror";
    }

    public static String getFedRemarkKey() {
        return "fedremark";
    }

    public static String getUser(HttpServletRequest request) {
        Object ssoToken = null;
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            ssoToken = sessionProvider.getSession(request);
            if (ssoToken != null && sessionProvider.isValid(ssoToken)) {
                debug.message("LibertyManager: getUser: token is valid");
                return sessionProvider.getPrincipalName(ssoToken);
            }
            return null;
        }
        catch (SessionException ssoe) {
            debug.error("LibertyManager: getUser: SessionException: ", ssoe);
            return null;
        }
    }

    public static String getHomeURL(String providerID, String providerRole) {
        return LibertyManager.getHomeURL("/", providerID, providerRole);
    }

    public static String getHomeURL(String realm, String providerID, String providerRole) {
        String homeURL = null;
        BaseConfigType config = IDFFMetaUtils.getExtendedConfig(realm, providerID, providerRole, metaManager);
        if (config != null) {
            homeURL = IDFFMetaUtils.getFirstAttributeValue(IDFFMetaUtils.getAttributes(config), "providerHomePageURL");
        }
        return homeURL;
    }

    public static String getPreLoginServletURL(String providerID, String providerRole, HttpServletRequest request) {
        return LibertyManager.getPreLoginServletURL("/", providerID, providerRole, request);
    }

    public static String getPreLoginServletURL(String realm, String providerID, String providerRole, HttpServletRequest request) {
        String metaAlias = LibertyManager.getMetaAlias(realm, providerID, providerRole);
        String baseURL = FSServiceUtils.getServicesBaseURL(request);
        return baseURL + "/preLogin" + "?" + "metaAlias" + "=" + metaAlias;
    }

    public static String getLoginURL(HttpServletRequest request) {
        String returnURL = FSServiceUtils.getServicesBaseURL(request) + "/UI/Login" + "?" + "arg" + "=" + "newsession";
        if (debug.messageEnabled()) {
            debug.message("LibertyManager: getLoginURL:  returnURL = " + returnURL);
        }
        return returnURL;
    }

    public static String getInterSiteURL(HttpServletRequest request) {
        String returnURL = FSServiceUtils.getServicesBaseURL(request) + "/" + "IntersiteTransferService";
        if (debug.messageEnabled()) {
            debug.message("LibertyManager::getInterSiteURL:: returnURL = " + returnURL);
        }
        return returnURL;
    }

    public static String getEntityID(String metaAlias) {
        try {
            if (metaManager == null) {
                debug.error("LibertyManager: getEntityID: meta manager isnull");
                return null;
            }
            return metaManager.getEntityIDByMetaAlias(metaAlias);
        }
        catch (IDFFMetaException ame) {
            debug.error("LibertyManager: getEntityID: Error getting ID", ame);
            return null;
        }
    }

    public static Set getProvidersToFederate(String providerID, String providerRole, String userName) {
        return LibertyManager.getProvidersToFederate("/", providerID, providerRole, userName);
    }

    public static Set getProvidersToFederate(String realm, String providerID, String providerRole, String userName) {
        HashSet<String> unFederatedIDPs = new HashSet<String>();
        if (providerID == null || providerRole == null || userName == null) {
            debug.error("LibertyManager.getProvidersToFederate:: null parameter values");
            return unFederatedIDPs;
        }
        if (!providerRole.equals("SP") && !providerRole.equals("IDP")) {
            debug.error("LibertyManager.getProvidersToFederate:: Invalid ProviderRole.");
            return unFederatedIDPs;
        }
        Iterator idpList = LibertyManager.getIDPList(realm, providerID);
        Set alreadyFederatedProviders = null;
        try {
            alreadyFederatedProviders = FSAccountManager.getInstance((String)LibertyManager.getMetaAlias(realm, providerID, providerRole)).readAllFederatedProviderID(providerID, userName);
            String idp = null;
            while (idpList.hasNext()) {
                idp = (String)idpList.next();
                if (alreadyFederatedProviders.contains(idp)) continue;
                unFederatedIDPs.add(idp);
            }
        }
        catch (FSAccountMgmtException ame) {
            debug.error("LibertyManager: getUnFederatedIDPList: Error while  getting allFederatedProviderID from Account Mgmt", ame);
        }
        return unFederatedIDPs;
    }

    public static Set getFederatedProviders(String userName, String hostProviderId, String hostProviderRole) {
        return LibertyManager.getFederatedProviders(userName, "/", hostProviderId, hostProviderRole);
    }

    public static Set getFederatedProviders(String userName, String realm, String hostProviderId, String hostProviderRole) {
        Set federatedProviders = new HashSet();
        try {
            federatedProviders = FSAccountManager.getInstance((String)LibertyManager.getMetaAlias(realm, hostProviderId, hostProviderRole)).readAllFederatedProviderID(userName);
        }
        catch (FSAccountMgmtException ame) {
            debug.error("LibertyManager: getFederatedProviders: Error while  getting federatedProviderIDs from Account Mgmt", ame);
        }
        return federatedProviders;
    }

    public static Set getListOfCOTs(String providerId, String providerRole) {
        return LibertyManager.getListOfCOTs("/", providerId, providerRole);
    }

    public static Set getListOfCOTs(String realm, String providerId, String providerRole) {
        HashSet<String> returnSet = new HashSet<String>();
        BaseConfigType hostConfig = IDFFMetaUtils.getExtendedConfig(realm, providerId, providerRole, metaManager);
        if (hostConfig != null) {
            List cotSet = IDFFMetaUtils.getAttributeValueFromConfig(hostConfig, "cotlist");
            if (cotSet != null && !cotSet.isEmpty()) {
                Iterator iter = cotSet.iterator();
                while (iter.hasNext()) {
                    String cotID = (String)iter.next();
                    try {
                        CircleOfTrustManager cotManager = new CircleOfTrustManager();
                        CircleOfTrustDescriptor cotDesc = cotManager.getCircleOfTrust(realm, cotID);
                        String tldURL = cotDesc.getIDFFWriterServiceURL();
                        String cotStatus = cotDesc.getCircleOfTrustStatus();
                        if (tldURL == null || tldURL.length() <= 0 || !cotStatus.equalsIgnoreCase("active")) continue;
                        returnSet.add(cotID);
                    }
                    catch (COTException fsExp) {
                        debug.error("LibertyManager: getListOfCots COTException caught ", fsExp);
                    }
                }
            }
            if (returnSet != null && returnSet.size() > 0) {
                if (debug.messageEnabled()) {
                    debug.message("LibertyManager: getListOfCots returning  cot set with " + returnSet);
                }
            } else if (debug.messageEnabled()) {
                debug.message("LibertyManager::getListOfCots returning null. Looks like COT is not set");
            }
        }
        return returnSet;
    }

    public static String getMetaAlias(String providerID, String providerRole) {
        return LibertyManager.getMetaAlias(null, providerID, providerRole);
    }

    public static String getMetaAlias(String realm, String providerID, String providerRole) {
        BaseConfigType providerConfig = IDFFMetaUtils.getExtendedConfig(realm, providerID, providerRole, metaManager);
        String metaAlias = "";
        if (providerConfig != null) {
            metaAlias = providerConfig.getMetaAlias();
        }
        if (debug.messageEnabled()) {
            debug.message("LibertyManager: getMetaAlias: providerID is " + providerID + " and corresponding metaAlias is " + metaAlias);
        }
        return metaAlias;
    }

    public static String getFederationDonePageURL(String providerID, String providerRole, HttpServletRequest request) {
        return LibertyManager.getFederationDonePageURL("/", providerID, providerRole, request);
    }

    public static String getFederationDonePageURL(String realm, String providerID, String providerRole, HttpServletRequest request) {
        BaseConfigType providerConfig = IDFFMetaUtils.getExtendedConfig(realm, providerID, providerRole, metaManager);
        String metaAlias = null;
        if (providerConfig != null) {
            metaAlias = providerConfig.getMetaAlias();
        }
        return FSServiceUtils.getFederationDonePageURL(request, providerConfig, metaAlias);
    }

    public static String getTerminationDonePageURL(String providerID, String providerRole, HttpServletRequest request) {
        return LibertyManager.getTerminationDonePageURL("/", providerID, providerRole, request);
    }

    public static String getTerminationDonePageURL(String realm, String providerID, String providerRole, HttpServletRequest request) {
        BaseConfigType providerConfig = IDFFMetaUtils.getExtendedConfig(realm, providerID, providerRole, metaManager);
        String metaAlias = null;
        if (providerConfig != null) {
            metaAlias = providerConfig.getMetaAlias();
        }
        return FSServiceUtils.getTerminationDonePageURL(request, providerConfig, metaAlias);
    }

    public static String getTerminationURL(String providerID, String providerRole, HttpServletRequest request) {
        return LibertyManager.getTerminationURL("/", providerID, providerRole, request);
    }

    public static String getTerminationURL(String realm, String providerID, String providerRole, HttpServletRequest request) {
        String metaAlias = LibertyManager.getMetaAlias(realm, providerID, providerRole);
        String baseURL = FSServiceUtils.getServicesBaseURL(request);
        return baseURL + "/federation-terminate" + "?" + "metaAlias" + "=" + metaAlias;
    }

    public static String getNameRegistrationURL(String providerID, String providerRole, HttpServletRequest request) {
        return LibertyManager.getNameRegistrationURL("/", providerID, providerRole, request);
    }

    public static String getNameRegistrationURL(String realm, String providerID, String providerRole, HttpServletRequest request) {
        String metaAlias = LibertyManager.getMetaAlias(realm, providerID, providerRole);
        String baseURL = FSServiceUtils.getServicesBaseURL(request);
        return baseURL + "/InitiateRegistration" + "?" + "metaAlias" + "=" + metaAlias;
    }

    public static String getErrorPageURL(String providerId, String providerRole, HttpServletRequest request) {
        return LibertyManager.getErrorPageURL("/", providerId, providerRole, request);
    }

    public static String getErrorPageURL(String realm, String providerId, String providerRole, HttpServletRequest request) {
        BaseConfigType providerConfig = IDFFMetaUtils.getExtendedConfig(realm, providerId, providerRole, metaManager);
        String metaAlias = null;
        if (providerConfig != null) {
            metaAlias = providerConfig.getMetaAlias();
        }
        return FSServiceUtils.getErrorPageURL(request, providerConfig, metaAlias);
    }

    public static String getFederationHandlerURL(HttpServletRequest request) {
        String returnURL = FSServiceUtils.getServicesBaseURL(request) + "/" + "federation";
        if (debug.messageEnabled()) {
            debug.message("LibertyManager: getFederationHandler: returnURL = " + returnURL);
        }
        return returnURL;
    }

    public static String getConsentHandlerURL(HttpServletRequest request) {
        String returnURL = FSServiceUtils.getServicesBaseURL(request) + "/" + "consentHandler";
        if (debug.messageEnabled()) {
            debug.message("LibertyManager: getConsentHandler: returnURL = " + returnURL);
        }
        return returnURL;
    }

    public static boolean isLogoutSuccess(HttpServletRequest request) {
        String status = request.getParameter("logoutStatus");
        return status == null || status.equalsIgnoreCase("logoutSuccess");
    }

    public static boolean isTerminationSuccess(HttpServletRequest request) {
        String status = request.getParameter("termStatus");
        return status == null || status.equalsIgnoreCase("termSuccess");
    }

    public static boolean isFederationCancelled(HttpServletRequest request) {
        String status = request.getParameter("termStatus");
        return status != null && status.equalsIgnoreCase("cancel");
    }

    public static boolean isTerminationCancelled(HttpServletRequest request) {
        String status = request.getParameter("termStatus");
        return status != null && status.equalsIgnoreCase("cancel");
    }

    public static String getRealmByMetaAlias(String metaAlias) {
        return IDFFMetaUtils.getRealmByMetaAlias(metaAlias);
    }

    public static String getNewRequest(HttpServletRequest request) {
        String targetURL = request.getParameter("RelayState");
        String metaAlias = request.getParameter("metaAlias");
        String entityID = LibertyManager.getEntityID(metaAlias);
        String realm = IDFFMetaUtils.getRealmByMetaAlias(metaAlias);
        Map headerMap = LibertyManager.getHeaderMap(request);
        String homePage = null;
        if (targetURL == null || targetURL.length() <= 0) {
            try {
                if (metaManager != null) {
                    SPDescriptorConfigElement providerConfig = metaManager.getSPDescriptorConfig(realm, entityID);
                    homePage = IDFFMetaUtils.getFirstAttributeValue(IDFFMetaUtils.getAttributes(providerConfig), "providerHomePageURL");
                }
            }
            catch (IDFFMetaException ame) {
                debug.error("LibertyManager: getNewRequest: Error while getting the HostedProvider from meta mgmt", ame);
            }
            if (debug.messageEnabled()) {
                debug.message("LibertyManager: getNewRequestID. no goto in queryString.Assinging targetURL = " + homePage);
            }
            targetURL = homePage;
        }
        try {
            FSLoginHelper loginHelper = new FSLoginHelper(request);
            HttpSession httpSession = request.getSession();
            String authLevel = (String)httpSession.getAttribute("authlevel");
            Map retMap = loginHelper.createAuthnRequest(headerMap, targetURL, authLevel, metaAlias, null, true);
            if (retMap != null) {
                String reqID = (String)retMap.get("RequestID");
                if (debug.messageEnabled()) {
                    debug.message("LibertyManager: getNewRequestID: new request created with id " + reqID);
                }
                return reqID;
            }
            debug.error("LibertyManager: getNewRequestID  Could not create new request ");
            return null;
        }
        catch (FSLoginHelperException exp) {
            debug.error("LibertyManager::getNewRequestIDIn login helper exception ", exp);
            return null;
        }
    }

    public static boolean setAuthnRequest(FSAuthnRequest request, String entityID) {
        return LibertyManager.setAuthnRequest(request, "/", entityID);
    }

    public static boolean setAuthnRequest(FSAuthnRequest request, String realm, String entityID) {
        if (request == null || entityID == null) {
            debug.message("LibertyManager.setAuthnRequest: null Input params");
            return false;
        }
        try {
            FSSessionManager sessionManager = FSSessionManager.getInstance((String)LibertyManager.getMetaAlias(realm, entityID, "SP"));
            String requestID = request.getRequestID();
            if (requestID != null) {
                sessionManager.setAuthnRequest(requestID, request);
                return true;
            }
        }
        catch (Exception ex) {
            FSUtils.debug.error("LibertyManager.setAuthnRequest Exception while setting authn request.", ex);
        }
        return false;
    }

    private static Map getHeaderMap(HttpServletRequest request) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String hn = headerNames.nextElement().toString();
            String hv = request.getHeader(hn);
            headerMap.put(hn, hv);
        }
        return headerMap;
    }

    public static String cleanQueryString(HttpServletRequest request) {
        Enumeration paramEnum = request.getParameterNames();
        String returnString = new String();
        while (paramEnum.hasMoreElements()) {
            String paramKey = (String)paramEnum.nextElement();
            if (paramKey.equalsIgnoreCase("metaAlias") || paramKey.equalsIgnoreCase("RequestID") || paramKey.equalsIgnoreCase("RelayState")) {
                if (!debug.messageEnabled()) continue;
                debug.message("Libertymanager::cleanQueryString  found metaAlias or LRURL or AUTH_REQUEST_ID.");
                continue;
            }
            if (paramKey.equals("SAMLart")) continue;
            String paramValue = request.getParameter(paramKey);
            if (returnString == null || returnString.length() < 1) {
                returnString = paramKey + "=" + URLEncDec.encode(paramValue);
                continue;
            }
            returnString = returnString + "&amp;" + paramKey + "=" + URLEncDec.encode(paramValue);
        }
        HttpSession httpSession = request.getSession();
        String authLevel = (String)httpSession.getAttribute("authlevel");
        if (authLevel != null) {
            returnString = returnString == null || returnString.length() < 1 ? "authlevel=" + authLevel : returnString + "&amp;" + "authlevel" + "=" + authLevel;
        }
        if (debug.messageEnabled()) {
            debug.message("Libertymanager::cleanQueryString  returning with " + returnString);
        }
        return returnString;
    }

    public static String getSuccinctID(String entityID) {
        return FSUtils.generateSourceID(entityID);
    }

    public static String getSuccinctID(String providerID, String providerRole) {
        return FSUtils.generateSourceID(providerID);
    }

    public static Set getRegisteredProviders(String userName, String hostProviderId, String providerRole) {
        return LibertyManager.getRegisteredProviders(userName, "/", hostProviderId, providerRole);
    }

    public static Set getRegisteredProviders(String userName, String realm, String hostProviderId, String providerRole) {
        Set registeredProviders = new HashSet();
        try {
            registeredProviders = FSAccountManager.getInstance((String)LibertyManager.getMetaAlias(realm, hostProviderId, providerRole)).readAllFederatedProviderID(userName);
        }
        catch (FSAccountMgmtException ame) {
            debug.error("LibertyManager: getRegisteredProviders: Error while  getting federatedProviderIDs from Account Mgmt", ame);
        }
        return registeredProviders;
    }

    public static String getNameRegistrationProviderIDKey() {
        return "_liberty_id";
    }

    public static boolean isNameRegistrationCancelled(HttpServletRequest request) {
        String status = request.getParameter("regisStatus");
        return status != null && status.equalsIgnoreCase("cancel");
    }

    public static boolean isNameRegistrationSuccess(HttpServletRequest request) {
        String status = request.getParameter("regisStatus");
        return status != null && status.equalsIgnoreCase("regisSuccess");
    }

    public static String getNameRegistrationDonePageURL(String providerID, String providerRole, HttpServletRequest request) {
        return LibertyManager.getNameRegistrationDonePageURL("/", providerID, providerRole, request);
    }

    public static String getNameRegistrationDonePageURL(String realm, String providerID, String providerRole, HttpServletRequest request) {
        BaseConfigType extendedConfig = IDFFMetaUtils.getExtendedConfig(realm, providerID, providerRole, metaManager);
        String metaAlias = null;
        if (extendedConfig != null) {
            metaAlias = extendedConfig.getMetaAlias();
        }
        return FSServiceUtils.getRegistrationDonePageURL(request, extendedConfig, metaAlias);
    }

    public static String getAuthnRequestEnvelope(HttpServletRequest request) {
        FSLoginHelper loginHelper = new FSLoginHelper(request);
        return loginHelper.createAuthnRequestEnvelope(request);
    }

    public static boolean isLECPProfile(HttpServletRequest request) {
        return FSServiceUtils.isLECPProfile(request);
    }

    public static String getLECPHeaderName() {
        return "Liberty-Enabled";
    }

    public static String getLECPContentType() {
        return "application/vnd.liberty-request+xml";
    }

    public static NodeList getDiscoveryBootStrapResourceOfferings(HttpServletRequest request, String providerID) {
        if (request == null || providerID == null) {
            if (debug.messageEnabled()) {
                debug.message("LibertyManager.getDiscoveryResourceOffering: null Input params");
            }
            return null;
        }
        try {
            Object token = SessionManager.getProvider().getSession(request);
            FSSessionManager sessionManager = FSSessionManager.getInstance((String)LibertyManager.getMetaAlias("/", providerID, "SP"));
            FSSession session = sessionManager.getSession(token);
            if (session == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("LibertyManager.getDiscoveryResourceOfferings: Theres no liberty session for this token");
                }
                return null;
            }
            return session.getBootStrapResourceOfferings();
        }
        catch (Exception ex) {
            FSUtils.debug.error("LibertyManager.getDiscoveryResourceOfferings Exception while retrieving discovery boot strap info.", ex);
            return null;
        }
    }

    public static NodeList getDiscoveryBootStrapResourceOfferings(HttpServletRequest request, String providerID, String providerRole) {
        if (request == null || providerID == null) {
            if (debug.messageEnabled()) {
                debug.message("LibertyManager.getDiscoveryResourceOffering: null Input params");
            }
            return null;
        }
        try {
            Object token = SessionManager.getProvider().getSession(request);
            FSSessionManager sessionManager = FSSessionManager.getInstance((String)LibertyManager.getMetaAlias("/", providerID, "SP"));
            FSSession session = sessionManager.getSession(token);
            if (session == null) {
                if (debug.messageEnabled()) {
                    debug.message("LibertyManager.getDiscoveryResourceOfferings: Theres no liberty session for this token");
                }
                return null;
            }
            return session.getBootStrapResourceOfferings();
        }
        catch (Exception ex) {
            FSUtils.debug.error("LibertyManager.getDiscoveryResourceOfferings Exception while retrieving discovery boot strap info.", ex);
            return null;
        }
    }

    public static List getDiscoveryBootStrapCredentials(HttpServletRequest request, String providerID) {
        if (request == null || providerID == null) {
            if (debug.messageEnabled()) {
                debug.message("LibertyManager.getDiscoveryCredentials: null Input params");
            }
            return null;
        }
        try {
            Object token = SessionManager.getProvider().getSession(request);
            FSSessionManager sessionManager = FSSessionManager.getInstance((String)LibertyManager.getMetaAlias("/", providerID, "SP"));
            FSSession session = sessionManager.getSession(token);
            if (session == null) {
                if (debug.messageEnabled()) {
                    debug.message("LibertyManager.getDiscoveryCredentials: Theres no liberty session for this token");
                }
                return null;
            }
            return session.getBootStrapCredential();
        }
        catch (Exception ex) {
            FSUtils.debug.error("LibertyManager.getDiscoveryCredentials Exception while retrieving discovery boot strap info.", ex);
            return null;
        }
    }

    public static List getDiscoveryBootStrapCredentials(HttpServletRequest request, String providerID, String providerRole) {
        if (request == null || providerID == null) {
            if (debug.messageEnabled()) {
                debug.message("LibertyManager.getDiscoveryCredentials: null Input params");
            }
            return null;
        }
        try {
            Object token = SessionManager.getProvider().getSession(request);
            FSSessionManager sessionManager = FSSessionManager.getInstance((String)LibertyManager.getMetaAlias("/", providerID, "SP"));
            FSSession session = sessionManager.getSession(token);
            if (session == null) {
                if (debug.messageEnabled()) {
                    debug.message("LibertyManager.getDiscoveryCredentials: Theres no liberty session for this token");
                }
                return null;
            }
            return session.getBootStrapCredential();
        }
        catch (Exception ex) {
            FSUtils.debug.error("LibertyManager.getDiscoveryCredentials Exception while retrieving discovery boot strap info.", ex);
            return null;
        }
    }

    public static String getAuthnContext(HttpServletRequest request, String entityID) {
        return LibertyManager.getAuthnContext(request, "/", entityID);
    }

    public static String getAuthnContext(HttpServletRequest request, String realm, String entityID) {
        if (request == null || entityID == null) {
            debug.message("LibertyManager.getAuthnContext: null Input params");
            return null;
        }
        try {
            Object token = SessionManager.getProvider().getSession(request);
            FSSessionManager sessionManager = FSSessionManager.getInstance((String)LibertyManager.getMetaAlias(realm, entityID, "SP"));
            FSSession session = sessionManager.getSession(token);
            if (session == null) {
                if (debug.messageEnabled()) {
                    debug.message("LibertyManager.getAuthnContext: There is no liberty session for this token");
                }
                return null;
            }
            return session.getAuthnContext();
        }
        catch (Exception ex) {
            FSUtils.debug.error("LibertyManager.getAuthnContext Exception while retrieving authncontext.", ex);
            return null;
        }
    }

    public static FSAccountFedInfo getAccountFedInfo(HttpServletRequest request, String entityID) {
        return LibertyManager.getAccountFedInfo(request, "/", entityID, "SP");
    }

    public static FSAccountFedInfo getAccountFedInfo(HttpServletRequest request, String realm, String entityID, String providerRole) {
        if (request == null || entityID == null) {
            debug.message("LibertyManager.getAccountFedInfo: null Input params");
            return null;
        }
        try {
            Object token = SessionManager.getProvider().getSession(request);
            FSSessionManager sessionManager = FSSessionManager.getInstance((String)LibertyManager.getMetaAlias(realm, entityID, providerRole));
            FSSession session = sessionManager.getSession(token);
            if (session == null) {
                if (debug.messageEnabled()) {
                    debug.message("LibertyManager.getAccountFedInfo: Theres no liberty session for this token");
                }
                return null;
            }
            return session.getAccountFedInfo();
        }
        catch (Exception ex) {
            FSUtils.debug.error("LibertyManager.getAccountFedInfo Exception while retrieving federation info.", ex);
            return null;
        }
    }

    public static String getProviderRole(String metaAlias) {
        try {
            if (metaManager == null) {
                return null;
            }
            return metaManager.getProviderRoleByMetaAlias(metaAlias);
        }
        catch (IDFFMetaException ame) {
            debug.error("LibertyManager: getProviderRole: Error getting Provider Role", ame);
            return null;
        }
    }

    public static NameIdentifier getMappedNameIdentifier(String hostedSPMetaAlias, Object ssoToken, String remoteSPEntityID) {
        String classMethod = "LibertyManager.getMappedNameIdentifier: ";
        String hostedEntityID = LibertyManager.getEntityID(hostedSPMetaAlias);
        String realm = IDFFMetaUtils.getRealmByMetaAlias(hostedSPMetaAlias);
        if (debug.messageEnabled()) {
            debug.message("NameMappingRequester: hostedEntityID=" + hostedEntityID);
        }
        SPDescriptorType hostedDescriptor = null;
        SPDescriptorConfigElement hostedConfig = null;
        try {
            hostedDescriptor = metaManager.getSPDescriptor(realm, hostedEntityID);
            hostedConfig = metaManager.getSPDescriptorConfig(realm, hostedEntityID);
        }
        catch (IDFFMetaException ie) {
            debug.error(classMethod + "couldn't obtain hosted meta:", ie);
            return null;
        }
        String userID = null;
        try {
            userID = SessionManager.getProvider().getPrincipalName(ssoToken);
        }
        catch (SessionException ssoe) {
            debug.error("SessionException caught when trying to get user DN from session token:", ssoe);
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message(classMethod + "userID=" + userID);
        }
        FSNameMappingHandler handler = new FSNameMappingHandler(hostedEntityID, (ProviderDescriptorType)hostedDescriptor, (BaseConfigType)hostedConfig, hostedSPMetaAlias);
        NameIdentifier ni = null;
        if (debug.messageEnabled()) {
            debug.message(classMethod + "targetNamespace (remoteSPEntityID)=" + remoteSPEntityID);
        }
        FSSessionManager sMgr = FSSessionManager.getInstance((String)hostedSPMetaAlias);
        FSSession sess = null;
        if (sMgr != null) {
            sess = sMgr.getSession(ssoToken);
        }
        FSSessionPartner partner = null;
        if (sess == null) {
            debug.error(classMethod + "session is null");
            return null;
        }
        partner = sess.getCurrentSessionPartner();
        String remoteIDPEntityID = null;
        if (partner != null) {
            remoteIDPEntityID = partner.getPartner();
        }
        if (debug.messageEnabled()) {
            debug.message(classMethod + "Remote IDP EntityID = " + remoteIDPEntityID);
        }
        try {
            ni = handler.getNameIdentifier(userID, remoteIDPEntityID, true);
        }
        catch (Exception e) {
            debug.error(classMethod + "Exception caught when trying to get Name " + "Identifier between local SP and remote IDP: ", e);
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message(classMethod + "Name Identifier between local SP and " + " remote IDP: " + ni.toString());
        }
        FSNameIdentifierMappingRequest mappingRequest = null;
        try {
            mappingRequest = new FSNameIdentifierMappingRequest(hostedEntityID, ni, remoteSPEntityID);
        }
        catch (FSMsgException fe) {
            debug.error(classMethod, fe);
            return null;
        }
        if (FSServiceUtils.isSigningOn()) {
            try {
                mappingRequest.signXML(IDFFMetaUtils.getFirstAttributeValueFromConfig(hostedConfig, "signingCertAlias"));
            }
            catch (SAMLException se) {
                debug.error(classMethod, se);
                return null;
            }
        }
        IDPDescriptorType remoteProviderDesc = null;
        try {
            remoteProviderDesc = metaManager.getIDPDescriptor(realm, remoteIDPEntityID);
        }
        catch (IDFFMetaException fme1) {
            debug.error(classMethod, fme1);
            return null;
        }
        String remoteSOAPEndPoint = remoteProviderDesc.getSoapEndpoint();
        if (debug.messageEnabled()) {
            debug.message(classMethod + "IDP's soap end point=" + remoteSOAPEndPoint);
        }
        FSSOAPService soapService = FSSOAPService.getInstance();
        SOAPMessage returnMsg = null;
        try {
            SOAPMessage msg = soapService.bind(mappingRequest.toXMLString(true, true));
            returnMsg = soapService.sendMessage(msg, remoteSOAPEndPoint);
        }
        catch (FSMsgException mex) {
            debug.error(classMethod, mex);
            return null;
        }
        catch (IOException ioe) {
            debug.error(classMethod, ioe);
            return null;
        }
        catch (SOAPException soape) {
            debug.error(classMethod, soape);
            return null;
        }
        Element elt = soapService.parseSOAPMessage(returnMsg);
        FSNameIdentifierMappingResponse mappingResponse = null;
        try {
            mappingResponse = new FSNameIdentifierMappingResponse(elt);
        }
        catch (FSMsgException fme2) {
            debug.error(classMethod, fme2);
            return null;
        }
        if (debug.messageEnabled()) {
            String resStr = null;
            try {
                resStr = mappingResponse.toXMLString();
            }
            catch (FSMsgException fme3) {
                debug.error(classMethod, fme3);
                return null;
            }
            debug.message(classMethod + "NameIdentifierMappingResponse: " + resStr);
        }
        if (FSServiceUtils.isSigningOn()) {
            if (FSNameMappingHandler.verifyNameIdMappingResponseSignature((Element)elt, (SOAPMessage)returnMsg, (String)realm)) {
                if (debug.messageEnabled()) {
                    debug.message(classMethod + "Success in verifying Name Identifier Mapping" + " Response Signature");
                }
            } else {
                debug.error(classMethod + "Failed verifying Name Identifier Mapping " + "Response");
                return null;
            }
        }
        return mappingResponse.getNameIdentifier();
    }

    static {
        debug = Debug.getInstance("libIDFF");
        metaManager = FSUtils.getIDFFMetaManager();
    }
}

