/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.CreateServiceConfig;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrgConfigViaAMSDK;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.PluginConfig;
import com.sun.identity.sm.PluginConfigImpl;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceAlreadyExistsException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigImpl;
import com.sun.identity.sm.ServiceConfigManagerImpl;
import com.sun.identity.sm.ServiceInstance;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchemaImpl;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceConfigManager {
    private SSOToken token;
    private String serviceName;
    private String version;
    private ServiceSchemaManagerImpl ssm;
    private ServiceConfigManagerImpl scm;

    public ServiceConfigManager(String serviceName, SSOToken token) throws SMSException, SSOException {
        this(token, serviceName, ServiceManager.serviceDefaultVersion(token, serviceName));
    }

    public ServiceConfigManager(SSOToken token, String serviceName, String version) throws SMSException, SSOException {
        if (token == null || serviceName == null || version == null) {
            throw new IllegalArgumentException(SMSEntry.bundle.getString("sms-INVALID_PARAMETERS"));
        }
        SSOTokenManager.getInstance().validateToken(token);
        this.scm = ServiceConfigManagerImpl.getInstance(token, serviceName, version);
        this.ssm = this.scm.getServiceSchemaManagerImpl();
        this.token = token;
        this.serviceName = serviceName;
        this.version = version;
    }

    public String getName() {
        return this.serviceName;
    }

    public String getVersion() {
        return this.version;
    }

    public Set getInstanceNames() throws SMSException {
        try {
            return this.scm.getInstanceNames(this.token);
        }
        catch (SSOException s) {
            SMSEntry.debug.error("ServiceConfigManager: Unable to get Instance Names", s);
            return Collections.EMPTY_SET;
        }
    }

    public Set getGroupNames() throws SMSException {
        try {
            return this.scm.getGroupNames(this.token);
        }
        catch (SSOException s) {
            SMSEntry.debug.error("ServiceConfigManager: Unable to get Group Names", s);
            return Collections.EMPTY_SET;
        }
    }

    public ServiceInstance getInstance(String instanceName) throws SMSException, SSOException {
        return new ServiceInstance(this, this.scm.getInstance(this.token, instanceName));
    }

    public void removeInstance(String instanceName) throws SMSException, SSOException {
        this.getInstance(instanceName).delete();
    }

    public ServiceConfig getGlobalConfig(String instanceName) throws SMSException, SSOException {
        ServiceConfigImpl sci = this.scm.getGlobalConfig(this.token, instanceName);
        return sci == null ? null : new ServiceConfig(this, sci);
    }

    public ServiceConfig getOrganizationConfig(String orgName, String instanceName) throws SMSException, SSOException {
        ServiceConfigImpl sci = this.scm.getOrganizationConfig(this.token, orgName, instanceName);
        return sci == null ? null : new ServiceConfig(this, sci);
    }

    public ServiceConfig createGlobalConfig(Map attrs) throws SMSException, SSOException {
        ServiceSchemaImpl ss = this.ssm.getSchema(SchemaType.GLOBAL);
        if (ss == null) {
            Object[] args = new String[]{this.serviceName};
            throw new SMSException("amSDK", "sms-service-does-not-have-global-schema", args);
        }
        String orgDN = this.scm.constructServiceConfigDN("default", "ou=GlobalConfig,", null);
        try {
            CreateServiceConfig.createSubConfigEntry(this.token, orgDN, ss, null, null, attrs, SMSEntry.baseDN);
        }
        catch (ServiceAlreadyExistsException slee) {
            // empty catch block
        }
        return this.getGlobalConfig(null);
    }

    public ServiceConfig createOrganizationConfig(String orgName, Map attrs) throws SMSException, SSOException {
        ServiceSchemaImpl ss = this.ssm.getSchema(SchemaType.ORGANIZATION);
        if (ss == null) {
            Object[] args = new String[]{this.serviceName};
            throw new SMSException("amSDK", "sms-service-does-not-have-org-schema", args);
        }
        String orgdn = DNMapper.orgNameToDN(orgName);
        CreateServiceConfig.checkBaseNodesForOrg(this.token, orgdn, this.serviceName, this.version);
        String orgDN = this.scm.constructServiceConfigDN("default", "ou=OrganizationConfig,", orgdn);
        try {
            CachedSMSEntry cEntry = CachedSMSEntry.getInstance(this.token, orgDN, null);
            if (cEntry.isNewEntry()) {
                CreateServiceConfig.createSubConfigEntry(this.token, orgDN, ss, null, null, attrs, orgName);
                if (ServiceManager.isCoexistenceMode()) {
                    String smsDN = DNMapper.orgNameToDN(orgName);
                    OrgConfigViaAMSDK amsdk = new OrgConfigViaAMSDK(this.token, DNMapper.realmNameToAMSDKName(smsDN), smsDN);
                    amsdk.assignService(this.serviceName);
                }
            } else if (attrs != null && !attrs.isEmpty()) {
                ServiceConfig sc = this.getOrganizationConfig(orgName, null);
                sc.setAttributes(attrs);
            }
        }
        catch (ServiceAlreadyExistsException slee) {
            // empty catch block
        }
        return this.getOrganizationConfig(orgName, null);
    }

    public void addConfiguration(InputStream in) throws SMSException, SSOException {
        ServiceManager sm = new ServiceManager(this.token);
        Document doc = SMSSchema.getXMLDocument(in);
        NodeList nodes = doc.getElementsByTagName("Service");
        for (int i = 0; nodes != null && i < nodes.getLength(); ++i) {
            Node configNode;
            Node serviceNode = nodes.item(i);
            String sName = XMLUtils.getNodeAttributeValue(serviceNode, "name");
            String sVersion = XMLUtils.getNodeAttributeValue(serviceNode, "version");
            if (!sName.equals(this.serviceName) || !sVersion.equals(this.version) || (configNode = XMLUtils.getChildNode(serviceNode, "Configuration")) == null) continue;
            CreateServiceConfig.createService(sm, sName, sVersion, configNode);
        }
    }

    public void removeGlobalConfiguration(String groupName) throws SMSException, SSOException {
        if (this.serviceName.equalsIgnoreCase("sunIdentityRepositoryService") || this.serviceName.equalsIgnoreCase("iPlanetAMAuthService")) {
            Object[] args = new String[]{this.serviceName};
            throw new SMSException("amSDK", "sms-SERVICE_CORE_CANNOT_DELETE", args);
        }
        if (groupName == null || groupName.length() == 0) {
            groupName = "default";
        }
        String gdn = this.scm.constructServiceConfigDN(groupName, "ou=GlobalConfig,", null);
        CachedSMSEntry cEntry = CachedSMSEntry.getInstance(this.token, gdn, null);
        SMSEntry entry = cEntry.getClonedSMSEntry();
        entry.delete(this.token);
        cEntry.refresh(entry);
    }

    public void deleteOrganizationConfig(String orgName) throws SMSException, SSOException {
        this.removeOrganizationConfiguration(orgName, "default");
    }

    public void removeOrganizationConfiguration(String orgName, String groupName) throws SMSException, SSOException {
        this.removeOrganizationConfiguration(orgName, groupName, true);
    }

    public void removeOrganizationConfiguration(String orgName, String groupName, boolean checkLegacyMode) throws SMSException, SSOException {
        String orgdn;
        String odn;
        CachedSMSEntry cEntry;
        if (groupName == null || groupName.length() == 0) {
            groupName = "default";
        }
        if ((cEntry = CachedSMSEntry.getInstance(this.token, odn = this.scm.constructServiceConfigDN(groupName, "ou=OrganizationConfig,", orgdn = DNMapper.orgNameToDN(orgName)), null)).isNewEntry()) {
            return;
        }
        if (checkLegacyMode && ServiceManager.isCoexistenceMode() && groupName.equalsIgnoreCase("default")) {
            OrgConfigViaAMSDK amsdk = new OrgConfigViaAMSDK(this.token, DNMapper.realmNameToAMSDKName(orgdn), orgdn);
            amsdk.unassignService(this.serviceName);
        }
        if (!cEntry.isNewEntry()) {
            SMSEntry entry = cEntry.getClonedSMSEntry();
            entry.delete(this.token);
            cEntry.refresh(entry);
        }
    }

    public Set getPluginConfigNames(String pluginSchemaName, String interfaceName, String orgName) throws SMSException, SSOException {
        StringBuffer sb = new StringBuffer(100);
        sb.append("ou=").append(pluginSchemaName).append(",ou=").append(interfaceName).append(",").append("ou=PluginConfig,").append("ou=").append(this.version).append(",").append("ou=").append(this.serviceName).append(",").append("ou=services").append(",").append(DNMapper.orgNameToDN(orgName));
        CachedSMSEntry.getInstance(this.token, sb.toString(), null);
        CachedSubEntries cse = CachedSubEntries.getInstance(this.token, sb.toString());
        return cse.getSubEntries(this.token);
    }

    public PluginConfig getPluginConfig(String name, String pluginSchemaName, String interfaceName, String orgName) throws SMSException, SSOException {
        PluginConfigImpl pci = this.scm.getPluginConfig(this.token, name, pluginSchemaName, interfaceName, orgName);
        return new PluginConfig(name, this, pci);
    }

    public void removePluginConfig(String name, String pluginSchemaName, String interfaceName, String orgName) throws SMSException, SSOException {
        PluginConfig pci = this.getPluginConfig(name, pluginSchemaName, interfaceName, orgName);
        if (pci != null) {
            pci.delete();
        }
    }

    public String addListener(ServiceListener listener) {
        return this.scm.addListener(listener);
    }

    public void removeListener(String listenerID) {
        this.scm.removeListener(listenerID);
    }

    public boolean equals(Object o) {
        if (o instanceof ServiceConfigManager) {
            ServiceConfigManager scm = (ServiceConfigManager)o;
            if (this.serviceName.equals(scm.serviceName) && this.version.equals(scm.version)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nService Config Manager: ").append(this.serviceName).append("\n\tVersion: ").append(this.version);
        try {
            Iterator instances = this.getInstanceNames().iterator();
            while (instances.hasNext()) {
                String instanceName = (String)instances.next();
                sb.append(this.getInstance(instanceName));
                ServiceConfig config = null;
                try {
                    config = this.getGlobalConfig(instanceName);
                    if (config != null) {
                        sb.append("\nGlobal Configuation:\n").append(config);
                    }
                }
                catch (SMSException e) {
                    // empty catch block
                }
                try {
                    config = this.getOrganizationConfig(null, instanceName);
                    if (config == null) continue;
                    sb.append("Org Configuation:\n").append(config);
                }
                catch (SMSException e) {}
            }
            sb.append("\n");
        }
        catch (SMSException smse) {
            sb.append(smse.getMessage());
        }
        catch (SSOException ssoe) {
            sb.append(ssoe.getMessage());
        }
        return sb.toString();
    }

    public String toXML() throws SMSException, SSOException {
        String instanceName;
        StringBuffer buff = new StringBuffer();
        buff.append("<Configuration>");
        Set instances = this.getInstanceNames();
        Iterator i = instances.iterator();
        while (i.hasNext()) {
            instanceName = (String)i.next();
            ServiceInstance instance = this.getInstance(instanceName);
            buff.append(instance.toXML());
        }
        instances.add("default");
        i = instances.iterator();
        while (i.hasNext()) {
            instanceName = (String)i.next();
            try {
                ServiceConfig sc = this.getGlobalConfig(instanceName);
                if (sc == null) continue;
                buff.append(sc.toXML("GlobalConfiguration"));
            }
            catch (SMSException e) {}
        }
        OrganizationConfigManager orgMgr = new OrganizationConfigManager(this.token, "/");
        HashSet<String> orgNames = new HashSet<String>();
        Set oNames = orgMgr.getSubOrganizationNames("*", true);
        Iterator i2 = oNames.iterator();
        while (i2.hasNext()) {
            String name = (String)i2.next();
            if (!name.startsWith("/")) {
                name = "/" + name;
            }
            orgNames.add(name);
        }
        orgNames.add("/");
        orgNames.add("/sunamhiddenrealmdelegationservicepermissions");
        i2 = orgNames.iterator();
        while (i2.hasNext()) {
            String orgName = (String)i2.next();
            Iterator j = instances.iterator();
            while (j.hasNext()) {
                String instanceName2 = (String)j.next();
                try {
                    ServiceConfig sc = this.getOrganizationConfig(orgName, instanceName2);
                    if (sc == null) continue;
                    buff.append(sc.toXML("OrganizationConfiguration", orgName));
                }
                catch (SMSException e) {}
            }
        }
        buff.append("</Configuration>");
        return buff.toString();
    }

    SSOToken getSSOToken() {
        return this.token;
    }

    boolean containsGroup(String groupName) throws SMSException, SSOException {
        return this.scm.containsGroup(this.token, groupName);
    }
}

