/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.ServerInstance;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSObject;

public abstract class SMSObjectDB
extends SMSObject {
    static String amsdkbaseDN;
    static String baseDN;

    public String getAMSdkBaseDN() {
        try {
            ServerInstance serverInstanceForUM = null;
            DSConfigMgr mgr = DSConfigMgr.getDSConfigMgr();
            if (mgr != null) {
                serverInstanceForUM = mgr.getServerInstance(LDAPUser.Type.AUTH_PROXY);
            }
            if (serverInstanceForUM != null) {
                amsdkbaseDN = serverInstanceForUM.getBaseDN();
            }
            if (mgr == null || serverInstanceForUM == null) {
                this.debug().error("SMSObjectDB: Unable to initialize LDAP");
                throw new SMSException("amSDK", "ums-configmanagererror", null);
            }
            if (this.debug().messageEnabled()) {
                this.debug().message("SMSObjectDB: amsdkbasedn: " + amsdkbaseDN);
            }
        }
        catch (Exception e) {
            this.debug().error("SMSObjectDB: Unable to get amsdkbasedn:", e);
        }
        return amsdkbaseDN;
    }

    public String getRootSuffix() {
        block7: {
            try {
                ServerInstance serverInstanceForSM = null;
                DSConfigMgr mgr = DSConfigMgr.getDSConfigMgr();
                if (mgr != null) {
                    serverInstanceForSM = mgr.getServerInstance("sms", LDAPUser.Type.AUTH_PROXY);
                }
                if (serverInstanceForSM != null) {
                    baseDN = serverInstanceForSM.getBaseDN();
                }
                if (mgr == null || serverInstanceForSM == null) {
                    baseDN = this.getAMSdkBaseDN();
                    if (this.debug().warningEnabled()) {
                        this.debug().warning("SMSObjectDB: SMS servergroup not available. Returning the default baseDN: " + baseDN);
                    }
                }
                if (this.debug().messageEnabled()) {
                    this.debug().message("SMSObjectDB: basedn: " + baseDN);
                }
            }
            catch (Exception e) {
                baseDN = this.getAMSdkBaseDN();
                if (!this.debug().warningEnabled()) break block7;
                this.debug().warning("SMSObjectDB: SMS servergroup not available. Returning the default baseDN: " + baseDN);
            }
        }
        return baseDN;
    }
}

