/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.DNUtils;
import com.sun.identity.delegation.DelegationEvaluator;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationPermission;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrganizationConfigManagerImpl;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigImpl;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceConfigManagerImpl;
import com.sun.identity.sm.ServiceManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

public class OrgConfigViaAMSDK {
    private SSOToken token;
    private String parentOrgName;
    private String smsOrgName;
    private AMOrganization parentOrg;
    private AMOrganization parentOrgWithAdminToken;
    private ServiceConfig serviceConfig;
    private int objType;
    boolean hasReadPermissionOnly;
    static Map attributeMappings = new CaseInsensitiveHashMap();
    static Map reverseAttributeMappings = new CaseInsensitiveHashMap();
    static Map attributeMappingServiceConfigs = new HashMap();
    static final String IDREPO_SERVICE = "sunidentityrepositoryservice";
    static final String MAPPING_ATTR_NAME = "sunCoexistenceAttributeMapping";
    static Map amsdkdn2realmname = new CaseInsensitiveHashMap();
    static Map amsdkConfiguredRealms = new CaseInsensitiveHashMap();
    static Debug debug = SMSEntry.debug;
    ResourceBundle bundle = SMSEntry.bundle;
    static Map notMigratedAttributeMappings;
    static Map notMigratedReverseAttributeMappings;

    OrgConfigViaAMSDK(SSOToken token, String orgName, String smsOrgName) throws SMSException {
        this.token = token;
        this.parentOrgName = orgName;
        this.smsOrgName = smsOrgName;
        SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        try {
            if (!SMSEntry.SMSJAXRPCObjectFlg) {
                if (this.checkRealmPermission(token, smsOrgName, SMSEntry.modifyActionSet)) {
                    token = adminToken;
                } else if (this.checkRealmPermission(token, smsOrgName, SMSEntry.readActionSet)) {
                    this.hasReadPermissionOnly = true;
                }
            }
            AMStoreConnection amcom = new AMStoreConnection(token);
            this.parentOrg = amcom.getOrganization(orgName);
            if (this.hasReadPermissionOnly) {
                amcom = new AMStoreConnection(adminToken);
                this.parentOrgWithAdminToken = amcom.getOrganization(orgName);
            }
            String newOrg = orgName;
            if (!SMSEntry.getRootSuffix().equalsIgnoreCase(SMSEntry.getAMSdkBaseDN())) {
                newOrg = smsOrgName;
            }
            if (ServiceManager.isConfigMigratedTo70() && (this.serviceConfig = (ServiceConfig)attributeMappingServiceConfigs.get(orgName)) == null) {
                ServiceConfigManager scm = new ServiceConfigManager(IDREPO_SERVICE, adminToken);
                this.serviceConfig = scm.getOrganizationConfig(newOrg, null);
                if (debug.messageEnabled()) {
                    debug.message("OrgConfigViaAMSDK::constructor: serviceConfig" + this.serviceConfig);
                }
                attributeMappingServiceConfigs.put(orgName, this.serviceConfig);
            }
        }
        catch (SSOException ssoe) {
            throw new SMSException(this.bundle.getString("sms-INVALID_SSO_TOKEN"), ssoe, "sms-INVALID_SSO_TOKEN");
        }
    }

    void createSubOrganization(String subOrgName) throws SMSException {
        if (!this.getSubOrganizationNames(subOrgName, false).isEmpty() || subOrgName.startsWith("sunamhiddenrealm")) {
            return;
        }
        try {
            if (ServiceManager.isConfigMigratedTo70()) {
                HashMap attrs = new HashMap();
                HashSet<String> attrValues = new HashSet<String>();
                attrValues.add("sunRealmService");
                attrs.put("objectclass", attrValues);
                HashMap subOrgs = new HashMap();
                subOrgs.put(subOrgName, attrs);
                this.parentOrg.createSubOrganizations(subOrgs);
            } else {
                HashSet<String> subOrgs = new HashSet<String>();
                subOrgs.add(subOrgName);
                this.parentOrg.createSubOrganizations(subOrgs);
            }
        }
        catch (AMException ame) {
            if (!ame.getErrorCode().equals("474")) {
                if (debug.messageEnabled()) {
                    debug.message("OrgConfigViaAMSDK::createSubOrganization: failed with AMException", ame);
                }
                throw new SMSException("amProfile", ame.getMessage(), ame, ame.getMessage());
            }
        }
        catch (SSOException ssoe) {
            throw new SMSException(this.bundle.getString("sms-INVALID_SSO_TOKEN"), ssoe, "sms-INVALID_SSO_TOKEN");
        }
    }

    Set getAssignedServices() throws SMSException {
        try {
            if (this.hasReadPermissionOnly) {
                return this.parentOrgWithAdminToken.getRegisteredServiceNames();
            }
            return this.parentOrg.getRegisteredServiceNames();
        }
        catch (AMException ame) {
            if (debug.messageEnabled()) {
                debug.message("OrgConfigViaAMSDK::getAssignedServices: failed with AMException", ame);
            }
            throw new SMSException("amProfile", ame.getMessage(), ame, ame.getMessage());
        }
        catch (SSOException ssoe) {
            throw new SMSException(this.bundle.getString("sms-INVALID_SSO_TOKEN"), ssoe, "sms-INVALID_SSO_TOKEN");
        }
    }

    void assignService(String serviceName) throws SMSException {
        try {
            if (ServiceManager.isCoexistenceMode() && this.parentOrgName.startsWith("o=sunamhiddenrealm")) {
                return;
            }
            if (!this.getAssignedServices().contains(serviceName)) {
                this.parentOrg.registerService(serviceName, false, false);
            }
        }
        catch (AMException ame) {
            if (debug.messageEnabled()) {
                debug.message("OrgConfigViaAMSDK::assignService: failed with AMException", ame);
            }
            throw new SMSException("amProfile", ame.getMessage(), ame, ame.getMessage());
        }
        catch (SSOException ssoe) {
            throw new SMSException(this.bundle.getString("sms-INVALID_SSO_TOKEN"), ssoe, "sms-INVALID_SSO_TOKEN");
        }
    }

    void unassignService(String serviceName) throws SMSException {
        try {
            if (this.getAssignedServices().contains(serviceName)) {
                this.parentOrg.unregisterService(serviceName);
            }
        }
        catch (AMException ame) {
            if (debug.messageEnabled()) {
                debug.message("OrgConfigViaAMSDK::unassignService: failed with AMException", ame);
            }
            throw new SMSException("amProfile", ame.getMessage(), ame, ame.getMessage());
        }
        catch (SSOException ssoe) {
            throw new SMSException(this.bundle.getString("sms-INVALID_SSO_TOKEN"), ssoe, "sms-INVALID_SSO_TOKEN");
        }
    }

    Set getSubOrganizationNames(String pattern, boolean recursive) throws SMSException {
        try {
            Set subOrgDNs = this.hasReadPermissionOnly ? this.parentOrgWithAdminToken.searchSubOrganizations(pattern, recursive ? 2 : 1) : this.parentOrg.searchSubOrganizations(pattern, recursive ? 2 : 1);
            if (subOrgDNs != null && !subOrgDNs.isEmpty()) {
                HashSet<String> subOrgs = new HashSet<String>();
                Iterator items = subOrgDNs.iterator();
                while (items.hasNext()) {
                    subOrgs.add(DNMapper.orgNameToDN((String)items.next()));
                }
                return SMSEntry.parseResult(subOrgs, this.smsOrgName);
            }
        }
        catch (AMException ame) {
            if (debug.messageEnabled()) {
                debug.message("OrgConfigViaAMSDK::getSubOrganizationNames: failed with AMException", ame);
            }
            throw new SMSException("amProfile", ame.getMessage(), ame, ame.getMessage());
        }
        catch (SSOException ssoe) {
            throw new SMSException(this.bundle.getString("sms-INVALID_SSO_TOKEN"), ssoe, "sms-INVALID_SSO_TOKEN");
        }
        return Collections.EMPTY_SET;
    }

    void deleteSubOrganization(String subOrgName) throws SMSException {
        try {
            if (subOrgName == null || subOrgName.trim().length() == 0) {
                if (this.parentOrg.isExists()) {
                    this.parentOrg.delete(true);
                }
                return;
            }
            if (subOrgName.startsWith("sunamhiddenrealm")) {
                return;
            }
            Set subOrgDNs = this.parentOrg.searchSubOrganizations(subOrgName, 1);
            if (subOrgDNs != null && !subOrgDNs.isEmpty()) {
                Iterator items = subOrgDNs.iterator();
                while (items.hasNext()) {
                    String dn = (String)items.next();
                    AMOrganization subOrg = this.parentOrg.getSubOrganization(dn);
                    if (subOrg == null) continue;
                    subOrg.delete(true);
                }
            } else {
                AMOrganization subOrg = this.parentOrg.getSubOrganization(subOrgName);
                if (subOrg != null) {
                    subOrg.delete(true);
                }
            }
        }
        catch (AMException ame) {
            if (debug.messageEnabled()) {
                debug.message("OrgConfigViaAMSDK::deleteSubOrganization: failed with AMException", ame);
            }
            throw new SMSException("amProfile", ame.getMessage(), ame, ame.getMessage());
        }
        catch (SSOException ssoe) {
            throw new SMSException(this.bundle.getString("sms-INVALID_SSO_TOKEN"), ssoe, "sms-INVALID_SSO_TOKEN");
        }
    }

    Map getAttributes() throws SMSException {
        HashMap answer = null;
        try {
            Map attributes;
            Map attrMapping = this.getReverseAttributeMapping();
            Set attrNames = attrMapping.keySet();
            if (!attrNames.isEmpty() && (attributes = this.hasReadPermissionOnly ? this.parentOrgWithAdminToken.getAttributes(attrNames) : this.parentOrg.getAttributes(attrNames)) != null && !attributes.isEmpty()) {
                Iterator items = attributes.keySet().iterator();
                while (items.hasNext()) {
                    String key = (String)items.next();
                    Set values = (Set)attributes.get(key);
                    if (values == null || values.isEmpty()) continue;
                    if (answer == null) {
                        answer = new HashMap();
                    }
                    answer.put(attrMapping.get(key), values);
                }
            }
        }
        catch (AMException ame) {
            if (debug.messageEnabled()) {
                debug.message("OrgConfigViaAMSDK::getAttributes: failed with AMException", ame);
            }
            throw new SMSException("amProfile", ame.getMessage(), ame, ame.getMessage());
        }
        catch (SSOException ssoe) {
            throw new SMSException(this.bundle.getString("sms-INVALID_SSO_TOKEN"), ssoe, "sms-INVALID_SSO_TOKEN");
        }
        return answer == null ? Collections.EMPTY_MAP : answer;
    }

    void addAttributeValues(String attrName, Set values) throws SMSException {
        if (attrName != null && values != null && !values.isEmpty()) {
            Map attrs = this.getAttributes();
            Set origValues = (Set)attrs.get(attrName);
            HashSet newValues = new HashSet(values);
            if (origValues != null && !origValues.isEmpty()) {
                newValues.addAll(origValues);
            }
            HashMap newAttrs = new HashMap();
            newAttrs.put(attrName, newValues);
            this.setAttributes(newAttrs);
        }
    }

    void setAttributes(Map attributes) throws SMSException {
        HashMap amsdkAttrs = null;
        if (attributes != null && !attributes.isEmpty()) {
            CaseInsensitiveHashMap smsIdRepoAttrs = new CaseInsensitiveHashMap(attributes);
            Map attrs = this.getAttributeMapping();
            Map existingAttributes = this.getAttributes();
            if (attrs != null && !attrs.isEmpty()) {
                Iterator items = attrs.keySet().iterator();
                while (items.hasNext()) {
                    String key = (String)items.next();
                    Set value = (Set)smsIdRepoAttrs.get(key);
                    if (value == null) continue;
                    if (amsdkAttrs == null) {
                        amsdkAttrs = new HashMap();
                    }
                    boolean notEmptyFlg = false;
                    if (!value.isEmpty()) {
                        Iterator iter = value.iterator();
                        while (iter.hasNext()) {
                            String val = (String)iter.next();
                            if (val.length() <= 0) continue;
                            notEmptyFlg = true;
                        }
                        if (!notEmptyFlg) continue;
                        amsdkAttrs.put(attrs.get(key), value);
                        continue;
                    }
                    Set existingValues = (Set)existingAttributes.get(key);
                    if (existingValues == null || existingValues.isEmpty()) continue;
                    amsdkAttrs.put(attrs.get(key), value);
                }
            }
        }
        if (amsdkAttrs != null) {
            try {
                this.parentOrg.setAttributes(amsdkAttrs);
                this.parentOrg.store();
            }
            catch (AMException ame) {
                if (debug.messageEnabled()) {
                    debug.message("OrgConfigViaAMSDK::createSubOrganization: failed with AMException", ame);
                }
                throw new SMSException("amProfile", ame.getMessage(), ame, ame.getMessage());
            }
            catch (SSOException ssoe) {
                throw new SMSException(this.bundle.getString("sms-INVALID_SSO_TOKEN"), ssoe, "sms-INVALID_SSO_TOKEN");
            }
        }
    }

    void removeAttribute(String attrName) throws SMSException {
        if (attrName == null) {
            return;
        }
        Map attrMap = this.getAttributeMapping();
        String amsdkAttrName = (String)attrMap.get(attrName);
        if (amsdkAttrName != null) {
            HashSet<String> set = new HashSet<String>();
            set.add(amsdkAttrName);
            try {
                this.parentOrg.removeAttributes(set);
                this.parentOrg.store();
            }
            catch (AMException ame) {
                if (debug.messageEnabled()) {
                    debug.message("OrgConfigViaAMSDK::removeAttribute: failed with AMException", ame);
                }
                throw new SMSException("amProfile", ame.getMessage(), ame, ame.getMessage());
            }
            catch (SSOException ssoe) {
                throw new SMSException(this.bundle.getString("sms-INVALID_SSO_TOKEN"), ssoe, "sms-INVALID_SSO_TOKEN");
            }
        }
    }

    void removeAttributeValues(String attrName, Set values) throws SMSException {
        Map attrs;
        Set origValues;
        if (attrName != null && (origValues = (Set)(attrs = this.getAttributes()).get(attrName)) != null && !origValues.isEmpty()) {
            HashSet newValues = new HashSet(origValues);
            newValues.removeAll(values);
            if (newValues.isEmpty()) {
                this.removeAttribute(attrName);
            } else {
                HashMap newAttrs = new HashMap();
                newAttrs.put(attrName, newValues);
                this.setAttributes(newAttrs);
            }
        }
    }

    private Map getAttributeMapping() throws SMSException {
        Set mapAttrs;
        if (!ServiceManager.isConfigMigratedTo70()) {
            return notMigratedAttributeMappings;
        }
        Map answer = (Map)attributeMappings.get(this.parentOrgName);
        if (answer != null) {
            return answer;
        }
        Map attrs = this.serviceConfig.getAttributes();
        if (attrs != null && !attrs.isEmpty() && (mapAttrs = (Set)attrs.get(MAPPING_ATTR_NAME)) != null && !mapAttrs.isEmpty()) {
            Iterator items = mapAttrs.iterator();
            while (items.hasNext()) {
                String attrMapping = (String)items.next();
                String[] maps = DNMapper.splitString(attrMapping);
                if (answer == null) {
                    answer = new CaseInsensitiveHashMap();
                }
                answer.put(maps[0], maps[1]);
            }
        }
        if (answer == null) {
            answer = Collections.EMPTY_MAP;
        }
        attributeMappings.put(this.parentOrgName, answer);
        return answer;
    }

    private Map getReverseAttributeMapping() throws SMSException {
        if (!ServiceManager.isConfigMigratedTo70()) {
            return notMigratedReverseAttributeMappings;
        }
        Map answer = (Map)reverseAttributeMappings.get(this.parentOrgName);
        if (answer != null) {
            return answer;
        }
        Map attrMaps = this.getAttributeMapping();
        Iterator items = attrMaps.entrySet().iterator();
        while (items.hasNext()) {
            Map.Entry entry = items.next();
            if (answer == null) {
                answer = new CaseInsensitiveHashMap();
            }
            answer.put(entry.getValue(), entry.getKey().toString());
        }
        if (answer == null) {
            answer = Collections.EMPTY_MAP;
        }
        reverseAttributeMappings.put(this.parentOrgName, answer);
        return answer;
    }

    private boolean checkRealmPermission(SSOToken token, String realm, Set action) {
        boolean answer;
        block4: {
            answer = false;
            if (token != null) {
                try {
                    DelegationEvaluator de = new DelegationEvaluator();
                    DelegationPermission dp = new DelegationPermission(realm, "sunAMRealmService", "1.0", "*", "*", action, Collections.EMPTY_MAP);
                    answer = de.isAllowed(token, dp, null);
                }
                catch (DelegationException dex) {
                    debug.error("OrgConfigViaAMSDK.checkRealmPermission: Got Delegation Exception: ", dex);
                }
                catch (SSOException ssoe) {
                    if (!debug.messageEnabled()) break block4;
                    debug.message("OrgConfigViaAMSDK.checkRealmPermission: Invalid SSOToken: ", ssoe);
                }
            }
        }
        return answer;
    }

    static String getNamingAttrForOrg() {
        return AMNamingAttrManager.getNamingAttr(2);
    }

    static String getNamingAttrForOrgUnit() {
        return AMNamingAttrManager.getNamingAttr(3);
    }

    public Set getSDKAttributeValue(String key) {
        Set attrSet;
        block4: {
            attrSet = new HashSet();
            try {
                attrSet = this.parentOrg.getAttribute(key);
            }
            catch (AMException ame) {
                if (debug.warningEnabled()) {
                    debug.warning("OrgConfigViaAMSDK::getSDKAttributeValue: failed with AMException", ame);
                }
            }
            catch (SSOException ssoe) {
                if (!debug.warningEnabled()) break block4;
                debug.warning("OrgConfigViaAMSDK::getSDKAttributeValue: failed with SSOException", ssoe);
            }
        }
        return attrSet;
    }

    protected static void clearCache() {
        attributeMappings = new CaseInsensitiveHashMap();
        reverseAttributeMappings = new CaseInsensitiveHashMap();
        amsdkdn2realmname = new CaseInsensitiveHashMap();
        amsdkConfiguredRealms = new CaseInsensitiveHashMap();
    }

    protected static void updateAMSDKConfiguredRealms(String realm, boolean configured) {
        if (!amsdkConfiguredRealms.keySet().contains(realm)) {
            amsdkConfiguredRealms.put(realm, configured);
        }
    }

    public static boolean isAMSDKConfigured(String realm) {
        if (ServiceManager.isCoexistenceMode()) {
            return true;
        }
        Boolean answer = (Boolean)amsdkConfiguredRealms.get(realm = DNUtils.normalizeDN(realm));
        if (answer == null) {
            try {
                SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                OrganizationConfigManagerImpl ocm = OrganizationConfigManagerImpl.getInstance(token, realm);
                String orgname = OrgConfigViaAMSDK.getAmsdkdn(token, ocm);
                answer = orgname != null;
            }
            catch (SSOException ssoe) {
                answer = Boolean.FALSE;
            }
            catch (SMSException smse) {
                answer = Boolean.FALSE;
            }
            amsdkConfiguredRealms.put(realm, answer);
        }
        return answer;
    }

    public static String getRealmForAMSDK(String amsdkdn, String inrealm) {
        String realm;
        block17: {
            if (ServiceManager.isCoexistenceMode()) {
                return amsdkdn;
            }
            realm = inrealm;
            if ((amsdkdn = DNUtils.normalizeDN(amsdkdn)) == null) {
                return null;
            }
            String orgname = (String)amsdkdn2realmname.get(amsdkdn);
            if (orgname != null) {
                if (debug.messageEnabled()) {
                    debug.message("OrgConfigViaAMSDK:getRealmForAMSDK from cache: orgdn=" + amsdkdn + " realm=" + orgname);
                }
                return orgname;
            }
            OrganizationConfigManagerImpl ocm = null;
            SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            try {
                String dn;
                if (inrealm != null) {
                    ocm = OrganizationConfigManagerImpl.getInstance(token, inrealm);
                    orgname = OrgConfigViaAMSDK.getAmsdkdn(token, ocm);
                }
                if ((inrealm == null || orgname != null && !orgname.equals(realm) || orgname != null && !amsdkdn.equals(DNUtils.normalizeDN(inrealm))) && (orgname = OrgConfigViaAMSDK.getAmsdkdn(token, ocm = OrganizationConfigManagerImpl.getInstance(token, dn = OrgConfigViaAMSDK.hideOrgUnits(amsdkdn)))) != null && orgname.equals(amsdkdn)) {
                    realm = ocm.getOrgDN();
                }
            }
            catch (SMSException sme) {
            }
            catch (SSOException ssoe) {
                // empty catch block
            }
            if (realm != null) {
                amsdkdn2realmname.put(amsdkdn, realm);
                if (debug.messageEnabled()) {
                    debug.message("OrgConfigViaAMSDK:getRealmForAMSDK first realm lookup: orgdn=" + amsdkdn + " realm=" + realm);
                }
            } else {
                try {
                    ocm = OrganizationConfigManagerImpl.getInstance(token, "/");
                    OrgConfigViaAMSDK.updateAmsdk2RealmNameCache(token, ocm, amsdkdn);
                    realm = (String)amsdkdn2realmname.get(amsdkdn);
                    if (debug.messageEnabled()) {
                        debug.message("OrgConfigViaAMSDK:getRealmForAMSDK full search orgdn=" + amsdkdn + " realm=" + realm);
                    }
                }
                catch (SMSException e) {
                    if (debug.messageEnabled()) {
                        debug.message("OrgConfigViaAMSDK:getRealmForAMSDK Exception: ", e);
                    }
                }
                catch (SSOException ssoe) {
                    if (!debug.messageEnabled()) break block17;
                    debug.message("OrgConfigViaAMSDK:getRealmForAMSDK SSException: ", ssoe);
                }
            }
        }
        return realm;
    }

    private static String hideOrgUnits(String orgUnitDN) {
        String ou = OrgConfigViaAMSDK.getNamingAttrForOrgUnit();
        if (!orgUnitDN.startsWith(ou)) {
            return orgUnitDN;
        }
        DN result = new DN();
        result.setDNType(DN.RFC);
        DN dn = new DN(orgUnitDN);
        Vector rdns = dn.getRDNs();
        Iterator iter = rdns.iterator();
        while (iter.hasNext()) {
            String relDN = ((RDN)iter.next()).toString();
            if (relDN.startsWith(ou)) {
                relDN = relDN.replaceFirst(ou + "=", ou + "=" + "sunamhiddenrealm");
            }
            result.addRDNToBack(new RDN(relDN));
        }
        return result.toRFCString();
    }

    private static boolean updateAmsdk2RealmNameCache(SSOToken token, OrganizationConfigManagerImpl ocm, String amsdkdn) throws SMSException, SSOException {
        boolean foundEntry;
        block3: {
            OrganizationConfigManagerImpl socm;
            Set subRealmNames;
            foundEntry = false;
            String orgname = OrgConfigViaAMSDK.getAmsdkdn(token, ocm);
            if (orgname != null) {
                amsdkdn2realmname.put(orgname, ocm.getOrgDN());
                if (orgname.equals(amsdkdn)) {
                    foundEntry = true;
                }
            }
            if (foundEntry || (subRealmNames = ocm.getSubOrganizationNames(token)) == null || subRealmNames.isEmpty()) break block3;
            Iterator realms = subRealmNames.iterator();
            while (realms.hasNext() && !(foundEntry = OrgConfigViaAMSDK.updateAmsdk2RealmNameCache(token, socm = OrganizationConfigManagerImpl.getInstance(token, "o=" + realms.next() + "," + ocm.getOrgDN()), amsdkdn))) {
            }
        }
        return foundEntry;
    }

    public static String getAmsdkdn(SSOToken token, OrganizationConfigManagerImpl ocm) throws SMSException, SSOException {
        Set plugins;
        ServiceConfigImpl sc;
        if (ServiceManager.isCoexistenceMode()) {
            return ocm.getOrgDN();
        }
        String orgdn = null;
        ServiceConfigManagerImpl sci = ServiceConfigManagerImpl.getInstance(token, IDREPO_SERVICE, "1.0");
        if (sci != null && (sc = sci.getOrganizationConfig(token, ocm.getOrgDN(), null)) != null && (plugins = sc.getSubConfigNames(token)) != null && !plugins.isEmpty()) {
            Iterator items = plugins.iterator();
            while (items.hasNext()) {
                Set orgs;
                ServiceConfigImpl ssc = sc.getSubConfig(token, (String)items.next());
                if (!ssc.getSchemaID().equalsIgnoreCase("amSDK")) continue;
                Map cMap = ssc.getAttributesForRead();
                if (cMap == null || cMap.isEmpty() || (orgs = (Set)cMap.get("amSDKOrgName")) == null || orgs.isEmpty()) break;
                orgdn = DNUtils.normalizeDN((String)orgs.iterator().next());
                break;
            }
        }
        return orgdn;
    }

    private int getObjectType() {
        if (this.objType == 0) {
            try {
                AMStoreConnection amcom = new AMStoreConnection((SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance()));
                this.objType = amcom.getAMObjectType(this.parentOrgName);
            }
            catch (AMException ame) {
                this.objType = 3;
                debug.error("OrgConfigViaAMSDK: Unable to determine type");
            }
            catch (SSOException ssoe) {
                this.objType = 3;
            }
        }
        return this.objType;
    }

    static {
        if (!ServiceManager.isConfigMigratedTo70()) {
            notMigratedAttributeMappings = new CaseInsensitiveHashMap();
            notMigratedAttributeMappings.put("sunPreferredDomain", "sunPreferredDomain");
            notMigratedAttributeMappings.put("sunOrganizationStatus", "inetDomainStatus");
            notMigratedAttributeMappings.put("sunOrganizationAliases", "sunOrganizationAlias");
            notMigratedAttributeMappings.put("sunDNSAliases", "associatedDomain");
            notMigratedReverseAttributeMappings = new CaseInsensitiveHashMap();
            notMigratedReverseAttributeMappings.put("sunPreferredDomain", "sunPreferredDomain");
            notMigratedReverseAttributeMappings.put("inetDomainStatus", "sunOrganizationStatus");
            notMigratedReverseAttributeMappings.put("sunOrganizationAlias", "sunOrganizationAliases");
            notMigratedReverseAttributeMappings.put("associatedDomain", "sunDNSAliases");
        }
    }
}

