/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared.xml;

import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.ValidationErrorHandler;
import com.sun.identity.shared.xml.XMLHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUtils {
    private static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    private static boolean validating = false;
    private static String ATTR_VALUE_PAIR_NODE;
    private static String VALUE_NODE;

    public String getATTR_VALUE_PAIR_NODE() {
        return ATTR_VALUE_PAIR_NODE;
    }

    public static Document toDOMDocument(String xmlString, Debug debug) {
        if (xmlString == null || xmlString.length() == 0) {
            return null;
        }
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(xmlString.getBytes("UTF-8"));
            return XMLUtils.toDOMDocument(is, debug);
        }
        catch (UnsupportedEncodingException uee) {
            if (debug != null && debug.warningEnabled()) {
                debug.warning("Can't parse the XML document:\n" + xmlString, uee);
            }
            return null;
        }
    }

    public static Document toDOMDocument(InputStream is, Debug debug) {
        DocumentBuilderFactory dbFactory;
        block8: {
            dbFactory = null;
            try {
                dbFactory = DocumentBuilderFactory.newInstance();
                dbFactory.setValidating(validating);
                dbFactory.setNamespaceAware(true);
            }
            catch (Exception e) {
                if (debug == null) break block8;
                debug.error("XMLUtils.DocumentBuilder init failed", e);
            }
        }
        try {
            DocumentBuilder documentBuilder = dbFactory.newDocumentBuilder();
            if (documentBuilder == null) {
                if (debug != null) {
                    debug.error("XMLUtils.toDOM : null builder instance");
                }
                return null;
            }
            documentBuilder.setEntityResolver(new XMLHandler());
            if (debug != null && debug.warningEnabled()) {
                documentBuilder.setErrorHandler(new ValidationErrorHandler(debug));
            }
            return documentBuilder.parse(is);
        }
        catch (Exception e) {
            if (debug != null && debug.warningEnabled()) {
                debug.warning("Can't parse the XML document", e);
            }
            return null;
        }
    }

    public static Set parseAttributesTag(Node n) {
        NodeList attributes = n.getChildNodes();
        int numAttributes = attributes.getLength();
        if (numAttributes == 0) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (int l = 0; l < numAttributes; ++l) {
            Node attr = attributes.item(l);
            if (attr.getNodeType() != 1 && !attr.getNodeName().equals("Attribute")) continue;
            set.add(((Element)attr).getAttribute("name"));
        }
        return set;
    }

    public static Map parseAttributeValuePairTags(Node parentNode) {
        NodeList avList = parentNode.getChildNodes();
        HashMap map = null;
        int numAVPairs = avList.getLength();
        if (numAVPairs <= 0) {
            return EMPTY_MAP;
        }
        for (int l = 0; l < numAVPairs; ++l) {
            Set oldValues;
            NodeList leafNodeList;
            long numLeafNodes;
            Node avPair = avList.item(l);
            if (avPair.getNodeType() != 1 || !avPair.getNodeName().equals("AttributeValuePair") || (numLeafNodes = (long)(leafNodeList = avPair.getChildNodes()).getLength()) < 2L) continue;
            String key = null;
            HashSet<String> values = null;
            Node attributeNode = null;
            int i = 0;
            while ((long)i < numLeafNodes) {
                attributeNode = leafNodeList.item(i);
                if (attributeNode.getNodeType() == 1 && attributeNode.getNodeName().equals("Attribute")) {
                    i = (int)numLeafNodes;
                }
                ++i;
            }
            key = ((Element)attributeNode).getAttribute("name");
            int m = 0;
            while ((long)m < numLeafNodes) {
                Node valueNode = leafNodeList.item(m);
                if (valueNode.getNodeType() == 1 && valueNode.getNodeName().equals("Value")) {
                    String value;
                    Text fchild;
                    if (values == null) {
                        values = new HashSet<String>();
                    }
                    if ((fchild = (Text)valueNode.getFirstChild()) != null && (value = fchild.getNodeValue()) != null) {
                        values.add(value.trim());
                    }
                }
                ++m;
            }
            if (values == null) continue;
            if (map == null) {
                map = new HashMap();
            }
            if ((oldValues = (Set)map.get(key)) != null) {
                values.addAll(oldValues);
            }
            map.put(key, values);
            values = null;
        }
        return map == null ? EMPTY_MAP : map;
    }

    public static Document newDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        dbFactory.setValidating(validating);
        return dbFactory.newDocumentBuilder().newDocument();
    }

    public static Document getXMLDocument(InputStream in) throws Exception {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validating);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(in);
            return doc;
        }
        catch (SAXParseException pe) {
            String msg = "\n" + pe.getMessage() + "\n";
            Object[] params = new Object[]{new Integer(pe.getLineNumber())};
            throw new Exception(msg + "XMLUtils.parser_error" + params);
        }
        catch (SAXException sax) {
            Object[] params = new Object[]{new String(sax.getMessage())};
            throw new Exception("XMLUtils.exception_message" + params);
        }
        catch (ParserConfigurationException pc) {
            Object[] params = new Object[]{new String(pc.getMessage())};
            throw new Exception("XMLUtils.invalid_xml_document" + params);
        }
        catch (IOException ioe) {
            Object[] params = new Object[]{new String(ioe.getMessage())};
            throw new Exception("XMLUtils.invalid_input_stream" + params);
        }
    }

    public static Node getRootNode(Document doc, String nodeName) {
        NodeList nodes = doc.getElementsByTagName(nodeName);
        if (nodes == null || nodes.getLength() == 0) {
            return null;
        }
        return nodes.item(0);
    }

    public static Node getChildNode(Node parentNode, String childName) {
        NodeList children = parentNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!node.getNodeName().equalsIgnoreCase(childName)) continue;
            return node;
        }
        return null;
    }

    public static boolean hasElementChild(Node node) {
        NodeList nl = node.getChildNodes();
        Node child = null;
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    public static Node getNamedChildNode(Node parentNode, String childNodeName, String attrName, String attrValue) {
        NodeList children = parentNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!childNodeName.equalsIgnoreCase(node.getNodeName()) || !XMLUtils.getNodeAttributeValue(node, attrName).equalsIgnoreCase(attrValue)) continue;
            return node;
        }
        return null;
    }

    public static Set getChildNodes(Node parentNode, String childName) {
        HashSet<Node> retVal = new HashSet<Node>();
        NodeList children = parentNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!node.getNodeName().equalsIgnoreCase(childName)) continue;
            retVal.add(node);
        }
        return retVal;
    }

    public static String getElementValue(Element element) {
        if (element == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(1000);
        NodeList nl = element.getChildNodes();
        Node child = null;
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            child = nl.item(i);
            if (child.getNodeType() != 3) continue;
            sb.append(child.getNodeValue());
        }
        return sb.toString().trim();
    }

    public static String getChildrenValue(Element element) {
        if (element == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(1000);
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            sb.append(XMLUtils.print(nl.item(i)));
        }
        return sb.toString().trim();
    }

    public static String getElementString(Element element) {
        if (element == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(1000);
        NodeList nl = element.getChildNodes();
        Node child = null;
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            child = nl.item(i);
            if (child.getNodeType() != 3) {
                return null;
            }
            sb.append(child.getNodeValue());
        }
        return sb.toString().trim();
    }

    public static String getNodeAttributeValue(Node node, String attrName) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs == null) {
            return null;
        }
        Node value = attrs.getNamedItem(attrName);
        if (value == null) {
            return null;
        }
        return value.getNodeValue();
    }

    public static String getNodeAttributeValueNS(Node node, String namespaceURI, String attrName) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs == null) {
            return null;
        }
        Node value = attrs.getNamedItemNS(namespaceURI, attrName);
        if (value == null) {
            return null;
        }
        return value.getNodeValue();
    }

    public static Set getAttributeValuePair(Node node) {
        if (!node.getNodeName().equals(ATTR_VALUE_PAIR_NODE)) {
            return null;
        }
        HashSet<String> retVal = new HashSet<String>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (!n.getNodeName().equalsIgnoreCase(VALUE_NODE)) continue;
            retVal.add(XMLUtils.getValueOfValueNode(n));
        }
        return retVal;
    }

    public static String getValueOfValueNode(Node n) {
        return XMLUtils.getValueOfValueNodeNoTrim(n).trim();
    }

    public static String getValueOfValueNodeNoTrim(Node n) {
        NodeList textNodes = n.getChildNodes();
        StringBuffer value = new StringBuffer("");
        for (int j = 0; j < textNodes.getLength(); ++j) {
            Node textNode = textNodes.item(j);
            String text = null;
            if (textNode.getNodeType() == 3) {
                text = textNode.getNodeValue();
            } else if (textNode.getNodeType() == 1) {
                text = XMLUtils.print(textNode);
            }
            if (text == null) continue;
            value.append(text);
        }
        return value.toString();
    }

    public static List getElementsByTagNameNS1(Element element, String nsName, String tagName) {
        ArrayList<Node> list = new ArrayList<Node>();
        if (element != null) {
            NodeList nl = element.getChildNodes();
            int length = nl.getLength();
            for (int i = 0; i < length; ++i) {
                Node child = nl.item(i);
                String childName = child.getLocalName();
                String childNS = child.getNamespaceURI();
                if (childName == null || !childName.equals(tagName) || childNS == null || !childNS.equals(nsName)) continue;
                list.add(child);
            }
        }
        return list;
    }

    public static String printAttributeValue(Element node, String prefix) {
        if (node == null) {
            return null;
        }
        StringBuffer xml = new StringBuffer(100);
        xml.append('<');
        xml.append(prefix).append(node.getLocalName());
        NamedNodeMap attrs = node.getAttributes();
        int length = attrs.getLength();
        for (int i = 0; i < length; ++i) {
            Attr attr = (Attr)attrs.item(i);
            xml.append(' ');
            xml.append(attr.getNodeName());
            xml.append("=\"");
            xml.append(attr.getNodeValue());
            xml.append('\"');
        }
        xml.append('>');
        NodeList children = node.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                xml.append(XMLUtils.print(children.item(i)));
            }
        }
        xml.append("</");
        xml.append(prefix).append(node.getLocalName());
        xml.append('>');
        return xml.toString();
    }

    public static String print(Node node) {
        if (node == null) {
            return null;
        }
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            DOMSource source = new DOMSource(node);
            ByteArrayOutputStream os = new ByteArrayOutputStream(2000);
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
            return os.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String print(Node node, String encoding) {
        if (node == null) {
            return null;
        }
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            DOMSource source = new DOMSource(node);
            ByteArrayOutputStream os = new ByteArrayOutputStream(2000);
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
            return os.toString(encoding);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String unescapeSpecialCharacters(String text) {
        text = text.replaceAll("&amp;", "&");
        text = text.replaceAll("&lt;", "<");
        text = text.replaceAll("&gt;", ">");
        text = text.replaceAll("&quot;", "\"");
        text = text.replaceAll("&apos;", "'");
        text = text.replaceAll("&#xD;", "\n");
        return text;
    }

    public static String escapeSpecialCharacters(String text) {
        char c;
        int i;
        String escapedText = text;
        StringBuffer sb = null;
        int len = 0;
        if (text != null) {
            len = text.length();
        }
        boolean specialCharacterFound = false;
        for (i = 0; i < len; ++i) {
            c = text.charAt(i);
            if (c != '&' && c != '<' && c != '>' && c != '\'' && c != '\"' && c != '\n') continue;
            specialCharacterFound = true;
            break;
        }
        if (specialCharacterFound) {
            sb = new StringBuffer();
            sb.append(text.substring(0, i));
            while (i < len) {
                c = text.charAt(i);
                switch (c) {
                    case '&': {
                        sb.append("&amp;");
                        break;
                    }
                    case '<': {
                        sb.append("&lt;");
                        break;
                    }
                    case '>': {
                        sb.append("&gt;");
                        break;
                    }
                    case '\"': {
                        sb.append("&quot;");
                        break;
                    }
                    case '\'': {
                        sb.append("&apos;");
                        break;
                    }
                    case '\n': {
                        sb.append("&#xD;");
                        break;
                    }
                    default: {
                        sb.append(c);
                    }
                }
                ++i;
            }
            escapedText = sb.toString();
        }
        return escapedText;
    }

    static {
        try {
            String xmlVal = SystemPropertiesManager.get("com.iplanet.am.util.xml.validating", "off");
            String debugLevel = SystemPropertiesManager.get("com.iplanet.services.debug.level", "error");
            if (xmlVal.trim().equalsIgnoreCase("on") && (debugLevel.trim().equalsIgnoreCase("warning") || debugLevel.trim().equalsIgnoreCase("message"))) {
                validating = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ATTR_VALUE_PAIR_NODE = "AttributeValuePair";
        VALUE_NODE = "Value";
    }
}

