/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.security.cert;

import com.iplanet.am.util.AMPasswordUtil;
import com.iplanet.security.x509.X500Name;
import com.sun.identity.security.SecurityDebug;
import com.sun.identity.security.cert.AMCRLStore;
import com.sun.identity.security.cert.AMCertPath;
import com.sun.identity.security.cert.AMCertStore;
import com.sun.identity.security.cert.AMLDAPCertStoreParameters;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import java.io.IOException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Vector;

public class CRLValidator {
    private static Debug debug = SecurityDebug.debug;
    private static AMLDAPCertStoreParameters ldapParams = null;
    private static boolean crlCheckEnabled = false;
    private static String dirServerHost = null;
    private static String dirServerPort = null;
    private static String dirUseSSL = null;
    private static String dirPrincipleUser = null;
    private static String dirPrinciplePasswd = null;
    private static String dirStartSearchLoc = null;
    private static String crlSearchAttr = null;

    public static boolean validateCertificate(X509Certificate cert, boolean checkCAStatus) {
        String method = "validateCertificate : ";
        boolean certgood = true;
        try {
            X509Certificate[] certs;
            AMCertPath certpath;
            Vector<X509CRL> crls = new Vector<X509CRL>();
            X509CRL crl = AMCRLStore.getCRL(ldapParams, cert, crlSearchAttr);
            if (crl != null) {
                crls.add(crl);
            }
            if (debug.messageEnabled()) {
                debug.message(method + " crls size = " + crls.size());
                if (crls.size() > 0) {
                    debug.message(method + "CRL = " + crls.toString());
                } else {
                    debug.message(method + "NO CRL found.");
                }
            }
            if (!(certpath = new AMCertPath(crls)).verify(certs = new X509Certificate[]{cert}, true, false)) {
                debug.error(method + "CertPath:verify failed.");
                certgood = false;
                return false;
            }
        }
        catch (Exception e) {
            debug.error(method + "verify failed.", e);
            certgood = false;
            return false;
        }
        if (checkCAStatus && !AMCertStore.isRootCA(cert)) {
            X509Certificate caCert = AMCertStore.getIssuerCertificate(ldapParams, cert, crlSearchAttr);
            certgood = CRLValidator.validateCertificate(caCert, checkCAStatus);
        }
        return certgood;
    }

    public static X509CRL getCRL(X509Certificate cert) {
        X509CRL crl = null;
        String attrValue = null;
        try {
            X500Name dn = AMCRLStore.getIssuerDN(cert);
            if (dn != null) {
                attrValue = dn.getAttributeValue(crlSearchAttr);
            }
        }
        catch (Exception ex) {
            debug.error("attrValue to search crl : " + attrValue, ex);
            return null;
        }
        if (attrValue == null || ldapParams == null) {
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("CRLValidator - attrValue to search crl : " + attrValue);
        }
        String searchFilter = AMCRLStore.setSearchFilter(crlSearchAttr, attrValue);
        ldapParams.setSearchFilter(searchFilter);
        try {
            AMCRLStore store = new AMCRLStore(ldapParams);
            crl = store.getCRL(cert);
        }
        catch (IOException e) {
            debug.error("X509Certificate: verifyCertificate." + e.toString());
        }
        return crl;
    }

    public static boolean isCRLCheckEnabled() {
        return crlCheckEnabled;
    }

    static {
        dirServerHost = SystemPropertiesManager.get("com.sun.identity.crl.cache.directory.host", null);
        boolean bl = crlCheckEnabled = dirServerHost != null;
        if (debug.messageEnabled()) {
            debug.message("CRLValidator : CRL Check configured : " + crlCheckEnabled);
        }
        if (crlCheckEnabled) {
            dirServerHost = SystemPropertiesManager.get("com.sun.identity.crl.cache.directory.host", null);
            dirServerPort = SystemPropertiesManager.get("com.sun.identity.crl.cache.directory.port", "389");
            dirUseSSL = SystemPropertiesManager.get("com.sun.identity.crl.cache.directory.ssl", "false");
            dirPrincipleUser = SystemPropertiesManager.get("com.sun.identity.crl.cache.directory.user", null);
            dirPrinciplePasswd = AMPasswordUtil.decrypt(SystemPropertiesManager.get("com.sun.identity.crl.cache.directory.password", null));
            dirStartSearchLoc = SystemPropertiesManager.get("com.sun.identity.crl.cache.directory.searchloc", null);
            crlSearchAttr = SystemPropertiesManager.get("com.sun.identity.crl.cache.directory.searchattr", "CN");
            try {
                ldapParams = AMCertStore.setLdapStoreParam(dirServerHost, Integer.valueOf(dirServerPort), dirPrincipleUser, dirPrinciplePasswd, dirStartSearchLoc, null, dirUseSSL.equalsIgnoreCase("true"));
            }
            catch (Exception e) {
                debug.error("Unable to configure ldap CRL cache " + e);
            }
            if (debug.messageEnabled()) {
                debug.message("CRLValidator : Directory Server Host : " + dirServerHost);
                debug.message("CRLValidator : Directory Server Port# : " + dirServerPort);
                debug.message("CRLValidator : SSL Enabled : " + dirUseSSL);
                debug.message("CRLValidator : Principal User : " + dirPrincipleUser);
                if (dirPrinciplePasswd != null) {
                    debug.message("CRLValidator : User Password : xxxxxx");
                } else {
                    debug.message("CRLValidator : User Password : null");
                }
                debug.message("CRLValidator : Start Search Loc : " + dirStartSearchLoc);
                debug.message("CRLValidator : CRL Search Attr : " + crlSearchAttr);
            }
        }
    }
}

