/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.soapbinding;

import com.sun.identity.saml2.assertion.Assertion;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.EncryptedAssertion;
import com.sun.identity.saml2.assertion.Issuer;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.jaxb.entityconfig.XACMLAuthzDecisionQueryConfigElement;
import com.sun.identity.saml2.jaxb.metadata.XACMLAuthzDecisionQueryDescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.XACMLAuthzServiceElement;
import com.sun.identity.saml2.jaxb.metadata.XACMLPDPDescriptorElement;
import com.sun.identity.saml2.key.KeyUtil;
import com.sun.identity.saml2.logging.LogUtil;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.RequestAbstract;
import com.sun.identity.saml2.protocol.Response;
import com.sun.identity.saml2.protocol.impl.ResponseImpl;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.jaxrpc.SOAPClient;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.xacml.saml2.XACMLAuthzDecisionQuery;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QueryClient {
    public static Debug debug = Debug.getInstance("querySAML2");
    private static SAML2MetaManager saml2MetaManager = null;

    private QueryClient() {
    }

    public static Response processXACMLQuery(RequestAbstract request, String pepEntityID, String pdpEntityID) throws SAML2Exception {
        XACMLAuthzDecisionQuery xacmlQuery;
        String classMethod = "QueryClient:processXACMLQuery";
        String realm = "/";
        Response samlResponse = null;
        Response response = null;
        if (pepEntityID == null || pepEntityID.length() == 0) {
            debug.error(classMethod + "PEP Identifier is null");
            String[] data = new String[]{pepEntityID};
            LogUtil.error(Level.INFO, "INVALID_PEP_ID", data);
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullPEP"));
        }
        if (pdpEntityID == null || pdpEntityID.length() == 0) {
            debug.error(classMethod + "PDP Identifier is null");
            String[] data = new String[]{pdpEntityID};
            LogUtil.error(Level.INFO, "INVALID_PDP_ID", data);
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullPDP"));
        }
        if (request != null && (xacmlQuery = (XACMLAuthzDecisionQuery)request) != null) {
            Issuer issuer = QueryClient.createIssuer(pepEntityID);
            xacmlQuery.setIssuer(issuer);
            String requestID = SAML2SDKUtils.generateID();
            xacmlQuery.setID(requestID);
            xacmlQuery.setVersion("2.0");
            xacmlQuery.setIssueInstant(new Date());
            String xmlString = xacmlQuery.toXMLString(true, true);
            if (debug.messageEnabled()) {
                debug.message(classMethod + "XACML Query XML String :" + xmlString);
                String endPoint = null;
                XACMLAuthzDecisionQueryConfigElement pepConfig = QueryClient.getPEPConfig(realm, pepEntityID);
                endPoint = QueryClient.getPDPEndPoint(pdpEntityID);
                if (debug.messageEnabled()) {
                    debug.message(classMethod + " ResponseLocation is :" + endPoint);
                }
                try {
                    boolean isTrusted;
                    String line;
                    String soapMessage = SAML2SDKUtils.createSOAPMessageString(xmlString);
                    endPoint = SAML2SDKUtils.fillInBasicAuthInfo(pepConfig, endPoint);
                    String[] urls = new String[]{endPoint};
                    SOAPClient soapClient = new SOAPClient(urls);
                    if (debug.messageEnabled()) {
                        debug.message(classMethod + "soapMessage :" + soapMessage);
                    }
                    InputStream soapIn = soapClient.call(soapMessage, null, null);
                    StringBuffer reply = new StringBuffer();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(soapIn, "UTF-8"));
                    while ((line = reader.readLine()) != null) {
                        reply.append(line).append("\n");
                    }
                    xmlString = reply.toString();
                    if (debug.messageEnabled()) {
                        debug.message("Response Message:\n" + xmlString);
                    }
                    samlResponse = QueryClient.getSAMLResponse(xmlString);
                    issuer = samlResponse.getIssuer();
                    String issuerID = null;
                    if (issuer != null) {
                        issuerID = issuer.getValue().trim();
                    }
                    if (!(isTrusted = QueryClient.verifyResponseIssuer(realm, pepEntityID, issuerID))) {
                        if (debug.messageEnabled()) {
                            debug.message(classMethod + "Issuer in Request is not valid.");
                        }
                        String[] args = new String[]{realm, pepEntityID, pdpEntityID};
                        LogUtil.error(Level.INFO, "INVALID_ISSUER_IN_PEP_REQUEST", args);
                        throw new SAML2Exception("invalidIssuerInRequest");
                    }
                    if (samlResponse != null) {
                        xmlString = samlResponse.toXMLString(true, true);
                        if (debug.messageEnabled()) {
                            debug.message(classMethod + "Response: " + xmlString);
                        }
                        response = QueryClient.verifyResponse(realm, pepEntityID, samlResponse);
                        if (debug.messageEnabled()) {
                            debug.message(classMethod + "Response with decrypted Assertion: " + response.toXMLString(true, true));
                        }
                    }
                }
                catch (SOAPException soae) {
                    if (debug.messageEnabled()) {
                        debug.message(classMethod + "SOAPException :", soae);
                    }
                    throw new SAML2Exception(soae.getMessage());
                }
                catch (Exception e) {
                    if (debug.messageEnabled()) {
                        debug.message(classMethod + "Exception ", e);
                    }
                    throw new SAML2Exception(e.getMessage());
                }
            }
        }
        return response;
    }

    private static Issuer createIssuer(String entityID) throws SAML2Exception {
        Issuer issuer = AssertionFactory.getInstance().createIssuer();
        issuer.setValue(entityID);
        return issuer;
    }

    private static Response getSAMLResponse(String xmlString) throws IOException, SAML2Exception {
        String classMethod = "QueryClient:getSAMLResponse";
        if (xmlString == null || xmlString.length() == 0) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullResponse"));
        }
        if (debug.messageEnabled()) {
            debug.message(classMethod + "Response String : " + xmlString);
        }
        Response samlResponse = null;
        Document doc = XMLUtils.toDOMDocument(xmlString, debug);
        Element root = doc.getDocumentElement();
        String rootName = root.getLocalName();
        if (!rootName.equals("Envelope") || !root.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            SAML2SDKUtils.debug.error("Wrong Envelope tag or namespace.");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("serverError"));
        }
        NodeList nodes = root.getChildNodes();
        int nodeCount = nodes.getLength();
        if (nodeCount <= 0) {
            SAML2SDKUtils.debug.error("Envelope does not contain a SOAP body.");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingSOAPBody"));
        }
        String tagName = null;
        String ctagName = null;
        Node currentNode = null;
        Node cnode = null;
        block0: for (int i = 0; i < nodeCount; ++i) {
            currentNode = nodes.item(i);
            if (currentNode.getNodeType() != 1) continue;
            tagName = currentNode.getLocalName();
            if (tagName == null || tagName.length() == 0) {
                SAML2SDKUtils.debug.error(classMethod + "Child element is missing tag name");
                throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingChildTagName"));
            }
            if (tagName.equals("Body")) {
                NodeList cNodes = currentNode.getChildNodes();
                int cnodeCount = cNodes.getLength();
                for (int j = 0; j < cnodeCount; ++j) {
                    cnode = cNodes.item(j);
                    if (cnode.getNodeType() != 1) continue;
                    ctagName = cnode.getLocalName();
                    if (ctagName == null || ctagName.length() == 0) {
                        SAML2SDKUtils.debug.error("Missing tag name of child element of <SOAP-ENV:Body>");
                        throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingChildTagName"));
                    }
                    if (ctagName.equals("Fault")) {
                        SAML2SDKUtils.debug.error("SOAPFault error.");
                        throw new SAML2Exception(XMLUtils.print(cnode));
                    }
                    if (ctagName.equals("Response")) {
                        samlResponse = ProtocolFactory.getInstance().createResponse((Element)cnode);
                        continue block0;
                    }
                    SAML2SDKUtils.debug.error("Invalid child  element in SOAPBody");
                    throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalidSOAPBody"));
                }
                continue;
            }
            if (tagName.equals("Header")) {
                if (!SAML2SDKUtils.debug.messageEnabled()) continue;
                SAML2SDKUtils.debug.message("SOAP Header in Response");
                continue;
            }
            SAML2SDKUtils.debug.error("Invalid element in Envelope");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalidSOAPElement"));
        }
        return samlResponse;
    }

    private static boolean verifyResponseIssuer(String realm, String pepEntityID, String pdpEntityID) throws SAML2Exception {
        boolean isTrusted = false;
        try {
            isTrusted = saml2MetaManager.isTrustedXACMLProvider(realm, pepEntityID, pdpEntityID, "PEPRole");
        }
        catch (SAML2MetaException sme) {
            debug.error("Error retreiving meta", sme);
        }
        return isTrusted;
    }

    private static String getPDPEndPoint(String pdpEntityID) throws SAML2Exception {
        String endPoint = null;
        String classMethod = "QueryClient:getPDPEndPoint";
        if (saml2MetaManager != null) {
            try {
                Object o;
                Iterator i;
                List xacmlPDP;
                XACMLPDPDescriptorElement pdpDescriptor = saml2MetaManager.getPolicyDecisionPointDescriptor(null, pdpEntityID);
                if (pdpDescriptor != null && (xacmlPDP = pdpDescriptor.getXACMLAuthzService()) != null && (i = xacmlPDP.iterator()).hasNext() && (o = i.next()) instanceof XACMLAuthzServiceElement) {
                    XACMLAuthzServiceElement xType = (XACMLAuthzServiceElement)o;
                    endPoint = xType.getLocation();
                    if (debug.messageEnabled()) {
                        debug.message(classMethod + "EndPoint :" + endPoint);
                    }
                }
            }
            catch (SAML2MetaException sme) {
                if (debug.messageEnabled()) {
                    debug.message(classMethod + "Error retreiving PDP Meta", sme);
                }
                Object[] args = new String[]{pdpEntityID};
                LogUtil.error(Level.INFO, "PDP_METADATA_ERROR", (String[])args);
                throw new SAML2Exception("libSAML2", "pdpMetaRetreivalError", args);
            }
        }
        return endPoint;
    }

    private static XACMLAuthzDecisionQueryConfigElement getPEPConfig(String realm, String pepEntityID) throws SAML2Exception {
        XACMLAuthzDecisionQueryConfigElement pepConfig = null;
        String classMethod = "QueryClient:getPEPConfig";
        if (saml2MetaManager != null) {
            try {
                pepConfig = saml2MetaManager.getPolicyEnforcementPointConfig(realm, pepEntityID);
            }
            catch (SAML2MetaException sme) {
                if (debug.messageEnabled()) {
                    debug.message(classMethod + "Error retreiving PEP meta", sme);
                }
                Object[] args = new String[]{pepEntityID};
                LogUtil.error(Level.INFO, "PEP_METADATA_ERROR", (String[])args);
                throw new SAML2Exception("libSAML2", "pepMetaRetreivalError", args);
            }
        }
        return pepConfig;
    }

    private static Response verifyResponse(String realm, String pepEntityID, Response samlResponse) throws SAML2Exception {
        Response response = samlResponse;
        String classMethod = "QueryClient:verifyResponse";
        if (samlResponse != null) {
            Issuer issuer = samlResponse.getIssuer();
            String issuerID = null;
            if (issuer != null) {
                issuerID = issuer.getValue().trim();
            }
            String pdpEntityID = issuerID;
            boolean isTrusted = QueryClient.verifyResponseIssuer(realm, pepEntityID, issuerID);
            if (!isTrusted) {
                if (debug.messageEnabled()) {
                    debug.message(classMethod + "Issuer in Request is not valid.");
                }
                Object[] args = new String[]{realm, pepEntityID, issuerID};
                LogUtil.error(Level.INFO, "INVALID_ISSUER_IN_PEP_REQUEST", (String[])args);
                throw new SAML2Exception("libSAML2", "invalidIssuer", args);
            }
            QueryClient.verifySignedResponse(pepEntityID, samlResponse);
            try {
                XACMLAuthzDecisionQueryConfigElement pepConfig = saml2MetaManager.getPolicyEnforcementPointConfig(realm, pepEntityID);
                String assertionEncrypted = QueryClient.getAttributeValueFromPEPConfig(pepConfig, "wantAssertionEncrypted");
                boolean wantAssertionEncrypted = assertionEncrypted != null && assertionEncrypted.equalsIgnoreCase("true");
                boolean wantAssertionSigned = QueryClient.wantAssertionSigned(realm, pepEntityID);
                String respID = samlResponse.getID();
                ArrayList<Assertion> assertions = samlResponse.getAssertion();
                if (wantAssertionEncrypted && assertions != null && assertions.size() != 0) {
                    String[] data = new String[]{issuerID, respID};
                    LogUtil.error(Level.INFO, "ASSERTION_FROM_PDP_NOT_ENCRYPTED", data);
                    throw new SAML2Exception(SAML2SDKUtils.bundle.getString("assertionNotEncrypted"));
                }
                PrivateKey decryptionKey = null;
                List encAssertions = samlResponse.getEncryptedAssertion();
                Object decAssertions = null;
                if (encAssertions != null) {
                    Iterator encIter = encAssertions.iterator();
                    while (encIter.hasNext()) {
                        if (decryptionKey == null) {
                            decryptionKey = KeyUtil.getDecryptionKey(pepConfig);
                        }
                        Assertion assertion = ((EncryptedAssertion)encIter.next()).decrypt(decryptionKey);
                        if (assertions == null) {
                            assertions = new ArrayList<Assertion>();
                        }
                        assertions.add(assertion);
                    }
                }
                if (assertions == null || assertions.size() == 0) {
                    if (debug.messageEnabled()) {
                        debug.message(classMethod + "no assertion in the Response.");
                    }
                    String[] data = new String[]{issuerID, respID};
                    LogUtil.error(Level.INFO, "MISSING_ASSERTION_IN_PDP_RESPONSE", data);
                    throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingAssertion"));
                }
                Iterator assertionIter = assertions.iterator();
                X509Certificate cert = null;
                XACMLPDPDescriptorElement pdpDesc = null;
                if (wantAssertionSigned) {
                    pdpDesc = saml2MetaManager.getPolicyDecisionPointDescriptor(realm, pdpEntityID);
                    cert = KeyUtil.getPDPVerificationCert(pdpDesc, pdpEntityID);
                }
                while (assertionIter.hasNext()) {
                    Assertion assertion = (Assertion)assertionIter.next();
                    String assertionID = assertion.getID();
                    String assertionIssuer = assertion.getIssuer().getValue().trim();
                    isTrusted = QueryClient.verifyResponseIssuer(realm, pepEntityID, assertionIssuer);
                    if (!isTrusted) {
                        debug.error(classMethod + "Assertion's source site is not valid.");
                        String[] data = new String[]{assertionIssuer, assertionID};
                        LogUtil.error(Level.INFO, "INVALID_ISSUER_IN_ASSERTION_FROM_PDP", data);
                        throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalidIssuerInAssertion"));
                    }
                    String respIssuer = samlResponse.getIssuer().getValue().trim();
                    if (!respIssuer.equals(assertionIssuer)) {
                        if (debug.messageEnabled()) {
                            debug.message(classMethod + "Issuer in Assertion " + assertionIssuer + "doesn't match the Issuer in Response." + respIssuer);
                        }
                        String[] data = new String[]{pdpEntityID, assertionIssuer};
                        LogUtil.error(Level.INFO, "MISMATCH_ISSUER_IN_ASSERTION_FROM_PDP", data);
                        throw new SAML2Exception(SAML2SDKUtils.bundle.getString("mismatchIssuer"));
                    }
                    if (!wantAssertionSigned) continue;
                    if (debug.messageEnabled()) {
                        debug.message(classMethod + "wantAssertionSigned " + wantAssertionSigned);
                    }
                    if (assertion.isSigned() && assertion.isSignatureValid(cert)) continue;
                    debug.error(classMethod + "Assertion is not signed or signature " + "is not valid.");
                    String[] data = new String[]{assertionIssuer, assertionID};
                    LogUtil.error(Level.INFO, "INVALID_SIGNATURE_ASSERTION_FROM_PDP", data);
                    throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalidSignatureOnAssertion"));
                }
                if (wantAssertionEncrypted) {
                    response = QueryClient.createResponse(samlResponse, assertions);
                }
                if (debug.messageEnabled()) {
                    debug.message(classMethod + " Response : " + response.toXMLString(true, true));
                }
            }
            catch (SAML2MetaException sme) {
                if (debug.messageEnabled()) {
                    debug.message(classMethod + "Error retreiving meta", sme);
                }
                throw new SAML2Exception(SAML2SDKUtils.bundle.getString("metaDataError"));
            }
        }
        return response;
    }

    private static Response createResponse(Response samlResponse, List assertions) throws SAML2Exception {
        ResponseImpl response = new ResponseImpl();
        response.setVersion(samlResponse.getVersion());
        response.setIssueInstant(samlResponse.getIssueInstant());
        response.setID(samlResponse.getID());
        response.setInResponseTo(samlResponse.getInResponseTo());
        response.setIssuer(samlResponse.getIssuer());
        response.setDestination(samlResponse.getDestination());
        response.setExtensions(samlResponse.getExtensions());
        response.setConsent(samlResponse.getConsent());
        response.setStatus(samlResponse.getStatus());
        response.setAssertion(assertions);
        return response;
    }

    private static String getAttributeValueFromPEPConfig(XACMLAuthzDecisionQueryConfigElement pepConfig, String attrName) throws SAML2MetaException {
        List value;
        String classMethod = "QueryClient:getAttributeValueFromPEPConfig:";
        if (debug.messageEnabled()) {
            debug.message(classMethod + "attrName : " + attrName);
        }
        String result = null;
        Map attrs = SAML2MetaUtils.getAttributes(pepConfig);
        if (attrs != null && (value = (List)attrs.get(attrName)) != null && value.size() != 0) {
            result = (String)value.get(0);
        }
        if (debug.messageEnabled()) {
            debug.message(classMethod + "Attribute value is : " + result);
        }
        return result;
    }

    private static boolean wantAssertionSigned(String realm, String pepEntityID) throws SAML2MetaException {
        XACMLAuthzDecisionQueryDescriptorElement pepDescriptor = saml2MetaManager.getPolicyEnforcementPointDescriptor(realm, pepEntityID);
        return pepDescriptor.isWantAssertionsSigned();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean verifySignedResponse(String pepEntityID, Response response) throws SAML2Exception {
        X509Certificate signingCert;
        String classMethod = "QueryClient:verifySignedResponse: ";
        String realm = "/";
        XACMLAuthzDecisionQueryConfigElement pepConfig = QueryClient.getPEPConfig(realm, pepEntityID);
        String wantResponseSigned = QueryClient.getAttributeValueFromPEPConfig(pepConfig, "wantXACMLAuthzDecisionResponseSigned");
        boolean valid = false;
        if (wantResponseSigned != null && wantResponseSigned.equalsIgnoreCase("true")) {
            XACMLAuthzDecisionQueryDescriptorElement pepDescriptor = saml2MetaManager.getPolicyEnforcementPointDescriptor(null, pepEntityID);
            signingCert = KeyUtil.getPEPVerificationCert(pepDescriptor, pepEntityID);
            if (signingCert == null) {
                debug.error(classMethod + "Incorrect configuration for Signing Certificate.");
                throw new SAML2Exception(SAML2SDKUtils.bundle.getString("metaDataError"));
            }
        } else {
            if (!debug.messageEnabled()) return true;
            debug.message(classMethod + "Response doesn't need to be verified.");
            return true;
        }
        valid = response.isSignatureValid(signingCert);
        if (!debug.messageEnabled()) return valid;
        debug.message(classMethod + "Signature is valid :" + valid);
        return valid;
    }

    static {
        try {
            saml2MetaManager = new SAML2MetaManager();
        }
        catch (SAML2MetaException sme) {
            debug.error("Error retreiving metadata", sme);
        }
    }
}

