/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.protocol.impl;

import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.protocol.Artifact;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Element;

public class ArtifactImpl
implements Artifact {
    private String artifact = null;
    private String messageHandle = null;
    private String sourceID = null;
    private byte[] typeCode = null;
    private int endpointIndex = -1;
    static final int ARTIFACT_4_LENGTH = 44;
    static final byte ARTIFACT_4_TYPE_CODE_BYTE1 = 0;
    static final byte ARTIFACT_4_TYPE_CODE_BYTE2 = 4;
    static final byte[] ARTIFACT_4_TYPE_CODE = new byte[]{0, 4};

    private void parseElement(Element element) throws SAML2Exception {
        if (element == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ArtifactImpl.parseElement: Input is null.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullInput"));
        }
        String tag = element.getLocalName();
        if (tag == null || !tag.equals("Artifact")) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ArtifactImpl.parseElement: not Artifact.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
        }
        String value = XMLUtils.getElementValue(element);
        this.parseArtifactValue(value);
    }

    private void parseArtifactValue(String value) throws SAML2Exception {
        String method = "ArtifactImpl.parseArtifactValue: ";
        if (value == null || value.length() == 0) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message(method + "empty input.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullInput"));
        }
        byte[] raw = null;
        try {
            raw = Base64.decode(value);
        }
        catch (Exception e) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ArtifactImpl.parseElement: exception occured while decoding artifact:", e);
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
        }
        if (raw.length != 44) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ArtifactImpl.parseElement: the length is not 44:" + raw.length);
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
        }
        if (raw[0] != 0 || raw[1] != 4) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ArtifactImpl.parseElement: wrong typecode.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
        }
        this.typeCode = ARTIFACT_4_TYPE_CODE;
        this.artifact = value;
        byte[] endpointIndexB = new byte[2];
        byte[] sBytes = new byte[20];
        byte[] mBytes = new byte[20];
        System.arraycopy(raw, 2, endpointIndexB, 0, 2);
        System.arraycopy(raw, 4, sBytes, 0, 20);
        System.arraycopy(raw, 24, mBytes, 0, 20);
        try {
            this.sourceID = SAML2SDKUtils.byteArrayToString(sBytes);
            this.messageHandle = SAML2SDKUtils.byteArrayToString(mBytes);
        }
        catch (Exception e) {
            SAML2SDKUtils.debug.error("ArtifactImpl.parseElement: encoding exception: ", e);
            this.sourceID = new String(sBytes);
            this.messageHandle = new String(mBytes);
        }
        this.endpointIndex = SAML2SDKUtils.twoBytesToInt(endpointIndexB);
    }

    private ArtifactImpl() {
    }

    public ArtifactImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
    }

    public ArtifactImpl(String encodedArtifactValue) throws SAML2Exception {
        this.parseArtifactValue(encodedArtifactValue);
    }

    public ArtifactImpl(byte[] typecode, int endpointindex, String sourceid, String messagehandle) throws SAML2Exception {
        if (typecode != null && (typecode.length != 2 || typecode[0] != 0 || typecode[1] != 4)) {
            SAML2SDKUtils.debug.error("ArtifactImpl: wrong typecode.");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
        }
        this.typeCode = ARTIFACT_4_TYPE_CODE;
        if (sourceid == null) {
            SAML2SDKUtils.debug.error("ArtifactImpl: null sourceID.");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullInput"));
        }
        this.sourceID = sourceid;
        this.messageHandle = messagehandle == null ? SAML2SDKUtils.generateMessageHandle() : messagehandle;
        byte[] idBytes = null;
        byte[] handleBytes = null;
        try {
            idBytes = SAML2SDKUtils.stringToByteArray(this.sourceID);
            handleBytes = SAML2SDKUtils.stringToByteArray(this.messageHandle);
        }
        catch (Exception e) {
            SAML2SDKUtils.debug.error("ArtifactImpl: encoding exception: ", e);
            idBytes = this.sourceID.getBytes();
            handleBytes = this.messageHandle.getBytes();
        }
        if (idBytes.length != 20 || handleBytes.length != 20) {
            SAML2SDKUtils.debug.error("ArtifactImpl: wrong input length.");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
        }
        byte[] indexArray = SAML2SDKUtils.intToTwoBytes(endpointindex);
        this.endpointIndex = endpointindex;
        byte[] raw = new byte[44];
        raw[0] = 0;
        raw[1] = 4;
        raw[2] = indexArray[0];
        raw[3] = indexArray[1];
        for (int i = 0; i < 20; ++i) {
            raw[4 + i] = idBytes[i];
            raw[24 + i] = handleBytes[i];
        }
        try {
            this.artifact = Base64.encode(raw).trim();
        }
        catch (Exception e) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ArtifactImpl: exception encode input:", e);
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorCreateArtifact"));
        }
    }

    public String getArtifactValue() {
        return this.artifact;
    }

    public String getSourceID() {
        return this.sourceID;
    }

    public String getMessageHandle() {
        return this.messageHandle;
    }

    public byte[] getTypeCode() {
        return this.typeCode;
    }

    public int getEndpointIndex() {
        return this.endpointIndex;
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws SAML2Exception {
        if (this.artifact == null || this.artifact.trim().length() == 0) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ArtifactImpl.toXMLString: artifact value is empty");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingElementValue"));
        }
        StringBuffer xml = new StringBuffer(200);
        String prefix = "";
        if (includeNS) {
            prefix = "samlp:";
        }
        String uri = "";
        if (declareNS) {
            uri = " xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\"";
        }
        xml.append("<").append(prefix).append("Artifact").append(uri).append(">").append(this.artifact).append("</").append(prefix).append("Artifact>");
        return xml.toString();
    }
}

