/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.assertion.impl;

import com.sun.identity.saml2.assertion.BaseID;
import com.sun.identity.saml2.assertion.impl.BaseIDAbstractImpl;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BaseIDImpl
extends BaseIDAbstractImpl
implements BaseID {
    public static final String BASE_ID_ELEMENT = "BaseID";
    public static final String NAME_QUALIFIER_ATTR = "NameQualifier";
    public static final String SP_NAME_QUALIFIER_ATTR = "SPNameQualifier";

    public BaseIDImpl() {
    }

    public BaseIDImpl(String xml) throws SAML2Exception {
        Document document = XMLUtils.toDOMDocument(xml, SAML2SDKUtils.debug);
        if (document == null) {
            SAML2SDKUtils.debug.error("BaseIDImpl.processElement(): invalid XML input");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        Element rootElement = document.getDocumentElement();
        this.processElement(rootElement);
        this.makeImmutable();
    }

    public BaseIDImpl(Element element) throws SAML2Exception {
        this.processElement(element);
        this.makeImmutable();
    }

    private void processElement(Element element) throws SAML2Exception {
        if (element == null) {
            SAML2SDKUtils.debug.error("BaseIDImpl.processElement(): invalid root element");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalid_assertion_element"));
        }
        String elemName = element.getLocalName();
        if (elemName == null) {
            SAML2SDKUtils.debug.error("BaseIDImpl.processElement(): local name missing");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missing_local_name"));
        }
        if (!elemName.equals(BASE_ID_ELEMENT)) {
            SAML2SDKUtils.debug.error("BaseIDImpl.processElement(): invalid local name " + elemName);
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalid_local_name"));
        }
        String attrValue = element.getAttribute(NAME_QUALIFIER_ATTR);
        if (attrValue != null) {
            this.setNameQualifier(attrValue);
        }
        if ((attrValue = element.getAttribute(SP_NAME_QUALIFIER_ATTR)) != null) {
            this.setSPNameQualifier(attrValue);
        }
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        String spnq;
        StringBuffer sb = new StringBuffer(2000);
        String NS = "";
        String appendNS = "";
        if (declareNS) {
            NS = " xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\"";
        }
        if (includeNSPrefix) {
            appendNS = "saml:";
        }
        sb.append("<").append(appendNS).append(BASE_ID_ELEMENT).append(NS);
        String nq = this.getNameQualifier();
        if (nq != null) {
            sb.append(" ").append(NAME_QUALIFIER_ATTR).append("=\"").append(nq).append("\"");
        }
        if ((spnq = this.getSPNameQualifier()) != null) {
            sb.append(" ").append(SP_NAME_QUALIFIER_ATTR).append("=\"").append(spnq).append("\"");
        }
        sb.append(" />");
        return sb.toString();
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }
}

