/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.xmlsig;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml.xmlsig.SignatureProvider;
import com.sun.identity.saml.xmlsig.XMLSignatureException;
import java.security.cert.Certificate;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLSignatureManager {
    protected static XMLSignatureManager instance = null;
    private SignatureProvider sp = null;

    protected XMLSignatureManager() {
        try {
            String sprovider = SystemConfigurationUtil.getProperty("com.sun.identity.saml.xmlsig.signatureprovider.class", "com.sun.identity.saml.xmlsig.AMSignatureProvider");
            this.sp = (SignatureProvider)Class.forName(sprovider).newInstance();
        }
        catch (Exception e) {
            SAMLUtilsCommon.debug.error("XMLSignatureManager: constructor error");
        }
    }

    protected XMLSignatureManager(KeyProvider keyProvider, SignatureProvider sigProvider) {
        sigProvider.initialize(keyProvider);
        this.sp = sigProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLSignatureManager getInstance() {
        if (instance == null) {
            Class clazz = XMLSignatureManager.class;
            synchronized (clazz) {
                if (instance == null) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Constructing a new instance of XMLSignatureManager");
                    }
                    instance = new XMLSignatureManager();
                }
            }
        }
        return instance;
    }

    public static XMLSignatureManager getInstance(KeyProvider keyProvider, SignatureProvider sigProvider) {
        return new XMLSignatureManager(keyProvider, sigProvider);
    }

    public Element signXML(Document doc, String certAlias) throws XMLSignatureException {
        return this.sp.signXML(doc, certAlias);
    }

    public Element signXML(Document doc, String certAlias, String algorithm) throws XMLSignatureException {
        return this.sp.signXML(doc, certAlias, algorithm);
    }

    public String signXML(String XML, String certAlias) throws XMLSignatureException {
        return this.sp.signXML(XML, certAlias);
    }

    public String signXML(String XML, String certAlias, String algorithm) throws XMLSignatureException {
        return this.sp.signXML(XML, certAlias, algorithm);
    }

    public Element signXML(Document doc, String certAlias, String algorithm, String id) throws XMLSignatureException {
        return this.sp.signXML(doc, certAlias, algorithm, id);
    }

    public Element signXML(Document doc, String certAlias, String algorithm, String id, String xpath) throws XMLSignatureException {
        return this.sp.signXML(doc, certAlias, algorithm, id, xpath);
    }

    public Element signXML(Document doc, String certAlias, String algorithm, String idAttrName, String id, boolean includeCert) throws XMLSignatureException {
        return this.sp.signXML(doc, certAlias, algorithm, idAttrName, id, includeCert);
    }

    public String signXML(String xmlString, String certAlias, String algorithm, String idAttrName, String id, boolean includeCert) throws XMLSignatureException {
        return this.sp.signXML(xmlString, certAlias, algorithm, idAttrName, id, includeCert);
    }

    public Element signXML(Document doc, String certAlias, String algorithm, String idAttrName, String id, boolean includeCert, String xpath) throws XMLSignatureException {
        return this.sp.signXML(doc, certAlias, algorithm, idAttrName, id, includeCert, xpath);
    }

    public String signXML(String xmlString, String certAlias, String algorithm, String id) throws XMLSignatureException {
        return this.sp.signXML(xmlString, certAlias, algorithm, id);
    }

    public Element signXML(Document doc, String certAlias, String algorithm, List ids) throws XMLSignatureException {
        return this.sp.signXML(doc, certAlias, algorithm, ids);
    }

    public String signXML(String xmlString, String certAlias, String algorithm, List ids) throws XMLSignatureException {
        return this.sp.signXML(xmlString, certAlias, algorithm, ids);
    }

    public Element signXML(Document doc, String certAlias, String algorithm, String transformAlag, List ids) throws XMLSignatureException {
        return this.sp.signXML(doc, certAlias, algorithm, transformAlag, ids);
    }

    public Element signWithWSSSAMLTokenProfile(Document doc, Certificate cert, String assertionID, String algorithm, List ids) throws XMLSignatureException {
        return this.sp.signWithWSSSAMLTokenProfile(doc, cert, assertionID, algorithm, ids);
    }

    public Element signWithWSSSAMLTokenProfile(Document doc, Certificate cert, String assertionID, String algorithm, List ids, String wsfVersion) throws XMLSignatureException {
        return this.sp.signWithWSSSAMLTokenProfile(doc, cert, assertionID, algorithm, ids, wsfVersion);
    }

    public Element signWithSAMLToken(Document doc, Certificate cert, String assertionID, String algorithm, List ids) throws XMLSignatureException {
        return this.sp.signWithSAMLToken(doc, cert, assertionID, algorithm, ids);
    }

    public Element signWithBinarySecurityToken(Document doc, Certificate cert, String algorithm, List ids) throws XMLSignatureException {
        return this.sp.signWithBinarySecurityToken(doc, cert, algorithm, ids);
    }

    public Element signWithUserNameToken(Document doc, Certificate cert, String algorithm, List ids) throws XMLSignatureException {
        return this.sp.signWithUserNameToken(doc, cert, algorithm, ids);
    }

    public Element signWithWSSX509TokenProfile(Document doc, Certificate cert, String algorithm, List ids) throws XMLSignatureException {
        return this.sp.signWithWSSX509TokenProfile(doc, cert, algorithm, ids);
    }

    public Element signWithWSSX509TokenProfile(Document doc, Certificate cert, String algorithm, List ids, String wsfVersion) throws XMLSignatureException {
        return this.sp.signWithWSSX509TokenProfile(doc, cert, algorithm, ids, wsfVersion);
    }

    public boolean verifyXMLSignature(Document document) throws XMLSignatureException {
        return this.sp.verifyXMLSignature(document);
    }

    public boolean verifyXMLSignature(Document document, String certAlias) throws XMLSignatureException {
        return this.sp.verifyXMLSignature(document, certAlias);
    }

    public boolean verifyXMLSignature(Document document, Certificate cert) throws XMLSignatureException {
        return this.sp.verifyXMLSignature(document, cert);
    }

    public boolean verifyXMLSignature(Element element) throws XMLSignatureException {
        return this.sp.verifyXMLSignature(element);
    }

    public boolean verifyXMLSignature(Element element, String certAlias) throws XMLSignatureException {
        return this.sp.verifyXMLSignature(element, certAlias);
    }

    public boolean verifyXMLSignature(Element element, String idAttrName, String certAlias) throws XMLSignatureException {
        return this.sp.verifyXMLSignature(element, idAttrName, certAlias);
    }

    public boolean verifyXMLSignature(String XML) throws XMLSignatureException {
        return this.sp.verifyXMLSignature(XML);
    }

    public boolean verifyXMLSignature(String XML, String certAlias) throws XMLSignatureException {
        return this.sp.verifyXMLSignature(XML, certAlias);
    }

    public boolean verifyXMLSignature(String xmlString, String idAttrName, String certAlias) throws XMLSignatureException {
        return this.sp.verifyXMLSignature(xmlString, idAttrName, certAlias);
    }

    public boolean verifyXMLSignature(String wsfVersion, String certAlias, Document document) throws XMLSignatureException {
        return this.sp.verifyXMLSignature(wsfVersion, certAlias, document);
    }

    public boolean verifyWSSSignature(Document document, String certAlias) throws XMLSignatureException {
        return this.sp.verifyWSSSignature(document, certAlias);
    }

    public KeyProvider getKeyProvider() {
        return this.sp.getKeyProvider();
    }
}

