/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.protocol;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequestVersionTooHighException;
import com.sun.identity.saml.common.SAMLRequestVersionTooLowException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.SAMLVersionMismatchException;
import com.sun.identity.saml.protocol.AbstractResponse;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Response
extends AbstractResponse {
    protected Status status = null;
    protected List assertions = Collections.EMPTY_LIST;
    protected String xmlString = null;
    protected String signatureString = null;
    protected String issuer = null;
    private static final String RESPONSE_ID_ATTRIBUTE = "ResponseID";

    protected Response() {
    }

    public boolean isSignatureValid() {
        if (this.signed & !this.validationDone) {
            this.valid = SAMLUtils.checkSignatureValid(this.xmlString, RESPONSE_ID_ATTRIBUTE, this.issuer);
            this.validationDone = true;
        }
        return this.valid;
    }

    public void signXML() throws SAMLException {
        if (this.signed) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Response.signXML: the response is already signed.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("alreadySigned"));
        }
        String certAlias = SystemConfigurationUtil.getProperty("com.sun.identity.saml.xmlsig.certalias");
        if (certAlias == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Response.signXML: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(SAMLUtils.bundle.getString("cannotFindCertAlias"));
        }
        XMLSignatureManager manager = XMLSignatureManager.getInstance();
        if (this.majorVersion == 1 && this.minorVersion == 0) {
            SAMLUtils.debug.message("Request.signXML: sign with version 1.0");
            this.signatureString = manager.signXML(this.toString(true, true), certAlias);
            this.signature = XMLUtils.toDOMDocument(this.signatureString, SAMLUtils.debug).getDocumentElement();
        } else {
            Document doc = XMLUtils.toDOMDocument(this.toString(true, true), SAMLUtils.debug);
            this.signature = manager.signXML(doc, certAlias, null, RESPONSE_ID_ATTRIBUTE, this.getResponseID(), true, null);
            this.signatureString = XMLUtils.print(this.signature);
        }
        this.signed = true;
        this.xmlString = this.toString(true, true);
    }

    private void buildResponse(String responseID, String inResponseTo, Status status, String recipient, List contents) throws SAMLException {
        if (responseID == null || responseID.length() == 0) {
            this.responseID = SAMLUtils.generateID();
            if (this.responseID == null) {
                throw new SAMLRequesterException(SAMLUtils.bundle.getString("errorGenerateID"));
            }
        } else {
            this.responseID = responseID;
        }
        this.inResponseTo = inResponseTo;
        this.recipient = recipient;
        this.issueInstant = new Date();
        if (status == null) {
            SAMLUtils.debug.message("Response: missing <Status>.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
        this.status = status;
        if (contents != null && contents != Collections.EMPTY_LIST) {
            int length = contents.size();
            for (int i = 0; i < length; ++i) {
                Object temp = contents.get(i);
                if (temp instanceof Assertion) continue;
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Response: Wrong input for Assertion.");
                }
                throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
            }
            this.assertions = contents;
        }
    }

    public Response(String responseID, String inResponseTo, Status status, List contents) throws SAMLException {
        this.buildResponse(responseID, inResponseTo, status, null, contents);
    }

    public Response(String responseID, String inResponseTo, Status status, String recipient, List contents) throws SAMLException {
        this.buildResponse(responseID, inResponseTo, status, recipient, contents);
    }

    public Response(String responseID, Status status, String recipient, List contents) throws SAMLException {
        this.buildResponse(responseID, null, status, recipient, contents);
    }

    public Response(String responseID, Status status, List contents) throws SAMLException {
        this.buildResponse(responseID, null, status, null, contents);
    }

    public static Response parseXML(String xml) throws SAMLException {
        Document doc = XMLUtils.toDOMDocument(xml, SAMLUtils.debug);
        Element root = doc.getDocumentElement();
        return new Response(root);
    }

    public static Response parseXML(InputStream is) throws SAMLException {
        Document doc = XMLUtils.toDOMDocument(is, SAMLUtils.debug);
        Element root = doc.getDocumentElement();
        return new Response(root);
    }

    public Response(Element root) throws SAMLException {
        String instantString;
        if (root == null) {
            SAMLUtils.debug.message("Response(Element): null input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        String tag = null;
        tag = root.getLocalName();
        if (tag == null || !tag.equals("Response")) {
            SAMLUtils.debug.message("Response(Element): wrong input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        List signs = XMLUtils.getElementsByTagNameNS1(root, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        int signsSize = signs.size();
        if (signsSize == 1) {
            this.xmlString = XMLUtils.print(root);
            this.signed = true;
        } else if (signsSize != 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Response(Element): included more than one Signature element.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("moreElement"));
        }
        this.responseID = root.getAttribute(RESPONSE_ID_ATTRIBUTE);
        if (this.responseID == null || this.responseID.length() == 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Response.parseXML: Reponse doesn't have ResponseID.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute"));
        }
        if (root.hasAttribute("InResponseTo")) {
            this.inResponseTo = root.getAttribute("InResponseTo");
        }
        this.parseMajorVersion(root.getAttribute("MajorVersion"));
        this.parseMinorVersion(root.getAttribute("MinorVersion"));
        if (root.hasAttribute("Recipient")) {
            this.recipient = root.getAttribute("Recipient");
        }
        if ((instantString = root.getAttribute("IssueInstant")) == null || instantString.length() == 0) {
            SAMLUtils.debug.message("Response(Element): missing IssueInstant");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute"));
        }
        try {
            this.issueInstant = DateUtils.stringToDate(instantString);
        }
        catch (ParseException e) {
            SAMLUtils.debug.message("Resposne(Element): could not parse IssueInstant", e);
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        NodeList nl = root.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            String childName = child.getLocalName();
            if (childName == null) continue;
            if (childName.equals("Signature")) {
                this.signature = (Element)child;
                continue;
            }
            if (childName.equals("Status")) {
                if (this.status != null) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Response: included more than one <Status>");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("moreElement"));
                }
                this.status = new Status((Element)child);
                continue;
            }
            if (childName.equals("Assertion")) {
                if (this.assertions == Collections.EMPTY_LIST) {
                    this.assertions = new ArrayList();
                }
                Assertion oneAssertion = new Assertion((Element)child);
                this.issuer = oneAssertion.getIssuer();
                this.assertions.add(oneAssertion);
                continue;
            }
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Response: included wrong element:" + childName);
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        if (this.status == null) {
            SAMLUtils.debug.message("Response: missing element <Status>.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
        }
    }

    private void parseMajorVersion(String majorVer) throws SAMLException {
        try {
            this.majorVersion = Integer.parseInt(majorVer);
        }
        catch (NumberFormatException e) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Response(Element): invalid MajorVersion", e);
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        if (this.majorVersion != 1) {
            if (this.majorVersion > 1) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Response(Element):MajorVersion of the Response is too high.");
                }
                throw new SAMLVersionMismatchException(SAMLUtils.bundle.getString("responseVersionTooHigh"));
            }
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Response(Element):MajorVersion of the Response is too low.");
            }
            throw new SAMLVersionMismatchException(SAMLUtils.bundle.getString("responseVersionTooLow"));
        }
    }

    private void parseMinorVersion(String minorVer) throws SAMLException {
        try {
            this.minorVersion = Integer.parseInt(minorVer);
        }
        catch (NumberFormatException e) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Response(Element): invalid MinorVersion", e);
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        if (this.minorVersion > 1) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Response(Element): MinorVersion of the Response is too high.");
            }
            throw new SAMLRequestVersionTooHighException(SAMLUtils.bundle.getString("responseVersionTooHigh"));
        }
        if (this.minorVersion < 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Response(Element): MinorVersion of the Response is too low.");
            }
            throw new SAMLRequestVersionTooLowException(SAMLUtils.bundle.getString("responseVersionTooLow"));
        }
    }

    public List getAssertion() {
        return this.assertions;
    }

    public boolean addAssertion(Assertion assertion) {
        if (this.signed) {
            return false;
        }
        if (assertion == null) {
            return false;
        }
        if (this.assertions == null || this.assertions == Collections.EMPTY_LIST) {
            this.assertions = new ArrayList();
        }
        this.assertions.add(assertion);
        return true;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean setStatus(Status status) {
        if (this.signed) {
            return false;
        }
        if (status == null) {
            return false;
        }
        this.status = status;
        return true;
    }

    public boolean setSignature(Element elem) {
        this.signatureString = XMLUtils.print(elem);
        return super.setSignature(elem);
    }

    public String toString() {
        return this.toString(true, true);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        return this.toString(includeNS, declareNS, false);
    }

    public String toString(boolean includeNS, boolean declareNS, boolean includeHeader) {
        if (this.signed && this.xmlString != null) {
            return this.xmlString;
        }
        StringBuffer xml = new StringBuffer(300);
        if (includeHeader) {
            xml.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>\n");
        }
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "samlp:";
        }
        if (declareNS) {
            uri = " xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"";
        }
        String instantString = DateUtils.toUTCDateFormat(this.issueInstant);
        xml.append("<").append(prefix).append("Response").append(uri).append(" ResponseID=\"").append(this.responseID).append("\"");
        if (this.inResponseTo != null) {
            xml.append(" InResponseTo=\"").append(this.inResponseTo).append("\"");
        }
        xml.append(" MajorVersion=\"").append(this.majorVersion).append("\"").append(" MinorVersion=\"").append(this.minorVersion).append("\"").append(" IssueInstant=\"").append(instantString).append("\"");
        if (this.recipient != null) {
            xml.append(" Recipient=\"").append(this.recipient).append("\"");
        }
        xml.append(">\n");
        if (this.signed) {
            if (this.signatureString != null) {
                xml.append(this.signatureString);
            } else if (this.signature != null) {
                this.signatureString = XMLUtils.print(this.signature);
                xml.append(this.signatureString);
            }
        }
        xml.append(this.status.toString(includeNS, false));
        if (this.assertions != null && this.assertions != Collections.EMPTY_LIST) {
            Iterator j = this.assertions.iterator();
            while (j.hasNext()) {
                xml.append(((Assertion)j.next()).toString(true, true));
            }
        }
        xml.append("</").append(prefix).append("Response>\n");
        return xml.toString();
    }
}

