/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.plugins;

import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.plugins.PartnerAccountMapper;
import com.sun.identity.saml.protocol.SubjectQuery;
import com.sun.identity.sm.SMSEntry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class DefaultPartnerAccountMapper
implements PartnerAccountMapper {
    static String ANONYMOUS_USER = "anonymous";

    public Map getUser(List assertions, String sourceID, String targetURL) {
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("DefaultPartnerAccountMapper:getUser(List) targetURL = " + targetURL);
        }
        HashMap map = new HashMap();
        Subject subject = null;
        Assertion assertion = (Assertion)assertions.get(0);
        Iterator iter = assertion.getStatement().iterator();
        while (iter.hasNext()) {
            String cm;
            Set cms;
            Subject sub;
            SubjectConfirmation subConf;
            Statement statement = (Statement)iter.next();
            if (statement.getStatementType() != 1 || (subConf = (sub = ((SubjectStatement)statement).getSubject()).getSubjectConfirmation()) == null || (cms = subConf.getConfirmationMethod()) == null || cms.isEmpty() || (cm = (String)cms.iterator().next()) == null || !cm.equals(SAMLConstants.CONFIRMATION_METHOD_ARTIFACT) && !cm.equals("urn:oasis:names:tc:SAML:1.0:cm:artifact-01") && !cm.equals("urn:oasis:names:tc:SAML:1.0:cm:bearer")) continue;
            subject = sub;
            break;
        }
        if (subject != null) {
            this.getUser(subject, sourceID, map);
            HashMap attrMap = new HashMap();
            SAMLUtils.addEnvParamsFromAssertion(attrMap, assertion, subject);
            if (!attrMap.isEmpty()) {
                map.put("attribute", attrMap);
            }
        }
        return map;
    }

    public Map getUser(SubjectQuery subjectQuery, String sourceID) {
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("DefaultPartnerAccountMapper:getUser(SubjectQuery)");
        }
        HashMap map = new HashMap();
        this.getUser(subjectQuery.getSubject(), sourceID, map);
        return map;
    }

    protected void getUser(Subject subject, String sourceID, Map map) {
        NameIdentifier nameIdentifier = subject.getNameIdentifier();
        if (nameIdentifier != null) {
            String name = nameIdentifier.getName();
            String org = nameIdentifier.getNameQualifier();
            String rootSuffix = SMSEntry.getRootSuffix();
            if (name != null && name.length() != 0) {
                String temp = name;
                if (org != null && org.length() != 0) {
                    DN dn1 = new DN(name);
                    DN dn2 = new DN(org);
                    if (dn1.isDescendantOf(dn2)) {
                        int num = dn1.countRDNs() - dn2.countRDNs();
                        String[] rdns = dn1.explodeDN(false);
                        StringBuffer sb = new StringBuffer(50);
                        for (int i = 0; i < num; ++i) {
                            sb.append(rdns[i]).append(",");
                        }
                        sb.append(rootSuffix);
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("DefaultPAccountMapper: name = " + sb.toString());
                        }
                        map.put("name", sb.toString());
                    } else {
                        SAMLUtils.debug.warning("DefaultPAMapper:to anonymous");
                        map.put("name", ANONYMOUS_USER);
                    }
                } else {
                    SAMLUtils.debug.warning("DefaultAccountMapper: Org null.");
                    map.put("name", ANONYMOUS_USER);
                }
            } else {
                SAMLUtils.debug.warning("DefaultAccountMapper: Name is null");
                map.put("name", ANONYMOUS_USER);
            }
            map.put("org", rootSuffix);
        }
    }
}

