/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.assertion.Action;
import com.sun.identity.saml.assertion.EvidenceBase;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AuthorizationDecisionStatementBase
extends SubjectStatement {
    private String _resource = null;
    private int _decision = -1;
    private List _action = null;
    protected EvidenceBase _evidence = null;

    protected AuthorizationDecisionStatementBase() {
    }

    public AuthorizationDecisionStatementBase(Element element) throws SAMLException {
        if (element == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorizationDecisionStatement: null input.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        boolean valid = SAMLUtilsCommon.checkStatement(element, "AuthorizationDecisionStatement");
        if (!valid) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorizationDecisionStatement: Wrong input.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        int i = 0;
        NamedNodeMap atts = element.getAttributes();
        int attCount = atts.getLength();
        for (i = 0; i < attCount; ++i) {
            Node att = atts.item(i);
            if (att.getNodeType() != 2) continue;
            String attName = att.getLocalName();
            if (attName == null || attName.length() == 0) {
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("AuthorizationDecisionStatement: Attribute name is either null or empty.");
                }
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
            }
            if (attName.equals("Resource")) {
                this._resource = ((Attr)att).getValue().trim();
                if (this._resource != null && this._resource.length() != 0) continue;
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("AuthorizationDecisionStatement: Resource is null or empty.");
                }
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttributeValue"));
            }
            if (!attName.equals("Decision")) continue;
            String decisionStr = ((Attr)att).getValue().trim();
            if (decisionStr == null || decisionStr.length() == 0) {
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("AuthorizationDecisionStatement: Decision is null or empty.");
                }
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttributeValue"));
            }
            if (decisionStr.equals("Permit")) {
                this._decision = 1;
                continue;
            }
            if (decisionStr.equals("Deny")) {
                this._decision = 2;
                continue;
            }
            if (decisionStr.equals("Indeterminate")) {
                this._decision = 3;
                continue;
            }
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorizationDecisionStatement: The type of decision is illegal!");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        if (this._resource == null || this._resource.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorizationDecisionStatement: Resource is required attribute.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute"));
        }
        if (this._decision == -1) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorizationDecisionStatement: Decision is required attribute.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute"));
        }
        NodeList nodes = element.getChildNodes();
        int nodeCount = nodes.getLength();
        if (nodeCount > 0) {
            for (i = 0; i < nodeCount; ++i) {
                Node currentNode = nodes.item(i);
                if (currentNode.getNodeType() != 1) continue;
                String tagName = currentNode.getLocalName();
                String tagNS = currentNode.getNamespaceURI();
                if (tagName == null || tagName.length() == 0 || tagNS == null || tagNS.length() == 0) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("AuthorizationDecisionStatement: The tag name or tag namespace of child element is either null or empty.");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
                }
                if (tagName.equals("Subject") && tagNS.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                    if (this._subject != null) {
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("AuthorizationDecisionStatement:  should only contain one subject");
                        }
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("oneElement"));
                    }
                    this._subject = this.createSubject((Element)currentNode);
                    continue;
                }
                if (tagName.equals("Action") && tagNS.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                    if (this._action == null) {
                        this._action = new ArrayList();
                    }
                    if (this._action.add(this.createAction((Element)currentNode))) continue;
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("AuthenticationStatment: failed to add to the AuthorityBinding list.");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("addListError"));
                }
                if (tagName.equals("Evidence") && tagNS.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                    this._evidence = this.createEvidence((Element)currentNode);
                    continue;
                }
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("AuthorizationDecisionStatement: wrong element:" + tagName);
                }
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
            }
        }
        if (this._subject == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorizationDecisionStatement: should contain exactly one subject.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingElement"));
        }
        if (this._action == null || this._action.isEmpty()) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorizationDecisionStatement: should at least contain one Action.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingElement"));
        }
    }

    public AuthorizationDecisionStatementBase(Subject subject, String resource, int decision, List action, EvidenceBase evidence) throws SAMLException {
        if (subject == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorizationDecisionStatement:missing the subject.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingElement"));
        }
        this._subject = subject;
        if (resource == null || resource.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorizationDecisionStatement: resource is required attribute");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute"));
        }
        this._resource = resource;
        if (decision < 1 || decision > 3) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorizationDecisionStatement:The type of decision is illegal.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        this._decision = decision;
        if (action == null || action.isEmpty()) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorizationDecisionStatement: Action is required.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingElement"));
        }
        if (this._action == null) {
            this._action = new ArrayList();
        }
        this._action = action;
        this._evidence = evidence;
    }

    public AuthorizationDecisionStatementBase(Subject subject, String resource, int decision, List action) throws SAMLException {
        if (subject == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorizationDecisionStatement:missing the subject.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingElement"));
        }
        this._subject = subject;
        if (resource == null || resource.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorizationDecisionStatement: resource is required attribute");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute"));
        }
        this._resource = resource;
        if (decision <= 1 || decision >= 3) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorizationDecisionStatement:The type of decision is illegal.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        this._decision = decision;
        if (action == null || action.isEmpty()) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AuthorizationDecisionStatement: Action is required.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingElement"));
        }
        if (this._action == null) {
            this._action = new ArrayList();
        }
        this._action = action;
    }

    protected abstract EvidenceBase createEvidence(Element var1) throws SAMLException;

    protected abstract Subject createSubject(Element var1) throws SAMLException;

    protected abstract Action createAction(Element var1) throws SAMLException;

    public List getAction() {
        return this._action;
    }

    public String getResource() {
        return this._resource;
    }

    public int getDecision() {
        return this._decision;
    }

    public int getStatementType() {
        return 2;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer result = new StringBuffer(3000);
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "saml:";
        }
        if (declareNS) {
            uri = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        result.append("<").append(prefix).append("AuthorizationDecisionStatement").append(uri).append(" Resource=\"").append(this._resource).append("\" Decision=\"").append(this.decisionTypeConvert(this._decision)).append("\">\n");
        result.append(this._subject.toString(includeNS, false));
        Iterator iter = this._action.iterator();
        while (iter.hasNext()) {
            Action act = (Action)iter.next();
            result.append(act.toString(includeNS, false));
        }
        if (this._evidence != null) {
            result.append(this._evidence.toString(includeNS, false));
        }
        result.append("</").append(prefix).append("AuthorizationDecisionStatement>\n");
        return result.toString();
    }

    private String decisionTypeConvert(int number) {
        String result = "";
        switch (number) {
            case 1: {
                result = "Permit";
                break;
            }
            case 2: {
                result = "Deny";
                break;
            }
            case 3: {
                result = "Indeterminate";
            }
        }
        return result;
    }

    public static class DecisionType {
        public static final int PERMIT = 1;
        public static final int DENY = 2;
        public static final int INDETERMINATE = 3;
        public static final int NOT_SUPPORTED = -1;
    }
}

