/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AttributeStatement
extends SubjectStatement {
    private List _attributes = null;

    protected AttributeStatement() {
    }

    public AttributeStatement(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtilsCommon.debug.message("AttributeStatement: null input.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        boolean valid = SAMLUtilsCommon.checkStatement(element, "AttributeStatement");
        if (!valid) {
            SAMLUtilsCommon.debug.message("AttributeStatement: Wrong input.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        NodeList nodes = element.getChildNodes();
        int nodeCount = nodes.getLength();
        if (nodeCount > 0) {
            for (int i = 0; i < nodeCount; ++i) {
                Node currentNode = nodes.item(i);
                if (currentNode.getNodeType() != 1) continue;
                String tagName = currentNode.getLocalName();
                String tagNS = currentNode.getNamespaceURI();
                if (tagName == null || tagName.length() == 0 || tagNS == null || tagNS.length() == 0) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("AttributeStatement:  The tag name or tag namespace of child element is either null or empty.");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
                }
                if (tagName.equals("Subject") && tagNS.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                    if (this._subject != null) {
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("AttributeStatement: should not contain more than one subject.");
                        }
                        throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("oneElement"));
                    }
                    this._subject = this.createSubject((Element)currentNode);
                    continue;
                }
                if (tagName.equals("Attribute") && tagNS.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                    if (this._attributes == null) {
                        this._attributes = new ArrayList();
                    }
                    if (this._attributes.add(this.createAttribute((Element)currentNode))) continue;
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("AttributeStatement: failed to add to the Attribute list.");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("addListError"));
                }
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("AttributeStatement:wrong element:" + tagName);
                }
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
            }
        }
        if (this._subject == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AttributeStatement: missing Subject");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingElement"));
        }
        if (this._attributes == null || this._attributes.isEmpty()) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AttributeStatement: should at least contain one Attribute element.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingElement"));
        }
    }

    public AttributeStatement(Subject subject, List attribute) throws SAMLException {
        if (subject == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AttributeStatement: missing subject.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingElement"));
        }
        this._subject = subject;
        if (attribute == null || attribute.isEmpty()) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AttributeStatement: Attribute is required.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingElement"));
        }
        if (this._attributes == null) {
            this._attributes = new ArrayList();
        }
        this._attributes = attribute;
    }

    public List getAttribute() {
        return this._attributes;
    }

    public int getStatementType() {
        return 3;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer result = new StringBuffer(3000);
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "saml:";
        }
        if (declareNS) {
            uri = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        result.append("<").append(prefix).append("AttributeStatement ").append(uri).append(">\n");
        result.append(this._subject.toString(includeNS, false));
        Iterator iter = this._attributes.iterator();
        while (iter.hasNext()) {
            Attribute att = (Attribute)iter.next();
            result.append(att.toString(includeNS, false));
        }
        result.append("</").append(prefix).append("AttributeStatement>\n");
        return result.toString();
    }

    protected Subject createSubject(Element subjectElement) throws SAMLException {
        return new Subject(subjectElement);
    }

    protected Attribute createAttribute(Element attributeElement) throws SAMLException {
        return new Attribute(attributeElement);
    }
}

